/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.TGChordImpl;
import org.herac.tuxguitar.gui.editors.tab.TGLyricImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.TrackSpacing;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintStyles;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGTrack;

public class PrinterViewLayout
extends ViewLayout {
    private static final int DEFAULT_SCORE_LINE_SPACING = 7;
    private static final int DEFAULT_STRING_SPACING = 8;
    private static final int DEFAULT_HORIZONTAL_SPACING = 15;
    private static final int MIN_SCORE_TAB_SPACING = 15;
    private static final int DEFAULT_TRACK_SPACING = 5;
    private static final int DEFAULT_FIRST_TRACK_SPACING = 5;
    private static final int DEFAULT_MIN_BUFFER_SEPARATOR = 15;
    private static final int DEFAULT_MIN_TOP_SPACING = 20;
    private static final int CHORD_FRET_INDEX_SPACING = 8;
    private static final int CHORD_STRING_SPACING = 4;
    private static final int CHORD_FRET_SPACING = 5;
    private PrintStyles styles;
    private PrintDocument document;
    private int page;
    private Font songNameFont;
    private Font trackNameFont;
    private Font songAuthorFont;

    public PrinterViewLayout(Tablature tablature, PrintStyles printStyles, float f) {
        super(tablature, printStyles.getStyle() | 1, f);
        this.styles = printStyles;
    }

    protected void init(float f) {
        this.setBufferEnabled(false);
        this.setFirstMeasureSpacing(this.getScaledValue(f, 15));
        this.setMinBufferSeparator(this.getScaledValue(f, 15));
        this.setMinTopSpacing(this.getScaledValue(f, 20));
        this.setMinScoreTabSpacing(this.getScaledValue(f, 15));
        this.setScoreLineSpacing(this.getScaledValue(f, 7, 4));
        this.setScoreSpacing(this.getScoreLineSpacing() * 4 + this.getMinScoreTabSpacing());
        this.setFirstTrackSpacing(this.getScaledValue(f, 5));
        this.setTrackSpacing(this.getScaledValue(f, 5));
        this.setStringSpacing(this.getScaledValue(f, 8, 4));
        this.setChordFretIndexSpacing(this.getScaledValue(f, 8, 2));
        this.setChordStringSpacing(this.getScaledValue(f, 4, 2));
        this.setChordFretSpacing(this.getScaledValue(f, 5, 2));
        this.setChordNoteSize(this.getScaledValue(f, 3, 2));
        this.setRepeatEndingSpacing(this.getScaledValue(f, 20));
        this.setTextSpacing(this.getScaledValue(f, 15));
        this.setTupletoSpacing(this.getScaledValue(f, 10));
        this.setEffectSpacing(this.getScaledValue(f, 8));
        this.setScale(this.checkScale());
        this.setFontScale(f);
        this.getTablature().setViewLayout(this);
        this.getTablature().initDefaults();
        FontData[] fontDataArray = this.getResources().getPrinterDefaultFont().getFontData();
        String string = fontDataArray != null && fontDataArray.length > 0 ? fontDataArray[0].getName() : new String();
        this.songNameFont = new Font((Device)this.getTablature().getDisplay(), string, Math.round(16.0f * this.getFontScale()), 0x1000001);
        this.trackNameFont = new Font((Device)this.getTablature().getDisplay(), string, Math.round(8.0f * this.getFontScale()), 0x1000001);
        this.songAuthorFont = new Font((Device)this.getTablature().getDisplay(), string, Math.round(8.0f * this.getFontScale()), 0x1000001);
    }

    public int getMode() {
        return 0;
    }

    public void makeDocument(PrintDocument printDocument) {
        this.page = 0;
        this.document = printDocument;
        this.makeDocument();
    }

    private void makeDocument() {
        this.document.start();
        this.openPage();
        this.paintHeader(this.document.getPainter());
        this.paintSong(this.document.getPainter(), null, this.document.getBounds().x, this.document.getBounds().y + Math.round(80.0f * this.getFontScale()));
        this.paintFooter(this.document.getPainter());
        this.closePage();
        this.document.finish();
    }

    public void paintSong(TGPainter tGPainter, Rectangle rectangle, int n, int n2) {
        this.setWidth(0);
        this.setHeight(0);
        int n3 = this.getStyle();
        int n4 = n2 + this.getFirstTrackSpacing();
        int n5 = this.getFirstTrackSpacing();
        int n6 = 0;
        TGTrackImpl tGTrackImpl = (TGTrackImpl)this.getSongManager().getTrack(this.styles.getTrackNumber());
        ((TGLyricImpl)tGTrackImpl.getLyrics()).start(this.getSkippedBeats(tGTrackImpl));
        TrackSpacing trackSpacing = new TrackSpacing(this);
        TempLine tempLine = this.getTempLines(tGTrackImpl, this.styles.getFromMeasure() - 1, trackSpacing);
        while (!tempLine.measures.isEmpty()) {
            trackSpacing.setSize(6, (n3 & 4) != 0 ? this.getScoreLineSpacing() * 5 : 0);
            if ((n3 & 4) != 0) {
                trackSpacing.setSize(5, Math.abs(tempLine.minY));
                if (tempLine.maxY + this.getMinScoreTabSpacing() > this.getScoreSpacing()) {
                    trackSpacing.setSize(7, tempLine.maxY - this.getScoreLineSpacing() * 4);
                }
            }
            if ((n3 & 8) != 0) {
                trackSpacing.setSize(15, (n3 & 4) != 0 ? this.getMinScoreTabSpacing() : this.getStringSpacing());
                trackSpacing.setSize(16, (n3 & 4) != 0 ? tGTrackImpl.getTabHeight() + this.getStringSpacing() + 1 : tGTrackImpl.getTabHeight() + this.getStringSpacing() / 2 * 5 + 1);
            }
            trackSpacing.setSize(17, 10);
            this.checkDefaultSpacing(trackSpacing);
            n6 = trackSpacing.getSize();
            if (n4 + n6 + this.getTrackSpacing() > this.document.getBounds().y + this.getMaxHeight()) {
                this.paintFooter(tGPainter);
                this.closePage();
                this.openPage();
                n4 = this.document.getBounds().y + this.getFirstTrackSpacing();
            }
            this.paintLine(tGTrackImpl, tempLine, tGPainter, n, n4, trackSpacing);
            n4 += n6 + this.getTrackSpacing();
            n5 += n6 + this.getTrackSpacing();
            trackSpacing = new TrackSpacing(this);
            tempLine = this.getTempLines(tGTrackImpl, tempLine.lastIndex + 1, trackSpacing);
        }
        this.setHeight(n5);
    }

    public void paintHeader(TGPainter tGPainter) {
        if (this.document.isPaintable(this.page)) {
            int n = this.document.getBounds().x;
            int n2 = this.document.getBounds().y;
            String string = this.getSongManager().getSong().getName();
            String string2 = this.getSongManager().getSong().getAuthor();
            String string3 = "(" + this.getSongManager().getTrack(this.styles.getTrackNumber()).getName() + ")";
            if (string == null || string.length() == 0) {
                string = TuxGuitar.getProperty("print-header.default-song-name");
            }
            if (string2 == null || string2.length() == 0) {
                string2 = TuxGuitar.getProperty("print-header.default-song-author");
            }
            tGPainter.setFont(this.songNameFont);
            tGPainter.drawString(string, n + this.getCenter(tGPainter, string), n2);
            tGPainter.setFont(this.trackNameFont);
            tGPainter.drawString(string3, n + this.getCenter(tGPainter, string3), n2 + Math.round(30.0f * this.getFontScale()));
            tGPainter.setFont(this.songAuthorFont);
            tGPainter.drawString(string2, n + this.getRight(tGPainter, string2), n2 + Math.round(50.0f * this.getFontScale()));
        }
    }

    private void paintFooter(TGPainter tGPainter) {
        if (this.document.isPaintable(this.page)) {
            int n = this.document.getBounds().x;
            int n2 = this.document.getBounds().y;
            String string = Integer.toString(this.page);
            tGPainter.setBackground(this.getResources().getColorWhite());
            tGPainter.setForeground(this.getResources().getColorBlack());
            tGPainter.drawString(string, n + this.getRight(tGPainter, string), n2 + this.getBottom(tGPainter, string));
        }
    }

    public void paintLine(TGTrackImpl tGTrackImpl, TempLine tempLine, TGPainter tGPainter, int n, int n2, TrackSpacing trackSpacing) {
        if (this.document.isPaintable(this.page)) {
            int n3;
            int n4 = n;
            int n5 = n2;
            int n6 = 0;
            int n7 = 0;
            if (tempLine.fullLine && (n3 = this.getMaxWidth() - tempLine.tempWith) != 0 && tempLine.measures.size() > 0) {
                n7 = n3 / tempLine.measures.size();
            }
            for (n3 = 0; n3 < tempLine.measures.size(); ++n3) {
                int n8 = (Integer)tempLine.measures.get(n3);
                TGMeasureImpl tGMeasureImpl = (TGMeasureImpl)tGTrackImpl.getMeasure(n8);
                tGMeasureImpl.setPosX(n4);
                tGMeasureImpl.setPosY(n5);
                tGMeasureImpl.setTs(trackSpacing);
                ((TGLyricImpl)tGTrackImpl.getLyrics()).setCurrentMeasure(tGMeasureImpl);
                tGMeasureImpl.setFirstOfLine(n3 == 0);
                this.paintMeasure(tGMeasureImpl, tGPainter, n7);
                ((TGLyricImpl)tGTrackImpl.getLyrics()).paintCurrentNoteBeats(tGPainter, this, tGMeasureImpl, n4, n5);
                int n9 = tGMeasureImpl.getWidth(this) + tGMeasureImpl.getSpacing();
                n4 += n9;
                n6 += n9;
            }
            this.setWidth(Math.max(this.getWidth(), n6));
        }
    }

    private void openPage() {
        ++this.page;
        if (this.document.isPaintable(this.page)) {
            this.document.pageStart();
        }
    }

    private void closePage() {
        if (this.document.isPaintable(this.page)) {
            this.document.pageFinish();
        }
    }

    private int getCenter(TGPainter tGPainter, String string) {
        int n = tGPainter.getStringExtent((String)string).x;
        return (this.getMaxWidth() - n) / 2;
    }

    private int getRight(TGPainter tGPainter, String string) {
        int n = tGPainter.getStringExtent((String)string).x;
        return this.getMaxWidth() - n;
    }

    private int getBottom(TGPainter tGPainter, String string) {
        int n = tGPainter.getStringExtent((String)string).y;
        return this.getMaxHeight() - n;
    }

    private TempLine getTempLines(TGTrack tGTrack, int n, TrackSpacing trackSpacing) {
        TempLine tempLine = new TempLine();
        int n2 = tGTrack.countMeasures();
        for (int i = n; i < n2; ++i) {
            TGMeasureImpl tGMeasureImpl = (TGMeasureImpl)tGTrack.getMeasure(i);
            if (tGMeasureImpl.getNumber() < this.styles.getFromMeasure() || tGMeasureImpl.getNumber() > this.styles.getToMeasure()) continue;
            if (tempLine.tempWith + tGMeasureImpl.getWidth(this) >= this.getMaxWidth() && !tempLine.measures.isEmpty()) {
                tempLine.fullLine = true;
                return tempLine;
            }
            tempLine.tempWith += tGMeasureImpl.getWidth(this);
            tempLine.maxY = tGMeasureImpl.getMaxY() > tempLine.maxY ? tGMeasureImpl.getMaxY() : tempLine.maxY;
            tempLine.minY = tGMeasureImpl.getMinY() < tempLine.minY ? tGMeasureImpl.getMinY() : tempLine.minY;
            tempLine.addMeasure(i);
            tGMeasureImpl.registerEffects(this, trackSpacing);
        }
        return tempLine;
    }

    private int getSkippedBeats(TGTrack tGTrack) {
        int n = 0;
        for (int i = 0; i < this.styles.getFromMeasure() - 1; ++i) {
            TGMeasureImpl tGMeasureImpl = (TGMeasureImpl)tGTrack.getMeasure(i);
            n += tGMeasureImpl.getNotEmptyBeats();
        }
        return n;
    }

    public boolean isCaretVisible() {
        return false;
    }

    public boolean isPlayModeEnabled() {
        return false;
    }

    public void setMeasureNumberStyle(TGPainter tGPainter) {
        tGPainter.setFont(this.getResources().getPrinterDefaultFont());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setForeground(this.getResources().getColorRed());
    }

    public void setDivisionsStyle(TGPainter tGPainter, boolean bl) {
        tGPainter.setFont(this.getResources().getPrinterDefaultFont());
        tGPainter.setBackground(bl ? this.getResources().getColorBlack() : this.getResources().getBackgroundColor());
        tGPainter.setForeground(this.getResources().getColorBlack());
    }

    public void setTempoStyle(TGPainter tGPainter) {
        tGPainter.setFont(this.getResources().getPrinterDefaultFont());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setForeground(this.getResources().getColorBlack());
    }

    public void setTripletFeelStyle(TGPainter tGPainter) {
        tGPainter.setFont(this.getResources().getPrinterDefaultFont());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setForeground(this.getResources().getColorBlack());
    }

    public void setTabNoteStyle(TGPainter tGPainter, boolean bl) {
        tGPainter.setForeground(bl ? this.getResources().getPlayNoteColor() : this.getResources().getTabNoteColor());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setFont(this.getResources().getPrinterNoteFont());
    }

    public void setTimeSignatureStyle(TGPainter tGPainter) {
        tGPainter.setFont(this.getResources().getPrinterTimeSignatureFont());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setForeground(this.getResources().getColorBlack());
    }

    public void setGraceStyle(TGPainter tGPainter) {
        tGPainter.setFont(this.getResources().getPrinterGraceFont());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
    }

    public void setLyricStyle(TGPainter tGPainter, boolean bl) {
        tGPainter.setFont(this.getResources().getPrinterLyricFont());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setForeground(bl ? this.getResources().getPlayNoteColor() : this.getResources().getColorBlack());
    }

    public void setTextStyle(TGPainter tGPainter) {
        tGPainter.setFont(this.getResources().getPrinterTextFont());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setForeground(this.getResources().getColorBlack());
    }

    public void setOfflineEffectStyle(TGPainter tGPainter) {
        tGPainter.setForeground(this.getResources().getColorBlack());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setFont(this.getResources().getPrinterDefaultFont());
    }

    public void setTupletoStyle(TGPainter tGPainter) {
        tGPainter.setForeground(this.getResources().getColorBlack());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setFont(this.getResources().getPrinterDefaultFont());
    }

    public void setRepeatEndingStyle(TGPainter tGPainter) {
        tGPainter.setForeground(this.getResources().getColorBlack());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setFont(this.getResources().getPrinterDefaultFont());
    }

    public void setChordStyle(TGChordImpl tGChordImpl) {
        tGChordImpl.setStyle(this.getStyle());
        tGChordImpl.setFont(this.getResources().getPrinterChordFont());
        tGChordImpl.setForegroundColor(this.getResources().getColorBlack());
        tGChordImpl.setBackgroundColor(this.getResources().getBackgroundColor());
        tGChordImpl.setColor(this.getResources().getLineColor());
        tGChordImpl.setNoteColor(this.getResources().getTabNoteColor());
        tGChordImpl.setTonicColor(this.getResources().getTabNoteColor());
        tGChordImpl.setFretSpacing(this.getChordFretSpacing());
        tGChordImpl.setStringSpacing(this.getChordStringSpacing());
        tGChordImpl.setNoteSize(this.getChordNoteSize());
        tGChordImpl.setFirstFretSpacing(this.getChordFretIndexSpacing());
        tGChordImpl.setFirstFretFont(this.getResources().getChordFretFont());
    }

    public int getMaxWidth() {
        return this.document.getBounds().width - this.document.getBounds().x - 10;
    }

    public int getMaxHeight() {
        return this.document.getBounds().height - this.document.getBounds().y - 10;
    }

    public boolean isFirstMeasure(TGMeasure tGMeasure) {
        return tGMeasure.getNumber() == this.styles.getFromMeasure();
    }

    public boolean isLastMeasure(TGMeasure tGMeasure) {
        return tGMeasure.getNumber() == this.styles.getToMeasure();
    }

    private int getScaledValue(float f, int n) {
        return this.getScaledValue(f, n, 1);
    }

    private int getScaledValue(float f, int n, int n2) {
        float f2 = (float)n * f;
        return Math.max(Math.round(f2), n2);
    }

    public void disposeLayout() {
        super.disposeLayout();
        this.songNameFont.dispose();
        this.trackNameFont.dispose();
        this.songAuthorFont.dispose();
    }

    private class TempLine {
        protected int tempWith;
        protected int lastIndex;
        protected boolean fullLine;
        protected int maxY = 0;
        protected int minY = 50;
        protected List measures = new ArrayList();

        protected void addMeasure(int n) {
            this.measures.add(new Integer(n));
            this.lastIndex = n;
        }
    }
}

