/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.editors.tab.TGChordImpl;
import org.herac.tuxguitar.gui.editors.tab.TGLyricImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureHeaderImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGResources;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.TrackSpacing;
import org.herac.tuxguitar.gui.system.config.TGConfigManager;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;

public abstract class ViewLayout {
    public static final int MODE_PAGE = 1;
    public static final int MODE_LINEAR = 2;
    public static final int DEFAULT_MODE = 2;
    public static final int DISPLAY_COMPACT = 1;
    public static final int DISPLAY_MULTITRACK = 2;
    public static final int DISPLAY_SCORE = 4;
    public static final int DISPLAY_TABLATURE = 8;
    public static final int DISPLAY_CHORD_NAME = 16;
    public static final int DISPLAY_CHORD_DIAGRAM = 32;
    private Tablature tablature;
    private float scale;
    private float fontScale;
    private int style;
    private int width;
    private int height;
    private int minBufferSeparator;
    private int minTopSpacing;
    private int minScoreTabSpacing;
    private int stringSpacing;
    private int scoreLineSpacing;
    private int scoreSpacing;
    private int trackSpacing;
    private int firstTrackSpacing;
    private int firstMeasureSpacing;
    private int chordFretIndexSpacing;
    private int chordStringSpacing;
    private int chordFretSpacing;
    private int chordNoteSize;
    private int repeatEndingSpacing;
    private int effectSpacing;
    private int tupletoSpacing;
    private int textSpacing;
    private boolean bufferEnabled;
    private boolean playModeEnabled;
    private List trackPositions;
    private TGResources resources;

    public ViewLayout(Tablature tablature, int n) {
        this(tablature, n, 1.0f);
    }

    public ViewLayout(Tablature tablature, int n, float f) {
        this.tablature = tablature;
        this.trackPositions = new ArrayList();
        this.playModeEnabled = false;
        this.resources = new TGResources(this);
        this.style = n;
        if ((this.style & 8) == 0 && (this.style & 4) == 0) {
            this.style |= 8;
        }
        this.init(f);
    }

    protected void init(float f) {
        TGConfigManager tGConfigManager = TuxGuitar.instance().getConfig();
        this.setBufferEnabled(true);
        this.setStringSpacing((int)((float)tGConfigManager.getIntConfigValue("tab.line-spacing") * f));
        this.setScoreLineSpacing((int)((float)tGConfigManager.getIntConfigValue("score.line-spacing") * f));
        this.setScale(this.checkScale());
        this.setFontScale(this.getScale());
        this.setFirstMeasureSpacing(Math.round(20.0f * this.getScale()));
        this.setMinBufferSeparator(Math.round(20.0f * this.getScale()));
        this.setMinTopSpacing(Math.round(30.0f * this.getScale()));
        this.setMinScoreTabSpacing(Math.round((float)tGConfigManager.getIntConfigValue("score.min.score-tab-spacing") * this.getScale()));
        this.setScoreSpacing(this.getScoreLineSpacing() * 4 + this.getMinScoreTabSpacing());
        this.setFirstTrackSpacing(Math.round((float)tGConfigManager.getIntConfigValue("first-track.spacing") * this.getScale()));
        this.setTrackSpacing(Math.round((float)tGConfigManager.getIntConfigValue("track.spacing") * this.getScale()));
        this.setChordFretIndexSpacing(Math.round(8.0f * this.getScale()));
        this.setChordStringSpacing(Math.round(5.0f * this.getScale()));
        this.setChordFretSpacing(Math.round(6.0f * this.getScale()));
        this.setChordNoteSize(Math.round(4.0f * this.getScale()));
        this.setRepeatEndingSpacing(Math.round(20.0f * this.getScale()));
        this.setTextSpacing(Math.round(15.0f * this.getScale()));
        this.setTupletoSpacing(Math.round(10.0f * this.getScale()));
        this.setEffectSpacing(Math.round(8.0f * this.getScale()));
    }

    public abstract void paintSong(TGPainter var1, Rectangle var2, int var3, int var4);

    public abstract int getMode();

    public void paint(TGPainter tGPainter, Rectangle rectangle, int n, int n2) {
        this.playModeEnabled = false;
        this.paintSong(tGPainter, rectangle, n, n2);
    }

    public void paintMeasure(TGMeasureImpl tGMeasureImpl, TGPainter tGPainter, int n) {
        tGMeasureImpl.setSpacing(n);
        tGMeasureImpl.paintMeasure(this, tGPainter);
    }

    public void updateSong() {
        this.updateTracks();
        this.updateCaret();
    }

    public void updateTracks() {
        int n = this.getSongManager().getSong().countTracks();
        int n2 = this.getSongManager().getSong().countMeasureHeaders();
        for (int i = 0; i < n2; ++i) {
            TGMeasureImpl tGMeasureImpl;
            TGTrackImpl tGTrackImpl;
            int n3;
            TGMeasureHeaderImpl tGMeasureHeaderImpl = (TGMeasureHeaderImpl)this.getSongManager().getSong().getMeasureHeader(i);
            tGMeasureHeaderImpl.update(this, i);
            for (n3 = 0; n3 < n; ++n3) {
                tGTrackImpl = (TGTrackImpl)this.getSongManager().getSong().getTrack(n3);
                tGMeasureImpl = (TGMeasureImpl)tGTrackImpl.getMeasure(i);
                tGMeasureImpl.create(this);
            }
            for (n3 = 0; n3 < n; ++n3) {
                tGTrackImpl = (TGTrackImpl)this.getSongManager().getSong().getTrack(n3);
                tGMeasureImpl = (TGMeasureImpl)tGTrackImpl.getMeasure(i);
                tGTrackImpl.update(this);
                tGMeasureImpl.update(this);
            }
        }
    }

    private void updateCaret() {
        this.tablature.getCaret().update();
    }

    public void fireUpdate(int n) {
        TGMeasureImpl tGMeasureImpl;
        TGTrackImpl tGTrackImpl;
        int n2;
        int n3 = n - 1;
        int n4 = this.getSongManager().getSong().countTracks();
        TGMeasureHeaderImpl tGMeasureHeaderImpl = (TGMeasureHeaderImpl)this.getSongManager().getSong().getMeasureHeader(n3);
        tGMeasureHeaderImpl.update(this, n3);
        for (n2 = 0; n2 < n4; ++n2) {
            tGTrackImpl = (TGTrackImpl)this.getSongManager().getSong().getTrack(n2);
            tGMeasureImpl = null;
            tGMeasureImpl = (TGMeasureImpl)tGTrackImpl.getMeasure(n3);
            tGMeasureImpl.create(this);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            tGTrackImpl = (TGTrackImpl)this.getSongManager().getSong().getTrack(n2);
            tGMeasureImpl = (TGMeasureImpl)tGTrackImpl.getMeasure(n3);
            tGMeasureImpl.update(this);
        }
        this.updateCaret();
    }

    public void reloadStyles() {
        this.getResources().load();
    }

    public void paintLines(TGTrackImpl tGTrackImpl, TrackSpacing trackSpacing, TGPainter tGPainter, int n, int n2, int n3) {
        if (n3 > 0) {
            int n4;
            this.setLineStyle(tGPainter);
            int n5 = n < 0 ? 0 : n;
            int n6 = n2;
            if ((this.style & 4) != 0) {
                n4 = n6 + trackSpacing.getPosition(6);
                tGPainter.initPath();
                for (int i = 1; i <= 5; ++i) {
                    tGPainter.moveTo(n5, n4);
                    tGPainter.lineTo(n5 + n3, n4);
                    n4 += this.getScoreLineSpacing();
                }
                tGPainter.closePath();
            }
            if ((this.style & 8) != 0) {
                n6 += trackSpacing.getPosition(16);
                tGPainter.initPath();
                for (n4 = 0; n4 < tGTrackImpl.stringCount(); ++n4) {
                    tGPainter.moveTo(n5, n6);
                    tGPainter.lineTo(n5 + n3, n6);
                    n6 += this.getStringSpacing();
                }
                tGPainter.closePath();
            }
        }
    }

    public void paintCaret(TGPainter tGPainter) {
        Caret caret;
        if (this.isCaretVisible() && (this.style & 0xC) != 0 && !(caret = this.getTablature().getCaret()).getMeasure().isOutOfBounds()) {
            caret.paintCaret(this, tGPainter);
        }
    }

    public void paintPlayMode(TGPainter tGPainter, TGMeasureImpl tGMeasureImpl, TGBeatImpl tGBeatImpl, boolean bl) {
        this.playModeEnabled = true;
        if (bl) {
            tGMeasureImpl.paintMeasure(this, tGPainter);
        }
        tGBeatImpl.paint(this, tGPainter, tGMeasureImpl.getPosX() + tGMeasureImpl.getHeaderImpl().getLeftSpacing(this), tGMeasureImpl.getPosY());
        ((TGLyricImpl)tGMeasureImpl.getTrackImpl().getLyrics()).paintCurrentNoteBeats(tGPainter, this, tGMeasureImpl, tGMeasureImpl.getPosX(), tGMeasureImpl.getPosY());
        this.playModeEnabled = false;
    }

    protected float checkScale() {
        float f = (this.style & 4) != 0 ? (float)this.getScoreLineSpacing() * 1.25f : 0.0f;
        float f2 = (this.style & 8) != 0 ? this.getStringSpacing() : 0;
        float f3 = Math.max(f, f2) / 10.0f;
        return f3;
    }

    protected void checkDefaultSpacing(TrackSpacing trackSpacing) {
        int n = -1;
        int n2 = this.getMinBufferSeparator();
        if ((this.style & 4) != 0) {
            int n3 = trackSpacing.getPosition(5) - trackSpacing.getPosition(2);
            if (n3 < n2) {
                trackSpacing.setSize(2, n2 - n3);
            }
            n = trackSpacing.getPosition(6);
        } else if ((this.style & 8) != 0) {
            int n4 = trackSpacing.getPosition(16) - trackSpacing.getPosition(2);
            if (n4 < n2) {
                trackSpacing.setSize(2, n2 - n4);
            }
            n = trackSpacing.getPosition(16);
        }
        if (n >= 0 && n < this.getMinTopSpacing()) {
            trackSpacing.setSize(0, this.getMinTopSpacing() - n);
        }
    }

    public int getSpacingForQuarter(TGDuration tGDuration) {
        double d = 960.0 / (double)tGDuration.getTime() * (double)this.getMinSpacing(tGDuration);
        return (int)d;
    }

    protected float getMinSpacing(TGDuration tGDuration) {
        float f = this.getScale();
        switch (tGDuration.getValue()) {
            case 1: {
                return 50.0f * f;
            }
            case 2: {
                return 30.0f * f;
            }
            case 4: {
                return 25.0f * f;
            }
            case 8: {
                return 20.0f * f;
            }
        }
        return 18.0f * f;
    }

    public float getBeatWidth(TGBeatImpl tGBeatImpl) {
        float f = this.getScale();
        TGDuration tGDuration = tGBeatImpl.getDuration();
        if (tGDuration != null) {
            switch (tGDuration.getValue()) {
                case 1: {
                    return 30.0f * f;
                }
                case 2: {
                    return 25.0f * f;
                }
                case 4: {
                    return 21.0f * f;
                }
                case 8: {
                    return 20.0f * f;
                }
                case 16: {
                    return 19.0f * f;
                }
                case 32: {
                    return 18.0f * f;
                }
            }
            return 17.0f * f;
        }
        return 20.0f * f;
    }

    public boolean isCaretVisible() {
        return true;
    }

    public boolean isPlayModeEnabled() {
        return this.playModeEnabled;
    }

    public void setMeasureNumberStyle(TGPainter tGPainter) {
        tGPainter.setFont(this.getResources().getDefaultFont());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setForeground(this.getResources().getColorRed());
    }

    public void setDivisionsStyle(TGPainter tGPainter, boolean bl) {
        tGPainter.setFont(this.getResources().getDefaultFont());
        tGPainter.setBackground(bl ? this.getResources().getColorBlack() : this.getResources().getBackgroundColor());
        tGPainter.setForeground(this.getResources().getColorBlack());
    }

    public void setTempoStyle(TGPainter tGPainter, boolean bl) {
        tGPainter.setFont(this.getResources().getDefaultFont());
        tGPainter.setForeground(this.getResources().getColorBlack());
        tGPainter.setBackground(bl ? this.getResources().getBackgroundColor() : this.getResources().getColorBlack());
    }

    public void setTripletFeelStyle(TGPainter tGPainter, boolean bl) {
        tGPainter.setFont(this.getResources().getDefaultFont());
        tGPainter.setForeground(this.getResources().getColorBlack());
        tGPainter.setBackground(bl ? this.getResources().getBackgroundColor() : this.getResources().getColorBlack());
    }

    public void setMeasurePlayingStyle(TGPainter tGPainter) {
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setForeground(this.getResources().getColorBlack());
    }

    public void setGraceStyle(TGPainter tGPainter) {
        tGPainter.setFont(this.getResources().getGraceFont());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
    }

    public void setLyricStyle(TGPainter tGPainter, boolean bl) {
        tGPainter.setFont(this.getResources().getLyricFont());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setForeground(bl ? this.getResources().getPlayNoteColor() : this.getResources().getColorBlack());
    }

    public void setTextStyle(TGPainter tGPainter) {
        tGPainter.setFont(this.getResources().getTextFont());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setForeground(this.getResources().getColorBlack());
    }

    public void setTimeSignatureStyle(TGPainter tGPainter) {
        tGPainter.setFont(this.getResources().getTimeSignatureFont());
        tGPainter.setForeground(this.getResources().getColorBlack());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
    }

    public void setKeySignatureStyle(TGPainter tGPainter) {
        tGPainter.setBackground(this.getResources().getColorBlack());
    }

    public void setClefStyle(TGPainter tGPainter) {
        tGPainter.setBackground(this.getResources().getColorBlack());
    }

    public void setLineStyle(TGPainter tGPainter) {
        tGPainter.setLineWidth(1);
        tGPainter.setForeground(this.getResources().getLineColor());
    }

    public void setCaretStyle(TGPainter tGPainter) {
        tGPainter.setForeground(this.getResources().getLineColor());
    }

    public void setScoreSilenceStyle(TGPainter tGPainter, boolean bl) {
        tGPainter.setForeground(bl ? this.getResources().getPlayNoteColor() : this.getResources().getScoreNoteColor());
        tGPainter.setBackground(bl ? this.getResources().getPlayNoteColor() : this.getResources().getScoreNoteColor());
    }

    public void setTabSilenceStyle(TGPainter tGPainter, boolean bl) {
        tGPainter.setForeground(bl ? this.getResources().getPlayNoteColor() : this.getResources().getTabNoteColor());
        tGPainter.setBackground(bl ? this.getResources().getPlayNoteColor() : this.getResources().getTabNoteColor());
    }

    public void setScoreNoteStyle(TGPainter tGPainter, boolean bl) {
        tGPainter.setForeground(bl ? this.getResources().getPlayNoteColor() : this.getResources().getScoreNoteColor());
        tGPainter.setBackground(bl ? this.getResources().getPlayNoteColor() : this.getResources().getScoreNoteColor());
    }

    public void setScoreNoteFooterStyle(TGPainter tGPainter) {
        tGPainter.setForeground(this.getResources().getScoreNoteColor());
        tGPainter.setBackground(this.getResources().getScoreNoteColor());
    }

    public void setScoreEffectStyle(TGPainter tGPainter) {
        tGPainter.setForeground(this.getResources().getScoreNoteColor());
        tGPainter.setBackground(this.getResources().getScoreNoteColor());
    }

    public void setTabNoteStyle(TGPainter tGPainter, boolean bl) {
        tGPainter.setForeground(bl ? this.getResources().getPlayNoteColor() : this.getResources().getTabNoteColor());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setFont(this.getResources().getNoteFont());
    }

    public void setTabNoteFooterStyle(TGPainter tGPainter) {
        tGPainter.setForeground(this.getResources().getTabNoteColor());
        tGPainter.setBackground(this.getResources().getTabNoteColor());
    }

    public void setTabEffectStyle(TGPainter tGPainter) {
        tGPainter.setForeground(this.getResources().getTabNoteColor());
        tGPainter.setBackground(this.getResources().getTabNoteColor());
    }

    public void setPlayNoteColor(TGPainter tGPainter) {
        tGPainter.setForeground(this.getResources().getPlayNoteColor());
        tGPainter.setBackground(this.getResources().getPlayNoteColor());
    }

    public void setOfflineEffectStyle(TGPainter tGPainter) {
        tGPainter.setForeground(this.getResources().getColorBlack());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setFont(this.getResources().getDefaultFont());
    }

    public void setDotStyle(TGPainter tGPainter) {
        tGPainter.setForeground(this.getResources().getColorBlack());
        tGPainter.setBackground(this.getResources().getColorBlack());
    }

    public void setTupletoStyle(TGPainter tGPainter) {
        tGPainter.setForeground(this.getResources().getColorBlack());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setFont(this.getResources().getDefaultFont());
    }

    public void setRepeatEndingStyle(TGPainter tGPainter) {
        tGPainter.setForeground(this.getResources().getColorBlack());
        tGPainter.setBackground(this.getResources().getBackgroundColor());
        tGPainter.setFont(this.getResources().getDefaultFont());
    }

    public void setChordStyle(TGChordImpl tGChordImpl) {
        tGChordImpl.setFont(this.getResources().getChordFont());
        tGChordImpl.setForegroundColor(this.getResources().getColorBlack());
        tGChordImpl.setBackgroundColor(this.getResources().getBackgroundColor());
        tGChordImpl.setColor(this.getResources().getLineColor());
        tGChordImpl.setNoteColor(this.getResources().getTabNoteColor());
        tGChordImpl.setTonicColor(this.getResources().getTabNoteColor());
        tGChordImpl.setStyle(this.style);
        tGChordImpl.setFretSpacing(this.getChordFretSpacing());
        tGChordImpl.setStringSpacing(this.getChordStringSpacing());
        tGChordImpl.setNoteSize(this.getChordNoteSize());
        tGChordImpl.setFirstFretSpacing(this.getChordFretIndexSpacing());
        tGChordImpl.setFirstFretFont(this.getResources().getChordFretFont());
    }

    public Rectangle getNoteOrientation(TGPainter tGPainter, int n, int n2, TGNote tGNote) {
        String string = null;
        if (tGNote.isTiedNote()) {
            string = "L";
            string = tGNote.getEffect().isGhostNote() ? "(" + string + ")" : string;
        } else if (tGNote.getEffect().isDeadNote()) {
            string = "X";
            string = tGNote.getEffect().isGhostNote() ? "(" + string + ")" : string;
        } else {
            string = Integer.toString(tGNote.getValue());
            string = tGNote.getEffect().isGhostNote() ? "(" + string + ")" : string;
        }
        return this.getOrientation(tGPainter, n, n2, string);
    }

    public Rectangle getOrientation(TGPainter tGPainter, int n, int n2, String string) {
        Point point = tGPainter.getStringExtent(string);
        return new Rectangle(n - point.x / 2, n2 - point.y / 2, point.x, point.y);
    }

    public TGSongManager getSongManager() {
        return this.getTablature().getSongManager();
    }

    public Tablature getTablature() {
        return this.tablature;
    }

    public void setTablature(Tablature tablature) {
        this.tablature = tablature;
    }

    public TGResources getResources() {
        return this.resources;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int n) {
        this.style = n;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float f) {
        this.scale = f;
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(float f) {
        this.fontScale = f;
    }

    public boolean isBufferEnabled() {
        return this.bufferEnabled;
    }

    public void setBufferEnabled(boolean bl) {
        this.bufferEnabled = bl;
    }

    public int getFirstMeasureSpacing() {
        return this.firstMeasureSpacing;
    }

    public void setFirstMeasureSpacing(int n) {
        this.firstMeasureSpacing = n;
    }

    public int getMinBufferSeparator() {
        return this.minBufferSeparator;
    }

    public void setMinBufferSeparator(int n) {
        this.minBufferSeparator = n;
    }

    public int getMinTopSpacing() {
        return this.minTopSpacing;
    }

    public void setMinTopSpacing(int n) {
        this.minTopSpacing = n;
    }

    public int getMinScoreTabSpacing() {
        return this.minScoreTabSpacing;
    }

    public void setMinScoreTabSpacing(int n) {
        this.minScoreTabSpacing = n;
    }

    public int getScoreLineSpacing() {
        return this.scoreLineSpacing;
    }

    public void setScoreLineSpacing(int n) {
        this.scoreLineSpacing = n;
    }

    public int getScoreSpacing() {
        return this.scoreSpacing;
    }

    public void setScoreSpacing(int n) {
        this.scoreSpacing = n;
    }

    public int getFirstTrackSpacing() {
        return this.firstTrackSpacing;
    }

    public void setFirstTrackSpacing(int n) {
        this.firstTrackSpacing = n;
    }

    public int getTrackSpacing() {
        return this.trackSpacing;
    }

    public void setTrackSpacing(int n) {
        this.trackSpacing = n;
    }

    public int getStringSpacing() {
        return this.stringSpacing;
    }

    public void setStringSpacing(int n) {
        this.stringSpacing = n;
    }

    public int getChordFretIndexSpacing() {
        return this.chordFretIndexSpacing;
    }

    public void setChordFretIndexSpacing(int n) {
        this.chordFretIndexSpacing = n;
    }

    public int getChordStringSpacing() {
        return this.chordStringSpacing;
    }

    public void setChordStringSpacing(int n) {
        this.chordStringSpacing = n;
    }

    public int getChordFretSpacing() {
        return this.chordFretSpacing;
    }

    public void setChordFretSpacing(int n) {
        this.chordFretSpacing = n;
    }

    public int getChordNoteSize() {
        return this.chordNoteSize;
    }

    public void setChordNoteSize(int n) {
        this.chordNoteSize = n;
    }

    public int getRepeatEndingSpacing() {
        return this.repeatEndingSpacing;
    }

    public void setRepeatEndingSpacing(int n) {
        this.repeatEndingSpacing = n;
    }

    public int getTupletoSpacing() {
        return this.tupletoSpacing;
    }

    public void setTupletoSpacing(int n) {
        this.tupletoSpacing = n;
    }

    public int getTextSpacing() {
        return this.textSpacing;
    }

    public void setTextSpacing(int n) {
        this.textSpacing = n;
    }

    public int getEffectSpacing() {
        return this.effectSpacing;
    }

    public void setEffectSpacing(int n) {
        this.effectSpacing = n;
    }

    public int getDefaultChordSpacing() {
        int n = 0;
        if ((this.style & 0x20) != 0) {
            n += 6 * this.getChordFretSpacing() + this.getChordFretSpacing();
        }
        if ((this.style & 0x10) != 0) {
            n += Math.round(15.0f * this.getScale());
        }
        return n;
    }

    public boolean isFirstMeasure(TGMeasure tGMeasure) {
        return tGMeasure.getNumber() == 1;
    }

    public boolean isLastMeasure(TGMeasure tGMeasure) {
        return tGMeasure.getNumber() == this.getSongManager().getSong().countMeasureHeaders();
    }

    protected void clearTrackPositions() {
        this.trackPositions.clear();
    }

    protected void addTrackPosition(int n, int n2, int n3) {
        this.trackPositions.add(new TrackPosition(n, n2, n3));
    }

    public int getTrackNumberAt(int n) {
        TrackPosition trackPosition = this.getTrackPositionAt(n);
        return trackPosition != null ? trackPosition.getTrack() : -1;
    }

    public TrackPosition getTrackPositionAt(int n) {
        TrackPosition trackPosition = null;
        int n2 = 0;
        Iterator iterator = this.trackPositions.iterator();
        while (iterator.hasNext()) {
            TrackPosition trackPosition2 = (TrackPosition)iterator.next();
            int n3 = Math.min(Math.abs(n - trackPosition2.getPosY()), Math.abs(n - (trackPosition2.getPosY() + trackPosition2.getHeight() - 10)));
            if (trackPosition != null && n3 >= n2) continue;
            trackPosition = trackPosition2;
            n2 = n3;
        }
        return trackPosition;
    }

    public void disposeLayout() {
        this.getResources().dispose();
    }

    public class TrackPosition {
        private int track;
        private int posY;
        private int height;

        public TrackPosition(int n, int n2, int n3) {
            this.track = n;
            this.posY = n2;
            this.height = n3;
        }

        public int getPosY() {
            return this.posY;
        }

        public int getHeight() {
            return this.height;
        }

        public int getTrack() {
            return this.track;
        }
    }
}

