/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import java.util.Iterator;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.gui.tools.custom.TGCustomTool;
import org.herac.tuxguitar.gui.tools.custom.TGCustomToolManager;

public class ToolMenuItem
implements MenuItems {
    private MenuItem settingsMenuItem;
    private Menu menu;
    private MenuItem scale;
    private MenuItem browser;
    private MenuItem plugins;
    private MenuItem config;
    private MenuItem keyBindings;

    public ToolMenuItem(Shell shell, Menu menu, int n) {
        this.settingsMenuItem = new MenuItem(menu, n);
        this.menu = new Menu(shell, 4);
    }

    public void showItems() {
        this.scale = new MenuItem(this.menu, 8);
        this.scale.addSelectionListener(TuxGuitar.instance().getAction("action.tools.scale"));
        this.browser = new MenuItem(this.menu, 8);
        this.browser.addSelectionListener(TuxGuitar.instance().getAction("action.tools.browser"));
        Iterator iterator = TGCustomToolManager.instance().getCustomTools();
        while (iterator.hasNext()) {
            TGCustomTool tGCustomTool = (TGCustomTool)iterator.next();
            MenuItem menuItem = new MenuItem(this.menu, 8);
            menuItem.setText(tGCustomTool.getName());
            menuItem.addSelectionListener(TuxGuitar.instance().getAction(tGCustomTool.getAction()));
        }
        new MenuItem(this.menu, 2);
        this.plugins = new MenuItem(this.menu, 8);
        this.plugins.addSelectionListener(TuxGuitar.instance().getAction("action.settings.plugins"));
        this.keyBindings = new MenuItem(this.menu, 8);
        this.keyBindings.addSelectionListener(TuxGuitar.instance().getAction("action.settings.key-bindings"));
        this.config = new MenuItem(this.menu, 8);
        this.config.addSelectionListener(TuxGuitar.instance().getAction("action.settings.configure"));
        this.settingsMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void loadProperties() {
        this.settingsMenuItem.setText(TuxGuitar.getProperty("tools"));
        this.scale.setText(TuxGuitar.getProperty("tools.scale"));
        this.browser.setText(TuxGuitar.getProperty("tools.browser"));
        this.plugins.setText(TuxGuitar.getProperty("tools.plugins"));
        this.keyBindings.setText(TuxGuitar.getProperty("tools.shortcuts"));
        this.config.setText(TuxGuitar.getProperty("tools.settings"));
    }

    public void loadIcons() {
    }

    public void update() {
    }
}

