/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ToolItems;

public class FileToolItems
extends ToolItems {
    public static final String NAME = "file.items";
    private ToolItem newSong;
    private ToolItem openSong;
    private ToolItem saveSong;
    private ToolItem saveAsSong;
    private ToolItem printSong;
    private ToolItem printPreviewSong;

    public FileToolItems() {
        super(NAME);
    }

    public void showItems(ToolBar toolBar) {
        this.newSong = new ToolItem(toolBar, 8);
        this.newSong.addSelectionListener(TuxGuitar.instance().getAction("action.file.new"));
        this.openSong = new ToolItem(toolBar, 8);
        this.openSong.addSelectionListener(TuxGuitar.instance().getAction("action.file.open"));
        this.saveSong = new ToolItem(toolBar, 8);
        this.saveSong.addSelectionListener(TuxGuitar.instance().getAction("action.file.save"));
        this.saveAsSong = new ToolItem(toolBar, 8);
        this.saveAsSong.addSelectionListener(TuxGuitar.instance().getAction("action.file.save-as"));
        this.printSong = new ToolItem(toolBar, 8);
        this.printSong.addSelectionListener(TuxGuitar.instance().getAction("action.file.print"));
        this.printPreviewSong = new ToolItem(toolBar, 8);
        this.printPreviewSong.addSelectionListener(TuxGuitar.instance().getAction("action.file.print-preview"));
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
    }

    public void loadProperties() {
        this.newSong.setToolTipText(TuxGuitar.getProperty("file.new"));
        this.openSong.setToolTipText(TuxGuitar.getProperty("file.open"));
        this.saveSong.setToolTipText(TuxGuitar.getProperty("file.save"));
        this.saveAsSong.setToolTipText(TuxGuitar.getProperty("file.save-as"));
        this.printSong.setToolTipText(TuxGuitar.getProperty("file.print"));
        this.printPreviewSong.setToolTipText(TuxGuitar.getProperty("file.print-preview"));
    }

    public void loadIcons() {
        this.newSong.setImage(TuxGuitar.instance().getIconManager().getFileNew());
        this.openSong.setImage(TuxGuitar.instance().getIconManager().getFileOpen());
        this.saveSong.setImage(TuxGuitar.instance().getIconManager().getFileSave());
        this.saveAsSong.setImage(TuxGuitar.instance().getIconManager().getFileSaveAs());
        this.printSong.setImage(TuxGuitar.instance().getIconManager().getFilePrint());
        this.printPreviewSong.setImage(TuxGuitar.instance().getIconManager().getFilePrintPreview());
    }
}

