/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.mixer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.mixer.TGMixerTrack;
import org.herac.tuxguitar.gui.system.icons.IconLoader;
import org.herac.tuxguitar.gui.system.language.LanguageLoader;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGTrack;

public class TGMixer
implements IconLoader,
LanguageLoader {
    public static final int MUTE = 1;
    public static final int SOLO = 2;
    public static final int VOLUME = 4;
    public static final int BALANCE = 8;
    public static final int CHANNEL = 16;
    public static final int CHANGE_ALL = 31;
    protected Shell dialog;
    private List tracks = new ArrayList();
    private Scale volumeScale;
    private Label volumeValueLabel;
    private Label volumeValueTitleLabel;
    private String volumeTip;
    private int volumeValue;

    public TGMixer() {
        TuxGuitar.instance().getIconManager().addLoader(this);
        TuxGuitar.instance().getLanguageManager().addLoader(this);
    }

    public void show() {
        this.dialog = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 2144);
        this.loadData();
        TuxGuitar.instance().updateCache(true);
        DialogUtils.openDialog(this.dialog, 9);
        TuxGuitar.instance().updateCache(true);
    }

    protected void loadData() {
        Object object;
        Object object2;
        this.tracks.clear();
        Iterator iterator = TuxGuitar.instance().getSongManager().getSong().getTracks();
        while (iterator.hasNext()) {
            object2 = (TGTrack)iterator.next();
            object = new TGMixerTrack(this, (TGTrack)object2);
            ((TGMixerTrack)object).init(this.dialog);
            this.tracks.add(object);
        }
        object2 = new Composite(this.dialog, 2048);
        ((Composite)object2).setLayout(new GridLayout());
        ((Control)object2).setLayoutData(new GridData(0x1000000, 4, true, true));
        this.volumeValue = -1;
        this.volumeScale = new Scale((Composite)object2, 512);
        this.volumeScale.setMaximum(10);
        this.volumeScale.setMinimum(0);
        this.volumeScale.setIncrement(1);
        this.volumeScale.setPageIncrement(1);
        this.volumeScale.setLayoutData(new GridData(0x1000000, 4, true, true));
        object = new Label((Composite)object2, 258);
        ((Control)object).setLayoutData(new GridData(4, 1024, true, false));
        Composite composite = new Composite((Composite)object2, 0);
        composite.setLayout(new GridLayout(2, false));
        this.volumeValueTitleLabel = new Label(composite, 0);
        this.volumeValueLabel = new Label(composite, 0x1000000);
        this.volumeValueLabel.setLayoutData(this.getVolumeValueLabelData());
        this.volumeScale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TGMixer.this.changeVolume();
            }
        });
        this.loadVolume();
        this.loadIcons();
        this.loadProperties();
        this.dialog.setLayout(this.getLayout(this.dialog.getChildren().length));
        this.dialog.pack();
    }

    private GridLayout getLayout(int n) {
        GridLayout gridLayout = new GridLayout(n, false);
        gridLayout.verticalSpacing = 1;
        gridLayout.horizontalSpacing = 1;
        return gridLayout;
    }

    protected void changeVolume() {
        short s = (short)(this.volumeScale.getMaximum() - this.volumeScale.getSelection());
        if (s != TuxGuitar.instance().getPlayer().getVolume()) {
            TuxGuitar.instance().getPlayer().setVolume(s);
            this.volumeScale.setToolTipText(this.volumeTip + ": " + TuxGuitar.instance().getPlayer().getVolume());
            this.volumeValueLabel.setText(Integer.toString(this.volumeScale.getMaximum() - this.volumeScale.getSelection()));
            this.volumeValue = s;
        }
    }

    protected void loadVolume() {
        int n = TuxGuitar.instance().getPlayer().getVolume();
        if (this.volumeValue != n) {
            this.volumeScale.setSelection(this.volumeScale.getMaximum() - TuxGuitar.instance().getPlayer().getVolume());
            this.volumeValueLabel.setText(Integer.toString(this.volumeScale.getMaximum() - this.volumeScale.getSelection()));
            this.volumeValue = n;
        }
    }

    private GridData getVolumeValueLabelData() {
        GridData gridData = new GridData(0x1000000, 0, true, false);
        gridData.minimumWidth = 40;
        return gridData;
    }

    protected void clear() {
        Control[] controlArray = this.dialog.getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].dispose();
        }
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public synchronized void fireChanges(TGChannel tGChannel, int n) {
        Iterator iterator = this.tracks.iterator();
        while (iterator.hasNext()) {
            TGMixerTrack tGMixerTrack = (TGMixerTrack)iterator.next();
            if (tGMixerTrack.getTrack().getChannel().getChannel() == tGChannel.getChannel()) {
                boolean bl = tGMixerTrack.getTrack().getChannel().isSolo();
                boolean bl2 = tGMixerTrack.getTrack().getChannel().isMute();
                tGChannel.copy(tGMixerTrack.getTrack().getChannel());
                tGMixerTrack.getTrack().getChannel().setSolo(bl);
                tGMixerTrack.getTrack().getChannel().setMute(bl2);
            }
            tGMixerTrack.fireChanges(n);
        }
        if (TuxGuitar.instance().getPlayer().isRunning()) {
            TuxGuitar.instance().getPlayer().updateControllers();
        }
    }

    public synchronized void loadProperties() {
        if (!this.isDisposed()) {
            Iterator iterator = this.tracks.iterator();
            while (iterator.hasNext()) {
                TGMixerTrack tGMixerTrack = (TGMixerTrack)iterator.next();
                tGMixerTrack.loadProperties();
            }
            this.volumeValueTitleLabel.setText(TuxGuitar.getProperty("mixer.volume") + ":");
            this.volumeTip = TuxGuitar.getProperty("mixer.volume");
            this.volumeScale.setToolTipText(this.volumeTip + ": " + TuxGuitar.instance().getPlayer().getVolume());
            this.dialog.setText(TuxGuitar.getProperty("mixer"));
            this.dialog.pack();
            this.dialog.layout(true, true);
            this.dialog.redraw();
        }
    }

    public synchronized void loadIcons() {
        if (!this.isDisposed()) {
            this.dialog.setImage(TuxGuitar.instance().getIconManager().getAppIcon());
        }
    }

    public synchronized void updateItems() {
        if (!this.isDisposed()) {
            Iterator iterator = this.tracks.iterator();
            while (iterator.hasNext()) {
                TGMixerTrack tGMixerTrack = (TGMixerTrack)iterator.next();
                tGMixerTrack.updateItems();
            }
        }
    }

    public synchronized void updateValues() {
        if (!this.isDisposed()) {
            this.loadVolume();
            Iterator iterator = this.tracks.iterator();
            while (iterator.hasNext()) {
                TGMixerTrack tGMixerTrack = (TGMixerTrack)iterator.next();
                tGMixerTrack.fireChanges(31);
            }
        }
    }

    public synchronized void update() {
        if (!this.isDisposed()) {
            new SyncThread(new Runnable(){

                public void run() {
                    if (!TGMixer.this.isDisposed()) {
                        TGMixer.this.clear();
                        TGMixer.this.loadData();
                        TGMixer.this.dialog.layout(true, true);
                        TGMixer.this.dialog.redraw();
                    }
                }
            }).start();
        }
    }

    public synchronized void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }
}

