/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.ActionLock;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.system.config.TGConfigDefaults;
import org.herac.tuxguitar.gui.system.config.TGConfigManager;
import org.herac.tuxguitar.gui.system.config.items.LanguageOption;
import org.herac.tuxguitar.gui.system.config.items.MainOption;
import org.herac.tuxguitar.gui.system.config.items.Option;
import org.herac.tuxguitar.gui.system.config.items.SkinOption;
import org.herac.tuxguitar.gui.system.config.items.SoundOption;
import org.herac.tuxguitar.gui.system.config.items.StylesOption;
import org.herac.tuxguitar.gui.system.config.items.ToolBarsOption;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.DialogUtils;

public class TGConfigEditor {
    protected Shell dialog;
    protected TGConfigManager config = TuxGuitar.instance().getConfig();
    protected List options;
    protected Properties defaults;
    protected boolean accepted;
    protected List runnables;

    public void showDialog(Shell shell) {
        this.accepted = false;
        this.dialog = DialogUtils.newDialog(shell, 67680);
        this.dialog.setLayout(new GridLayout());
        this.dialog.setText(TuxGuitar.getProperty("settings.config"));
        Composite composite = new Composite(this.dialog, 0);
        composite.setLayout(new GridLayout(2, false));
        composite.setLayoutData(new GridData(4, 4, true, true));
        this.createComposites(composite);
        Composite composite2 = new Composite(this.dialog, 0);
        composite2.setLayout(new GridLayout(3, true));
        composite2.setLayoutData(new GridData(131072, 4, true, true));
        Button button = new Button(composite2, 8);
        button.setLayoutData(this.getButtonData());
        button.setText(TuxGuitar.getProperty("defaults"));
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGConfigEditor.this.accepted = true;
                TuxGuitar.instance().loadCursor(1);
                TGConfigEditor.this.dispose();
                TGConfigEditor.this.setDefaults();
                ConfirmDialog confirmDialog = new ConfirmDialog(TuxGuitar.getProperty("settings.config.apply-changes-question"));
                confirmDialog.setDefaultStatus(ConfirmDialog.STATUS_NO);
                if (confirmDialog.confirm(ConfirmDialog.BUTTON_YES | ConfirmDialog.BUTTON_NO, ConfirmDialog.BUTTON_YES) == ConfirmDialog.STATUS_NO) {
                    TuxGuitar.instance().loadCursor(0);
                    ActionLock.unlock();
                    return;
                }
                TGConfigEditor.this.applyConfig(true);
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setLayoutData(this.getButtonData());
        button2.setText(TuxGuitar.getProperty("ok"));
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGConfigEditor.this.accepted = true;
                TuxGuitar.instance().loadCursor(1);
                TGConfigEditor.this.updateOptions();
                TGConfigEditor.this.dispose();
                ConfirmDialog confirmDialog = new ConfirmDialog(TuxGuitar.getProperty("settings.config.apply-changes-question"));
                confirmDialog.setDefaultStatus(ConfirmDialog.STATUS_NO);
                if (confirmDialog.confirm(ConfirmDialog.BUTTON_YES | ConfirmDialog.BUTTON_NO, ConfirmDialog.BUTTON_YES) == ConfirmDialog.STATUS_NO) {
                    TuxGuitar.instance().loadCursor(0);
                    ActionLock.unlock();
                    return;
                }
                TGConfigEditor.this.applyConfig(false);
            }
        });
        Button button3 = new Button(composite2, 8);
        button3.setLayoutData(this.getButtonData());
        button3.setText(TuxGuitar.getProperty("cancel"));
        button3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().loadCursor(1);
                TGConfigEditor.this.dispose();
                TuxGuitar.instance().loadCursor(0);
            }
        });
        this.dialog.setDefaultButton(button2);
        DialogUtils.openDialog(this.dialog, 11);
        if (!this.accepted) {
            ActionLock.unlock();
        }
    }

    private void createComposites(Composite composite) {
        ToolBar toolBar = new ToolBar(composite, 8389184);
        toolBar.setLayoutData(new GridData(4, 4, true, true));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new FormLayout());
        this.initOptions(toolBar, composite2);
        Point point = this.computeOptionsSize(0, toolBar.computeSize((int)-1, (int)-1).y);
        composite2.setLayoutData(new GridData(point.x, point.y));
        if (this.options.size() > 0) {
            this.select((Option)this.options.get(0));
        }
    }

    private void initOptions(ToolBar toolBar, Composite composite) {
        this.options = new ArrayList();
        this.options.add(new MainOption(this, toolBar, composite));
        this.options.add(new StylesOption(this, toolBar, composite));
        this.options.add(new LanguageOption(this, toolBar, composite));
        this.options.add(new ToolBarsOption(this, toolBar, composite));
        this.options.add(new SkinOption(this, toolBar, composite));
        this.options.add(new SoundOption(this, toolBar, composite));
        Iterator iterator = this.options.iterator();
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            option.createOption();
        }
    }

    private Point computeOptionsSize(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        Iterator iterator = this.options.iterator();
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            Point point = option.computeSize();
            if (point.x > n3) {
                n3 = point.x;
            }
            if (point.y <= n4) continue;
            n4 = point.y;
        }
        return new Point(n3, n4);
    }

    public void pack() {
        this.dialog.pack();
    }

    protected GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    public GridData makeGridData(int n, int n2, int n3, int n4) {
        GridData gridData = new GridData();
        gridData.minimumWidth = n3;
        gridData.minimumHeight = n4;
        if (n > 0) {
            gridData.widthHint = n;
        } else {
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
        }
        if (n2 > 0) {
            gridData.heightHint = n;
        } else {
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
        }
        return gridData;
    }

    public void select(Option option) {
        this.hideAll();
        option.setVisible(true);
        this.dialog.redraw();
    }

    private void hideAll() {
        Iterator iterator = this.options.iterator();
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            option.setVisible(false);
        }
    }

    protected void updateOptions() {
        Iterator iterator = this.options.iterator();
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            option.updateConfig();
        }
        this.config.save();
    }

    protected void setDefaults() {
        Iterator iterator = this.options.iterator();
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            option.updateDefaults();
        }
        this.config.save();
    }

    protected void applyConfig(final boolean bl) {
        new Thread(new Runnable(){

            public void run() {
                TGConfigEditor.this.runnables = new ArrayList();
                Iterator iterator = TGConfigEditor.this.options.iterator();
                while (iterator.hasNext()) {
                    Option option = (Option)iterator.next();
                    option.applyConfig(bl);
                }
                new SyncThread(new Runnable(){

                    public void run() {
                        Iterator iterator = (this).TGConfigEditor.this.runnables.iterator();
                        while (iterator.hasNext()) {
                            Runnable runnable = (Runnable)iterator.next();
                            runnable.run();
                        }
                        new Thread(new Runnable(){

                            public void run() {
                                TuxGuitar.instance().fireUpdate();
                                TuxGuitar.instance().updateCache(true);
                                TuxGuitar.instance().loadCursor(0);
                                ActionLock.unlock();
                            }
                        }).start();
                    }
                }).start();
            }
        }).start();
    }

    protected void dispose() {
        Iterator iterator = this.options.iterator();
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            option.dispose();
        }
        this.getDialog().dispose();
    }

    public Properties getDefaults() {
        if (this.defaults == null) {
            this.defaults = new TGConfigDefaults().getProperties();
        }
        return this.defaults;
    }

    public TGConfigManager getConfig() {
        return this.config;
    }

    public TablatureEditor getEditor() {
        return TuxGuitar.instance().getTablatureEditor();
    }

    public Shell getDialog() {
        return this.dialog;
    }

    public void addSyncThread(Runnable runnable) {
        this.runnables.add(runnable);
    }
}

