/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config.items;

import java.util.Properties;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.system.config.TGConfigEditor;
import org.herac.tuxguitar.gui.system.config.TGConfigManager;

public abstract class Option
extends SelectionAdapter {
    protected static final int DEFAULT_INDENT = 20;
    private TGConfigEditor configEditor;
    private ToolBar toolBar;
    private Group group;
    private Composite composite;
    private ToolItem toolItem;

    public Option(TGConfigEditor tGConfigEditor, ToolBar toolBar, Composite composite, String string, int n, int n2) {
        this.configEditor = tGConfigEditor;
        this.toolBar = toolBar;
        this.toolItem = new ToolItem(toolBar, 16);
        this.group = new Group(composite, 16);
        this.group.setLayout(new GridLayout());
        this.group.setLayoutData(this.getGroupData());
        this.group.setText(string);
        this.composite = new Composite(this.group, 16);
        this.composite.setLayout(new GridLayout());
        this.composite.setLayoutData(new GridData(n, n2, true, true));
    }

    public Option(TGConfigEditor tGConfigEditor, ToolBar toolBar, Composite composite, String string) {
        this(tGConfigEditor, toolBar, composite, string, 4, 128);
    }

    public abstract void createOption();

    public abstract void updateConfig();

    public abstract void updateDefaults();

    public abstract void applyConfig(boolean var1);

    public void setVisible(boolean bl) {
        this.toolItem.setSelection(bl);
        this.group.setVisible(bl);
        this.group.setFocus();
        this.group.redraw();
    }

    public void dispose() {
    }

    protected Label showLabel(Composite composite, int n, int n2, int n3, String string) {
        return this.showLabel(composite, 4, 0x1000000, n, n2, n3, string);
    }

    protected Label showLabel(Composite composite, int n, int n2, int n3, int n4, int n5, String string) {
        return this.showLabel(composite, n, n2, true, true, n3, n4, n5, string);
    }

    protected Label showLabel(Composite composite, int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, String string) {
        Label label = new Label(composite, n3);
        label.setText(string);
        label.setLayoutData(new GridData(n, n2, bl, bl2));
        FontData[] fontDataArray = label.getFont().getFontData();
        if (fontDataArray.length > 0) {
            final Font font = new Font((Device)label.getDisplay(), fontDataArray[0].getName(), fontDataArray[0].getHeight() + n5, n4);
            label.setFont(font);
            label.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    font.dispose();
                }
            });
        }
        return label;
    }

    protected Label showImageLabel(Composite composite, int n, Image image) {
        Label label = new Label(composite, n);
        label.setImage(image);
        return label;
    }

    protected FormData getGroupData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        return formData;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.configEditor.select(this);
    }

    public Composite getComposite() {
        return this.composite;
    }

    public ToolItem getToolItem() {
        return this.toolItem;
    }

    public Point computeSize() {
        return this.computeSize(-1, -1);
    }

    protected Point computeSize(int n, int n2) {
        return this.group.computeSize(n, n2);
    }

    public TGConfigManager getConfig() {
        return this.configEditor.getConfig();
    }

    public Properties getDefaults() {
        return this.configEditor.getDefaults();
    }

    public TablatureEditor getEditor() {
        return this.configEditor.getEditor();
    }

    public Display getDisplay() {
        return this.toolBar.getDisplay();
    }

    public Shell getShell() {
        return this.toolBar.getShell();
    }

    protected boolean isDisposed() {
        return this.toolBar.isDisposed() || this.toolBar.getShell().isDisposed();
    }

    public GridData makeGridData(int n, int n2, int n3, int n4) {
        return this.configEditor.makeGridData(n, n2, n3, n4);
    }

    protected GridData getTabbedData() {
        return this.getTabbedData(20, 4, 0x1000000);
    }

    protected GridData getTabbedData(int n, int n2, boolean bl, boolean bl2) {
        return this.getTabbedData(20, n, n2, bl, bl2);
    }

    protected GridData getTabbedData(int n, int n2) {
        return this.getTabbedData(20, n, n2);
    }

    protected GridData getTabbedData(int n, int n2, int n3) {
        return this.getTabbedData(n, n2, n3, true, true);
    }

    protected GridData getTabbedData(int n, int n2, int n3, boolean bl, boolean bl2) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = n2;
        gridData.grabExcessHorizontalSpace = bl;
        gridData.verticalAlignment = n3;
        gridData.grabExcessVerticalSpace = bl2;
        gridData.horizontalIndent = n;
        return gridData;
    }

    public GridData makeGridData(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, int n7, int n8) {
        GridData gridData = new GridData();
        gridData.widthHint = n;
        gridData.heightHint = n2;
        gridData.minimumWidth = n3;
        gridData.minimumHeight = n4;
        gridData.horizontalAlignment = n5;
        gridData.verticalAlignment = n6;
        gridData.grabExcessHorizontalSpace = bl;
        gridData.grabExcessVerticalSpace = bl2;
        gridData.horizontalSpan = n7;
        gridData.verticalSpan = n8;
        return gridData;
    }

    public void pack() {
        this.configEditor.pack();
    }

    public void loadCursor(int n) {
        TuxGuitar.instance().loadCursor(this.configEditor.getDialog(), n);
    }

    protected void addSyncThread(Runnable runnable) {
        this.configEditor.addSyncThread(runnable);
    }
}

