/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config.items;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.system.config.TGConfigEditor;
import org.herac.tuxguitar.gui.system.config.items.Option;
import org.herac.tuxguitar.gui.util.TGFileUtils;

public class SkinOption
extends Option {
    protected boolean initialized = false;
    protected List skins;
    protected Combo combo;
    protected Label nameLabel;
    protected Label authorLabel;
    protected Label versionLabel;
    protected Label descriptionLabel;
    protected Image preview;
    protected Composite previewArea;

    public SkinOption(TGConfigEditor tGConfigEditor, ToolBar toolBar, Composite composite) {
        super(tGConfigEditor, toolBar, composite, TuxGuitar.getProperty("settings.config.skin"), 4, 4);
    }

    public void createOption() {
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.skin"));
        this.getToolItem().setImage(TuxGuitar.instance().getIconManager().getOptionSkin());
        this.getToolItem().addSelectionListener(this);
        this.showLabel(this.getComposite(), 4, 128, true, false, 16576, 1, 0, TuxGuitar.getProperty("settings.config.skin.choose"));
        Composite composite = new Composite(this.getComposite(), 0);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(this.getTabbedData(4, 4, true, false));
        this.combo = new Combo(composite, 12);
        this.combo.setLayoutData(new GridData(4, 4, true, true));
        Composite composite2 = new Composite(this.getComposite(), 0);
        composite2.setLayout(new GridLayout(2, false));
        composite2.setLayoutData(this.getTabbedData(4, 4, true, false));
        this.showLabel(composite2, 4, 0x1000000, false, true, 16576, 1, 0, TuxGuitar.getProperty("name") + ": ");
        this.nameLabel = this.showLabel(composite2, 4, 0x1000000, 16576, 0, 0, "");
        this.showLabel(composite2, 4, 0x1000000, false, true, 16576, 1, 0, TuxGuitar.getProperty("author") + ": ");
        this.authorLabel = this.showLabel(composite2, 4, 0x1000000, 16576, 0, 0, "");
        this.showLabel(composite2, 4, 0x1000000, false, true, 16576, 1, 0, TuxGuitar.getProperty("version") + ": ");
        this.versionLabel = this.showLabel(composite2, 4, 0x1000000, 16576, 0, 0, "");
        this.showLabel(composite2, 4, 0x1000000, false, true, 16576, 1, 0, TuxGuitar.getProperty("description") + ": ");
        this.descriptionLabel = this.showLabel(composite2, 4, 0x1000000, 16576, 0, 0, "");
        Composite composite3 = new Composite(this.getComposite(), 0);
        composite3.setLayout(new GridLayout());
        composite3.setLayoutData(this.getTabbedData(4, 4, true, true));
        this.previewArea = new Composite(composite3, 0x20000000);
        this.previewArea.setLayoutData(new GridData(4, 4, true, true));
        this.previewArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (SkinOption.this.preview != null && !SkinOption.this.preview.isDisposed()) {
                    paintEvent.gc.drawImage(SkinOption.this.preview, 0, 0);
                }
            }
        });
        this.loadConfig();
    }

    protected void loadConfig() {
        new Thread(new Runnable(){

            public void run() {
                File file;
                SkinOption.this.skins = new ArrayList();
                String string = TGFileUtils.PATH_SKINS;
                if (string != null && (file = new File(string)).exists() && file.isDirectory()) {
                    String[] stringArray = file.list();
                    for (int i = 0; i < stringArray.length; ++i) {
                        Object object;
                        Properties properties = new Properties();
                        try {
                            object = new File(string + File.separator + stringArray[i] + File.separator + "skin.properties");
                            if (((File)object).exists()) {
                                properties.load(new FileInputStream((File)object));
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            fileNotFoundException.printStackTrace();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        object = new SkinInfo(stringArray[i]);
                        ((SkinInfo)object).setName(properties.getProperty("name", ((SkinInfo)object).getSkin()));
                        ((SkinInfo)object).setAuthor(properties.getProperty("author", "Not available."));
                        ((SkinInfo)object).setVersion(properties.getProperty("version", "Not available."));
                        ((SkinInfo)object).setDescription(properties.getProperty("description", "Not available."));
                        ((SkinInfo)object).setDate(properties.getProperty("date", null));
                        ((SkinInfo)object).setPreview(properties.getProperty("preview", null));
                        SkinOption.this.skins.add(object);
                    }
                    new SyncThread(new Runnable(){

                        public void run() {
                            if (!SkinOption.this.isDisposed()) {
                                int n;
                                for (n = 0; n < (this).SkinOption.this.skins.size(); ++n) {
                                    SkinInfo skinInfo = (SkinInfo)(this).SkinOption.this.skins.get(n);
                                    (this).SkinOption.this.combo.add(skinInfo.getName());
                                    if (!skinInfo.getSkin().equals(SkinOption.this.getConfig().getStringConfigValue("skin"))) continue;
                                    (this).SkinOption.this.combo.select(n);
                                }
                                (this).SkinOption.this.combo.addSelectionListener(new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent selectionEvent) {
                                        int n = ((this).this).SkinOption.this.combo.getSelectionIndex();
                                        if (n >= 0 && n < ((this).this).SkinOption.this.skins.size()) {
                                            SkinOption.this.showSkinInfo((SkinInfo)((this).this).SkinOption.this.skins.get(n));
                                        }
                                    }
                                });
                                n = (this).SkinOption.this.combo.getSelectionIndex();
                                if (n >= 0 && n < (this).SkinOption.this.skins.size()) {
                                    SkinOption.this.showSkinInfo((SkinInfo)(this).SkinOption.this.skins.get(n));
                                }
                                (this).SkinOption.this.initialized = true;
                                SkinOption.this.pack();
                            }
                        }
                    }).start();
                }
            }
        }).start();
    }

    protected void showSkinInfo(final SkinInfo skinInfo) {
        this.loadCursor(1);
        new SyncThread(new Runnable(){

            public void run() {
                if (!SkinOption.this.isDisposed()) {
                    SkinOption.this.disposePreview();
                    SkinOption.this.nameLabel.setText(skinInfo.getName());
                    SkinOption.this.authorLabel.setText(skinInfo.getAuthor());
                    SkinOption.this.descriptionLabel.setText(skinInfo.getDescription());
                    SkinOption.this.versionLabel.setText(skinInfo.getDate() == null ? skinInfo.getVersion() : skinInfo.getVersion() + " (" + skinInfo.getDate() + ")");
                    if (skinInfo.getPreview() != null) {
                        SkinOption.this.preview = TGFileUtils.loadImage(skinInfo.getSkin(), skinInfo.getPreview());
                    }
                    SkinOption.this.previewArea.redraw();
                    SkinOption.this.loadCursor(0);
                }
            }
        }).start();
    }

    public void updateConfig() {
        int n;
        if (this.initialized && (n = this.combo.getSelectionIndex()) >= 0 && n < this.skins.size()) {
            SkinInfo skinInfo = (SkinInfo)this.skins.get(n);
            this.getConfig().setProperty("skin", skinInfo.getSkin());
        }
    }

    public void updateDefaults() {
        if (this.initialized) {
            this.getConfig().setProperty("skin", this.getDefaults().getProperty("skin"));
        }
    }

    public void applyConfig(boolean bl) {
        if (bl || this.initialized && TuxGuitar.instance().getIconManager().shouldReload()) {
            this.addSyncThread(new Runnable(){

                public void run() {
                    TuxGuitar.instance().loadSkin();
                }
            });
        }
    }

    public void dispose() {
        this.disposePreview();
    }

    public void disposePreview() {
        if (this.preview != null && !this.preview.isDisposed()) {
            this.preview.dispose();
        }
    }

    private class SkinInfo {
        private String skin;
        private String name;
        private String date;
        private String author;
        private String version;
        private String description;
        private String preview;

        public SkinInfo(String string) {
            this.skin = string;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String string) {
            this.author = string;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String string) {
            this.date = string;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String string) {
            this.version = string;
        }

        public String getSkin() {
            return this.skin;
        }

        public String getPreview() {
            return this.preview;
        }

        public void setPreview(String string) {
            this.preview = string;
        }
    }
}

