/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config.items;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.system.config.TGConfigEditor;
import org.herac.tuxguitar.gui.system.config.items.Option;

public class StylesOption
extends Option {
    private static final int BUTTON_WIDTH = 200;
    private static final int BUTTON_HEIGHT = 0;
    protected boolean initialized = false;
    protected FontData defaultFontData = new FontData();
    protected FontData noteFontData = new FontData();
    protected FontData timeSignatureFontData = new FontData();
    protected FontData textFontData = new FontData();
    protected FontData lyricFontData = new FontData();
    protected FontData printerDefaultFontData = new FontData();
    protected FontData printerNoteFontData = new FontData();
    protected FontData printerTSFontData = new FontData();
    protected FontData printerTextFontData = new FontData();
    protected FontData printerLyricFontData = new FontData();
    protected RGB scoreNoteRGB = new RGB(0, 0, 0);
    protected RGB tabNoteRGB = new RGB(0, 0, 0);
    protected RGB playNoteRGB = new RGB(0, 0, 0);
    protected RGB linesRGB = new RGB(0, 0, 0);
    protected Button defaultFontButton;
    protected Button noteFontButton;
    protected Button timeSignatureFontButton;
    protected Button textFontButton;
    protected Button lyricFontButton;
    protected Button printerDefaultFontButton;
    protected Button printerNoteFontButton;
    protected Button printerTSFontButton;
    protected Button printerTextFontButton;
    protected Button printerLyricFontButton;
    protected Button scoreNoteColorButton;
    protected Button tabNoteColorButton;
    protected Button playNoteColorButton;
    protected Button linesColorButton;

    public StylesOption(TGConfigEditor tGConfigEditor, ToolBar toolBar, Composite composite) {
        super(tGConfigEditor, toolBar, composite, TuxGuitar.getProperty("settings.config.styles"));
    }

    public void createOption() {
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.styles"));
        this.getToolItem().setImage(TuxGuitar.instance().getIconManager().getOptionStyle());
        this.getToolItem().addSelectionListener(this);
        this.showLabel(this.getComposite(), 16576, 1, 0, TuxGuitar.getProperty("settings.config.styles.general"));
        Composite composite = new Composite(this.getComposite(), 0);
        composite.setLayout(new GridLayout(2, false));
        composite.setLayoutData(this.getTabbedData());
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.default"));
        this.defaultFontButton = new Button(composite, 8);
        this.defaultFontButton.setLayoutData(this.makeButtonData());
        this.addFontButtonListeners(this.defaultFontButton, this.defaultFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.note"));
        this.noteFontButton = new Button(composite, 8);
        this.noteFontButton.setLayoutData(this.makeButtonData());
        this.addFontButtonListeners(this.noteFontButton, this.noteFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.lyric"));
        this.lyricFontButton = new Button(composite, 8);
        this.lyricFontButton.setLayoutData(this.makeButtonData());
        this.addFontButtonListeners(this.lyricFontButton, this.lyricFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.text"));
        this.textFontButton = new Button(composite, 8);
        this.textFontButton.setLayoutData(this.makeButtonData());
        this.addFontButtonListeners(this.textFontButton, this.textFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.time-signature"));
        this.timeSignatureFontButton = new Button(composite, 8);
        this.timeSignatureFontButton.setLayoutData(this.makeButtonData());
        this.addFontButtonListeners(this.timeSignatureFontButton, this.timeSignatureFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.color.score-note"));
        this.scoreNoteColorButton = new Button(composite, 8);
        this.scoreNoteColorButton.setLayoutData(this.makeButtonData());
        this.addColorButtonListeners(this.scoreNoteColorButton, this.scoreNoteRGB);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.color.tab-note"));
        this.tabNoteColorButton = new Button(composite, 8);
        this.tabNoteColorButton.setLayoutData(this.makeButtonData());
        this.addColorButtonListeners(this.tabNoteColorButton, this.tabNoteRGB);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.color.play-note"));
        this.playNoteColorButton = new Button(composite, 8);
        this.playNoteColorButton.setLayoutData(this.makeButtonData());
        this.addColorButtonListeners(this.playNoteColorButton, this.playNoteRGB);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.color.lines"));
        this.linesColorButton = new Button(composite, 8);
        this.linesColorButton.setLayoutData(this.makeButtonData());
        this.addColorButtonListeners(this.linesColorButton, this.linesRGB);
        this.showLabel(this.getComposite(), 16576, 1, 0, TuxGuitar.getProperty("settings.config.styles.printer"));
        composite = new Composite(this.getComposite(), 0);
        composite.setLayout(new GridLayout(2, false));
        composite.setLayoutData(this.getTabbedData());
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.default"));
        this.printerDefaultFontButton = new Button(composite, 8);
        this.printerDefaultFontButton.setLayoutData(this.makeButtonData());
        this.addFontButtonListeners(this.printerDefaultFontButton, this.printerDefaultFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.note"));
        this.printerNoteFontButton = new Button(composite, 8);
        this.printerNoteFontButton.setLayoutData(this.makeButtonData());
        this.addFontButtonListeners(this.printerNoteFontButton, this.printerNoteFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.lyric"));
        this.printerLyricFontButton = new Button(composite, 8);
        this.printerLyricFontButton.setLayoutData(this.makeButtonData());
        this.addFontButtonListeners(this.printerLyricFontButton, this.printerLyricFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.text"));
        this.printerTextFontButton = new Button(composite, 8);
        this.printerTextFontButton.setLayoutData(this.makeButtonData());
        this.addFontButtonListeners(this.printerTextFontButton, this.printerTextFontData);
        this.showLabel(composite, 4, 0x1000000, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.time-signature"));
        this.printerTSFontButton = new Button(composite, 8);
        this.printerTSFontButton.setLayoutData(this.makeButtonData());
        this.addFontButtonListeners(this.printerTSFontButton, this.printerTSFontData);
        this.loadConfig();
    }

    private void addFontButtonListeners(final Button button, final FontData fontData) {
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (StylesOption.this.initialized) {
                    Font font = new Font((Device)StylesOption.this.getDisplay(), fontData);
                    FontData[] fontDataArray = font.getFontData();
                    font.dispose();
                    FontDialog fontDialog = new FontDialog(StylesOption.this.getShell());
                    fontDialog.setFontList(fontDataArray);
                    FontData fontData2 = fontDialog.open();
                    if (fontData2 != null) {
                        StylesOption.this.loadFontData(fontData2, fontData, button);
                    }
                }
            }
        });
    }

    private void addColorButtonListeners(final Button button, final RGB rGB) {
        button.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Color color = new Color(StylesOption.this.getDisplay(), rGB);
                TGPainter tGPainter = new TGPainter(paintEvent.gc);
                tGPainter.setBackground(color);
                tGPainter.initPath(2);
                tGPainter.addRectangle(5.0f, 5.0f, button.getSize().x - 10, button.getSize().y - 10);
                tGPainter.closePath();
                color.dispose();
            }
        });
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (StylesOption.this.initialized) {
                    ColorDialog colorDialog = new ColorDialog(StylesOption.this.getShell());
                    colorDialog.setRGB(rGB);
                    colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                    RGB rGB2 = colorDialog.open();
                    if (rGB2 != null) {
                        StylesOption.this.loadColor(rGB2, rGB, button);
                    }
                }
            }
        });
    }

    protected void loadFontData(FontData fontData, FontData fontData2, Button button) {
        this.copyFontData(fontData, fontData2);
        this.setButtonFontData(button, fontData2);
    }

    protected void loadColor(RGB rGB, RGB rGB2, Button button) {
        this.copyRGB(rGB, rGB2);
        button.redraw();
    }

    protected void setButtonFontData(Button button, FontData fontData) {
        String string = fontData.getName();
        if ((fontData.getStyle() & 1) != 0) {
            string = string + " Bold";
        }
        if ((fontData.getStyle() & 2) != 0) {
            string = string + " Italic";
        }
        string = string + " " + fontData.getHeight();
        button.setText(string);
    }

    protected void copyFontData(FontData fontData, FontData fontData2) {
        fontData2.setName(fontData.getName());
        fontData2.setStyle(fontData.getStyle());
        fontData2.setHeight(fontData.getHeight());
    }

    protected void copyRGB(RGB rGB, RGB rGB2) {
        rGB2.red = rGB.red;
        rGB2.green = rGB.green;
        rGB2.blue = rGB.blue;
    }

    protected void loadConfig() {
        new Thread(new Runnable(){

            public void run() {
                final FontData fontData = StylesOption.this.getConfig().getFontDataConfigValue("font.default");
                final FontData fontData2 = StylesOption.this.getConfig().getFontDataConfigValue("font.note");
                final FontData fontData3 = StylesOption.this.getConfig().getFontDataConfigValue("font.time-signature");
                final FontData fontData4 = StylesOption.this.getConfig().getFontDataConfigValue("font.text");
                final FontData fontData5 = StylesOption.this.getConfig().getFontDataConfigValue("font.lyric");
                final FontData fontData6 = StylesOption.this.getConfig().getFontDataConfigValue("font.printer.default");
                final FontData fontData7 = StylesOption.this.getConfig().getFontDataConfigValue("font.printer.note");
                final FontData fontData8 = StylesOption.this.getConfig().getFontDataConfigValue("font.printer.time-signature");
                final FontData fontData9 = StylesOption.this.getConfig().getFontDataConfigValue("font.printer.text");
                final FontData fontData10 = StylesOption.this.getConfig().getFontDataConfigValue("font.printer.lyric");
                final RGB rGB = StylesOption.this.getConfig().getRGBConfigValue("color.score.note");
                final RGB rGB2 = StylesOption.this.getConfig().getRGBConfigValue("color.tab.note");
                final RGB rGB3 = StylesOption.this.getConfig().getRGBConfigValue("color.play.note");
                final RGB rGB4 = StylesOption.this.getConfig().getRGBConfigValue("color.line");
                new SyncThread(new Runnable(){

                    public void run() {
                        if (!StylesOption.this.isDisposed()) {
                            StylesOption.this.loadFontData(fontData, (this).StylesOption.this.defaultFontData, (this).StylesOption.this.defaultFontButton);
                            StylesOption.this.loadFontData(fontData2, (this).StylesOption.this.noteFontData, (this).StylesOption.this.noteFontButton);
                            StylesOption.this.loadFontData(fontData3, (this).StylesOption.this.timeSignatureFontData, (this).StylesOption.this.timeSignatureFontButton);
                            StylesOption.this.loadFontData(fontData4, (this).StylesOption.this.textFontData, (this).StylesOption.this.textFontButton);
                            StylesOption.this.loadFontData(fontData5, (this).StylesOption.this.lyricFontData, (this).StylesOption.this.lyricFontButton);
                            StylesOption.this.loadFontData(fontData6, (this).StylesOption.this.printerDefaultFontData, (this).StylesOption.this.printerDefaultFontButton);
                            StylesOption.this.loadFontData(fontData7, (this).StylesOption.this.printerNoteFontData, (this).StylesOption.this.printerNoteFontButton);
                            StylesOption.this.loadFontData(fontData8, (this).StylesOption.this.printerTSFontData, (this).StylesOption.this.printerTSFontButton);
                            StylesOption.this.loadFontData(fontData9, (this).StylesOption.this.printerTextFontData, (this).StylesOption.this.printerTextFontButton);
                            StylesOption.this.loadFontData(fontData10, (this).StylesOption.this.printerLyricFontData, (this).StylesOption.this.printerLyricFontButton);
                            StylesOption.this.loadColor(rGB, (this).StylesOption.this.scoreNoteRGB, (this).StylesOption.this.scoreNoteColorButton);
                            StylesOption.this.loadColor(rGB2, (this).StylesOption.this.tabNoteRGB, (this).StylesOption.this.tabNoteColorButton);
                            StylesOption.this.loadColor(rGB3, (this).StylesOption.this.playNoteRGB, (this).StylesOption.this.playNoteColorButton);
                            StylesOption.this.loadColor(rGB4, (this).StylesOption.this.linesRGB, (this).StylesOption.this.linesColorButton);
                            (this).StylesOption.this.initialized = true;
                            StylesOption.this.pack();
                        }
                    }
                }).start();
            }
        }).start();
    }

    public GridData makeButtonData() {
        GridData gridData = new GridData(4, 0x1000000, true, true);
        gridData.minimumWidth = 200;
        gridData.minimumHeight = 0;
        return gridData;
    }

    public void updateConfig() {
        if (this.initialized) {
            this.getConfig().setProperty("font.default", this.defaultFontData);
            this.getConfig().setProperty("font.note", this.noteFontData);
            this.getConfig().setProperty("font.time-signature", this.timeSignatureFontData);
            this.getConfig().setProperty("font.text", this.textFontData);
            this.getConfig().setProperty("font.lyric", this.lyricFontData);
            this.getConfig().setProperty("font.printer.default", this.printerDefaultFontData);
            this.getConfig().setProperty("font.printer.note", this.printerNoteFontData);
            this.getConfig().setProperty("font.printer.time-signature", this.printerTSFontData);
            this.getConfig().setProperty("font.printer.text", this.printerTextFontData);
            this.getConfig().setProperty("font.printer.lyric", this.printerLyricFontData);
            this.getConfig().setProperty("color.score.note", this.scoreNoteRGB);
            this.getConfig().setProperty("color.tab.note", this.tabNoteRGB);
            this.getConfig().setProperty("color.play.note", this.playNoteRGB);
            this.getConfig().setProperty("color.line", this.linesRGB);
        }
    }

    public void updateDefaults() {
        if (this.initialized) {
            this.getConfig().setProperty("font.default", this.getDefaults().getProperty("font.default"));
            this.getConfig().setProperty("font.note", this.getDefaults().getProperty("font.note"));
            this.getConfig().setProperty("font.time-signature", this.getDefaults().getProperty("font.time-signature"));
            this.getConfig().setProperty("font.text", this.getDefaults().getProperty("font.text"));
            this.getConfig().setProperty("font.lyric", this.getDefaults().getProperty("font.lyric"));
            this.getConfig().setProperty("font.printer.default", this.getDefaults().getProperty("font.printer.default"));
            this.getConfig().setProperty("font.printer.note", this.getDefaults().getProperty("font.printer.note"));
            this.getConfig().setProperty("font.printer.time-signature", this.getDefaults().getProperty("font.printer.time-signature"));
            this.getConfig().setProperty("font.printer.text", this.getDefaults().getProperty("font.printer.text"));
            this.getConfig().setProperty("font.printer.lyric", this.getDefaults().getProperty("font.printer.lyric"));
            this.getConfig().setProperty("color.score.note", this.getDefaults().getProperty("color.score.note"));
            this.getConfig().setProperty("color.tab.note", this.getDefaults().getProperty("color.tab.note"));
            this.getConfig().setProperty("color.play.note", this.getDefaults().getProperty("color.play.note"));
            this.getConfig().setProperty("color.line", this.getDefaults().getProperty("color.line"));
        }
    }

    public void applyConfig(boolean bl) {
        if (bl || this.initialized) {
            this.addSyncThread(new Runnable(){

                public void run() {
                    TuxGuitar.instance().loadStyles();
                }
            });
        }
    }
}

