/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.plugins.base;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.plugins.TGPluginException;
import org.herac.tuxguitar.gui.system.plugins.base.TGPluginAdapter;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.base.MidiPortProvider;

public abstract class TGMidiPortProviderPlugin
extends TGPluginAdapter {
    private boolean loaded;
    private MidiPortProvider provider;

    protected abstract MidiPortProvider getProvider();

    public void init() {
        this.provider = this.getProvider();
        this.loaded = false;
    }

    public void close() throws TGPluginException {
        try {
            this.provider.closeAll();
        }
        catch (MidiPlayerException midiPlayerException) {
            throw new TGPluginException(midiPlayerException.getMessage(), midiPlayerException);
        }
    }

    protected void addPlugin() throws TGPluginException {
        if (!this.loaded) {
            try {
                TuxGuitar.instance().getPlayer().addPortProvider(this.provider);
                this.loaded = true;
            }
            catch (MidiPlayerException midiPlayerException) {
                throw new TGPluginException(midiPlayerException.getMessage(), midiPlayerException);
            }
        }
    }

    protected void removePlugin() throws TGPluginException {
        if (this.loaded) {
            try {
                TuxGuitar.instance().getPlayer().removePortProvider(this.provider);
                this.loaded = false;
            }
            catch (MidiPlayerException midiPlayerException) {
                throw new TGPluginException(midiPlayerException.getMessage(), midiPlayerException);
            }
        }
    }

    public void setEnabled(boolean bl) throws TGPluginException {
        if (bl) {
            this.addPlugin();
        } else {
            this.removePlugin();
        }
    }
}

