/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.table;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.ActionLock;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.system.language.LanguageLoader;
import org.herac.tuxguitar.gui.table.TGTable;
import org.herac.tuxguitar.gui.table.TGTableCanvasPainter;
import org.herac.tuxguitar.gui.table.TGTableRow;
import org.herac.tuxguitar.player.base.MidiInstrument;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGTrack;

public class TGTableViewer
implements LanguageLoader {
    public static final Color[] BACKGROUNDS = new Color[]{new Color(TuxGuitar.instance().getDisplay(), 255, 255, 255), new Color(TuxGuitar.instance().getDisplay(), 238, 238, 238), new Color(TuxGuitar.instance().getDisplay(), 192, 192, 192)};
    private Composite composite;
    private ScrollBar hSroll;
    private TGTable table;
    private int selectedTrack;
    private int selectedMeasure;
    private int trackCount = 0;
    private boolean autoSizeEnabled;
    private boolean update;
    private boolean followScroll;

    public TGTableViewer() {
        TuxGuitar.instance().getLanguageManager().addLoader(this);
    }

    public void init(Composite composite) {
        this.composite = new Composite(composite, 256);
        this.addLayout();
        this.addTable();
        this.addHScroll();
        this.loadConfig();
    }

    private void addLayout() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.getComposite().setLayout(gridLayout);
    }

    private void addHScroll() {
        this.hSroll = this.getComposite().getHorizontalBar();
        this.hSroll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TGTableViewer.this.redraw();
            }
        });
    }

    private void addTable() {
        MouseListener mouseListener = this.mouseFocusListener();
        this.table = new TGTable(this.getComposite());
        this.table.getColumnNumber().getControl().addMouseListener(mouseListener);
        this.table.getColumnName().getControl().addMouseListener(mouseListener);
        this.table.getColumnInstrument().getControl().addMouseListener(mouseListener);
        this.table.getColumnCanvas().getControl().addMouseListener(mouseListener);
        this.table.getColumnCanvas().getControl().addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                TuxGuitar.instance().getAction("action.composition.change-info").process(mouseEvent);
            }
        });
        this.fireUpdate(true);
        this.loadProperties();
    }

    public void loadProperties() {
        this.table.getColumnNumber().setTitle(TuxGuitar.getProperty("track.number"));
        this.table.getColumnName().setTitle(TuxGuitar.getProperty("track.name"));
        this.table.getColumnInstrument().setTitle(TuxGuitar.getProperty("track.instrument"));
    }

    public void fireUpdate(boolean bl) {
        this.update = true;
        if (bl) {
            this.trackCount = 0;
        }
    }

    public void updateItems() {
        this.followScroll = true;
    }

    public void updateHScroll() {
        int n = this.getEditor().getTablature().getCaret().getTrack().countMeasures() * this.table.getRowHeight();
        this.hSroll.setIncrement(this.table.getScrollIncrement());
        this.hSroll.setMaximum(n);
        this.hSroll.setThumb(Math.min(n, this.table.getColumnCanvas().getControl().getClientArea().width));
    }

    public TGTable getTable() {
        return this.table;
    }

    public int getHScrollSelection() {
        return this.hSroll.getSelection();
    }

    public TablatureEditor getEditor() {
        return TuxGuitar.instance().getTablatureEditor();
    }

    private String getInstrument(TGTrack tGTrack) {
        if (tGTrack.isPercussionTrack()) {
            return TuxGuitar.getProperty("track.name.default-percussion-name");
        }
        MidiInstrument[] midiInstrumentArray = TuxGuitar.instance().getPlayer().getInstruments();
        short s = tGTrack.getChannel().getInstrument();
        if (midiInstrumentArray != null && s >= 0 && s < midiInstrumentArray.length) {
            return midiInstrumentArray[s].getName();
        }
        return new String();
    }

    private void updateTable() {
        if (this.update) {
            int n;
            int n2 = TuxGuitar.instance().getSongManager().getSong().countTracks();
            this.table.removeRowsAfter(n2);
            for (n = this.table.getRowCount(); n < n2; ++n) {
                this.table.newRow();
            }
            for (n = 0; n < n2; ++n) {
                final TGTrack tGTrack = TuxGuitar.instance().getSongManager().getSong().getTrack(n);
                final TGTableRow tGTableRow = this.table.getRow(n);
                if (tGTableRow == null) continue;
                tGTableRow.getNumber().setText(Integer.toString(tGTrack.getNumber()));
                tGTableRow.getNumber().setData(tGTrack);
                tGTableRow.getName().setText(tGTrack.getName());
                tGTableRow.getName().setData(tGTrack);
                tGTableRow.getInstrument().setText(this.getInstrument(tGTrack));
                tGTableRow.getInstrument().setData(tGTrack);
                tGTableRow.setMouseListenerLabel(new MouseAdapter(){

                    public void mouseUp(MouseEvent mouseEvent) {
                        tGTableRow.getPainter().setFocus();
                    }

                    public void mouseDown(MouseEvent mouseEvent) {
                        if (tGTrack.getNumber() != TGTableViewer.this.getEditor().getTablature().getCaret().getTrack().getNumber()) {
                            TuxGuitar.instance().getAction("action.track.goto").process(mouseEvent);
                        }
                    }

                    public void mouseDoubleClick(final MouseEvent mouseEvent) {
                        new Thread(new Runnable(){

                            public void run() {
                                ActionLock.waitFor();
                                TuxGuitar.instance().getAction("action.track.properties").process(mouseEvent);
                            }
                        }).start();
                    }
                });
                tGTableRow.setMouseListenerCanvas(new MouseAdapter(){

                    public void mouseUp(MouseEvent mouseEvent) {
                        tGTableRow.getPainter().setFocus();
                    }

                    public void mouseDown(MouseEvent mouseEvent) {
                        int n = (mouseEvent.x + TGTableViewer.this.getHScrollSelection()) / TGTableViewer.this.getTable().getRowHeight();
                        if (n >= 0 && n < tGTrack.countMeasures()) {
                            TGMeasureImpl tGMeasureImpl = (TGMeasureImpl)tGTrack.getMeasure(n);
                            TGBeat tGBeat = TuxGuitar.instance().getSongManager().getMeasureManager().getFirstBeat(tGMeasureImpl.getBeats());
                            if (tGBeat != null) {
                                TGTableViewer.this.getEditor().getTablature().getCaret().moveTo((TGTrackImpl)tGTrack, tGMeasureImpl, tGBeat, 1);
                                TuxGuitar.instance().updateCache(true);
                            }
                        }
                    }
                });
                tGTableRow.setPaintListenerCanvas(new TGTableCanvasPainter(this, tGTrack));
            }
            this.table.update();
            this.selectedTrack = 0;
            this.selectedMeasure = 0;
            if (this.autoSizeEnabled && this.trackCount != n2) {
                TuxGuitar.instance().setTableHeight(this.getHeight());
                this.trackCount = n2;
            }
        }
        this.update = false;
    }

    private int getHeight() {
        return this.table.getMinHeight() + this.getComposite().getHorizontalBar().getSize().y;
    }

    private void redrawRows(int n) {
        int n2 = this.table.getRowCount();
        for (int i = 0; i < n2; ++i) {
            TGTableRow tGTableRow = this.table.getRow(i);
            tGTableRow.getPainter().redraw();
            if (this.selectedTrack == n) continue;
            tGTableRow.setBackground(n - 1 == i ? BACKGROUNDS[2] : BACKGROUNDS[i % 2]);
        }
    }

    public void redraw() {
        if (!this.isDisposed() && !TuxGuitar.instance().isLocked()) {
            TuxGuitar.instance().lock();
            this.updateTable();
            this.table.getColumnCanvas().setTitle(TuxGuitar.instance().getSongManager().getSong().getName());
            int n = this.getEditor().getTablature().getCaret().getTrack().getNumber();
            this.redrawRows(n);
            this.selectedTrack = n;
            this.selectedMeasure = 0;
            this.updateHScroll();
            if (this.followScroll) {
                this.followHorizontalScroll(this.getEditor().getTablature().getCaret().getMeasure().getNumber());
                this.followScroll = false;
            }
            this.getComposite().redraw();
            TuxGuitar.instance().unlock();
        }
    }

    public void redrawPlayingMode() {
        if (!this.isDisposed() && !TuxGuitar.instance().isLocked()) {
            TuxGuitar.instance().lock();
            TGMeasureImpl tGMeasureImpl = TuxGuitar.instance().getEditorCache().getPlayMeasure();
            if (tGMeasureImpl != null && tGMeasureImpl.getTrack() != null) {
                this.updateTable();
                int n = tGMeasureImpl.getTrack().getNumber();
                int n2 = tGMeasureImpl.getNumber();
                if (this.selectedTrack != n || this.selectedMeasure != n2) {
                    this.redrawRows(n);
                    this.followHorizontalScroll(n2);
                }
                this.selectedTrack = n;
                this.selectedMeasure = n2;
            }
            TuxGuitar.instance().unlock();
        }
    }

    private void followHorizontalScroll(int n) {
        int n2 = this.hSroll.getSelection();
        int n3 = this.hSroll.getThumb();
        int n4 = this.table.getRowHeight();
        int n5 = n * n4 - n4;
        if (n5 - n2 < 0 || n5 + n4 - n2 > n3) {
            this.hSroll.setSelection(n5);
        }
    }

    public void loadConfig() {
        this.autoSizeEnabled = TuxGuitar.instance().getConfig().getBooleanConfigValue("table.auto-size");
        this.trackCount = 0;
    }

    public static void disposeColors() {
        for (int i = 0; i < BACKGROUNDS.length; ++i) {
            BACKGROUNDS[i].dispose();
        }
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.getComposite().dispose();
            TGTableViewer.disposeColors();
        }
    }

    public boolean isDisposed() {
        return this.getComposite() == null || this.getComposite().isDisposed();
    }

    protected int getSelectedTrack() {
        return this.selectedTrack;
    }

    private MouseListener mouseFocusListener() {
        return new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                TGTableRow tGTableRow;
                TGTable tGTable = TGTableViewer.this.getTable();
                if (tGTable != null && (tGTableRow = tGTable.getRow(TGTableViewer.this.getSelectedTrack() - 1)) != null) {
                    tGTableRow.getPainter().setFocus();
                }
            }
        };
    }
}

