/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.transport;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.system.icons.IconLoader;
import org.herac.tuxguitar.gui.system.language.LanguageLoader;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.MidiTickUtil;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGMeasureHeader;

public class TGTransport
implements IconLoader,
LanguageLoader {
    private static final int PLAY_MODE_DELAY = 250;
    public static final int STATUS_STOPPED = 1;
    public static final int STATUS_PAUSED = 2;
    public static final int STATUS_RUNNING = 3;
    protected Shell dialog;
    protected Label label;
    protected ProgressBar tickProgress;
    protected Button metronome;
    protected Button mode;
    protected ToolBar toolBar;
    protected ToolItem first;
    protected ToolItem last;
    protected ToolItem previous;
    protected ToolItem next;
    protected ToolItem stop;
    protected ToolItem play;
    protected boolean editingTickScale;
    protected long redrawTime;
    protected int status;
    protected int position;

    public TGTransport() {
        TuxGuitar.instance().getIconManager().addLoader(this);
        TuxGuitar.instance().getLanguageManager().addLoader(this);
    }

    public void show() {
        this.dialog = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 2144);
        this.dialog.setImage(TuxGuitar.instance().getIconManager().getAppIcon());
        this.dialog.setLayout(new GridLayout());
        this.dialog.setText(TuxGuitar.getProperty("transport"));
        this.initComposites();
        this.initToolBar();
        this.redraw();
        TuxGuitar.instance().updateCache(true);
        DialogUtils.openDialog(this.dialog, 11);
    }

    private void initComposites() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        Composite composite = new Composite(this.dialog, 2048);
        composite.setLayout(gridLayout);
        composite.setLayoutData(new GridData(4, 4, true, true));
        this.initOptions(composite);
        this.initProgress(composite);
    }

    private void initOptions(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout());
        composite2.setLayoutData(new GridData(16384, 4, false, true));
        this.metronome = new Button(composite2, 2);
        this.metronome.setLayoutData(new GridData(4, 4, true, true));
        this.metronome.addSelectionListener(TuxGuitar.instance().getAction("action.transport.metronome"));
        this.mode = new Button(composite2, 8);
        this.mode.setLayoutData(new GridData(4, 4, true, true));
        this.mode.addSelectionListener(TuxGuitar.instance().getAction("action.transport.mode"));
        this.loadOptionIcons();
    }

    private void initProgress(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout());
        composite2.setLayoutData(new GridData(4, 4, true, true));
        this.initLabel(composite2);
        this.initScale(composite2);
    }

    private void initLabel(Composite composite) {
        final Font font = new Font((Device)composite.getDisplay(), "Minisystem", 36, 0);
        this.label = new Label(composite, 131072);
        this.label.setLayoutData(new GridData(4, 4, true, true));
        this.label.setBackground(composite.getDisplay().getSystemColor(2));
        this.label.setForeground(composite.getDisplay().getSystemColor(9));
        this.label.setFont(font);
        this.label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                font.dispose();
            }
        });
    }

    private void initScale(Composite composite) {
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.heightHint = 10;
        this.tickProgress = new ProgressBar(composite, 67840);
        this.tickProgress.setCursor(this.tickProgress.getDisplay().getSystemCursor(21));
        this.tickProgress.setLayoutData(gridData);
        this.tickProgress.setSelection(960);
        this.tickProgress.addMouseListener(new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                TGTransport.this.setEditingTickScale(true);
                TGTransport.this.updateProgressBar(mouseEvent.x);
            }

            public void mouseUp(MouseEvent mouseEvent) {
                TGTransport.this.gotoMeasure(TGTransport.this.getSongManager().getMeasureHeaderAt(TGTransport.this.tickProgress.getSelection()), true);
                TGTransport.this.setEditingTickScale(false);
            }
        });
        this.tickProgress.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                TGTransport.this.updateProgressBar(mouseEvent.x);
            }
        });
    }

    protected void updateProgressBar(int n) {
        if (this.isEditingTickScale()) {
            int n2 = this.tickProgress.getMinimum() + n * (this.tickProgress.getMaximum() - this.tickProgress.getMinimum()) / this.tickProgress.getSize().x;
            this.tickProgress.setSelection(Math.max(960, n2));
            this.redraw();
        }
    }

    private void initToolBar() {
        if (this.toolBar != null) {
            this.toolBar.dispose();
        }
        this.toolBar = new ToolBar(this.dialog, 0x800000);
        this.first = new ToolItem(this.toolBar, 8);
        this.first.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGTransport.this.gotoFirst();
            }
        });
        this.previous = new ToolItem(this.toolBar, 8);
        this.previous.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGTransport.this.gotoPrevious();
            }
        });
        this.stop = new ToolItem(this.toolBar, 8);
        this.stop.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGTransport.this.stop(selectionEvent);
            }
        });
        this.play = new ToolItem(this.toolBar, 8);
        this.play.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGTransport.this.play(selectionEvent);
            }
        });
        this.next = new ToolItem(this.toolBar, 8);
        this.next.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGTransport.this.gotoNext();
            }
        });
        this.last = new ToolItem(this.toolBar, 8);
        this.last.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGTransport.this.gotoLast();
            }
        });
        this.updateItems(true);
        this.loadProperties();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void updateItems() {
        this.updateItems(false);
    }

    public void updateItems(boolean bl) {
        if (!this.isDisposed()) {
            int n = this.getStatus();
            if (TuxGuitar.instance().getPlayer().isRunning()) {
                this.setStatus(3);
            } else if (TuxGuitar.instance().getPlayer().isPaused()) {
                this.setStatus(2);
            } else {
                this.setStatus(1);
            }
            if (bl || n != this.getStatus()) {
                if (this.getStatus() == 3) {
                    this.first.setImage(TuxGuitar.instance().getIconManager().getTransportFirst2());
                    this.last.setImage(TuxGuitar.instance().getIconManager().getTransportLast2());
                    this.previous.setImage(TuxGuitar.instance().getIconManager().getTransportPrevious2());
                    this.next.setImage(TuxGuitar.instance().getIconManager().getTransportNext2());
                    this.stop.setImage(TuxGuitar.instance().getIconManager().getTransportStop2());
                    this.play.setImage(TuxGuitar.instance().getIconManager().getTransportPause());
                } else if (this.getStatus() == 2) {
                    this.first.setImage(TuxGuitar.instance().getIconManager().getTransportFirst2());
                    this.last.setImage(TuxGuitar.instance().getIconManager().getTransportLast2());
                    this.previous.setImage(TuxGuitar.instance().getIconManager().getTransportPrevious2());
                    this.next.setImage(TuxGuitar.instance().getIconManager().getTransportNext2());
                    this.stop.setImage(TuxGuitar.instance().getIconManager().getTransportStop2());
                    this.play.setImage(TuxGuitar.instance().getIconManager().getTransportPlay2());
                } else if (this.getStatus() == 1) {
                    this.first.setImage(TuxGuitar.instance().getIconManager().getTransportFirst1());
                    this.last.setImage(TuxGuitar.instance().getIconManager().getTransportLast1());
                    this.previous.setImage(TuxGuitar.instance().getIconManager().getTransportPrevious1());
                    this.next.setImage(TuxGuitar.instance().getIconManager().getTransportNext1());
                    this.stop.setImage(TuxGuitar.instance().getIconManager().getTransportStop1());
                    this.play.setImage(TuxGuitar.instance().getIconManager().getTransportPlay1());
                }
                this.loadPlayText();
            }
            TGMeasureHeader tGMeasureHeader = this.getSongManager().getFirstMeasureHeader();
            TGMeasureHeader tGMeasureHeader2 = this.getSongManager().getLastMeasureHeader();
            this.tickProgress.setMinimum((int)tGMeasureHeader.getStart());
            this.tickProgress.setMaximum((int)(tGMeasureHeader2.getStart() + tGMeasureHeader2.getLength()) - 1);
            this.metronome.setSelection(TuxGuitar.instance().getPlayer().isMetronomeEnabled());
            this.redraw();
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty("transport"));
            this.stop.setToolTipText(TuxGuitar.getProperty("transport.stop"));
            this.first.setToolTipText(TuxGuitar.getProperty("transport.first"));
            this.last.setToolTipText(TuxGuitar.getProperty("transport.last"));
            this.previous.setToolTipText(TuxGuitar.getProperty("transport.previous"));
            this.next.setToolTipText(TuxGuitar.getProperty("transport.next"));
            this.metronome.setToolTipText(TuxGuitar.getProperty("transport.metronome"));
            this.mode.setToolTipText(TuxGuitar.getProperty("transport.mode"));
            this.loadPlayText();
        }
    }

    public void loadPlayText() {
        String string = TuxGuitar.getProperty(this.getStatus() == 3 ? "transport.pause" : "transport.start");
        this.play.setToolTipText(string);
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.initToolBar();
            this.loadOptionIcons();
            this.dialog.setImage(TuxGuitar.instance().getIconManager().getAppIcon());
            this.dialog.layout(true);
            this.dialog.pack(true);
        }
    }

    private void loadOptionIcons() {
        this.metronome.setImage(TuxGuitar.instance().getIconManager().getTransportMetronome());
        this.mode.setImage(TuxGuitar.instance().getIconManager().getTransportMode());
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public boolean isEditingTickScale() {
        return this.editingTickScale;
    }

    public void setEditingTickScale(boolean bl) {
        this.editingTickScale = bl;
    }

    protected TGSongManager getSongManager() {
        return TuxGuitar.instance().getSongManager();
    }

    public void gotoFirst() {
        this.gotoMeasure(this.getSongManager().getFirstMeasureHeader(), true);
    }

    public void gotoLast() {
        this.gotoMeasure(this.getSongManager().getLastMeasureHeader(), true);
    }

    public void gotoNext() {
        MidiPlayer midiPlayer = TuxGuitar.instance().getPlayer();
        TGMeasureHeader tGMeasureHeader = this.getSongManager().getMeasureHeaderAt(MidiTickUtil.getStart(midiPlayer.getTickPosition()));
        if (tGMeasureHeader != null) {
            this.gotoMeasure(this.getSongManager().getNextMeasureHeader(tGMeasureHeader), true);
        }
    }

    public void gotoPrevious() {
        MidiPlayer midiPlayer = TuxGuitar.instance().getPlayer();
        TGMeasureHeader tGMeasureHeader = this.getSongManager().getMeasureHeaderAt(MidiTickUtil.getStart(midiPlayer.getTickPosition()));
        if (tGMeasureHeader != null) {
            this.gotoMeasure(this.getSongManager().getPrevMeasureHeader(tGMeasureHeader), true);
        }
    }

    public void gotoMeasure(TGMeasureHeader tGMeasureHeader) {
        this.gotoMeasure(tGMeasureHeader, false);
    }

    protected void gotoMeasure(TGMeasureHeader tGMeasureHeader, boolean bl) {
        if (tGMeasureHeader != null && this.position != tGMeasureHeader.getNumber()) {
            TuxGuitar.instance().getPlayer().setTickPosition(MidiTickUtil.getTick(tGMeasureHeader.getStart()));
            if (bl) {
                TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().goToTickPosition();
                TuxGuitar.instance().updateCache(true);
            }
            this.redraw();
        }
    }

    private void checkPosition() {
        TGMeasureImpl tGMeasureImpl = null;
        tGMeasureImpl = TuxGuitar.instance().getPlayer().isRunning() ? TuxGuitar.instance().getEditorCache().getPlayMeasure() : TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getMeasure();
        this.position = tGMeasureImpl != null ? tGMeasureImpl.getNumber() : 0;
    }

    public void play(TypedEvent typedEvent) {
        TuxGuitar.instance().getAction("action.transport.play").process(typedEvent);
    }

    public void stop(TypedEvent typedEvent) {
        TuxGuitar.instance().getAction("action.transport.stop").process(typedEvent);
    }

    public void redraw() {
        if (!TuxGuitar.instance().isLocked()) {
            this.checkPosition();
            if (!this.isDisposed()) {
                new SyncThread(new Runnable(){

                    public void run() {
                        if (!TGTransport.this.isDisposed() && !TuxGuitar.instance().isLocked()) {
                            if (TGTransport.this.isEditingTickScale()) {
                                TGTransport.this.label.setText(Long.toString(TGTransport.this.tickProgress.getSelection()));
                            } else if (!TuxGuitar.instance().getPlayer().isRunning()) {
                                long l = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getPosition();
                                TGTransport.this.label.setText(Long.toString(l));
                                TGTransport.this.tickProgress.setSelection((int)l);
                            }
                        }
                    }
                }).start();
            }
        }
    }

    public void redrawPlayingMode() {
        if (!TuxGuitar.instance().isLocked()) {
            long l;
            TuxGuitar.instance().lock();
            this.checkPosition();
            if (!this.isDisposed() && !this.isEditingTickScale() && TuxGuitar.instance().getPlayer().isRunning() && (l = System.currentTimeMillis()) > this.redrawTime + 250L) {
                long l2 = TuxGuitar.instance().getEditorCache().getPlayStart() + (TuxGuitar.instance().getPlayer().getTickPosition() - TuxGuitar.instance().getEditorCache().getPlayTick());
                this.label.setText(Long.toString(l2));
                this.tickProgress.setSelection((int)l2);
                this.redrawTime = l;
            }
            TuxGuitar.instance().unlock();
        }
    }
}

