/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.track;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGTrack;

public class UndoableMoveTrackUp
implements UndoableEdit {
    private int doAction;
    private int trackNumber;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;

    private UndoableMoveTrackUp() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
        tGSongManager.moveTrackUp(tGSongManager.getTrack(this.trackNumber + 1));
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().update();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
        tGSongManager.moveTrackDown(tGSongManager.getTrack(this.trackNumber));
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().update();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableMoveTrackUp startUndo() {
        UndoableMoveTrackUp undoableMoveTrackUp = new UndoableMoveTrackUp();
        undoableMoveTrackUp.doAction = 1;
        undoableMoveTrackUp.undoCaret = new UndoableCaretHelper();
        return undoableMoveTrackUp;
    }

    public UndoableMoveTrackUp endUndo(TGTrack tGTrack) {
        this.redoCaret = new UndoableCaretHelper();
        this.trackNumber = tGTrack.getNumber();
        return this;
    }
}

