/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.util;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.TGMusicKeyNames;

public class TGMusicKeyUtils {
    public static final String PREFIX_CHORD = "chord";
    public static final String PREFIX_SCALE = "scale";
    public static final String PREFIX_TUNING = "tuning";
    public static final String PREFIX_FRETBOARD = "fretboard";
    public static final String PREFIX_MATRIX = "matrix";
    private static final String[][] DEFAULT_KEY_NAMES = new String[][]{{"C", "C#", "Cb"}, {"D", "D#", "Db"}, {"E", "E#", "Eb"}, {"F", "F#", "Fb"}, {"G", "G#", "Gb"}, {"A", "A#", "Ab"}, {"B", "B#", "Bb"}};

    public static String[] getSharpKeyNames(String string) {
        return new TGMusicKeyNames(true, string).getNames();
    }

    public static String[] getFlatKeyNames(String string) {
        return new TGMusicKeyNames(false, string).getNames();
    }

    protected static void loadKeyNames(String[] stringArray, String string, boolean bl) {
        if (bl) {
            TGMusicKeyUtils.loadSharpKeyNames(stringArray, string);
        } else {
            TGMusicKeyUtils.loadFlatKeyNames(stringArray, string);
        }
    }

    private static void loadSharpKeyNames(String[] stringArray, String string) {
        stringArray[0] = TGMusicKeyUtils.getName(string, 0, 0);
        stringArray[1] = TGMusicKeyUtils.getName(string, 0, 1);
        stringArray[2] = TGMusicKeyUtils.getName(string, 1, 0);
        stringArray[3] = TGMusicKeyUtils.getName(string, 1, 1);
        stringArray[4] = TGMusicKeyUtils.getName(string, 2, 0);
        stringArray[5] = TGMusicKeyUtils.getName(string, 3, 0);
        stringArray[6] = TGMusicKeyUtils.getName(string, 3, 1);
        stringArray[7] = TGMusicKeyUtils.getName(string, 4, 0);
        stringArray[8] = TGMusicKeyUtils.getName(string, 4, 1);
        stringArray[9] = TGMusicKeyUtils.getName(string, 5, 0);
        stringArray[10] = TGMusicKeyUtils.getName(string, 5, 1);
        stringArray[11] = TGMusicKeyUtils.getName(string, 6, 0);
    }

    private static void loadFlatKeyNames(String[] stringArray, String string) {
        stringArray[0] = TGMusicKeyUtils.getName(string, 0, 0);
        stringArray[1] = TGMusicKeyUtils.getName(string, 1, 2);
        stringArray[2] = TGMusicKeyUtils.getName(string, 1, 0);
        stringArray[3] = TGMusicKeyUtils.getName(string, 2, 2);
        stringArray[4] = TGMusicKeyUtils.getName(string, 2, 0);
        stringArray[5] = TGMusicKeyUtils.getName(string, 3, 0);
        stringArray[6] = TGMusicKeyUtils.getName(string, 4, 2);
        stringArray[7] = TGMusicKeyUtils.getName(string, 4, 0);
        stringArray[8] = TGMusicKeyUtils.getName(string, 5, 2);
        stringArray[9] = TGMusicKeyUtils.getName(string, 5, 0);
        stringArray[10] = TGMusicKeyUtils.getName(string, 6, 2);
        stringArray[11] = TGMusicKeyUtils.getName(string, 6, 0);
    }

    private static String getName(String string, int n, int n2) {
        String string2 = "key." + string + "." + n + "." + n2;
        return TuxGuitar.instance().getLanguageManager().getProperty(string2, DEFAULT_KEY_NAMES[n][n2]);
    }
}

