/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.managers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import org.herac.tuxguitar.song.models.effects.TGEffectTrill;

public class TGMeasureManager {
    private TGSongManager songManager;

    public TGMeasureManager(TGSongManager tGSongManager) {
        this.songManager = tGSongManager;
    }

    public TGSongManager getSongManager() {
        return this.songManager;
    }

    public void orderBeats(TGMeasure tGMeasure) {
        for (int i = 0; i < tGMeasure.countBeats(); ++i) {
            TGBeat tGBeat = null;
            for (int j = i; j < tGMeasure.countBeats(); ++j) {
                TGBeat tGBeat2 = tGMeasure.getBeat(j);
                if (tGBeat != null && tGBeat2.getStart() >= tGBeat.getStart()) continue;
                tGBeat = tGBeat2;
            }
            tGMeasure.moveBeat(i, tGBeat);
        }
    }

    public void addBeat(TGMeasure tGMeasure, TGBeat tGBeat) {
        if (this.validateDuration(tGMeasure, tGBeat, false, false)) {
            tGMeasure.addBeat(tGBeat);
        }
    }

    public void removeBeat(TGBeat tGBeat) {
        tGBeat.getMeasure().removeBeat(tGBeat);
    }

    public void removeBeat(TGMeasure tGMeasure, long l, boolean bl) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            this.removeBeat(tGBeat, bl);
        }
    }

    public void removeBeat(TGBeat tGBeat, boolean bl) {
        TGMeasure tGMeasure = tGBeat.getMeasure();
        this.removeBeat(tGBeat);
        if (bl) {
            long l = tGBeat.getStart();
            long l2 = tGBeat.getDuration().getTime();
            TGBeat tGBeat2 = this.getNextBeat(tGMeasure.getBeats(), tGBeat);
            if (tGBeat2 != null) {
                l2 = tGBeat2.getStart() - l;
            }
            this.moveBeats(tGBeat.getMeasure(), l + l2, -l2, tGBeat.getDuration());
        }
    }

    public void removeBeatsBeforeEnd(TGMeasure tGMeasure, long l) {
        List list = this.getBeatsBeforeEnd(tGMeasure.getBeats(), l);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TGBeat tGBeat = (TGBeat)iterator.next();
            this.removeBeat(tGBeat);
        }
    }

    public void addNote(TGMeasure tGMeasure, long l, TGNote tGNote, TGDuration tGDuration) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            this.addNote(tGBeat, tGNote, tGDuration);
        }
    }

    public void addNote(TGBeat tGBeat, TGNote tGNote, TGDuration tGDuration) {
        this.addNote(tGBeat, tGNote, tGDuration, tGBeat.getStart());
    }

    public void addNote(TGBeat tGBeat, TGNote tGNote, TGDuration tGDuration, long l) {
        if (this.validateDuration(tGBeat.getMeasure(), tGBeat, tGDuration, true, true)) {
            TGBeat tGBeat2;
            this.removeNote(tGBeat.getMeasure(), tGBeat.getStart(), tGNote.getString());
            tGDuration.copy(tGBeat.getDuration());
            this.tryChangeSilenceAfter(tGBeat.getMeasure(), tGBeat);
            TGBeat tGBeat3 = tGBeat;
            if (tGBeat3.getStart() != l && (tGBeat2 = this.getBeatIn(tGBeat3.getMeasure(), l)) != null) {
                tGBeat3 = tGBeat2;
            }
            tGBeat3.addNote(tGNote);
        }
    }

    public void removeNote(TGNote tGNote) {
        tGNote.getBeat().removeNote(tGNote);
    }

    public void removeNote(TGMeasure tGMeasure, long l, int n) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            for (int i = 0; i < tGBeat.countNotes(); ++i) {
                TGNote tGNote = tGBeat.getNote(i);
                if (tGNote.getString() != n) continue;
                this.removeNote(tGNote);
                if (tGBeat.isRestBeat()) {
                    this.removeChord(tGMeasure, tGBeat.getStart());
                }
                return;
            }
        }
    }

    public void removeNotesAfterString(TGMeasure tGMeasure, int n) {
        Object object;
        Object object2;
        ArrayList<TGNote> arrayList = new ArrayList<TGNote>();
        Iterator iterator = tGMeasure.getBeats().iterator();
        while (iterator.hasNext()) {
            object2 = (TGBeat)iterator.next();
            object = ((TGBeat)object2).getNotes().iterator();
            while (object.hasNext()) {
                TGNote tGNote = (TGNote)object.next();
                if (tGNote.getString() <= n) continue;
                arrayList.add(tGNote);
            }
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (TGNote)object2.next();
            this.removeNote((TGNote)object);
        }
    }

    public List getNotes(TGMeasure tGMeasure, long l) {
        ArrayList<TGNote> arrayList = new ArrayList<TGNote>();
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            Iterator iterator = tGBeat.getNotes().iterator();
            while (iterator.hasNext()) {
                TGNote tGNote = (TGNote)iterator.next();
                arrayList.add(tGNote);
            }
        }
        return arrayList;
    }

    public TGNote getNote(TGMeasure tGMeasure, long l, int n) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            return this.getNote(tGBeat, n);
        }
        return null;
    }

    public TGNote getNote(TGBeat tGBeat, int n) {
        Iterator iterator = tGBeat.getNotes().iterator();
        while (iterator.hasNext()) {
            TGNote tGNote = (TGNote)iterator.next();
            if (tGNote.getString() != n) continue;
            return tGNote;
        }
        return null;
    }

    public TGNote getPreviousNote(TGMeasure tGMeasure, long l, int n) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            TGBeat tGBeat2 = this.getPreviousBeat(tGMeasure.getBeats(), tGBeat);
            while (tGBeat2 != null) {
                for (int i = 0; i < tGBeat2.countNotes(); ++i) {
                    TGNote tGNote = tGBeat2.getNote(i);
                    if (tGNote.getString() != n) continue;
                    return tGNote;
                }
                tGBeat2 = this.getPreviousBeat(tGMeasure.getBeats(), tGBeat2);
            }
        }
        return null;
    }

    public TGNote getNextNote(TGMeasure tGMeasure, long l, int n) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            TGBeat tGBeat2 = this.getNextBeat(tGMeasure.getBeats(), tGBeat);
            while (tGBeat2 != null) {
                for (int i = 0; i < tGBeat2.countNotes(); ++i) {
                    TGNote tGNote = tGBeat2.getNote(i);
                    if (tGNote.getString() != n) continue;
                    return tGNote;
                }
                tGBeat2 = this.getNextBeat(tGMeasure.getBeats(), tGBeat2);
            }
        }
        return null;
    }

    public TGBeat getBeat(TGMeasure tGMeasure, long l) {
        Iterator iterator = tGMeasure.getBeats().iterator();
        while (iterator.hasNext()) {
            TGBeat tGBeat = (TGBeat)iterator.next();
            if (tGBeat.getStart() != l) continue;
            return tGBeat;
        }
        return null;
    }

    public TGBeat getBeatIn(TGMeasure tGMeasure, long l) {
        Iterator iterator = tGMeasure.getBeats().iterator();
        while (iterator.hasNext()) {
            TGBeat tGBeat = (TGBeat)iterator.next();
            if (tGBeat.getStart() > l || tGBeat.getStart() + tGBeat.getDuration().getTime() <= l) continue;
            return tGBeat;
        }
        return null;
    }

    public TGBeat getNextBeat(List list, TGBeat tGBeat) {
        TGBeat tGBeat2 = null;
        for (int i = 0; i < list.size(); ++i) {
            TGBeat tGBeat3 = (TGBeat)list.get(i);
            if (tGBeat3.getStart() <= tGBeat.getStart()) continue;
            if (tGBeat2 == null) {
                tGBeat2 = tGBeat3;
                continue;
            }
            if (tGBeat3.getStart() < tGBeat2.getStart()) {
                tGBeat2 = tGBeat3;
                continue;
            }
            if (tGBeat3.getStart() != tGBeat2.getStart() || tGBeat3.getDuration().getTime() > tGBeat2.getDuration().getTime()) continue;
            tGBeat2 = tGBeat3;
        }
        return tGBeat2;
    }

    public TGBeat getPreviousBeat(List list, TGBeat tGBeat) {
        TGBeat tGBeat2 = null;
        for (int i = 0; i < list.size(); ++i) {
            TGBeat tGBeat3 = (TGBeat)list.get(i);
            if (tGBeat3.getStart() >= tGBeat.getStart()) continue;
            if (tGBeat2 == null) {
                tGBeat2 = tGBeat3;
                continue;
            }
            if (tGBeat3.getStart() > tGBeat2.getStart()) {
                tGBeat2 = tGBeat3;
                continue;
            }
            if (tGBeat3.getStart() != tGBeat2.getStart() || tGBeat3.getDuration().getTime() > tGBeat2.getDuration().getTime()) continue;
            tGBeat2 = tGBeat3;
        }
        return tGBeat2;
    }

    public TGBeat getFirstBeat(List list) {
        TGBeat tGBeat = null;
        for (int i = 0; i < list.size(); ++i) {
            TGBeat tGBeat2 = (TGBeat)list.get(i);
            if (tGBeat != null && tGBeat2.getStart() >= tGBeat.getStart()) continue;
            tGBeat = tGBeat2;
        }
        return tGBeat;
    }

    public TGBeat getLastBeat(List list) {
        TGBeat tGBeat = null;
        for (int i = 0; i < list.size(); ++i) {
            TGBeat tGBeat2 = (TGBeat)list.get(i);
            if (tGBeat != null && tGBeat.getStart() >= tGBeat2.getStart()) continue;
            tGBeat = tGBeat2;
        }
        return tGBeat;
    }

    public TGBeat getNextRestBeat(List list, TGBeat tGBeat) {
        TGBeat tGBeat2 = this.getNextBeat(list, tGBeat);
        while (tGBeat2 != null && !tGBeat2.isRestBeat()) {
            tGBeat2 = this.getNextBeat(list, tGBeat2);
        }
        return tGBeat2;
    }

    public List getBeatsBeforeEnd(List list, long l) {
        ArrayList<TGBeat> arrayList = new ArrayList<TGBeat>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TGBeat tGBeat = (TGBeat)iterator.next();
            if (tGBeat.getStart() < l) continue;
            arrayList.add(tGBeat);
        }
        return arrayList;
    }

    public void moveAllBeats(TGMeasure tGMeasure, long l) {
        this.moveBeats(tGMeasure.getBeats(), l);
    }

    public boolean moveBeats(TGMeasure tGMeasure, long l, long l2, TGDuration tGDuration) {
        if (l2 == 0L) {
            return false;
        }
        boolean bl = true;
        long l3 = tGMeasure.getStart();
        long l4 = l3 + tGMeasure.getLength();
        List list = this.getBeatsBeforeEnd(tGMeasure.getBeats(), l);
        this.moveBeats(list, l2);
        if (bl) {
            ArrayList<TGBeat> arrayList = new ArrayList<TGBeat>();
            ArrayList arrayList2 = new ArrayList(tGMeasure.getBeats());
            TGBeat tGBeat = this.getFirstBeat(arrayList2);
            while (tGBeat != null && tGBeat.isRestBeat() && !tGBeat.isTextBeat() && tGBeat.getStart() < l3) {
                arrayList2.remove(tGBeat);
                arrayList.add(tGBeat);
                tGBeat = this.getNextBeat(arrayList2, tGBeat);
            }
            TGBeat tGBeat2 = this.getLastBeat(arrayList2);
            while (tGBeat2 != null && tGBeat2.isRestBeat() && !tGBeat2.isTextBeat() && tGBeat2.getStart() + tGBeat2.getDuration().getTime() > l4) {
                arrayList2.remove(tGBeat2);
                arrayList.add(tGBeat2);
                tGBeat2 = this.getPreviousBeat(arrayList2, tGBeat2);
            }
            if (tGBeat != null && tGBeat2 != null && (tGBeat.getStart() < l3 || tGBeat2.getStart() + tGBeat2.getDuration().getTime() > l4)) {
                bl = false;
            }
            if (bl) {
                TGBeat tGBeat3;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    tGBeat3 = (TGBeat)iterator.next();
                    this.removeBeat(tGBeat3);
                }
                if (tGDuration != null) {
                    if (l2 < 0L) {
                        tGBeat2 = this.getLastBeat(tGMeasure.getBeats());
                        tGBeat3 = this.getSongManager().getFactory().newBeat();
                        tGBeat3.setStart(tGBeat2 != null ? tGBeat2.getStart() + tGBeat2.getDuration().getTime() : l);
                        tGDuration.copy(tGBeat3.getDuration());
                        if (tGBeat3.getStart() + tGBeat3.getDuration().getTime() <= l4) {
                            this.addBeat(tGMeasure, tGBeat3);
                        }
                    } else {
                        tGBeat = this.getFirstBeat(this.getBeatsBeforeEnd(tGMeasure.getBeats(), l));
                        tGBeat3 = this.getSongManager().getFactory().newBeat();
                        tGBeat3.setStart(l);
                        tGDuration.copy(tGBeat3.getDuration());
                        if (tGBeat3.getStart() + tGBeat3.getDuration().getTime() <= (tGBeat != null ? tGBeat.getStart() : l4)) {
                            this.addBeat(tGMeasure, tGBeat3);
                        }
                    }
                }
            }
        }
        if (!bl) {
            this.moveBeats(list, -l2);
        }
        return bl;
    }

    private void moveBeats(List list, long l) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TGBeat tGBeat = (TGBeat)iterator.next();
            this.moveBeat(tGBeat, l);
        }
    }

    private void moveBeat(TGBeat tGBeat, long l) {
        long l2 = tGBeat.getStart();
        tGBeat.setStart(l2 + l);
    }

    public void cleanBeat(TGBeat tGBeat) {
        if (tGBeat.getText() != null) {
            tGBeat.removeChord();
        }
        if (tGBeat.getChord() != null) {
            tGBeat.removeText();
        }
        this.cleanBeatNotes(tGBeat);
    }

    public void cleanBeatNotes(TGBeat tGBeat) {
        while (tGBeat.countNotes() > 0) {
            TGNote tGNote = tGBeat.getNote(0);
            this.removeNote(tGNote);
        }
    }

    public void cleanBeatNotes(TGMeasure tGMeasure, long l) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            this.cleanBeatNotes(tGBeat);
        }
    }

    public void addChord(TGMeasure tGMeasure, long l, TGChord tGChord) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            this.addChord(tGBeat, tGChord);
        }
    }

    public void addChord(TGBeat tGBeat, TGChord tGChord) {
        tGBeat.removeChord();
        tGBeat.setChord(tGChord);
    }

    public TGChord getChord(TGMeasure tGMeasure, long l) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            return tGBeat.getChord();
        }
        return null;
    }

    public void removeChord(TGMeasure tGMeasure, long l) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            tGBeat.removeChord();
        }
    }

    public void addText(TGMeasure tGMeasure, long l, TGText tGText) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            this.addText(tGBeat, tGText);
        }
    }

    public void addText(TGBeat tGBeat, TGText tGText) {
        tGBeat.removeText();
        if (!tGText.isEmpty()) {
            tGBeat.setText(tGText);
        }
    }

    public TGText getText(TGMeasure tGMeasure, long l) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            return tGBeat.getText();
        }
        return null;
    }

    public void removeText(TGBeat tGBeat) {
        tGBeat.removeText();
    }

    public boolean removeText(TGMeasure tGMeasure, long l) {
        TGBeat tGBeat = this.getBeat(tGMeasure, l);
        if (tGBeat != null) {
            this.removeText(tGBeat);
            return true;
        }
        return false;
    }

    public void cleanMeasure(TGMeasure tGMeasure) {
        while (tGMeasure.countBeats() > 0) {
            this.removeBeat(tGMeasure.getBeat(0));
        }
    }

    public int shiftNoteUp(TGMeasure tGMeasure, long l, int n) {
        return this.shiftNote(tGMeasure, l, n, -1);
    }

    public int shiftNoteDown(TGMeasure tGMeasure, long l, int n) {
        return this.shiftNote(tGMeasure, l, n, 1);
    }

    private int shiftNote(TGMeasure tGMeasure, long l, int n, int n2) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            int n3 = tGNote.getString() + n2;
            while (this.getNote(tGMeasure, l, n3) != null) {
                n3 += n2;
            }
            if (n3 >= 1 && n3 <= tGMeasure.getTrack().stringCount()) {
                TGString tGString = tGMeasure.getTrack().getString(tGNote.getString());
                TGString tGString2 = tGMeasure.getTrack().getString(n3);
                int n4 = tGNote.getValue() + tGString.getValue();
                if (n4 >= tGString2.getValue() && (tGString2.getValue() + 30 > n4 || tGMeasure.getTrack().isPercussionTrack())) {
                    tGNote.setValue(n4 - tGString2.getValue());
                    tGNote.setString(tGString2.getNumber());
                    return tGNote.getString();
                }
            }
        }
        return 0;
    }

    public boolean moveSemitoneUp(TGMeasure tGMeasure, long l, int n) {
        return this.moveSemitone(tGMeasure, l, n, 1);
    }

    public boolean moveSemitoneDown(TGMeasure tGMeasure, long l, int n) {
        return this.moveSemitone(tGMeasure, l, n, -1);
    }

    private boolean moveSemitone(TGMeasure tGMeasure, long l, int n, int n2) {
        int n3;
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null && (n3 = tGNote.getValue() + n2) >= 0 && (n3 < 30 || tGMeasure.getTrack().isPercussionTrack())) {
            tGNote.setValue(n3);
            return true;
        }
        return false;
    }

    public boolean validateDuration(TGMeasure tGMeasure, TGBeat tGBeat, boolean bl, boolean bl2) {
        return this.validateDuration(tGMeasure, tGBeat, tGBeat.getDuration(), bl, bl2);
    }

    public boolean validateDuration(TGMeasure tGMeasure, TGBeat tGBeat, TGDuration tGDuration, boolean bl, boolean bl2) {
        long l;
        int n = 10;
        this.orderBeats(tGMeasure);
        long l2 = tGMeasure.getStart();
        long l3 = l2 + tGMeasure.getLength();
        long l4 = tGBeat.getStart();
        long l5 = tGDuration.getTime();
        long l6 = l4 + l5;
        List list = tGMeasure.getBeats();
        TGBeat tGBeat2 = this.getBeat(tGMeasure, l4);
        if (tGBeat2 != null && l5 <= tGBeat2.getDuration().getTime()) {
            return true;
        }
        TGBeat tGBeat3 = this.getNextBeat(list, tGBeat);
        if (tGBeat2 == null) {
            if (tGBeat3 == null && l6 < l3 + (long)n) {
                return true;
            }
            if (tGBeat3 != null && l6 < tGBeat3.getStart() + (long)n) {
                return true;
            }
        }
        if (tGBeat3 != null && tGBeat3.isRestBeat()) {
            l = 0L;
            ArrayList<TGBeat> arrayList = new ArrayList<TGBeat>();
            while (tGBeat3 != null && tGBeat3.isRestBeat() && !tGBeat3.isTextBeat()) {
                arrayList.add(tGBeat3);
                l = tGBeat3.getStart() + tGBeat3.getDuration().getTime();
                tGBeat3 = this.getNextBeat(list, tGBeat3);
            }
            if (tGBeat3 == null) {
                l = l3;
            } else if (!tGBeat3.isRestBeat() || tGBeat3.isTextBeat()) {
                l = tGBeat3.getStart();
            }
            if (l6 <= l + (long)n) {
                while (!arrayList.isEmpty()) {
                    TGBeat tGBeat4 = (TGBeat)arrayList.get(0);
                    arrayList.remove(tGBeat4);
                    this.removeBeat(tGBeat4, false);
                }
                return true;
            }
        }
        if (bl && (tGBeat3 = this.getNextBeat(list, tGBeat)) != null) {
            l = l5 - (tGBeat3.getStart() - l4);
            long l7 = 0L;
            TGBeat tGBeat5 = this.getNextRestBeat(list, tGBeat);
            while (tGBeat5 != null && !tGBeat5.isTextBeat()) {
                l7 += tGBeat5.getDuration().getTime();
                tGBeat5 = this.getNextRestBeat(list, tGBeat5);
            }
            if (l <= l7 + (long)n) {
                list = this.getBeatsBeforeEnd(tGMeasure.getBeats(), tGBeat3.getStart());
                while (!list.isEmpty()) {
                    TGBeat tGBeat6 = (TGBeat)list.get(0);
                    if (tGBeat6.isRestBeat() && !tGBeat6.isTextBeat()) {
                        l -= tGBeat6.getDuration().getTime();
                        this.removeBeat(tGBeat6, false);
                    } else if (l > 0L) {
                        this.moveBeat(tGBeat6, l);
                    }
                    list.remove(0);
                }
                return true;
            }
        }
        if (bl2 && tGBeat2 != null) {
            tGBeat2.getDuration().copy(tGDuration);
            return true;
        }
        return false;
    }

    public void changeDuration(TGMeasure tGMeasure, TGBeat tGBeat, TGDuration tGDuration, boolean bl) {
        TGDuration tGDuration2 = tGBeat.getDuration().clone(this.getSongManager().getFactory());
        if (this.validateDuration(tGMeasure, tGBeat, tGDuration, bl, false)) {
            tGBeat.setDuration(tGDuration.clone(this.getSongManager().getFactory()));
            this.tryChangeSilenceAfter(tGMeasure, tGBeat);
        } else {
            tGDuration2.copy(tGBeat.getDuration());
        }
    }

    public void tryChangeSilenceAfter(TGMeasure tGMeasure, TGBeat tGBeat) {
        this.autoCompleteSilences(tGMeasure);
        TGBeat tGBeat2 = this.getNextBeat(tGMeasure.getBeats(), tGBeat);
        long l = tGBeat.getStart() + tGBeat.getDuration().getTime();
        long l2 = tGMeasure.getStart() + tGMeasure.getLength();
        if (tGBeat2 != null && tGBeat2.isRestBeat() && l <= l2) {
            long l3 = this.getRealStart(tGMeasure, l) - this.getRealStart(tGMeasure, tGBeat2.getStart());
            if (tGBeat2.getStart() + l3 < l2 && tGBeat2.getStart() + tGBeat2.getDuration().getTime() + l3 <= l2) {
                this.moveBeat(tGBeat2, l3);
                this.changeDuration(tGMeasure, tGBeat2, tGBeat.getDuration().clone(this.getSongManager().getFactory()), false);
            }
        }
    }

    public void autoCompleteSilences(TGMeasure tGMeasure) {
        long l = tGMeasure.getStart();
        long l2 = 0L;
        long l3 = 0L;
        List list = tGMeasure.getBeats();
        TGBeat tGBeat = this.getFirstBeat(list);
        while (tGBeat != null) {
            l2 = tGBeat.getStart() + tGBeat.getDuration().getTime();
            if (tGBeat.getStart() > l && (l3 = tGBeat.getStart() - l) > 0L) {
                this.createSilences(tGMeasure, l, l3);
            }
            l = l2;
            tGBeat = this.getNextBeat(list, tGBeat);
        }
        l2 = tGMeasure.getStart() + tGMeasure.getLength();
        l3 = l2 - l;
        if (l3 > 0L) {
            this.createSilences(tGMeasure, l, l3);
        }
    }

    private void createSilences(TGMeasure tGMeasure, long l, long l2) {
        long l3 = l;
        List list = TGMeasureManager.createDurations(this.getSongManager().getFactory(), l2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TGDuration tGDuration = (TGDuration)iterator.next();
            TGBeat tGBeat = this.getSongManager().getFactory().newBeat();
            tGBeat.setStart(this.getRealStart(tGMeasure, l3));
            tGDuration.copy(tGBeat.getDuration());
            this.addBeat(tGMeasure, tGBeat);
            l3 += tGDuration.getTime();
        }
    }

    public long getRealStart(TGMeasure tGMeasure, long l) {
        boolean bl;
        long l2 = l;
        long l3 = TGSongManager.getDivisionLength(tGMeasure.getHeader());
        boolean bl2 = bl = l2 % l3 == 0L;
        if (!bl) {
            TGDuration tGDuration = this.getSongManager().getFactory().newDuration();
            tGDuration.setValue(64);
            tGDuration.getTupleto().setEnters(3);
            tGDuration.getTupleto().setTimes(2);
            int n = 0;
            while ((long)n < tGDuration.getTime()) {
                boolean bl3 = bl = ++l2 % l3 == 0L;
                if (bl) break;
                ++n;
            }
            if (!bl) {
                l2 = l;
            }
        }
        return l2;
    }

    public void changeTieNote(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            this.changeTieNote(tGNote);
        }
    }

    public void changeTieNote(TGNote tGNote) {
        tGNote.setTiedNote(!tGNote.isTiedNote());
        tGNote.getEffect().setDeadNote(false);
    }

    public void changeVibratoNote(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setVibrato(!tGNote.getEffect().isVibrato());
        }
    }

    public void changeDeadNote(TGNote tGNote) {
        tGNote.getEffect().setDeadNote(!tGNote.getEffect().isDeadNote());
        tGNote.setTiedNote(false);
    }

    public void changeSlideNote(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setSlide(!tGNote.getEffect().isSlide());
        }
    }

    public void changeHammerNote(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setHammer(!tGNote.getEffect().isHammer());
        }
    }

    public void changePalmMute(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setPalmMute(!tGNote.getEffect().isPalmMute());
        }
    }

    public void changeStaccato(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setStaccato(!tGNote.getEffect().isStaccato());
        }
    }

    public void changeTapping(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setTapping(!tGNote.getEffect().isTapping());
        }
    }

    public void changeSlapping(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setSlapping(!tGNote.getEffect().isSlapping());
        }
    }

    public void changePopping(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setPopping(!tGNote.getEffect().isPopping());
        }
    }

    public void changeBendNote(TGMeasure tGMeasure, long l, int n, TGEffectBend tGEffectBend) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setBend(tGEffectBend);
        }
    }

    public void changeTremoloBar(TGMeasure tGMeasure, long l, int n, TGEffectTremoloBar tGEffectTremoloBar) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setTremoloBar(tGEffectTremoloBar);
        }
    }

    public void changeGhostNote(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setGhostNote(!tGNote.getEffect().isGhostNote());
        }
    }

    public void changeAccentuatedNote(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setAccentuatedNote(!tGNote.getEffect().isAccentuatedNote());
        }
    }

    public void changeHeavyAccentuatedNote(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setHeavyAccentuatedNote(!tGNote.getEffect().isHeavyAccentuatedNote());
        }
    }

    public void changeHarmonicNote(TGMeasure tGMeasure, long l, int n, TGEffectHarmonic tGEffectHarmonic) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setHarmonic(tGEffectHarmonic);
        }
    }

    public void changeGraceNote(TGMeasure tGMeasure, long l, int n, TGEffectGrace tGEffectGrace) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setGrace(tGEffectGrace);
        }
    }

    public void changeTrillNote(TGMeasure tGMeasure, long l, int n, TGEffectTrill tGEffectTrill) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setTrill(tGEffectTrill);
        }
    }

    public void changeTremoloPicking(TGMeasure tGMeasure, long l, int n, TGEffectTremoloPicking tGEffectTremoloPicking) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setTremoloPicking(tGEffectTremoloPicking);
        }
    }

    public void changeFadeIn(TGMeasure tGMeasure, long l, int n) {
        TGNote tGNote = this.getNote(tGMeasure, l, n);
        if (tGNote != null) {
            tGNote.getEffect().setFadeIn(!tGNote.getEffect().isFadeIn());
        }
    }

    public void changeVelocity(int n, TGMeasure tGMeasure, long l, int n2) {
        TGNote tGNote = this.getNote(tGMeasure, l, n2);
        if (tGNote != null) {
            tGNote.setVelocity(n);
        }
    }

    public static List createDurations(TGFactory tGFactory, long l) {
        TGDuration tGDuration;
        ArrayList<TGDuration> arrayList = new ArrayList<TGDuration>();
        TGDuration tGDuration2 = tGFactory.newDuration();
        tGDuration2.setValue(64);
        tGDuration2.setDotted(false);
        tGDuration2.setDoubleDotted(false);
        tGDuration2.getTupleto().setEnters(3);
        tGDuration2.getTupleto().setTimes(2);
        for (long i = l; i > tGDuration2.getTime(); i -= tGDuration.getTime()) {
            tGDuration = TGDuration.fromTime(tGFactory, i, tGDuration2, 10);
            arrayList.add(tGDuration.clone(tGFactory));
        }
        return arrayList;
    }
}

