/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGText;

public abstract class TGBeat {
    private long start = 960L;
    private TGDuration duration;
    private TGMeasure measure;
    private List notes;
    private TGChord chord;
    private TGText text;

    public TGBeat(TGFactory tGFactory) {
        this.duration = tGFactory.newDuration();
        this.notes = new ArrayList();
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long l) {
        this.start = l;
    }

    public TGDuration getDuration() {
        return this.duration;
    }

    public void setDuration(TGDuration tGDuration) {
        this.duration = tGDuration;
    }

    public TGMeasure getMeasure() {
        return this.measure;
    }

    public void setMeasure(TGMeasure tGMeasure) {
        this.measure = tGMeasure;
    }

    public List getNotes() {
        return this.notes;
    }

    public void addNote(TGNote tGNote) {
        tGNote.setBeat(this);
        this.notes.add(tGNote);
    }

    public void moveNote(int n, TGNote tGNote) {
        this.getNotes().remove(tGNote);
        this.getNotes().add(n, tGNote);
    }

    public void removeNote(TGNote tGNote) {
        this.notes.remove(tGNote);
    }

    public TGNote getNote(int n) {
        if (n >= 0 && n < this.countNotes()) {
            return (TGNote)this.notes.get(n);
        }
        return null;
    }

    public int countNotes() {
        return this.notes.size();
    }

    public void setChord(TGChord tGChord) {
        this.chord = tGChord;
        this.chord.setBeat(this);
    }

    public TGChord getChord() {
        return this.chord;
    }

    public void removeChord() {
        this.chord = null;
    }

    public TGText getText() {
        return this.text;
    }

    public void setText(TGText tGText) {
        this.text = tGText;
        this.text.setBeat(this);
    }

    public void removeText() {
        this.text = null;
    }

    public boolean isRestBeat() {
        return this.notes.isEmpty();
    }

    public boolean isChordBeat() {
        return this.chord != null;
    }

    public boolean isTextBeat() {
        return this.text != null;
    }

    public TGBeat clone(TGFactory tGFactory) {
        TGBeat tGBeat = tGFactory.newBeat();
        tGBeat.setStart(this.getStart());
        this.getDuration().copy(tGBeat.getDuration());
        for (int i = 0; i < this.countNotes(); ++i) {
            TGNote tGNote = (TGNote)this.notes.get(i);
            tGBeat.addNote(tGNote.clone(tGFactory));
        }
        if (this.chord != null) {
            tGBeat.setChord(this.chord.clone(tGFactory));
        }
        if (this.text != null) {
            tGBeat.setText(this.text.clone(tGFactory));
        }
        return tGBeat;
    }
}

