/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import org.herac.tuxguitar.song.models.effects.TGEffectTrill;

public abstract class TGNoteEffect {
    private TGEffectBend bend = null;
    private TGEffectTremoloBar tremoloBar = null;
    private TGEffectHarmonic harmonic = null;
    private TGEffectGrace grace = null;
    private TGEffectTrill trill = null;
    private TGEffectTremoloPicking tremoloPicking = null;
    private boolean vibrato = false;
    private boolean deadNote = false;
    private boolean slide = false;
    private boolean hammer = false;
    private boolean ghostNote = false;
    private boolean accentuatedNote = false;
    private boolean heavyAccentuatedNote = false;
    private boolean palmMute = false;
    private boolean staccato = false;
    private boolean tapping = false;
    private boolean slapping = false;
    private boolean popping = false;
    private boolean fadeIn = false;

    public boolean isDeadNote() {
        return this.deadNote;
    }

    public void setDeadNote(boolean bl) {
        this.deadNote = bl;
        if (this.isDeadNote()) {
            this.tremoloBar = null;
            this.bend = null;
            this.trill = null;
            this.slide = false;
            this.hammer = false;
        }
    }

    public boolean isVibrato() {
        return this.vibrato;
    }

    public void setVibrato(boolean bl) {
        this.vibrato = bl;
        if (this.isVibrato()) {
            this.trill = null;
        }
    }

    public TGEffectBend getBend() {
        return this.bend;
    }

    public void setBend(TGEffectBend tGEffectBend) {
        this.bend = tGEffectBend;
        if (this.isBend()) {
            this.tremoloBar = null;
            this.trill = null;
            this.deadNote = false;
            this.slide = false;
            this.hammer = false;
        }
    }

    public boolean isBend() {
        return this.bend != null && !this.bend.getPoints().isEmpty();
    }

    public TGEffectTremoloBar getTremoloBar() {
        return this.tremoloBar;
    }

    public void setTremoloBar(TGEffectTremoloBar tGEffectTremoloBar) {
        this.tremoloBar = tGEffectTremoloBar;
        if (this.isTremoloBar()) {
            this.bend = null;
            this.trill = null;
            this.deadNote = false;
            this.slide = false;
            this.hammer = false;
        }
    }

    public boolean isTremoloBar() {
        return this.tremoloBar != null;
    }

    public TGEffectTrill getTrill() {
        return this.trill;
    }

    public void setTrill(TGEffectTrill tGEffectTrill) {
        this.trill = tGEffectTrill;
        if (this.isTrill()) {
            this.bend = null;
            this.tremoloBar = null;
            this.tremoloPicking = null;
            this.slide = false;
            this.hammer = false;
            this.deadNote = false;
            this.vibrato = false;
        }
    }

    public boolean isTrill() {
        return this.trill != null;
    }

    public TGEffectTremoloPicking getTremoloPicking() {
        return this.tremoloPicking;
    }

    public void setTremoloPicking(TGEffectTremoloPicking tGEffectTremoloPicking) {
        this.tremoloPicking = tGEffectTremoloPicking;
        if (this.isTremoloPicking()) {
            this.trill = null;
            this.bend = null;
            this.tremoloBar = null;
            this.slide = false;
            this.hammer = false;
            this.deadNote = false;
            this.vibrato = false;
        }
    }

    public boolean isTremoloPicking() {
        return this.tremoloPicking != null;
    }

    public boolean isHammer() {
        return this.hammer;
    }

    public void setHammer(boolean bl) {
        this.hammer = bl;
        if (this.isHammer()) {
            this.trill = null;
            this.tremoloBar = null;
            this.bend = null;
            this.deadNote = false;
            this.slide = false;
        }
    }

    public boolean isSlide() {
        return this.slide;
    }

    public void setSlide(boolean bl) {
        this.slide = bl;
        if (this.isSlide()) {
            this.trill = null;
            this.tremoloBar = null;
            this.bend = null;
            this.deadNote = false;
            this.hammer = false;
        }
    }

    public boolean isGhostNote() {
        return this.ghostNote;
    }

    public void setGhostNote(boolean bl) {
        this.ghostNote = bl;
        if (this.isGhostNote()) {
            this.accentuatedNote = false;
            this.heavyAccentuatedNote = false;
        }
    }

    public boolean isAccentuatedNote() {
        return this.accentuatedNote;
    }

    public void setAccentuatedNote(boolean bl) {
        this.accentuatedNote = bl;
        if (this.isAccentuatedNote()) {
            this.ghostNote = false;
            this.heavyAccentuatedNote = false;
        }
    }

    public boolean isHeavyAccentuatedNote() {
        return this.heavyAccentuatedNote;
    }

    public void setHeavyAccentuatedNote(boolean bl) {
        this.heavyAccentuatedNote = bl;
        if (this.isHeavyAccentuatedNote()) {
            this.ghostNote = false;
            this.accentuatedNote = false;
        }
    }

    public void setHarmonic(TGEffectHarmonic tGEffectHarmonic) {
        this.harmonic = tGEffectHarmonic;
    }

    public TGEffectHarmonic getHarmonic() {
        return this.harmonic;
    }

    public boolean isHarmonic() {
        return this.harmonic != null;
    }

    public TGEffectGrace getGrace() {
        return this.grace;
    }

    public void setGrace(TGEffectGrace tGEffectGrace) {
        this.grace = tGEffectGrace;
    }

    public boolean isGrace() {
        return this.grace != null;
    }

    public boolean isPalmMute() {
        return this.palmMute;
    }

    public void setPalmMute(boolean bl) {
        this.palmMute = bl;
        if (this.isPalmMute()) {
            this.staccato = false;
        }
    }

    public boolean isStaccato() {
        return this.staccato;
    }

    public void setStaccato(boolean bl) {
        this.staccato = bl;
        if (this.isStaccato()) {
            this.palmMute = false;
        }
    }

    public boolean isPopping() {
        return this.popping;
    }

    public void setPopping(boolean bl) {
        this.popping = bl;
        if (this.isPopping()) {
            this.tapping = false;
            this.slapping = false;
        }
    }

    public boolean isSlapping() {
        return this.slapping;
    }

    public void setSlapping(boolean bl) {
        this.slapping = bl;
        if (this.isSlapping()) {
            this.tapping = false;
            this.popping = false;
        }
    }

    public boolean isTapping() {
        return this.tapping;
    }

    public void setTapping(boolean bl) {
        this.tapping = bl;
        if (this.isTapping()) {
            this.slapping = false;
            this.popping = false;
        }
    }

    public boolean isFadeIn() {
        return this.fadeIn;
    }

    public void setFadeIn(boolean bl) {
        this.fadeIn = bl;
    }

    public boolean hasAnyEffect() {
        return this.isBend() || this.isTremoloBar() || this.isHarmonic() || this.isGrace() || this.isTrill() || this.isTremoloPicking() || this.isVibrato() || this.isDeadNote() || this.isSlide() || this.isHammer() || this.isGhostNote() || this.isAccentuatedNote() || this.isHeavyAccentuatedNote() || this.isPalmMute() || this.isStaccato() || this.isTapping() || this.isSlapping() || this.isPopping() || this.isFadeIn();
    }

    public TGNoteEffect clone(TGFactory tGFactory) {
        TGNoteEffect tGNoteEffect = tGFactory.newEffect();
        tGNoteEffect.setVibrato(this.isVibrato());
        tGNoteEffect.setDeadNote(this.isDeadNote());
        tGNoteEffect.setSlide(this.isSlide());
        tGNoteEffect.setHammer(this.isHammer());
        tGNoteEffect.setGhostNote(this.isGhostNote());
        tGNoteEffect.setAccentuatedNote(this.isAccentuatedNote());
        tGNoteEffect.setHeavyAccentuatedNote(this.isHeavyAccentuatedNote());
        tGNoteEffect.setPalmMute(this.isPalmMute());
        tGNoteEffect.setStaccato(this.isStaccato());
        tGNoteEffect.setTapping(this.isTapping());
        tGNoteEffect.setSlapping(this.isSlapping());
        tGNoteEffect.setPopping(this.isPopping());
        tGNoteEffect.setFadeIn(this.isFadeIn());
        tGNoteEffect.setBend(this.isBend() ? this.bend.clone(tGFactory) : null);
        tGNoteEffect.setTremoloBar(this.isTremoloBar() ? this.tremoloBar.clone(tGFactory) : null);
        tGNoteEffect.setHarmonic(this.isHarmonic() ? this.harmonic.clone(tGFactory) : null);
        tGNoteEffect.setGrace(this.isGrace() ? this.grace.clone(tGFactory) : null);
        tGNoteEffect.setTrill(this.isTrill() ? this.trill.clone(tGFactory) : null);
        tGNoteEffect.setTremoloPicking(this.isTremoloPicking() ? this.tremoloPicking.clone(tGFactory) : null);
        return tGNoteEffect;
    }
}

