/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gtp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGInputStreamBase;
import org.herac.tuxguitar.io.gtp.GTPFormatException;
import org.herac.tuxguitar.io.gtp.GTPInputStream;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;

public class GP3InputStream
extends GTPInputStream
implements TGInputStreamBase {
    private static final String[] SUPPORTED_VERSIONS = new String[]{"FICHIER GUITAR PRO v3.00"};
    private static final float GP_BEND_SEMITONE = 25.0f;
    private static final float GP_BEND_POSITION = 60.0f;
    private int tripletFeel;

    public GP3InputStream() {
        super(SUPPORTED_VERSIONS);
    }

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("Guitar Pro 3", "*.gp3");
    }

    public TGSong readSong() throws GTPFormatException, IOException {
        this.readVersion();
        if (!this.isSupportedVersion(this.getVersion())) {
            this.close();
            throw new GTPFormatException("Unsuported Version");
        }
        TGSong tGSong = this.getFactory().newSong();
        this.readInfo(tGSong);
        this.tripletFeel = this.readBoolean() ? 2 : 1;
        int n = this.readInt();
        this.readInt();
        List list = this.readChannels();
        int n2 = this.readInt();
        int n3 = this.readInt();
        this.readMeasureHeaders(tGSong, n2);
        this.readTracks(tGSong, n3, list);
        this.readMeasures(tGSong, n2, n3, n);
        this.close();
        return tGSong;
    }

    private List readChannels() throws IOException {
        ArrayList<TGChannel> arrayList = new ArrayList<TGChannel>();
        for (int i = 0; i < 64; ++i) {
            TGChannel tGChannel = this.getFactory().newChannel();
            tGChannel.setChannel((short)i);
            tGChannel.setEffectChannel((short)i);
            tGChannel.setInstrument((short)this.readInt());
            tGChannel.setVolume(this.toChannelShort(this.readByte()));
            tGChannel.setBalance(this.toChannelShort(this.readByte()));
            tGChannel.setChorus(this.toChannelShort(this.readByte()));
            tGChannel.setReverb(this.toChannelShort(this.readByte()));
            tGChannel.setPhaser(this.toChannelShort(this.readByte()));
            tGChannel.setTremolo(this.toChannelShort(this.readByte()));
            tGChannel.setSolo(false);
            tGChannel.setMute(false);
            arrayList.add(tGChannel);
            this.skip(2);
        }
        return arrayList;
    }

    private void readInfo(TGSong tGSong) throws IOException {
        tGSong.setName(this.readStringByteSizeOfInteger());
        this.readStringByteSizeOfInteger();
        tGSong.setArtist(this.readStringByteSizeOfInteger());
        tGSong.setAlbum(this.readStringByteSizeOfInteger());
        tGSong.setAuthor(this.readStringByteSizeOfInteger());
        this.readStringByteSizeOfInteger();
        this.readStringByteSizeOfInteger();
        this.readStringByteSizeOfInteger();
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            this.readStringByteSizeOfInteger();
        }
    }

    private void readMeasureHeaders(TGSong tGSong, int n) throws IOException {
        TGTimeSignature tGTimeSignature = this.getFactory().newTimeSignature();
        for (int i = 0; i < n; ++i) {
            tGSong.addMeasureHeader(this.readMeasureHeader(i + 1, tGSong, tGTimeSignature));
        }
    }

    private void readTracks(TGSong tGSong, int n, List list) throws IOException {
        for (int i = 1; i <= n; ++i) {
            tGSong.addTrack(this.readTrack(i, list));
        }
    }

    private void readMeasures(TGSong tGSong, int n, int n2, int n3) throws IOException {
        TGTempo tGTempo = this.getFactory().newTempo();
        tGTempo.setValue(n3);
        long l = 960L;
        for (int i = 0; i < n; ++i) {
            TGMeasureHeader tGMeasureHeader = tGSong.getMeasureHeader(i);
            tGMeasureHeader.setStart(l);
            for (int j = 0; j < n2; ++j) {
                TGTrack tGTrack = tGSong.getTrack(j);
                TGMeasure tGMeasure = this.getFactory().newMeasure(tGMeasureHeader);
                tGTrack.addMeasure(tGMeasure);
                this.readMeasure(tGMeasure, tGTrack, tGTempo);
            }
            tGTempo.copy(tGMeasureHeader.getTempo());
            l += tGMeasureHeader.getLength();
        }
    }

    private TGDuration readDuration(int n) throws IOException {
        TGDuration tGDuration = this.getFactory().newDuration();
        tGDuration.setValue((int)(Math.pow(2.0, this.readByte() + 4) / 4.0));
        tGDuration.setDotted((n & 1) != 0);
        if ((n & 0x20) != 0) {
            int n2 = this.readInt();
            switch (n2) {
                case 3: {
                    tGDuration.getTupleto().setEnters(3);
                    tGDuration.getTupleto().setTimes(2);
                    break;
                }
                case 5: {
                    tGDuration.getTupleto().setEnters(5);
                    tGDuration.getTupleto().setTimes(4);
                    break;
                }
                case 6: {
                    tGDuration.getTupleto().setEnters(6);
                    tGDuration.getTupleto().setTimes(4);
                    break;
                }
                case 7: {
                    tGDuration.getTupleto().setEnters(7);
                    tGDuration.getTupleto().setTimes(4);
                    break;
                }
                case 9: {
                    tGDuration.getTupleto().setEnters(9);
                    tGDuration.getTupleto().setTimes(8);
                    break;
                }
                case 10: {
                    tGDuration.getTupleto().setEnters(10);
                    tGDuration.getTupleto().setTimes(8);
                    break;
                }
                case 11: {
                    tGDuration.getTupleto().setEnters(11);
                    tGDuration.getTupleto().setTimes(8);
                    break;
                }
                case 12: {
                    tGDuration.getTupleto().setEnters(12);
                    tGDuration.getTupleto().setTimes(8);
                }
            }
        }
        return tGDuration;
    }

    private int getTiedNoteValue(int n, TGTrack tGTrack) {
        int n2 = tGTrack.countMeasures();
        if (n2 > 0) {
            for (int i = n2 - 1; i >= 0; --i) {
                TGMeasure tGMeasure = tGTrack.getMeasure(i);
                for (int j = tGMeasure.countBeats() - 1; j >= 0; --j) {
                    TGBeat tGBeat = tGMeasure.getBeat(j);
                    for (int k = 0; k < tGBeat.countNotes(); ++k) {
                        TGNote tGNote = tGBeat.getNote(k);
                        if (tGNote.getString() != n) continue;
                        return tGNote.getValue();
                    }
                }
            }
        }
        return -1;
    }

    private void readColor(TGColor tGColor) throws IOException {
        tGColor.setR(this.readUnsignedByte());
        tGColor.setG(this.readUnsignedByte());
        tGColor.setB(this.readUnsignedByte());
        this.read();
    }

    private TGMarker readMarker(int n) throws IOException {
        TGMarker tGMarker = this.getFactory().newMarker();
        tGMarker.setMeasure(n);
        tGMarker.setTitle(this.readStringByteSizeOfInteger());
        this.readColor(tGMarker.getColor());
        return tGMarker;
    }

    private TGMeasureHeader readMeasureHeader(int n, TGSong tGSong, TGTimeSignature tGTimeSignature) throws IOException {
        int n2 = this.readUnsignedByte();
        TGMeasureHeader tGMeasureHeader = this.getFactory().newHeader();
        tGMeasureHeader.setNumber(n);
        tGMeasureHeader.setStart(0L);
        tGMeasureHeader.getTempo().setValue(120);
        tGMeasureHeader.setTripletFeel(this.tripletFeel);
        tGMeasureHeader.setRepeatOpen((n2 & 4) != 0);
        if ((n2 & 1) != 0) {
            tGTimeSignature.setNumerator((int)this.readByte());
        }
        if ((n2 & 2) != 0) {
            tGTimeSignature.getDenominator().setValue((int)this.readByte());
        }
        tGTimeSignature.copy(tGMeasureHeader.getTimeSignature());
        if ((n2 & 8) != 0) {
            tGMeasureHeader.setRepeatClose((int)this.readByte());
        }
        if ((n2 & 0x10) != 0) {
            tGMeasureHeader.setRepeatAlternative(this.parseRepeatAlternative(tGSong, n, this.readUnsignedByte()));
        }
        if ((n2 & 0x20) != 0) {
            tGMeasureHeader.setMarker(this.readMarker(n));
        }
        if ((n2 & 0x40) != 0) {
            this.readByte();
            this.readByte();
        }
        return tGMeasureHeader;
    }

    private void readMeasure(TGMeasure tGMeasure, TGTrack tGTrack, TGTempo tGTempo) throws IOException {
        long l = tGMeasure.getStart();
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            l += this.readBeat(l, tGMeasure, tGTrack, tGTempo);
        }
    }

    private long readBeat(long l, TGMeasure tGMeasure, TGTrack tGTrack, TGTempo tGTempo) throws IOException {
        int n = this.readUnsignedByte();
        if ((n & 0x40) != 0) {
            this.readUnsignedByte();
        }
        TGBeat tGBeat = this.getFactory().newBeat();
        TGDuration tGDuration = this.readDuration(n);
        TGNoteEffect tGNoteEffect = this.getFactory().newEffect();
        if ((n & 2) != 0) {
            this.readChord(tGTrack.stringCount(), tGBeat);
        }
        if ((n & 4) != 0) {
            this.readText(tGBeat);
        }
        if ((n & 8) != 0) {
            this.readBeatEffects(tGNoteEffect);
        }
        if ((n & 0x10) != 0) {
            this.readMixChange(tGTempo);
        }
        int n2 = this.readUnsignedByte();
        for (int i = 6; i >= 0; --i) {
            if ((n2 & 1 << i) == 0 || 6 - i >= tGTrack.stringCount()) continue;
            TGString tGString = tGTrack.getString(6 - i + 1).clone(this.getFactory());
            TGNote tGNote = this.readNote(tGString, tGTrack, tGNoteEffect.clone(this.getFactory()));
            tGBeat.addNote(tGNote);
        }
        tGBeat.setStart(l);
        tGDuration.copy(tGBeat.getDuration());
        tGMeasure.addBeat(tGBeat);
        return tGDuration.getTime();
    }

    private void readText(TGBeat tGBeat) throws IOException {
        TGText tGText = this.getFactory().newText();
        tGText.setValue(this.readStringByteSizeOfInteger());
        tGBeat.setText(tGText);
    }

    private TGNote readNote(TGString tGString, TGTrack tGTrack, TGNoteEffect tGNoteEffect) throws IOException {
        int n;
        int n2 = this.readUnsignedByte();
        TGNote tGNote = this.getFactory().newNote();
        tGNote.setString(tGString.getNumber());
        tGNote.setEffect(tGNoteEffect);
        tGNote.getEffect().setGhostNote((n2 & 4) != 0);
        if ((n2 & 0x20) != 0) {
            n = this.readUnsignedByte();
            tGNote.setTiedNote(n == 2);
            tGNote.getEffect().setDeadNote(n == 3);
        }
        if ((n2 & 1) != 0) {
            this.skip(2);
        }
        if ((n2 & 0x10) != 0) {
            tGNote.setVelocity(15 + 16 * this.readByte() - 16);
        }
        if ((n2 & 0x20) != 0) {
            n = this.readByte();
            int n3 = tGNote.isTiedNote() ? this.getTiedNoteValue(tGString.getNumber(), tGTrack) : n;
            tGNote.setValue(n3 >= 0 && n3 < 100 ? n3 : 0);
        }
        if ((n2 & 0x80) != 0) {
            this.skip(2);
        }
        if ((n2 & 8) != 0) {
            this.readNoteEffects(tGNote.getEffect());
        }
        return tGNote;
    }

    private TGTrack readTrack(int n, List list) throws IOException {
        TGTrack tGTrack = this.getFactory().newTrack();
        tGTrack.setNumber(n);
        this.readUnsignedByte();
        tGTrack.setName(this.readStringByte(40));
        int n2 = this.readInt();
        for (int i = 0; i < 7; ++i) {
            int n3 = this.readInt();
            if (n2 <= i) continue;
            TGString tGString = this.getFactory().newString();
            tGString.setNumber(i + 1);
            tGString.setValue(n3);
            tGTrack.getStrings().add(tGString);
        }
        this.readInt();
        this.readChannel(tGTrack.getChannel(), list);
        this.readInt();
        tGTrack.setOffset(this.readInt());
        this.readColor(tGTrack.getColor());
        return tGTrack;
    }

    private void readChannel(TGChannel tGChannel, List list) throws IOException {
        int n = this.readInt() - 1;
        int n2 = this.readInt() - 1;
        if (n >= 0 && n < list.size()) {
            ((TGChannel)list.get(n)).copy(tGChannel);
            if (tGChannel.getInstrument() < 0) {
                tGChannel.setInstrument((short)0);
            }
            if (!tGChannel.isPercussionChannel()) {
                tGChannel.setEffectChannel((short)n2);
            }
        }
    }

    private int parseRepeatAlternative(TGSong tGSong, int n, int n2) {
        TGMeasureHeader tGMeasureHeader;
        int n3 = 0;
        int n4 = 0;
        Iterator iterator = tGSong.getMeasureHeaders();
        while (iterator.hasNext() && (tGMeasureHeader = (TGMeasureHeader)iterator.next()).getNumber() != n) {
            if (tGMeasureHeader.isRepeatOpen()) {
                n4 = 0;
            }
            n4 |= tGMeasureHeader.getRepeatAlternative();
        }
        for (int i = 0; i < 8; ++i) {
            if (n2 <= i || (n4 & 1 << i) != 0) continue;
            n3 |= 1 << i;
        }
        return n3;
    }

    private void readChord(int n, TGBeat tGBeat) throws IOException {
        TGChord tGChord = this.getFactory().newChord(n);
        int n2 = this.readUnsignedByte();
        if ((n2 & 1) == 0) {
            tGChord.setName(this.readStringByteSizeOfInteger());
            tGChord.setFirstFret(this.readInt());
            if (tGChord.getFirstFret() != 0) {
                for (int i = 0; i < 6; ++i) {
                    int n3 = this.readInt();
                    if (i >= tGChord.countStrings()) continue;
                    tGChord.addFretValue(i, n3);
                }
            }
        } else {
            this.skip(25);
            tGChord.setName(this.readStringByte(34));
            tGChord.setFirstFret(this.readInt());
            for (int i = 0; i < 6; ++i) {
                int n4 = this.readInt();
                if (i >= tGChord.countStrings()) continue;
                tGChord.addFretValue(i, n4);
            }
            this.skip(36);
        }
        if (tGChord.countNotes() > 0) {
            tGBeat.setChord(tGChord);
        }
    }

    private void readGrace(TGNoteEffect tGNoteEffect) throws IOException {
        int n = this.readUnsignedByte();
        TGEffectGrace tGEffectGrace = this.getFactory().newEffectGrace();
        tGEffectGrace.setOnBeat(false);
        tGEffectGrace.setDead(n == 255);
        tGEffectGrace.setFret(!tGEffectGrace.isDead() ? n : 0);
        tGEffectGrace.setDynamic(15 + 16 * this.readUnsignedByte() - 16);
        int n2 = this.readUnsignedByte();
        if (n2 == 0) {
            tGEffectGrace.setTransition(0);
        } else if (n2 == 1) {
            tGEffectGrace.setTransition(1);
        } else if (n2 == 2) {
            tGEffectGrace.setTransition(2);
        } else if (n2 == 3) {
            tGEffectGrace.setTransition(3);
        }
        tGEffectGrace.setDuration(this.readUnsignedByte());
        tGNoteEffect.setGrace(tGEffectGrace);
    }

    private void readBend(TGNoteEffect tGNoteEffect) throws IOException {
        TGEffectBend tGEffectBend = this.getFactory().newEffectBend();
        this.skip(5);
        int n = this.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = this.readInt();
            int n3 = this.readInt();
            this.readByte();
            int n4 = Math.round((float)(n2 * 12) / 60.0f);
            int n5 = Math.round((float)(n3 * 1) / 25.0f);
            tGEffectBend.addPoint(n4, n5);
        }
        if (!tGEffectBend.getPoints().isEmpty()) {
            tGNoteEffect.setBend(tGEffectBend);
        }
    }

    private void readTremoloBar(TGNoteEffect tGNoteEffect) throws IOException {
        int n = this.readInt();
        TGEffectTremoloBar tGEffectTremoloBar = this.getFactory().newEffectTremoloBar();
        tGEffectTremoloBar.addPoint(0, 0);
        tGEffectTremoloBar.addPoint(Math.round(6.0f), Math.round(-((float)n / 50.0f)));
        tGEffectTremoloBar.addPoint(12, 0);
        tGNoteEffect.setTremoloBar(tGEffectTremoloBar);
    }

    private void readNoteEffects(TGNoteEffect tGNoteEffect) throws IOException {
        int n = this.readUnsignedByte();
        tGNoteEffect.setSlide((n & 4) != 0);
        tGNoteEffect.setHammer((n & 2) != 0);
        if ((n & 1) != 0) {
            this.readBend(tGNoteEffect);
        }
        if ((n & 0x10) != 0) {
            this.readGrace(tGNoteEffect);
        }
    }

    private void readBeatEffects(TGNoteEffect tGNoteEffect) throws IOException {
        int n = this.readUnsignedByte();
        tGNoteEffect.setVibrato((n & 1) != 0 || (n & 2) != 0);
        tGNoteEffect.setFadeIn((n & 0x10) != 0);
        if ((n & 0x20) != 0) {
            int n2 = this.readUnsignedByte();
            if (n2 == 0) {
                this.readTremoloBar(tGNoteEffect);
            } else {
                tGNoteEffect.setTapping(n2 == 1);
                tGNoteEffect.setSlapping(n2 == 2);
                tGNoteEffect.setPopping(n2 == 3);
                this.readInt();
            }
        }
        if ((n & 0x40) != 0) {
            this.readByte();
            this.readByte();
        }
        if ((n & 4) != 0) {
            TGEffectHarmonic tGEffectHarmonic = this.getFactory().newEffectHarmonic();
            tGEffectHarmonic.setType(1);
            tGNoteEffect.setHarmonic(tGEffectHarmonic);
        }
        if ((n & 8) != 0) {
            TGEffectHarmonic tGEffectHarmonic = this.getFactory().newEffectHarmonic();
            tGEffectHarmonic.setType(2);
            tGEffectHarmonic.setData(0);
            tGNoteEffect.setHarmonic(tGEffectHarmonic);
        }
    }

    private void readMixChange(TGTempo tGTempo) throws IOException {
        this.readByte();
        byte by = this.readByte();
        byte by2 = this.readByte();
        byte by3 = this.readByte();
        byte by4 = this.readByte();
        byte by5 = this.readByte();
        byte by6 = this.readByte();
        int n = this.readInt();
        if (by >= 0) {
            this.readByte();
        }
        if (by2 >= 0) {
            this.readByte();
        }
        if (by3 >= 0) {
            this.readByte();
        }
        if (by4 >= 0) {
            this.readByte();
        }
        if (by5 >= 0) {
            this.readByte();
        }
        if (by6 >= 0) {
            this.readByte();
        }
        if (n >= 0) {
            tGTempo.setValue(n);
            this.readByte();
        }
    }

    private short toChannelShort(byte by) {
        short s = (short)(by * 8 - 1);
        return (short)Math.max(s, 0);
    }
}

