/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gtp;

import java.io.IOException;
import java.io.OutputStream;
import org.herac.tuxguitar.io.base.TGOutputStreamBase;
import org.herac.tuxguitar.song.factory.TGFactory;

public abstract class GTPOutputStream
implements TGOutputStreamBase {
    private TGFactory factory;
    private OutputStream outputStream;

    public void init(TGFactory tGFactory, OutputStream outputStream) {
        this.factory = tGFactory;
        this.outputStream = outputStream;
    }

    protected TGFactory getFactory() {
        return this.factory;
    }

    protected void skipBytes(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.outputStream.write(0);
        }
    }

    protected void writeByte(byte by) throws IOException {
        this.outputStream.write(by);
    }

    protected void writeUnsignedByte(int n) throws IOException {
        this.outputStream.write(n);
    }

    protected void writeBytes(byte[] byArray) throws IOException {
        this.outputStream.write(byArray);
    }

    protected void writeBoolean(boolean bl) throws IOException {
        this.outputStream.write(bl ? 1 : 0);
    }

    protected void writeInt(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        this.outputStream.write(byArray);
    }

    protected void writeString(char[] cArray, int n) throws IOException {
        int n2 = n == 0 || n > cArray.length ? cArray.length : n;
        for (int i = 0; i < n2; ++i) {
            this.outputStream.write(cArray[i]);
        }
    }

    protected void writeStringInteger(String string) throws IOException {
        char[] cArray = string.toCharArray();
        this.writeInt(cArray.length);
        this.writeString(cArray, 0);
    }

    protected void writeStringByte(String string, int n) throws IOException {
        char[] cArray = string.toCharArray();
        this.writeByte((byte)(n == 0 || n > cArray.length ? cArray.length : n));
        this.writeString(cArray, n);
        this.skipBytes(n - cArray.length);
    }

    protected void writeStringByteSizeOfInteger(String string) throws IOException {
        char[] cArray = string.toCharArray();
        this.writeInt(cArray.length + 1);
        this.writeStringByte(string, cArray.length);
    }

    protected void close() throws IOException {
        this.outputStream.flush();
        this.outputStream.close();
    }
}

