/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tef;

import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGSongImporter;
import org.herac.tuxguitar.io.tef.TEInputStream;
import org.herac.tuxguitar.io.tef.TGSongAdjuster;
import org.herac.tuxguitar.io.tef.base.TEChord;
import org.herac.tuxguitar.io.tef.base.TEComponent;
import org.herac.tuxguitar.io.tef.base.TEComponentChord;
import org.herac.tuxguitar.io.tef.base.TEComponentNote;
import org.herac.tuxguitar.io.tef.base.TESong;
import org.herac.tuxguitar.io.tef.base.TETimeSignature;
import org.herac.tuxguitar.io.tef.base.TETrack;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGTupleto;

public class TESongImporter
implements TGSongImporter {
    private static final int[][] PERCUSSION_TUNINGS = new int[][]{{49, 41, 32}, {49, 51, 42, 50}, {49, 42, 50, 37, 32}, {49, 51, 42, 50, 45, 37}, {49, 51, 42, 50, 45, 37, 41}};
    protected TGSongManager manager;

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("Tef", "*.tef");
    }

    public String getImportName() {
        return "Tef";
    }

    public boolean configure(boolean bl) {
        return true;
    }

    public TGSong importSong(TGFactory tGFactory, InputStream inputStream) throws TGFileFormatException {
        try {
            this.manager = new TGSongManager(tGFactory);
            return this.parseSong(new TEInputStream(inputStream).readSong());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new TGFileFormatException();
        }
    }

    private TGSong parseSong(TESong tESong) {
        this.sortComponents(tESong);
        this.newTGSong(tESong.getTracks().length, tESong.getMeasures(), tESong.getTempo().getValue());
        this.addMeasureValues(tESong);
        this.addTrackValues(tESong.getTracks());
        this.addComponents(tESong);
        return new TGSongAdjuster(this.manager).process();
    }

    private void newTGSong(int n, int n2, int n3) {
        this.manager.setSong(this.manager.newSong());
        this.manager.getFirstMeasureHeader().getTempo().setValue(n3);
        while (this.manager.getSong().countTracks() < n) {
            this.manager.createTrack();
        }
        while (this.manager.getSong().countMeasureHeaders() < n2) {
            this.manager.addNewMeasureBeforeEnd();
        }
    }

    private void addMeasureValues(TESong tESong) {
        TGTimeSignature tGTimeSignature = this.manager.getFactory().newTimeSignature();
        for (int i = 0; i < this.manager.getSong().countMeasureHeaders(); ++i) {
            TGMeasureHeader tGMeasureHeader = this.manager.getSong().getMeasureHeader(i);
            TETimeSignature tETimeSignature = tESong.getTimeSignature(i);
            tGTimeSignature.setNumerator(tETimeSignature.getNumerator());
            tGTimeSignature.getDenominator().setValue(tETimeSignature.getDenominator());
            this.manager.changeTimeSignature(tGMeasureHeader, tGTimeSignature, false);
        }
    }

    private void addTrackValues(TETrack[] tETrackArray) {
        for (int i = 0; i < tETrackArray.length; ++i) {
            TGTrack tGTrack = this.manager.getSong().getTrack(i);
            tGTrack.getChannel().setVolume((short)((15 - tETrackArray[i].getVolume()) * 127 / 15));
            tGTrack.getChannel().setBalance((short)(tETrackArray[i].getPan() * 127 / 15));
            tGTrack.getChannel().setInstrument((short)tETrackArray[i].getInstrument());
            if (tETrackArray[i].isPercussion()) {
                TGChannel.setPercusionChannel((TGChannel)tGTrack.getChannel());
            }
            tGTrack.getStrings().clear();
            int[] nArray = tETrackArray[i].getStrings();
            for (int j = 0; j < nArray.length && j < 7; ++j) {
                TGString tGString = this.manager.getFactory().newString();
                tGString.setNumber(j + 1);
                tGString.setValue(tETrackArray[i].isPercussion() ? 0 : 96 - nArray[j]);
                tGTrack.getStrings().add(tGString);
            }
        }
    }

    private void addComponents(TESong tESong) {
        Iterator iterator = tESong.getComponents().iterator();
        while (iterator.hasNext()) {
            TEComponent tEComponent = (TEComponent)iterator.next();
            if (tEComponent.getMeasure() < 0 || tEComponent.getMeasure() >= this.manager.getSong().countMeasureHeaders()) continue;
            int n = 0;
            TETrack[] tETrackArray = tESong.getTracks();
            for (int i = 0; i < tETrackArray.length; ++i) {
                int n2 = tETrackArray[i].getStrings().length;
                int n3 = tEComponent.getString() - n;
                if (n3 >= 0 && n3 < n2 && n3 < 7) {
                    TGTrack tGTrack = this.manager.getSong().getTrack(i);
                    TGMeasure tGMeasure = tGTrack.getMeasure(tEComponent.getMeasure());
                    if (tEComponent instanceof TEComponentNote) {
                        this.addNote(tETrackArray[i], (TEComponentNote)tEComponent, n3, n2, tGMeasure);
                    } else if (tEComponent instanceof TEComponentChord) {
                        this.addChord(tESong.getChords(), (TEComponentChord)tEComponent, tGTrack, tGMeasure);
                    }
                }
                n += n2;
            }
        }
    }

    private TGBeat getBeat(TGMeasure tGMeasure, long l) {
        TGBeat tGBeat = this.manager.getMeasureManager().getBeat(tGMeasure, l);
        if (tGBeat == null) {
            tGBeat = this.manager.getFactory().newBeat();
            tGBeat.setStart(l);
            tGMeasure.addBeat(tGBeat);
        }
        return tGBeat;
    }

    private long getStart(TGDuration tGDuration, TGMeasure tGMeasure, int n) {
        float f = n;
        if (tGDuration != null && !tGDuration.getTupleto().isEqual(TGTupleto.NORMAL)) {
            f = f - f % 64.0f + f % 64.0f * 2.0f * 2.0f / 3.0f;
        }
        long l = (long)((float)tGMeasure.getStart() + f * 960.0f / 64.0f);
        return l;
    }

    private TGDuration getDuration(int n) {
        TGDuration tGDuration = this.manager.getFactory().newDuration();
        int n2 = 1;
        for (int i = 0; i < n / 3; ++i) {
            n2 *= 2;
        }
        if (n % 3 == 1) {
            n2 *= 2;
            tGDuration.setDotted(true);
        } else if (n % 3 == 2) {
            tGDuration.getTupleto().setEnters(3);
            tGDuration.getTupleto().setTimes(2);
        }
        tGDuration.setValue(n2);
        return tGDuration;
    }

    private void addNote(TETrack tETrack, TEComponentNote tEComponentNote, int n, int n2, TGMeasure tGMeasure) {
        int n3 = tEComponentNote.getFret();
        if (tETrack.isPercussion()) {
            int n4 = Math.min(n2 - 2, PERCUSSION_TUNINGS.length) - 1;
            if (n >= 0 && n < PERCUSSION_TUNINGS[n4].length) {
                n3 += PERCUSSION_TUNINGS[n4][n];
            }
        }
        TGNote tGNote = this.manager.getFactory().newNote();
        tGNote.setString(n + 1);
        tGNote.setValue(n3);
        TGDuration tGDuration = this.getDuration(tEComponentNote.getDuration());
        TGBeat tGBeat = this.getBeat(tGMeasure, this.getStart(tGDuration, tGMeasure, tEComponentNote.getPosition()));
        tGDuration.copy(tGBeat.getDuration());
        tGBeat.addNote(tGNote);
    }

    private void addChord(TEChord[] tEChordArray, TEComponentChord tEComponentChord, TGTrack tGTrack, TGMeasure tGMeasure) {
        if (tEComponentChord.getChord() >= 0 && tEComponentChord.getChord() < tEChordArray.length) {
            TEChord tEChord = tEChordArray[tEComponentChord.getChord()];
            byte[] byArray = tEChord.getStrings();
            TGChord tGChord = this.manager.getFactory().newChord(tGTrack.stringCount());
            tGChord.setName(tEChord.getName());
            for (int i = 0; i < tGChord.countStrings(); ++i) {
                int n = i < byArray.length ? byArray[i] : -1;
                tGChord.addFretValue(i, n);
            }
            if (tGChord.countNotes() > 0) {
                TGBeat tGBeat = this.getBeat(tGMeasure, this.getStart(null, tGMeasure, tEComponentChord.getPosition()));
                tGBeat.setChord(tGChord);
            }
        }
    }

    public void sortComponents(TESong tESong) {
        Collections.sort(tESong.getComponents(), new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof TEComponent && object2 instanceof TEComponent) {
                    TEComponent tEComponent = (TEComponent)object;
                    TEComponent tEComponent2 = (TEComponent)object2;
                    if (tEComponent.getMeasure() < tEComponent2.getMeasure()) {
                        return -1;
                    }
                    if (tEComponent.getMeasure() > tEComponent2.getMeasure()) {
                        return 1;
                    }
                    if (tEComponent.getPosition() < tEComponent2.getPosition()) {
                        return -1;
                    }
                    if (tEComponent.getPosition() > tEComponent2.getPosition()) {
                        return 1;
                    }
                    if (tEComponent instanceof TEComponentNote && !(tEComponent2 instanceof TEComponentNote)) {
                        return -1;
                    }
                    if (tEComponent2 instanceof TEComponentNote && !(tEComponent instanceof TEComponentNote)) {
                        return 1;
                    }
                }
                return 0;
            }
        });
    }
}

