/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tef.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.io.tef.base.TEChord;
import org.herac.tuxguitar.io.tef.base.TEInfo;
import org.herac.tuxguitar.io.tef.base.TEPercussion;
import org.herac.tuxguitar.io.tef.base.TERepeat;
import org.herac.tuxguitar.io.tef.base.TERhythm;
import org.herac.tuxguitar.io.tef.base.TETempo;
import org.herac.tuxguitar.io.tef.base.TEText;
import org.herac.tuxguitar.io.tef.base.TETimeSignature;
import org.herac.tuxguitar.io.tef.base.TETimeSignatureChange;
import org.herac.tuxguitar.io.tef.base.TETrack;

public class TESong {
    private int strings;
    private int measures;
    private TEInfo info;
    private TETempo tempo;
    private TETimeSignature timeSignature;
    private TERepeat[] repeats;
    private TEText[] texts;
    private TEChord[] chords;
    private TEPercussion[] percussions;
    private TERhythm[] rhythms;
    private TETrack[] tracks;
    private List components = new ArrayList();
    private List tsChanges = new ArrayList();

    public TERhythm[] getRhythms() {
        return this.rhythms;
    }

    public void setRhythms(int n) {
        this.rhythms = new TERhythm[n];
    }

    public void setRhythm(int n, TERhythm tERhythm) {
        this.rhythms[n] = tERhythm;
    }

    public TEPercussion[] getPercussions() {
        return this.percussions;
    }

    public void setPercussions(int n) {
        this.percussions = new TEPercussion[n];
    }

    public void setPercussion(int n, TEPercussion tEPercussion) {
        this.percussions[n] = tEPercussion;
    }

    public TEChord[] getChords() {
        return this.chords;
    }

    public void setChords(int n) {
        this.chords = new TEChord[n];
    }

    public void setChord(int n, TEChord tEChord) {
        this.chords[n] = tEChord;
    }

    public TEInfo getInfo() {
        return this.info;
    }

    public void setInfo(TEInfo tEInfo) {
        this.info = tEInfo;
    }

    public TERepeat[] getRepeats() {
        return this.repeats;
    }

    public void setRepeats(int n) {
        this.repeats = new TERepeat[n];
    }

    public void setRepeat(int n, TERepeat tERepeat) {
        this.repeats[n] = tERepeat;
    }

    public TEText[] getTexts() {
        return this.texts;
    }

    public void setTexts(int n) {
        this.texts = new TEText[n];
    }

    public void setText(int n, TEText tEText) {
        this.texts[n] = tEText;
    }

    public TETrack[] getTracks() {
        return this.tracks;
    }

    public void setTracks(int n) {
        this.tracks = new TETrack[n];
    }

    public void setTrack(int n, TETrack tETrack) {
        this.tracks[n] = tETrack;
    }

    public TETimeSignature getTimeSignature() {
        return this.timeSignature;
    }

    public void setTimeSignature(TETimeSignature tETimeSignature) {
        this.timeSignature = tETimeSignature;
    }

    public TETempo getTempo() {
        return this.tempo;
    }

    public void setTempo(TETempo tETempo) {
        this.tempo = tETempo;
    }

    public int getStrings() {
        return this.strings;
    }

    public void setStrings(int n) {
        this.strings = n;
    }

    public int getMeasures() {
        return this.measures;
    }

    public void setMeasures(int n) {
        this.measures = n;
    }

    public List getComponents() {
        return this.components;
    }

    public void addTimeSignatureChange(TETimeSignatureChange tETimeSignatureChange) {
        this.tsChanges.add(tETimeSignatureChange);
    }

    public TETimeSignature getTimeSignature(int n) {
        Iterator iterator = this.tsChanges.iterator();
        while (iterator.hasNext()) {
            TETimeSignatureChange tETimeSignatureChange = (TETimeSignatureChange)iterator.next();
            if (tETimeSignatureChange.getMeasure() != n) continue;
            return tETimeSignatureChange.getTimeSignature();
        }
        return this.getTimeSignature();
    }

    public String toString() {
        int n;
        String string = new String("[SONG] *** Tabledit file format ***\n");
        string = string + this.getInfo().toString() + "\n";
        string = string + this.getTempo().toString() + "\n";
        for (n = 0; n < this.repeats.length; ++n) {
            string = string + this.repeats[n].toString() + "\n";
        }
        for (n = 0; n < this.texts.length; ++n) {
            string = string + this.texts[n].toString() + "\n";
        }
        for (n = 0; n < this.chords.length; ++n) {
            string = string + this.chords[n].toString() + "\n";
        }
        for (n = 0; n < this.percussions.length; ++n) {
            string = string + this.percussions[n].toString() + "\n";
        }
        for (n = 0; n < this.rhythms.length; ++n) {
            string = string + this.rhythms[n].toString() + "\n";
        }
        for (n = 0; n < this.tracks.length; ++n) {
            string = string + this.tracks[n].toString() + "\n";
        }
        for (n = 0; n < this.components.size(); ++n) {
            string = string + this.components.get(n).toString() + "\n";
        }
        return string;
    }
}

