/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class BarcodeCodabar
extends Barcode {
    static byte[][] BARS;
    static String CHARS;
    static final int START_STOP_IDX = 16;

    static {
        byte[][] byArrayArray = new byte[20][];
        byte[] byArray = new byte[7];
        byArray[5] = 1;
        byArray[6] = 1;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[7];
        byArray2[4] = 1;
        byArray2[5] = 1;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[7];
        byArray3[3] = 1;
        byArray3[6] = 1;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[7];
        byArray4[0] = 1;
        byArray4[1] = 1;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[7];
        byArray5[2] = 1;
        byArray5[5] = 1;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[7];
        byArray6[0] = 1;
        byArray6[5] = 1;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[7];
        byArray7[1] = 1;
        byArray7[6] = 1;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[7];
        byArray8[1] = 1;
        byArray8[4] = 1;
        byArrayArray[7] = byArray8;
        byte[] byArray9 = new byte[7];
        byArray9[1] = 1;
        byArray9[2] = 1;
        byArrayArray[8] = byArray9;
        byte[] byArray10 = new byte[7];
        byArray10[0] = 1;
        byArray10[3] = 1;
        byArrayArray[9] = byArray10;
        byte[] byArray11 = new byte[7];
        byArray11[3] = 1;
        byArray11[4] = 1;
        byArrayArray[10] = byArray11;
        byte[] byArray12 = new byte[7];
        byArray12[2] = 1;
        byArray12[3] = 1;
        byArrayArray[11] = byArray12;
        byte[] byArray13 = new byte[7];
        byArray13[0] = 1;
        byArray13[4] = 1;
        byArray13[6] = 1;
        byArrayArray[12] = byArray13;
        byte[] byArray14 = new byte[7];
        byArray14[0] = 1;
        byArray14[2] = 1;
        byArray14[6] = 1;
        byArrayArray[13] = byArray14;
        byte[] byArray15 = new byte[7];
        byArray15[0] = 1;
        byArray15[2] = 1;
        byArray15[4] = 1;
        byArrayArray[14] = byArray15;
        byte[] byArray16 = new byte[7];
        byArray16[2] = 1;
        byArray16[4] = 1;
        byArray16[6] = 1;
        byArrayArray[15] = byArray16;
        byte[] byArray17 = new byte[7];
        byArray17[2] = 1;
        byArray17[3] = 1;
        byArray17[5] = 1;
        byArrayArray[16] = byArray17;
        byte[] byArray18 = new byte[7];
        byArray18[1] = 1;
        byArray18[3] = 1;
        byArray18[6] = 1;
        byArrayArray[17] = byArray18;
        byte[] byArray19 = new byte[7];
        byArray19[3] = 1;
        byArray19[5] = 1;
        byArray19[6] = 1;
        byArrayArray[18] = byArray19;
        byte[] byArray20 = new byte[7];
        byArray20[3] = 1;
        byArray20[4] = 1;
        byArray20[5] = 1;
        byArrayArray[19] = byArray20;
        BARS = byArrayArray;
        CHARS = "0123456789-$:/.+ABCD";
    }

    public BarcodeCodabar() {
        try {
            this.x = 0.8f;
            this.n = 2.0f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.generateChecksum = false;
            this.checksumText = false;
            this.startStopText = false;
            this.codeType = 12;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static byte[] getBarsCodabar(String string) {
        int n = (string = string.toUpperCase()).length();
        if (n < 2) {
            throw new IllegalArgumentException("Codabar must have at least a start and stop character.");
        }
        if (CHARS.indexOf(string.charAt(0)) < 16 || CHARS.indexOf(string.charAt(n - 1)) < 16) {
            throw new IllegalArgumentException("Codabar must have one of 'ABCD' as start/stop character.");
        }
        byte[] byArray = new byte[string.length() * 8 - 1];
        int n2 = 0;
        while (n2 < n) {
            int n3 = CHARS.indexOf(string.charAt(n2));
            if (n3 >= 16 && n2 > 0 && n2 < n - 1) {
                throw new IllegalArgumentException("In codabar, start/stop characters are only allowed at the extremes.");
            }
            if (n3 < 0) {
                throw new IllegalArgumentException("The character '" + string.charAt(n2) + "' is illegal in codabar.");
            }
            System.arraycopy(BARS[n3], 0, byArray, n2 * 8, 7);
            ++n2;
        }
        return byArray;
    }

    public static String calculateChecksum(String string) {
        if (string.length() < 2) {
            return string;
        }
        String string2 = string.toUpperCase();
        int n = 0;
        int n2 = string2.length();
        int n3 = 0;
        while (n3 < n2) {
            n += CHARS.indexOf(string2.charAt(n3));
            ++n3;
        }
        n = (n + 15) / 16 * 16 - n;
        return String.valueOf(string.substring(0, n2 - 1)) + CHARS.charAt(n) + string.substring(n2 - 1);
    }

    public Rectangle getBarcodeSize() {
        float f = 0.0f;
        float f2 = 0.0f;
        String string = this.code;
        if (this.generateChecksum && this.checksumText) {
            string = BarcodeCodabar.calculateChecksum(this.code);
        }
        if (!this.startStopText) {
            string = string.substring(1, string.length() - 1);
        }
        if (this.font != null) {
            f2 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            f = this.font.getWidthPoint(this.altText != null ? this.altText : string, this.size);
        }
        string = this.code;
        if (this.generateChecksum) {
            string = BarcodeCodabar.calculateChecksum(this.code);
        }
        byte[] byArray = BarcodeCodabar.getBarsCodabar(string);
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n += byArray[n2];
            ++n2;
        }
        n2 = byArray.length - n;
        float f3 = this.x * ((float)n2 + (float)n * this.n);
        f3 = Math.max(f3, f);
        float f4 = this.barHeight + f2;
        return new Rectangle(f3, f4);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        String string = this.code;
        if (this.generateChecksum && this.checksumText) {
            string = BarcodeCodabar.calculateChecksum(this.code);
        }
        if (!this.startStopText) {
            string = string.substring(1, string.length() - 1);
        }
        float f = 0.0f;
        if (this.font != null) {
            string = this.altText != null ? this.altText : string;
            f = this.font.getWidthPoint(string, this.size);
        }
        byte[] byArray = BarcodeCodabar.getBarsCodabar(this.generateChecksum ? BarcodeCodabar.calculateChecksum(this.code) : this.code);
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n += byArray[n2];
            ++n2;
        }
        n2 = byArray.length - n;
        float f2 = this.x * ((float)n2 + (float)n * this.n);
        float f3 = 0.0f;
        float f4 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f > f2) {
                    f3 = f - f2;
                    break;
                }
                f4 = f2 - f;
                break;
            }
            default: {
                if (f > f2) {
                    f3 = (f - f2) / 2.0f;
                    break;
                }
                f4 = (f2 - f) / 2.0f;
            }
        }
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f6 = this.barHeight - this.baseline;
            } else {
                f6 = -this.font.getFontDescriptor(3, this.size);
                f5 = f6 + this.baseline;
            }
        }
        boolean bl = true;
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        int n3 = 0;
        while (n3 < byArray.length) {
            float f7;
            float f8 = f7 = byArray[n3] == 0 ? this.x : this.x * this.n;
            if (bl) {
                pdfContentByte.rectangle(f3, f5, f7 - this.inkSpreading, this.barHeight);
            }
            bl = !bl;
            f3 += f7;
            ++n3;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color2 != null) {
                pdfContentByte.setColorFill(color2);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f4, f6);
            pdfContentByte.showText(string);
            pdfContentByte.endText();
        }
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color color, Color color2) {
        int n = color.getRGB();
        int n2 = color2.getRGB();
        Canvas canvas = new Canvas();
        String string = this.code;
        if (this.generateChecksum && this.checksumText) {
            string = BarcodeCodabar.calculateChecksum(this.code);
        }
        if (!this.startStopText) {
            string = string.substring(1, string.length() - 1);
        }
        byte[] byArray = BarcodeCodabar.getBarsCodabar(this.generateChecksum ? BarcodeCodabar.calculateChecksum(this.code) : this.code);
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            n3 += byArray[n4];
            ++n4;
        }
        n4 = byArray.length - n3;
        int n5 = n4 + n3 * (int)this.n;
        boolean bl = true;
        int n6 = 0;
        int n7 = (int)this.barHeight;
        int[] nArray = new int[n5 * n7];
        int n8 = 0;
        while (n8 < byArray.length) {
            int n9 = byArray[n8] == 0 ? 1 : (int)this.n;
            int n10 = n2;
            if (bl) {
                n10 = n;
            }
            bl = !bl;
            int n11 = 0;
            while (n11 < n9) {
                nArray[n6++] = n10;
                ++n11;
            }
            ++n8;
        }
        n8 = n5;
        while (n8 < nArray.length) {
            System.arraycopy(nArray, 0, nArray, n8, n5);
            n8 += n5;
        }
        Image image = canvas.createImage(new MemoryImageSource(n5, n7, nArray, 0, n5));
        return image;
    }
}

