/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class PdfNumberTree {
    private static final int leafSize = 64;

    public static PdfDictionary writeTree(HashMap hashMap, PdfWriter pdfWriter) throws IOException {
        int n;
        int n2;
        if (hashMap.size() == 0) {
            return null;
        }
        Object[] objectArray = new Integer[hashMap.size()];
        objectArray = hashMap.keySet().toArray(objectArray);
        Arrays.sort(objectArray);
        if (objectArray.length <= 64) {
            PdfDictionary pdfDictionary = new PdfDictionary();
            PdfArray pdfArray = new PdfArray();
            int n3 = 0;
            while (n3 < objectArray.length) {
                pdfArray.add(new PdfNumber((Integer)objectArray[n3]));
                pdfArray.add((PdfObject)hashMap.get(objectArray[n3]));
                ++n3;
            }
            pdfDictionary.put(PdfName.NUMS, pdfArray);
            return pdfDictionary;
        }
        int n4 = 64;
        PdfIndirectReference[] pdfIndirectReferenceArray = new PdfIndirectReference[(objectArray.length + 64 - 1) / 64];
        int n5 = 0;
        while (n5 < pdfIndirectReferenceArray.length) {
            n2 = n5 * 64;
            n = Math.min(n2 + 64, objectArray.length);
            PdfDictionary pdfDictionary = new PdfDictionary();
            PdfArray pdfArray = new PdfArray();
            pdfArray.add(new PdfNumber((Integer)objectArray[n2]));
            pdfArray.add(new PdfNumber((Integer)objectArray[n - 1]));
            pdfDictionary.put(PdfName.LIMITS, pdfArray);
            pdfArray = new PdfArray();
            while (n2 < n) {
                pdfArray.add(new PdfNumber((Integer)objectArray[n2]));
                pdfArray.add((PdfObject)hashMap.get(objectArray[n2]));
                ++n2;
            }
            pdfDictionary.put(PdfName.NUMS, pdfArray);
            pdfIndirectReferenceArray[n5] = pdfWriter.addToBody(pdfDictionary).getIndirectReference();
            ++n5;
        }
        n5 = pdfIndirectReferenceArray.length;
        while (true) {
            if (n5 <= 64) {
                PdfArray pdfArray = new PdfArray();
                n = 0;
                while (n < n5) {
                    pdfArray.add(pdfIndirectReferenceArray[n]);
                    ++n;
                }
                PdfDictionary pdfDictionary = new PdfDictionary();
                pdfDictionary.put(PdfName.KIDS, pdfArray);
                return pdfDictionary;
            }
            n2 = (objectArray.length + (n4 *= 64) - 1) / n4;
            n = 0;
            while (n < n2) {
                int n6 = n * 64;
                int n7 = Math.min(n6 + 64, n5);
                PdfDictionary pdfDictionary = new PdfDictionary();
                PdfArray pdfArray = new PdfArray();
                pdfArray.add(new PdfNumber((Integer)objectArray[n * n4]));
                pdfArray.add(new PdfNumber((Integer)objectArray[Math.min((n + 1) * n4, objectArray.length) - 1]));
                pdfDictionary.put(PdfName.LIMITS, pdfArray);
                pdfArray = new PdfArray();
                while (n6 < n7) {
                    pdfArray.add(pdfIndirectReferenceArray[n6]);
                    ++n6;
                }
                pdfDictionary.put(PdfName.KIDS, pdfArray);
                pdfIndirectReferenceArray[n] = pdfWriter.addToBody(pdfDictionary).getIndirectReference();
                ++n;
            }
            n5 = n2;
        }
    }

    private static void iterateItems(PdfDictionary pdfDictionary, HashMap hashMap) {
        block3: {
            PdfArray pdfArray;
            block2: {
                pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.NUMS));
                if (pdfArray == null) break block2;
                ArrayList arrayList = pdfArray.getArrayList();
                int n = 0;
                while (n < arrayList.size()) {
                    PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(n++));
                    hashMap.put(new Integer(pdfNumber.intValue()), arrayList.get(n));
                    ++n;
                }
                break block3;
            }
            pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.KIDS));
            if (pdfArray == null) break block3;
            ArrayList arrayList = pdfArray.getArrayList();
            int n = 0;
            while (n < arrayList.size()) {
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)arrayList.get(n));
                PdfNumberTree.iterateItems(pdfDictionary2, hashMap);
                ++n;
            }
        }
    }

    public static HashMap readTree(PdfDictionary pdfDictionary) {
        HashMap hashMap = new HashMap();
        if (pdfDictionary != null) {
            PdfNumberTree.iterateItems(pdfDictionary, hashMap);
        }
        return hashMap;
    }
}

