/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.midiport;

import java.io.File;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.player.base.MidiOutputPort;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.base.MidiReceiver;
import org.herac.tuxguitar.player.impl.jsa.assistant.SBAssistant;
import org.herac.tuxguitar.player.impl.jsa.midiport.MidiPortSynthesizerReceiver;
import org.herac.tuxguitar.player.impl.jsa.utils.MidiConfigUtils;

public class MidiPortSynthesizer
extends MidiOutputPort {
    private Synthesizer synthesizer;
    private MidiReceiver receiver;
    private boolean synthesizerLoaded;
    private boolean soundbankLoaded;

    public MidiPortSynthesizer(Synthesizer synthesizer) {
        super(synthesizer.getDeviceInfo().getName(), synthesizer.getDeviceInfo().getName());
        this.synthesizer = synthesizer;
        this.receiver = new MidiPortSynthesizerReceiver(this);
    }

    public void open() {
        this.getSynthesizer();
    }

    public void close() {
        if (this.synthesizer != null && this.synthesizer.isOpen()) {
            this.unloadSoundbank();
            this.synthesizer.close();
        }
    }

    public MidiReceiver getReceiver() {
        return this.receiver;
    }

    public void check() throws MidiPlayerException {
        if (!this.isSynthesizerLoaded()) {
            throw new MidiPlayerException(TuxGuitar.getProperty((String)"jsa.error.midi.unavailable"));
        }
        if (!this.isSoundbankLoaded(true)) {
            throw new MidiPlayerException(TuxGuitar.getProperty((String)"jsa.error.soundbank.unavailable"));
        }
    }

    public Synthesizer getSynthesizer() {
        try {
            if (!this.synthesizer.isOpen()) {
                this.synthesizer.open();
                if (!this.isSoundbankLoaded(false)) {
                    String string = MidiConfigUtils.getSoundbankPath();
                    if (string != null) {
                        this.loadSoundbank(new File(string));
                    }
                    if (!this.isSoundbankLoaded(true)) {
                        this.loadSoundbank(this.synthesizer.getDefaultSoundbank());
                    }
                    if (!this.isSoundbankLoaded(true)) {
                        new SBAssistant(this).process();
                    }
                }
            }
            this.synthesizerLoaded = this.synthesizer.isOpen();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this.synthesizer;
    }

    public boolean loadSoundbank(File file) {
        try {
            return this.loadSoundbank(MidiSystem.getSoundbank(file));
        }
        catch (Throwable throwable) {
            new MidiPlayerException(TuxGuitar.getProperty((String)"jsa.error.soundbank.custom"), throwable).printStackTrace();
            return false;
        }
    }

    public boolean loadSoundbank(Soundbank soundbank) {
        try {
            if (soundbank != null && this.getSynthesizer().isSoundbankSupported(soundbank)) {
                this.unloadSoundbank();
                this.soundbankLoaded = this.getSynthesizer().loadAllInstruments(soundbank);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this.soundbankLoaded;
    }

    public void unloadSoundbank() {
        try {
            Instrument[] instrumentArray;
            this.soundbankLoaded = false;
            Instrument[] instrumentArray2 = this.synthesizer.getAvailableInstruments();
            if (instrumentArray2 != null) {
                for (int i = 0; i < instrumentArray2.length; ++i) {
                    this.getSynthesizer().unloadInstrument(instrumentArray2[i]);
                }
            }
            if ((instrumentArray = this.synthesizer.getLoadedInstruments()) != null) {
                for (int i = 0; i < instrumentArray.length; ++i) {
                    this.getSynthesizer().unloadInstrument(instrumentArray[i]);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isSynthesizerLoaded() {
        return this.synthesizerLoaded;
    }

    public boolean isSoundbankLoaded(boolean bl) {
        if (bl) {
            Instrument[] instrumentArray = this.synthesizer.getLoadedInstruments();
            Instrument[] instrumentArray2 = this.synthesizer.getAvailableInstruments();
            this.soundbankLoaded = instrumentArray != null && instrumentArray.length > 0 || instrumentArray2 != null && instrumentArray2.length > 0;
        }
        return this.soundbankLoaded;
    }
}

