/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.sequencer;

import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.impl.jsa.sequencer.MidiSequencerImpl;

public class MidiReceiverImpl
implements Receiver {
    private MidiSequencerImpl sequencer;

    public MidiReceiverImpl(MidiSequencerImpl midiSequencerImpl) {
        this.sequencer = midiSequencerImpl;
    }

    public void send(MidiMessage midiMessage, long l) {
        try {
            this.parseMessage(midiMessage.getMessage());
        }
        catch (MidiPlayerException midiPlayerException) {
            midiPlayerException.printStackTrace();
        }
    }

    public void close() {
    }

    private void parseMessage(byte[] byArray) throws MidiPlayerException {
        int n = byArray.length;
        if (((n > 0 ? byArray[0] & 0xFF : 0) & 0xF0) == 144) {
            this.parseNoteOn(byArray);
        } else if (((n > 0 ? byArray[0] & 0xFF : 0) & 0xF0) == 128) {
            this.parseNoteOff(byArray);
        } else if (((n > 0 ? byArray[0] & 0xFF : 0) & 0xF0) == 192) {
            this.parseProgramChange(byArray);
        } else if (((n > 0 ? byArray[0] & 0xFF : 0) & 0xF0) == 176) {
            this.parseControlChange(byArray);
        } else if (((n > 0 ? byArray[0] & 0xFF : 0) & 0xF0) == 224) {
            this.parsePitchBend(byArray);
        }
    }

    private void parseNoteOn(byte[] byArray) throws MidiPlayerException {
        int n;
        int n2 = byArray.length;
        int n3 = n2 > 0 ? byArray[0] & 0xFF & 0xF : 0;
        int n4 = n2 > 1 ? byArray[1] & 0xFF : 0;
        int n5 = n = n2 > 2 ? byArray[2] & 0xFF : 0;
        if (n == 0) {
            this.parseNoteOff(byArray);
        } else if (n4 > 0) {
            this.sequencer.getTransmitter().sendNoteOn(n3, n4, n);
        }
    }

    private void parseNoteOff(byte[] byArray) throws MidiPlayerException {
        int n = byArray.length;
        int n2 = n > 0 ? byArray[0] & 0xFF & 0xF : 0;
        int n3 = n > 1 ? byArray[1] & 0xFF : 0;
        int n4 = n > 2 ? byArray[2] & 0xFF : 0;
        this.sequencer.getTransmitter().sendNoteOff(n2, n3, n4);
    }

    private void parseProgramChange(byte[] byArray) throws MidiPlayerException {
        int n;
        int n2 = byArray.length;
        int n3 = n2 > 0 ? byArray[0] & 0xFF & 0xF : -1;
        int n4 = n = n2 > 1 ? byArray[1] & 0xFF : -1;
        if (n3 != -1 && n != -1) {
            this.sequencer.getTransmitter().sendProgramChange(n3, n);
        }
    }

    private void parseControlChange(byte[] byArray) throws MidiPlayerException {
        int n;
        int n2 = byArray.length;
        int n3 = n2 > 0 ? byArray[0] & 0xFF & 0xF : -1;
        int n4 = n2 > 1 ? byArray[1] & 0xFF : -1;
        int n5 = n = n2 > 2 ? byArray[2] & 0xFF : -1;
        if (n3 != -1 && n4 != -1 && n != -1) {
            this.sequencer.getTransmitter().sendControlChange(n3, n4, n);
        }
    }

    private void parsePitchBend(byte[] byArray) throws MidiPlayerException {
        int n;
        int n2 = byArray.length;
        int n3 = n2 > 0 ? byArray[0] & 0xFF & 0xF : -1;
        int n4 = n = n2 > 2 ? byArray[2] & 0xFF : -1;
        if (n3 != -1 && n != -1) {
            this.sequencer.getTransmitter().sendPitchBend(n3, n);
        }
    }
}

