/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class Jpeg
extends Image
implements Element {
    public static final int NOT_A_MARKER = -1;
    public static final int VALID_MARKER = 0;
    public static final int[] VALID_MARKERS = new int[]{192, 193, 194};
    public static final int UNSUPPORTED_MARKER = 1;
    public static final int[] UNSUPPORTED_MARKERS = new int[]{195, 197, 198, 199, 200, 201, 202, 203, 205, 206, 207};
    public static final int NOPARAM_MARKER = 2;
    public static final int[] NOPARAM_MARKERS = new int[]{208, 209, 210, 211, 212, 213, 214, 215, 216, 1};
    public static final int M_APP0 = 224;
    public static final int M_APPE = 238;
    public static final byte[] JFIF_ID = new byte[]{74, 70, 73, 70, 0};

    Jpeg(Image image) {
        super(image);
    }

    public Jpeg(URL uRL) throws BadElementException, IOException {
        super(uRL);
        this.processParameters();
    }

    public Jpeg(URL uRL, float f, float f2) throws BadElementException, IOException {
        this(uRL);
        this.scaledWidth = f;
        this.scaledHeight = f2;
    }

    public Jpeg(String string) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(string));
    }

    public Jpeg(String string, float f, float f2) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(string), f, f2);
    }

    public Jpeg(byte[] byArray) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = byArray;
        this.originalData = byArray;
        this.processParameters();
    }

    public Jpeg(byte[] byArray, float f, float f2) throws BadElementException, IOException {
        this(byArray);
        this.scaledWidth = f;
        this.scaledHeight = f2;
    }

    private static final int getShort(InputStream inputStream) throws IOException {
        return (inputStream.read() << 8) + inputStream.read();
    }

    private static final int marker(int n) {
        int n2;
        for (n2 = 0; n2 < VALID_MARKERS.length; ++n2) {
            if (n != VALID_MARKERS[n2]) continue;
            return 0;
        }
        for (n2 = 0; n2 < NOPARAM_MARKERS.length; ++n2) {
            if (n != NOPARAM_MARKERS[n2]) continue;
            return 2;
        }
        for (n2 = 0; n2 < UNSUPPORTED_MARKERS.length; ++n2) {
            if (n != UNSUPPORTED_MARKERS[n2]) continue;
            return 1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processParameters() throws BadElementException, IOException {
        this.type = 32;
        this.originalType = 1;
        InputStream inputStream = null;
        try {
            String string;
            if (this.rawData == null) {
                inputStream = this.url.openStream();
                string = this.url.toString();
            } else {
                inputStream = new ByteArrayInputStream(this.rawData);
                string = "Byte array";
            }
            if (inputStream.read() != 255 || inputStream.read() != 216) {
                throw new BadElementException(string + " is not a valid JPEG-file.");
            }
            boolean bl = true;
            while (true) {
                int n;
                byte[] byArray;
                int n2;
                int n3;
                if ((n3 = inputStream.read()) < 0) {
                    throw new IOException("Premature EOF while reading JPG.");
                }
                if (n3 != 255) continue;
                int n4 = inputStream.read();
                if (bl && n4 == 224) {
                    int n5;
                    bl = false;
                    n2 = Jpeg.getShort(inputStream);
                    if (n2 < 16) {
                        Jpeg.skip(inputStream, n2 - 2);
                        continue;
                    }
                    byArray = new byte[JFIF_ID.length];
                    n = inputStream.read(byArray);
                    if (n != byArray.length) {
                        throw new BadElementException(string + " corrupted JFIF marker.");
                    }
                    boolean bl2 = true;
                    for (n5 = 0; n5 < byArray.length; ++n5) {
                        if (byArray[n5] == JFIF_ID[n5]) continue;
                        bl2 = false;
                        break;
                    }
                    if (!bl2) {
                        Jpeg.skip(inputStream, n2 - 2 - byArray.length);
                        continue;
                    }
                    Jpeg.skip(inputStream, 2);
                    n5 = inputStream.read();
                    int n6 = Jpeg.getShort(inputStream);
                    int n7 = Jpeg.getShort(inputStream);
                    if (n5 == 1) {
                        this.dpiX = n6;
                        this.dpiY = n7;
                    } else if (n5 == 2) {
                        this.dpiX = (int)((float)n6 * 2.54f + 0.5f);
                        this.dpiY = (int)((float)n7 * 2.54f + 0.5f);
                    }
                    Jpeg.skip(inputStream, n2 - 2 - byArray.length - 7);
                    continue;
                }
                if (n4 == 238) {
                    String string2;
                    n2 = Jpeg.getShort(inputStream);
                    byArray = new byte[n2];
                    for (n = 0; n < n2; ++n) {
                        byArray[n] = (byte)inputStream.read();
                    }
                    if (byArray.length > 12 && (string2 = new String(byArray, 0, 5, "ISO-8859-1")).equals("Adobe")) {
                        this.invert = true;
                    }
                }
                bl = false;
                int n8 = Jpeg.marker(n4);
                if (n8 == 0) {
                    Jpeg.skip(inputStream, 2);
                    if (inputStream.read() != 8) {
                        throw new BadElementException(string + " must have 8 bits per component.");
                    }
                    this.scaledHeight = Jpeg.getShort(inputStream);
                    this.setTop(this.scaledHeight);
                    this.scaledWidth = Jpeg.getShort(inputStream);
                    this.setRight(this.scaledWidth);
                    this.colorspace = inputStream.read();
                    this.bpc = 8;
                    break;
                }
                if (n8 == 1) {
                    throw new BadElementException(string + ": unsupported JPEG marker: " + n4);
                }
                if (n8 == 2) continue;
                Jpeg.skip(inputStream, Jpeg.getShort(inputStream) - 2);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            this.plainWidth = this.width();
            this.plainHeight = this.height();
        }
    }
}

