/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.graphic;

import com.lowagie.text.rtf.RtfAddableElement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfShapePosition
extends RtfAddableElement {
    public static final int POSITION_X_RELATIVE_PAGE = 0;
    public static final int POSITION_X_RELATIVE_MARGIN = 1;
    public static final int POSITION_X_RELATIVE_COLUMN = 2;
    public static final int POSITION_Y_RELATIVE_PAGE = 0;
    public static final int POSITION_Y_RELATIVE_MARGIN = 1;
    public static final int POSITION_Y_RELATIVE_PARAGRAPH = 2;
    private int top = 0;
    private int left = 0;
    private int right = 0;
    private int bottom = 0;
    private int zOrder = 0;
    private int xRelativePos = 0;
    private int yRelativePos = 0;
    private boolean ignoreXRelative = false;
    private boolean ignoreYRelative = false;
    private boolean shapeBelowText = false;

    public RtfShapePosition(int n, int n2, int n3, int n4) {
        this.top = n;
        this.left = n2;
        this.right = n3;
        this.bottom = n4;
    }

    public boolean isShapeBelowText() {
        return this.shapeBelowText;
    }

    public void setShapeBelowText(boolean bl) {
        this.shapeBelowText = bl;
    }

    public void setXRelativePos(int n) {
        this.xRelativePos = n;
    }

    public void setYRelativePos(int n) {
        this.yRelativePos = n;
    }

    public void setZOrder(int n) {
        this.zOrder = n;
    }

    protected void setIgnoreXRelative(boolean bl) {
        this.ignoreXRelative = bl;
    }

    protected void setIgnoreYRelative(boolean bl) {
        this.ignoreYRelative = bl;
    }

    @Override
    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write("\\shpleft".getBytes());
            byteArrayOutputStream.write(this.intToByteArray(this.left));
            byteArrayOutputStream.write("\\shptop".getBytes());
            byteArrayOutputStream.write(this.intToByteArray(this.top));
            byteArrayOutputStream.write("\\shpright".getBytes());
            byteArrayOutputStream.write(this.intToByteArray(this.right));
            byteArrayOutputStream.write("\\shpbottom".getBytes());
            byteArrayOutputStream.write(this.intToByteArray(this.bottom));
            byteArrayOutputStream.write("\\shpz".getBytes());
            byteArrayOutputStream.write(this.intToByteArray(this.zOrder));
            switch (this.xRelativePos) {
                case 0: {
                    byteArrayOutputStream.write("\\shpbxpage".getBytes());
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write("\\shpbxmargin".getBytes());
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write("\\shpbxcolumn".getBytes());
                }
            }
            if (this.ignoreXRelative) {
                byteArrayOutputStream.write("\\shpbxignore".getBytes());
            }
            switch (this.yRelativePos) {
                case 0: {
                    byteArrayOutputStream.write("\\shpbypage".getBytes());
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write("\\shpbymargin".getBytes());
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write("\\shpbypara".getBytes());
                }
            }
            if (this.ignoreYRelative) {
                byteArrayOutputStream.write("\\shpbyignore".getBytes());
            }
            if (this.shapeBelowText) {
                byteArrayOutputStream.write("\\shpfblwtxt1".getBytes());
            } else {
                byteArrayOutputStream.write("\\shpfblwtxt0".getBytes());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

