/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.table;

import com.lowagie.text.Row;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.table.RtfBorderGroup;
import com.lowagie.text.rtf.table.RtfRow;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class RtfTable
extends RtfElement {
    private ArrayList rows = null;
    private float tableWidthPercent = 80.0f;
    private float[] proportionalWidths = null;
    private float cellPadding = 0.0f;
    private float cellSpacing = 0.0f;
    private RtfBorderGroup borders = null;
    private int alignment = 1;
    private boolean cellsFitToPage = false;
    private boolean tableFitToPage = false;
    private int headerRows = 0;

    public RtfTable(RtfDocument rtfDocument, Table table) {
        super(rtfDocument);
        table.complete();
        this.importTable(table);
    }

    private void importTable(Table table) {
        this.rows = new ArrayList();
        this.tableWidthPercent = table.widthPercentage();
        this.proportionalWidths = table.getProportionalWidths();
        this.cellPadding = (float)((double)table.cellpadding() * 20.0);
        this.cellSpacing = (float)((double)table.cellspacing() * 20.0);
        this.borders = new RtfBorderGroup(this.document, 1, table.border(), table.borderWidth(), table.borderColor());
        this.alignment = table.alignment();
        int n = 0;
        Iterator iterator = table.iterator();
        while (iterator.hasNext()) {
            this.rows.add(new RtfRow(this.document, this, (Row)iterator.next(), n));
            ++n;
        }
        for (n = 0; n < this.rows.size(); ++n) {
            ((RtfRow)this.rows.get(n)).handleCellSpanning();
            ((RtfRow)this.rows.get(n)).cleanRow();
        }
        this.headerRows = table.lastHeaderRow();
        this.cellsFitToPage = table.hasToFitPageCells();
        this.tableFitToPage = table.hasToFitPageTable();
    }

    @Override
    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (!this.inHeader) {
                byteArrayOutputStream.write(RtfParagraph.PARAGRAPH);
            }
            for (int i = 0; i < this.rows.size(); ++i) {
                byteArrayOutputStream.write(((RtfElement)this.rows.get(i)).write());
            }
            byteArrayOutputStream.write(RtfParagraph.PARAGRAPH_DEFAULTS);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected int getAlignment() {
        return this.alignment;
    }

    protected RtfBorderGroup getBorders() {
        return this.borders;
    }

    protected float getCellPadding() {
        return this.cellPadding;
    }

    protected float getCellSpacing() {
        return this.cellSpacing;
    }

    protected float[] getProportionalWidths() {
        return (float[])this.proportionalWidths.clone();
    }

    protected float getTableWidthPercent() {
        return this.tableWidthPercent;
    }

    protected ArrayList getRows() {
        return this.rows;
    }

    protected boolean getCellsFitToPage() {
        return this.cellsFitToPage;
    }

    protected boolean getTableFitToPage() {
        return this.tableFitToPage;
    }

    protected int getHeaderRows() {
        return this.headerRows;
    }
}

