/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;

public class RemoveLaunchApplication
extends AbstractTool {
    public RemoveLaunchApplication() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "srcfile", "The file from which you want to remove Launch Application actions", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the cleaned up version of the original PDF has to be written", true, new PdfFilter()));
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Remove Launch Applications", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Remove Launch Applications OPENED ===");
    }

    @Override
    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File file = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File file2 = (File)this.getValue("destfile");
            PdfReader pdfReader = new PdfReader(file.getAbsolutePath());
            for (int i = 1; i < pdfReader.getXrefSize(); ++i) {
                PdfDictionary pdfDictionary;
                PdfDictionary pdfDictionary2;
                PdfObject pdfObject = pdfReader.getPdfObject(i);
                if (!(pdfObject instanceof PdfDictionary) || (pdfObject = (pdfDictionary2 = (PdfDictionary)pdfObject).get(PdfName.A)) == null) continue;
                if (pdfObject instanceof PdfDictionary) {
                    pdfDictionary = (PdfDictionary)pdfObject;
                } else {
                    PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                    pdfDictionary = (PdfDictionary)pdfReader.getPdfObject(pRIndirectReference.getNumber());
                }
                PdfName pdfName = (PdfName)pdfDictionary.get(PdfName.S);
                if (!PdfName.LAUNCH.equals(pdfName)) continue;
                if (pdfDictionary.get(PdfName.F) != null) {
                    System.out.println("Removed: " + pdfDictionary.get(PdfName.F));
                    pdfDictionary.remove(PdfName.F);
                }
                if (pdfDictionary.get(PdfName.WIN) != null) {
                    System.out.println("Removed: " + pdfDictionary.get(PdfName.WIN));
                    pdfDictionary.remove(PdfName.WIN);
                }
                pdfDictionary.put(PdfName.S, PdfName.JAVASCRIPT);
                pdfDictionary.put(PdfName.JS, new PdfString("app.alert('Launch Application Action removed by iText');\r"));
            }
            PdfStamper pdfStamper = new PdfStamper(pdfReader, new FileOutputStream(file2));
            pdfStamper.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        RemoveLaunchApplication removeLaunchApplication = new RemoveLaunchApplication();
        if (stringArray.length < 2) {
            System.err.println(removeLaunchApplication.getUsage());
        }
        removeLaunchApplication.setArguments(stringArray);
        removeLaunchApplication.execute();
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        RemoveLaunchApplication.addVersion("$Id: RemoveLaunchApplication.java,v 1.4 2005/11/29 21:05:02 blowagie Exp $");
    }
}

