/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gtp;

import java.io.IOException;
import java.util.Iterator;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.gtp.GTPOutputStream;
import org.herac.tuxguitar.io.gtp.GTPSettings;
import org.herac.tuxguitar.io.gtp.GTPVoiceJoiner;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGStroke;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGTupleto;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;

public class GP3OutputStream
extends GTPOutputStream {
    private static final String GP3_FORMAT_EXTENSION = ".gp3";
    private static final String GP3_VERSION = "FICHIER GUITAR PRO v3.00";
    private static final int GP_BEND_SEMITONE = 25;
    private static final int GP_BEND_POSITION = 60;

    public GP3OutputStream(GTPSettings gTPSettings) {
        super(gTPSettings);
    }

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("Guitar Pro 3", "*.gp3");
    }

    public boolean isSupportedExtension(String string) {
        return string.toLowerCase().equals(GP3_FORMAT_EXTENSION);
    }

    public void writeSong(TGSong tGSong) {
        try {
            if (tGSong.isEmpty()) {
                throw new TGFileFormatException("Empty Song!!!");
            }
            TGMeasureHeader tGMeasureHeader = tGSong.getMeasureHeader(0);
            this.writeStringByte(GP3_VERSION, 30, "UTF-8");
            this.writeInfo(tGSong);
            this.writeBoolean(tGMeasureHeader.getTripletFeel() == 2);
            this.writeInt(tGMeasureHeader.getTempo().getValue());
            this.writeInt(0);
            this.writeChannels(tGSong);
            this.writeInt(tGSong.countMeasureHeaders());
            this.writeInt(tGSong.countTracks());
            this.writeMeasureHeaders(tGSong);
            this.writeTracks(tGSong);
            this.writeMeasures(tGSong, tGMeasureHeader.getTempo().clone(this.getFactory()));
            this.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeInfo(TGSong tGSong) throws IOException {
        this.writeStringByteSizeOfInteger(tGSong.getName());
        this.writeStringByteSizeOfInteger("");
        this.writeStringByteSizeOfInteger(tGSong.getArtist());
        this.writeStringByteSizeOfInteger(tGSong.getAlbum());
        this.writeStringByteSizeOfInteger(tGSong.getAuthor());
        this.writeStringByteSizeOfInteger("");
        this.writeStringByteSizeOfInteger("");
        this.writeStringByteSizeOfInteger("");
        this.writeInt(0);
    }

    private void writeChannels(TGSong tGSong) throws IOException {
        TGChannel[] tGChannelArray = this.makeChannels(tGSong);
        for (int i = 0; i < tGChannelArray.length; ++i) {
            this.writeInt(tGChannelArray[i].getInstrument());
            this.writeByte(this.toChannelByte(tGChannelArray[i].getVolume()));
            this.writeByte(this.toChannelByte(tGChannelArray[i].getBalance()));
            this.writeByte(this.toChannelByte(tGChannelArray[i].getChorus()));
            this.writeByte(this.toChannelByte(tGChannelArray[i].getReverb()));
            this.writeByte(this.toChannelByte(tGChannelArray[i].getPhaser()));
            this.writeByte(this.toChannelByte(tGChannelArray[i].getTremolo()));
            this.writeBytes(new byte[]{0, 0});
        }
    }

    private void writeMeasureHeaders(TGSong tGSong) throws IOException {
        TGTimeSignature tGTimeSignature = this.getFactory().newTimeSignature();
        if (tGSong.countMeasureHeaders() > 0) {
            for (int i = 0; i < tGSong.countMeasureHeaders(); ++i) {
                TGMeasureHeader tGMeasureHeader = tGSong.getMeasureHeader(i);
                this.writeMeasureHeader(tGMeasureHeader, tGTimeSignature);
                tGTimeSignature.setNumerator(tGMeasureHeader.getTimeSignature().getNumerator());
                tGTimeSignature.getDenominator().setValue(tGMeasureHeader.getTimeSignature().getDenominator().getValue());
            }
        }
    }

    private void writeMeasures(TGSong tGSong, TGTempo tGTempo) throws IOException {
        for (int i = 0; i < tGSong.countMeasureHeaders(); ++i) {
            TGMeasureHeader tGMeasureHeader = tGSong.getMeasureHeader(i);
            for (int j = 0; j < tGSong.countTracks(); ++j) {
                TGTrack tGTrack = tGSong.getTrack(j);
                TGMeasure tGMeasure = tGTrack.getMeasure(i);
                this.writeMeasure(tGMeasure, tGMeasureHeader.getTempo().getValue() != tGTempo.getValue());
            }
            tGMeasureHeader.getTempo().copy(tGTempo);
        }
    }

    private void writeMeasureHeader(TGMeasureHeader tGMeasureHeader, TGTimeSignature tGTimeSignature) throws IOException {
        int n = 0;
        if (tGMeasureHeader.getNumber() == 1 || tGMeasureHeader.getTimeSignature().getNumerator() != tGTimeSignature.getNumerator()) {
            n |= 1;
        }
        if (tGMeasureHeader.getNumber() == 1 || tGMeasureHeader.getTimeSignature().getDenominator().getValue() != tGTimeSignature.getDenominator().getValue()) {
            n |= 2;
        }
        if (tGMeasureHeader.isRepeatOpen()) {
            n |= 4;
        }
        if (tGMeasureHeader.getRepeatClose() > 0) {
            n |= 8;
        }
        if (tGMeasureHeader.hasMarker()) {
            n |= 0x20;
        }
        this.writeUnsignedByte(n);
        if ((n & 1) != 0) {
            this.writeByte((byte)tGMeasureHeader.getTimeSignature().getNumerator());
        }
        if ((n & 2) != 0) {
            this.writeByte((byte)tGMeasureHeader.getTimeSignature().getDenominator().getValue());
        }
        if ((n & 8) != 0) {
            this.writeByte((byte)tGMeasureHeader.getRepeatClose());
        }
        if ((n & 0x20) != 0) {
            this.writeMarker(tGMeasureHeader.getMarker());
        }
    }

    private void writeTracks(TGSong tGSong) throws IOException {
        for (int i = 0; i < tGSong.countTracks(); ++i) {
            TGTrack tGTrack = tGSong.getTrack(i);
            this.createTrack(tGTrack);
        }
    }

    private void createTrack(TGTrack tGTrack) throws IOException {
        int n = 0;
        if (tGTrack.isPercussionTrack()) {
            n |= 1;
        }
        this.writeUnsignedByte(n);
        this.writeStringByte(tGTrack.getName(), 40);
        this.writeInt(tGTrack.getStrings().size());
        for (int i = 0; i < 7; ++i) {
            int n2 = 0;
            if (tGTrack.getStrings().size() > i) {
                TGString tGString = (TGString)tGTrack.getStrings().get(i);
                n2 = tGString.getValue();
            }
            this.writeInt(n2);
        }
        this.writeInt(1);
        this.writeInt(tGTrack.getChannel().getChannel() + 1);
        this.writeInt(tGTrack.getChannel().getEffectChannel() + 1);
        this.writeInt(24);
        this.writeInt(Math.min(Math.max(tGTrack.getOffset(), 0), 12));
        this.writeColor(tGTrack.getColor());
    }

    private void writeMeasure(TGMeasure tGMeasure, boolean bl) throws IOException {
        TGMeasure tGMeasure2 = new GTPVoiceJoiner(this.getFactory(), tGMeasure).process();
        int n = tGMeasure2.countBeats();
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            TGBeat tGBeat = tGMeasure2.getBeat(i);
            this.writeBeat(tGBeat, tGMeasure2, bl && i == 0);
        }
    }

    private void writeBeat(TGBeat tGBeat, TGMeasure tGMeasure, boolean bl) throws IOException {
        int n;
        TGNote tGNote;
        TGVoice tGVoice = tGBeat.getVoice(0);
        TGDuration tGDuration = tGVoice.getDuration();
        int n2 = 0;
        if (tGDuration.isDotted() || tGDuration.isDoubleDotted()) {
            n2 |= 1;
        }
        if (!tGDuration.getTupleto().isEqual(TGTupleto.NORMAL)) {
            n2 |= 0x20;
        }
        if (tGBeat.isTextBeat()) {
            n2 |= 4;
        }
        if (bl) {
            n2 |= 0x10;
        }
        TGNoteEffect tGNoteEffect = null;
        if (tGVoice.isRestVoice()) {
            n2 |= 0x40;
        } else if (tGVoice.countNotes() > 0 && ((tGNoteEffect = (tGNote = tGVoice.getNote(0)).getEffect()).isVibrato() || tGNoteEffect.isTremoloBar() || tGNoteEffect.isTapping() || tGNoteEffect.isSlapping() || tGNoteEffect.isPopping() || tGNoteEffect.isHarmonic() || tGNoteEffect.isFadeIn() || tGBeat.getStroke().getDirection() != 0)) {
            n2 |= 8;
        }
        this.writeUnsignedByte(n2);
        if ((n2 & 0x40) != 0) {
            this.writeUnsignedByte(2);
        }
        this.writeByte(this.parseDuration(tGDuration));
        if ((n2 & 0x20) != 0) {
            this.writeInt(tGDuration.getTupleto().getEnters());
        }
        if ((n2 & 4) != 0) {
            this.writeText(tGBeat.getText());
        }
        if ((n2 & 8) != 0) {
            this.writeBeatEffects(tGBeat, tGNoteEffect);
        }
        if ((n2 & 0x10) != 0) {
            this.writeMixChange(tGMeasure.getTempo());
        }
        int n3 = 0;
        if (!tGVoice.isRestVoice()) {
            for (n = 0; n < tGVoice.countNotes(); ++n) {
                TGNote tGNote2 = tGVoice.getNote(n);
                int n4 = 7 - tGNote2.getString();
                n3 |= 1 << n4;
            }
        }
        this.writeUnsignedByte(n3);
        block1: for (n = 6; n >= 0; --n) {
            if ((n3 & 1 << n) == 0) continue;
            for (int i = 0; i < tGVoice.countNotes(); ++i) {
                TGNote tGNote3 = tGVoice.getNote(i);
                if (tGNote3.getString() != 6 - n + 1) continue;
                this.writeNote(tGNote3);
                continue block1;
            }
        }
    }

    private void writeNote(TGNote tGNote) throws IOException {
        int n = 48;
        if (tGNote.getEffect().isGhostNote()) {
            n |= 4;
        }
        if (tGNote.getEffect().isBend() || tGNote.getEffect().isGrace() || tGNote.getEffect().isSlide() || tGNote.getEffect().isHammer()) {
            n |= 8;
        }
        this.writeUnsignedByte(n);
        if ((n & 0x20) != 0) {
            int n2 = 1;
            if (tGNote.isTiedNote()) {
                n2 = 2;
            } else if (tGNote.getEffect().isDeadNote()) {
                n2 = 3;
            }
            this.writeUnsignedByte(n2);
        }
        if ((n & 0x10) != 0) {
            this.writeByte((byte)((tGNote.getVelocity() - 15) / 16 + 1));
        }
        if ((n & 0x20) != 0) {
            this.writeByte((byte)tGNote.getValue());
        }
        if ((n & 8) != 0) {
            this.writeNoteEffects(tGNote.getEffect());
        }
    }

    private byte parseDuration(TGDuration tGDuration) {
        byte by = 0;
        switch (tGDuration.getValue()) {
            case 1: {
                by = -2;
                break;
            }
            case 2: {
                by = -1;
                break;
            }
            case 4: {
                by = 0;
                break;
            }
            case 8: {
                by = 1;
                break;
            }
            case 16: {
                by = 2;
                break;
            }
            case 32: {
                by = 3;
                break;
            }
            case 64: {
                by = 4;
            }
        }
        return by;
    }

    private void writeText(TGText tGText) throws IOException {
        this.writeStringByteSizeOfInteger(tGText.getValue());
    }

    private void writeBeatEffects(TGBeat tGBeat, TGNoteEffect tGNoteEffect) throws IOException {
        int n = 0;
        if (tGNoteEffect.isVibrato()) {
            ++n;
        }
        if (tGNoteEffect.isTremoloBar() || tGNoteEffect.isTapping() || tGNoteEffect.isSlapping() || tGNoteEffect.isPopping()) {
            n += 32;
        }
        if (tGBeat.getStroke().getDirection() != 0) {
            n |= 0x40;
        }
        if (tGNoteEffect.isHarmonic() && tGNoteEffect.getHarmonic().getType() == 1) {
            n += 4;
        }
        if (tGNoteEffect.isHarmonic() && tGNoteEffect.getHarmonic().getType() != 1) {
            n += 8;
        }
        if (tGNoteEffect.isFadeIn()) {
            n += 16;
        }
        this.writeUnsignedByte(n);
        if ((n & 0x20) != 0) {
            if (tGNoteEffect.isTremoloBar()) {
                this.writeUnsignedByte(0);
                this.writeInt(100);
            } else if (tGNoteEffect.isTapping()) {
                this.writeUnsignedByte(1);
                this.writeInt(0);
            } else if (tGNoteEffect.isSlapping()) {
                this.writeUnsignedByte(2);
                this.writeInt(0);
            } else if (tGNoteEffect.isPopping()) {
                this.writeUnsignedByte(3);
                this.writeInt(0);
            }
        }
        if ((n & 0x40) != 0) {
            this.writeUnsignedByte(tGBeat.getStroke().getDirection() == -1 ? this.toStrokeValue(tGBeat.getStroke()) : 0);
            this.writeUnsignedByte(tGBeat.getStroke().getDirection() == 1 ? this.toStrokeValue(tGBeat.getStroke()) : 0);
        }
    }

    private void writeNoteEffects(TGNoteEffect tGNoteEffect) throws IOException {
        int n = 0;
        if (tGNoteEffect.isBend()) {
            n |= 1;
        }
        if (tGNoteEffect.isHammer()) {
            n |= 2;
        }
        if (tGNoteEffect.isSlide()) {
            n |= 4;
        }
        if (tGNoteEffect.isGrace()) {
            n |= 0x10;
        }
        this.writeUnsignedByte(n);
        if ((n & 1) != 0) {
            this.writeBend(tGNoteEffect.getBend());
        }
        if ((n & 0x10) != 0) {
            this.writeGrace(tGNoteEffect.getGrace());
        }
    }

    private void writeBend(TGEffectBend tGEffectBend) throws IOException {
        int n = tGEffectBend.getPoints().size();
        this.writeByte((byte)1);
        this.writeInt(0);
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            TGEffectBend.BendPoint bendPoint = (TGEffectBend.BendPoint)tGEffectBend.getPoints().get(i);
            this.writeInt(bendPoint.getPosition() * 60 / 12);
            this.writeInt(bendPoint.getValue() * 25 / 1);
            this.writeByte((byte)0);
        }
    }

    private void writeGrace(TGEffectGrace tGEffectGrace) throws IOException {
        if (tGEffectGrace.isDead()) {
            this.writeUnsignedByte(255);
        } else {
            this.writeUnsignedByte(tGEffectGrace.getFret());
        }
        this.writeUnsignedByte((tGEffectGrace.getDynamic() - 15) / 16 + 1);
        if (tGEffectGrace.getTransition() == 0) {
            this.writeUnsignedByte(0);
        } else if (tGEffectGrace.getTransition() == 1) {
            this.writeUnsignedByte(1);
        } else if (tGEffectGrace.getTransition() == 2) {
            this.writeUnsignedByte(2);
        } else if (tGEffectGrace.getTransition() == 3) {
            this.writeUnsignedByte(3);
        }
        this.writeUnsignedByte(tGEffectGrace.getDuration());
    }

    private void writeMixChange(TGTempo tGTempo) throws IOException {
        for (int i = 0; i < 7; ++i) {
            this.writeByte((byte)-1);
        }
        this.writeInt(tGTempo.getValue());
        this.writeByte((byte)0);
    }

    private void writeMarker(TGMarker tGMarker) throws IOException {
        this.writeStringByteSizeOfInteger(tGMarker.getTitle());
        this.writeColor(tGMarker.getColor());
    }

    private void writeColor(TGColor tGColor) throws IOException {
        this.writeUnsignedByte(tGColor.getR());
        this.writeUnsignedByte(tGColor.getG());
        this.writeUnsignedByte(tGColor.getB());
        this.writeByte((byte)0);
    }

    private TGChannel[] makeChannels(TGSong tGSong) {
        TGChannel[] tGChannelArray = new TGChannel[64];
        for (int i = 0; i < tGChannelArray.length; ++i) {
            tGChannelArray[i] = this.getFactory().newChannel();
            tGChannelArray[i].setChannel((short)i);
            tGChannelArray[i].setEffectChannel((short)i);
            tGChannelArray[i].setInstrument((short)24);
            tGChannelArray[i].setVolume((short)13);
            tGChannelArray[i].setBalance((short)8);
            tGChannelArray[i].setChorus((short)0);
            tGChannelArray[i].setReverb((short)0);
            tGChannelArray[i].setPhaser((short)0);
            tGChannelArray[i].setTremolo((short)0);
        }
        Iterator iterator = tGSong.getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            tGChannelArray[tGTrack.getChannel().getChannel()].setInstrument(tGTrack.getChannel().getInstrument());
            tGChannelArray[tGTrack.getChannel().getChannel()].setVolume(tGTrack.getChannel().getVolume());
            tGChannelArray[tGTrack.getChannel().getChannel()].setBalance(tGTrack.getChannel().getBalance());
            tGChannelArray[tGTrack.getChannel().getEffectChannel()].setInstrument(tGTrack.getChannel().getInstrument());
            tGChannelArray[tGTrack.getChannel().getEffectChannel()].setVolume(tGTrack.getChannel().getVolume());
            tGChannelArray[tGTrack.getChannel().getEffectChannel()].setBalance(tGTrack.getChannel().getBalance());
        }
        return tGChannelArray;
    }

    private int toStrokeValue(TGStroke tGStroke) {
        if (tGStroke.getValue() == 64) {
            return 2;
        }
        if (tGStroke.getValue() == 32) {
            return 3;
        }
        if (tGStroke.getValue() == 16) {
            return 4;
        }
        if (tGStroke.getValue() == 8) {
            return 5;
        }
        if (tGStroke.getValue() == 4) {
            return 6;
        }
        return 2;
    }

    private byte toChannelByte(short s) {
        return (byte)((s + 1) / 8);
    }
}

