/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.duration;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGTupleto;

public class ChangeTupletoDurationAction
extends Action {
    public static final String NAME = "action.note.duration.change-tupleto";

    public ChangeTupletoDurationAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
        boolean bl = false;
        if (typedEvent instanceof KeyEvent) {
            bl = true;
        }
        if (!bl) {
            TGTupleto tGTupleto = this.defaultTupleto();
            if (typedEvent.widget.getData() != null && typedEvent.widget.getData() instanceof TGTupleto) {
                tGTupleto = (TGTupleto)typedEvent.widget.getData();
            }
            if (this.getSelectedDuration().getTupleto().isEqual(tGTupleto)) {
                this.setTupleto(this.noTupleto());
            } else {
                this.setTupleto(tGTupleto);
            }
        } else if (this.getSelectedDuration().getTupleto().isEqual(TGTupleto.NORMAL)) {
            this.setTupleto(this.defaultTupleto());
        } else {
            this.setTupleto(this.noTupleto());
        }
        this.setDurations();
        this.addUndoableEdit(undoableMeasureGeneric.endUndo());
        return 0;
    }

    private TGTupleto noTupleto() {
        TGTupleto tGTupleto = this.getSongManager().getFactory().newTupleto();
        tGTupleto.setEnters(1);
        tGTupleto.setTimes(1);
        return tGTupleto;
    }

    private TGTupleto defaultTupleto() {
        TGTupleto tGTupleto = this.getSongManager().getFactory().newTupleto();
        tGTupleto.setEnters(3);
        tGTupleto.setTimes(2);
        return tGTupleto;
    }

    private void setTupleto(TGTupleto tGTupleto) {
        this.getSelectedDuration().getTupleto().setEnters(tGTupleto.getEnters());
        this.getSelectedDuration().getTupleto().setTimes(tGTupleto.getTimes());
    }

    private void setDurations() {
        Caret caret = this.getEditor().getTablature().getCaret();
        caret.changeDuration(this.getSelectedDuration().clone(this.getSongManager().getFactory()));
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasure().getNumber());
    }

    public TGDuration getSelectedDuration() {
        return this.getEditor().getTablature().getCaret().getDuration();
    }
}

