/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.File;
import java.net.URL;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.ActionLock;
import org.herac.tuxguitar.gui.actions.file.FileActionUtils;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.util.TGSynchronizer;

public class OpenFileAction
extends Action {
    public static final String NAME = "action.file.open";

    public OpenFileAction() {
        super(NAME, 13);
    }

    protected int execute(TypedEvent typedEvent) {
        TuxGuitar.instance().getPlayer().reset();
        final Object object = typedEvent.widget.getData();
        if (TuxGuitar.instance().getFileHistory().isUnsavedFile()) {
            ConfirmDialog confirmDialog = new ConfirmDialog(TuxGuitar.getProperty("file.save-changes-question"));
            confirmDialog.setDefaultStatus(ConfirmDialog.STATUS_CANCEL);
            int n = confirmDialog.confirm(ConfirmDialog.BUTTON_YES | ConfirmDialog.BUTTON_NO | ConfirmDialog.BUTTON_CANCEL, ConfirmDialog.BUTTON_YES);
            if (n == ConfirmDialog.STATUS_CANCEL) {
                return 2;
            }
            if (n == ConfirmDialog.STATUS_YES) {
                final String string = FileActionUtils.getFileName();
                if (string == null) {
                    return 2;
                }
                TuxGuitar.instance().loadCursor(1);
                new Thread(new Runnable(){

                    public void run() {
                        if (!TuxGuitar.isDisposed()) {
                            FileActionUtils.save(string);
                            new SyncThread(new Runnable(){

                                public void run() {
                                    if (!TuxGuitar.isDisposed()) {
                                        TuxGuitar.instance().loadCursor(0);
                                        OpenFileAction.this.openFile(object);
                                    }
                                }
                            }).start();
                        }
                    }
                }).start();
                return 0;
            }
        }
        this.openFile(object);
        return 0;
    }

    protected void openFile(Object object) {
        final URL uRL = this.getOpenFileName(object);
        if (uRL == null) {
            ActionLock.unlock();
            return;
        }
        TuxGuitar.instance().loadCursor(1);
        try {
            TGSynchronizer.instance().runLater(new TGSynchronizer.TGRunnable(){

                public void run() throws Throwable {
                    new Thread(new Runnable(){

                        public void run() {
                            if (!TuxGuitar.isDisposed()) {
                                FileActionUtils.open(uRL);
                                TuxGuitar.instance().loadCursor(0);
                                ActionLock.unlock();
                            }
                        }
                    }).start();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected URL getOpenFileName(Object object) {
        try {
            if (object instanceof URL) {
                TuxGuitar.instance().getFileHistory().setChooserPath((URL)object);
                return (URL)object;
            }
            String string = FileChooser.instance().open(TuxGuitar.instance().getShell(), TGFileFormatManager.instance().getInputFormats());
            if (string != null) {
                File file = new File(string);
                return file.toURI().toURL();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }
}

