/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.note;

import java.util.Iterator;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGBeatGroup;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.editors.tab.TGVoiceImpl;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.TGVoice;

public class SetVoiceAutoAction
extends Action {
    public static final String NAME = "action.beat.general.voice-auto";

    public SetVoiceAutoAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        Caret caret = this.getEditor().getTablature().getCaret();
        TGBeatImpl tGBeatImpl = caret.getSelectedBeat();
        if (tGBeatImpl != null) {
            TGVoiceImpl tGVoiceImpl = tGBeatImpl.getVoiceImpl(caret.getVoice());
            TGBeatGroup tGBeatGroup = tGVoiceImpl.getBeatGroup();
            if (!tGVoiceImpl.isEmpty() && !tGVoiceImpl.isRestVoice() && tGBeatGroup != null) {
                UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
                Iterator iterator = tGBeatGroup.getVoices().iterator();
                while (iterator.hasNext()) {
                    TGVoice tGVoice = (TGVoice)iterator.next();
                    this.getSongManager().getMeasureManager().changeVoiceDirection(tGVoice, 0);
                }
                this.addUndoableEdit(undoableMeasureGeneric.endUndo());
                TuxGuitar.instance().getFileHistory().setUnsavedFile();
                this.updateTablature();
            }
        }
        return 0;
    }

    public void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasure().getNumber());
    }
}

