/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.note;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.TGNote;

public class ShiftNoteDownAction
extends Action {
    public static final String NAME = "action.note.general.shift-down";

    public ShiftNoteDownAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        TGNote tGNote = this.getEditor().getTablature().getCaret().getSelectedNote();
        if (tGNote != null) {
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            int n = this.getSongManager().getMeasureManager().shiftNoteDown(this.getEditor().getTablature().getCaret().getMeasure(), tGNote.getVoice().getBeat().getStart(), tGNote.getString());
            if (n > 0) {
                this.getEditor().getTablature().getCaret().setStringNumber(n);
                this.addUndoableEdit(undoableMeasureGeneric.endUndo());
                TuxGuitar.instance().getFileHistory().setUnsavedFile();
            }
            this.updateTablature();
        }
        return 0;
    }

    public void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasure().getNumber());
    }
}

