/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.track;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableRemoveTrack;

public class RemoveTrackAction
extends Action {
    public static final String NAME = "action.track.remove";

    public RemoveTrackAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        Caret caret = this.getEditor().getTablature().getCaret();
        if (this.getSongManager().getSong().countTracks() <= 1) {
            TuxGuitar.instance().newSong();
            return 0;
        }
        UndoableRemoveTrack undoableRemoveTrack = UndoableRemoveTrack.startUndo();
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        TGTrackImpl tGTrackImpl = caret.getTrack();
        TGTrackImpl tGTrackImpl2 = (TGTrackImpl)this.getSongManager().getTrack(tGTrackImpl.getNumber() + 1);
        if (tGTrackImpl2 == null) {
            tGTrackImpl2 = (TGTrackImpl)this.getSongManager().getTrack(tGTrackImpl.getNumber() - 1);
        }
        this.getSongManager().removeTrack(tGTrackImpl);
        this.updateTablature();
        if (tGTrackImpl2 != null) {
            caret.update(tGTrackImpl2.getNumber(), this.getSongManager().getTrackManager().getMeasureAt(tGTrackImpl2, caret.getMeasure().getStart()).getStart(), 1);
        }
        TuxGuitar.instance().getMixer().update();
        this.addUndoableEdit(undoableRemoveTrack.endUndo());
        return 0;
    }
}

