/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.track;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.ActionLock;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableJoined;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableTrackGeneric;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableTrackInfo;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableTrackInstrument;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.TGMusicKeyUtils;
import org.herac.tuxguitar.player.base.MidiInstrument;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TrackPropertiesAction
extends Action {
    public static final String NAME = "action.track.properties";
    private static final String[] NOTE_NAMES = TGMusicKeyUtils.getSharpKeyNames("tuning");
    private static final int MINIMUN_LEFT_CONTROLS_WIDTH = 180;
    private static final int MINIMUN_BUTTON_WIDTH = 80;
    private static final int MINIMUN_BUTTON_HEIGHT = 25;
    private static final int MAX_STRINGS = 7;
    private static final int MIN_STRINGS = 4;
    private static final int MAX_OCTAVES = 10;
    private static final int MAX_NOTES = 12;
    protected Shell dialog;
    protected Text nameText;
    protected TGColor trackColor;
    protected List tempStrings;
    protected Spinner stringCountSpinner;
    protected Combo[] stringCombos = new Combo[7];
    protected Combo offsetCombo;
    protected int stringCount;
    protected Combo instrumentCombo;
    protected Button percussionCheckBox;
    protected Color colorButtonValue;

    public TrackPropertiesAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return 0;
    }

    public void showDialog(Shell shell) {
        TGTrackImpl tGTrackImpl = this.getEditor().getTablature().getCaret().getTrack();
        if (tGTrackImpl != null) {
            this.stringCount = tGTrackImpl.getStrings().size();
            this.trackColor = tGTrackImpl.getColor().clone(this.getSongManager().getFactory());
            this.initTempStrings(tGTrackImpl.getStrings());
            this.dialog = DialogUtils.newDialog(shell, 67680);
            this.dialog.setLayout((Layout)new GridLayout(2, false));
            this.dialog.setText(TuxGuitar.getProperty("track.properties"));
            Composite composite = new Composite((Composite)this.dialog, 0);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite composite2 = new Composite((Composite)this.dialog, 0);
            composite2.setLayout((Layout)new GridLayout());
            composite2.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite composite3 = new Composite((Composite)this.dialog, 0);
            composite3.setLayout((Layout)new GridLayout(2, false));
            composite3.setLayoutData((Object)new GridData(0x1000008, 4, true, true, 2, 1));
            this.initTrackInfo((Composite)this.makeGroup(composite, 1, TuxGuitar.getProperty("track.properties.general")), tGTrackImpl);
            this.initInstrumentFields((Composite)this.makeGroup(composite, 1, TuxGuitar.getProperty("instrument.instrument")), tGTrackImpl);
            this.initTuningInfo((Composite)this.makeGroup(composite2, 2, TuxGuitar.getProperty("tuning")), tGTrackImpl);
            this.initButtons(composite3);
            this.updateTuningGroup(!tGTrackImpl.isPercussionTrack());
            DialogUtils.openDialog(this.dialog, 11);
        }
    }

    private Group makeGroup(Composite composite, int n, String string) {
        Group group = new Group(composite, 16);
        group.setLayoutData((Object)this.makeGridData(n));
        group.setText(string);
        return group;
    }

    private GridData makeGridData(int n) {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = n;
        return gridData;
    }

    public GridData getButtonsData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    private void initTrackInfo(Composite composite, TGTrackImpl tGTrackImpl) {
        composite.setLayout((Layout)new GridLayout());
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 128, true, true));
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout((Layout)new GridLayout());
        composite3.setLayoutData((Object)new GridData(4, 1024, true, true));
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        label.setText(TuxGuitar.getProperty("track.name") + ":");
        this.nameText = new Text(composite2, 2048);
        this.nameText.setLayoutData((Object)this.getAlignmentData(180, 4));
        this.nameText.setText(tGTrackImpl.getName());
        Label label2 = new Label(composite3, 0);
        label2.setText(TuxGuitar.getProperty("track.color") + ":");
        label2.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        final Button button = new Button(composite3, 8);
        button.setLayoutData((Object)this.getAlignmentData(180, 4));
        button.setText(TuxGuitar.getProperty("choose"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorDialog colorDialog = new ColorDialog(TrackPropertiesAction.this.dialog);
                colorDialog.setRGB(TrackPropertiesAction.this.dialog.getDisplay().getSystemColor(2).getRGB());
                colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    TrackPropertiesAction.this.trackColor.setR(rGB.red);
                    TrackPropertiesAction.this.trackColor.setG(rGB.green);
                    TrackPropertiesAction.this.trackColor.setB(rGB.blue);
                    TrackPropertiesAction.this.setButtonColor(button);
                }
            }
        });
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                TrackPropertiesAction.this.disposeButtonColor();
            }
        });
        this.setButtonColor(button);
    }

    private void initTuningInfo(Composite composite, TGTrackImpl tGTrackImpl) {
        composite.setLayout((Layout)new GridLayout(2, true));
        this.initTuningData(composite, tGTrackImpl);
        this.initTuningCombos(composite);
    }

    private void initTuningCombos(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(131072, 4, true, true));
        String[] stringArray = this.getAllValueNames();
        for (int i = 0; i < 7; ++i) {
            this.stringCombos[i] = new Combo(composite2, 12);
            this.stringCombos[i].setItems(stringArray);
        }
    }

    private void initTuningData(Composite composite, TGTrackImpl tGTrackImpl) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 128, true, true));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout());
        composite3.setLayoutData((Object)new GridData(4, 128, true, true));
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayout((Layout)new GridLayout());
        composite4.setLayoutData((Object)new GridData(4, 1024, true, true));
        Label label = new Label(composite3, 0);
        label.setText(TuxGuitar.getProperty("tuning.strings") + ":");
        label.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        this.stringCountSpinner = new Spinner(composite3, 2048);
        this.stringCountSpinner.setLayoutData((Object)this.getAlignmentData(80, 4));
        this.stringCountSpinner.setMinimum(4);
        this.stringCountSpinner.setMaximum(7);
        this.stringCountSpinner.setSelection(this.stringCount);
        this.stringCountSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TrackPropertiesAction.this.stringCount = TrackPropertiesAction.this.stringCountSpinner.getSelection();
                TrackPropertiesAction.this.setDefaultTuning();
                TrackPropertiesAction.this.updateTuningGroup(!TrackPropertiesAction.this.percussionCheckBox.getSelection());
            }
        });
        Label label2 = new Label(composite4, 0);
        label2.setText(TuxGuitar.getProperty("tuning.offset") + ":");
        label2.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        this.offsetCombo = new Combo(composite4, 12);
        this.offsetCombo.setLayoutData((Object)this.getAlignmentData(80, 16384));
        for (int i = -24; i <= 24; ++i) {
            this.offsetCombo.add(Integer.toString(i));
            if (i != tGTrackImpl.getOffset()) continue;
            this.offsetCombo.select(i - -24);
        }
    }

    private GridData getAlignmentData(int n, int n2) {
        GridData gridData = new GridData();
        gridData.minimumWidth = n;
        gridData.horizontalAlignment = n2;
        gridData.verticalAlignment = -1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        return gridData;
    }

    private void initButtons(Composite composite) {
        Button button = new Button(composite, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.setLayoutData((Object)this.getButtonsData());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TrackPropertiesAction.this.updateTrackProperties();
                TrackPropertiesAction.this.dialog.dispose();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(TuxGuitar.getProperty("cancel"));
        button2.setLayoutData((Object)this.getButtonsData());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TrackPropertiesAction.this.dialog.dispose();
            }
        });
        this.dialog.setDefaultButton(button);
    }

    private void initInstrumentFields(Composite composite, TGTrackImpl tGTrackImpl) {
        composite.setLayout((Layout)new GridLayout());
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 128, true, true));
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout((Layout)new GridLayout());
        composite3.setLayoutData((Object)new GridData(4, 1024, true, true));
        Label label = new Label(composite2, 0);
        label.setText(TuxGuitar.getProperty("instrument.instrument") + ":");
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.instrumentCombo = new Combo(composite2, 12);
        this.instrumentCombo.setLayoutData((Object)this.getAlignmentData(180, 4));
        MidiInstrument[] midiInstrumentArray = TuxGuitar.instance().getPlayer().getInstruments();
        if (midiInstrumentArray != null) {
            int n = midiInstrumentArray.length;
            if (n > 128) {
                n = 128;
            }
            for (int i = 0; i < n; ++i) {
                this.instrumentCombo.add(midiInstrumentArray[i].getName());
            }
            this.instrumentCombo.select((int)tGTrackImpl.getChannel().getInstrument());
        }
        this.instrumentCombo.setEnabled(!tGTrackImpl.isPercussionTrack() && midiInstrumentArray != null);
        this.percussionCheckBox = new Button(composite3, 32);
        this.percussionCheckBox.setText(TuxGuitar.getProperty("instrument.percussion-track"));
        this.percussionCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        if (midiInstrumentArray != null) {
            this.percussionCheckBox.setSelection(tGTrackImpl.isPercussionTrack());
            this.percussionCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TrackPropertiesAction.this.instrumentCombo.setEnabled(!TrackPropertiesAction.this.percussionCheckBox.getSelection());
                    TrackPropertiesAction.this.setDefaultTuning();
                    TrackPropertiesAction.this.updateTuningGroup(!TrackPropertiesAction.this.percussionCheckBox.getSelection());
                }
            });
        } else {
            this.percussionCheckBox.setEnabled(false);
        }
    }

    protected void updateTrackProperties() {
        int n;
        final TGTrackImpl tGTrackImpl = this.getEditor().getTablature().getCaret().getTrack();
        final String string = this.nameText.getText();
        final ArrayList<TGString> arrayList = new ArrayList<TGString>();
        for (n = 0; n < this.stringCount; ++n) {
            arrayList.add(TGSongManager.newString(this.getSongManager().getFactory(), n + 1, this.stringCombos[n].getSelectionIndex()));
        }
        n = this.percussionCheckBox.getSelection() ? 1 : 0;
        final int n2 = n != 0 ? 0 : -24 + this.offsetCombo.getSelectionIndex();
        final int n3 = this.instrumentCombo.getSelectionIndex() >= 0 ? this.instrumentCombo.getSelectionIndex() : 0;
        final TGColor tGColor = this.trackColor;
        final boolean bl = this.hasInfoChanges(tGTrackImpl, string, tGColor, n2);
        final boolean bl2 = this.hasTuningChanges(tGTrackImpl, arrayList);
        final boolean bl3 = this.hasInstrumentChanges(tGTrackImpl, n3, n != 0);
        try {
            if (bl || bl2 || bl3) {
                ActionLock.lock();
                TGSynchronizer.instance().runLater(new TGSynchronizer.TGRunnable(n != 0){
                    private final /* synthetic */ boolean val$percussion;
                    {
                        this.val$percussion = bl4;
                    }

                    public void run() throws Throwable {
                        TuxGuitar.instance().loadCursor(1);
                        new Thread(new Runnable(){

                            public void run() {
                                UndoableEdit undoableEdit;
                                TuxGuitar.instance().getFileHistory().setUnsavedFile();
                                UndoableJoined undoableJoined = new UndoableJoined();
                                UndoableTrackGeneric undoableTrackGeneric = null;
                                if (bl2) {
                                    undoableTrackGeneric = UndoableTrackGeneric.startUndo(tGTrackImpl);
                                }
                                if (bl) {
                                    undoableEdit = null;
                                    if (!bl2) {
                                        undoableEdit = UndoableTrackInfo.startUndo(tGTrackImpl);
                                    }
                                    TrackPropertiesAction.this.getSongManager().getTrackManager().changeInfo(tGTrackImpl, string, tGColor, n2);
                                    if (!bl2 && undoableEdit != null) {
                                        undoableJoined.addUndoableEdit(((UndoableTrackInfo)undoableEdit).endUndo(tGTrackImpl));
                                    }
                                }
                                if (bl2) {
                                    TrackPropertiesAction.this.getSongManager().getTrackManager().changeInstrumentStrings(tGTrackImpl, arrayList);
                                }
                                if (bl3) {
                                    undoableEdit = null;
                                    if (!bl2) {
                                        undoableEdit = UndoableTrackInstrument.startUndo(tGTrackImpl);
                                    }
                                    TrackPropertiesAction.this.getSongManager().getTrackManager().changeInstrument(tGTrackImpl, n3, val$percussion);
                                    if (!bl2 && undoableEdit != null) {
                                        undoableJoined.addUndoableEdit(((UndoableTrackInstrument)undoableEdit).endUndo(tGTrackImpl));
                                    }
                                }
                                if (bl2 && undoableTrackGeneric != null) {
                                    undoableJoined.addUndoableEdit(undoableTrackGeneric.endUndo(tGTrackImpl));
                                }
                                TrackPropertiesAction.this.addUndoableEdit(undoableJoined.endUndo());
                                new SyncThread(new Runnable(){

                                    public void run() {
                                        if (!TuxGuitar.isDisposed()) {
                                            TrackPropertiesAction.this.updateTablature();
                                            TuxGuitar.instance().getMixer().updateValues();
                                            TuxGuitar.instance().updateCache(true);
                                            TuxGuitar.instance().loadCursor(0);
                                            ActionLock.unlock();
                                        }
                                    }
                                }).start();
                            }
                        }).start();
                    }
                });
            }
        }
        catch (Throwable throwable) {
            TuxGuitar.instance().loadCursor(0);
            ActionLock.unlock();
            throwable.printStackTrace();
        }
    }

    protected boolean hasInfoChanges(TGTrackImpl tGTrackImpl, String string, TGColor tGColor, int n) {
        if (!string.equals(tGTrackImpl.getName())) {
            return true;
        }
        if (!tGColor.isEqual(tGTrackImpl.getColor())) {
            return true;
        }
        return n != tGTrackImpl.getOffset();
    }

    protected boolean hasTuningChanges(TGTrackImpl tGTrackImpl, List list) {
        List list2 = tGTrackImpl.getStrings();
        if (list2.size() != list.size()) {
            return true;
        }
        for (int i = 0; i < list2.size(); ++i) {
            TGString tGString = (TGString)list2.get(i);
            boolean bl = false;
            for (int j = 0; j < list.size(); ++j) {
                TGString tGString2 = (TGString)list.get(j);
                if (!tGString2.isEqual(tGString)) continue;
                bl = true;
            }
            if (bl) continue;
            return true;
        }
        return false;
    }

    protected boolean hasInstrumentChanges(TGTrackImpl tGTrackImpl, int n, boolean bl) {
        return tGTrackImpl.getChannel().getInstrument() != n || tGTrackImpl.isPercussionTrack() != bl;
    }

    protected void setButtonColor(Button button) {
        Color color = new Color((Device)this.dialog.getDisplay(), this.trackColor.getR(), this.trackColor.getG(), this.trackColor.getB());
        button.setForeground(color);
        this.disposeButtonColor();
        this.colorButtonValue = color;
    }

    protected void disposeButtonColor() {
        if (this.colorButtonValue != null && !this.colorButtonValue.isDisposed()) {
            this.colorButtonValue.dispose();
            this.colorButtonValue = null;
        }
    }

    protected void updateTuningGroup(boolean bl) {
        int n;
        for (n = 0; n < this.tempStrings.size(); ++n) {
            TGString tGString = (TGString)this.tempStrings.get(n);
            this.stringCombos[n].select(tGString.getValue());
            this.stringCombos[n].setVisible(true);
            this.stringCombos[n].setEnabled(bl);
        }
        for (n = this.tempStrings.size(); n < 7; ++n) {
            this.stringCombos[n].select(0);
            this.stringCombos[n].setVisible(false);
        }
        this.offsetCombo.setEnabled(bl);
    }

    protected void initTempStrings(List list) {
        this.tempStrings = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            TGString tGString = (TGString)list.get(i);
            this.tempStrings.add(tGString.clone(this.getSongManager().getFactory()));
        }
    }

    protected void setDefaultTuning() {
        this.tempStrings.clear();
        if (this.percussionCheckBox.getSelection()) {
            for (int i = 1; i <= this.stringCount; ++i) {
                this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), i, 0));
            }
        } else {
            switch (this.stringCount) {
                case 7: {
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 1, 64));
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 2, 59));
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 3, 55));
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 4, 50));
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 5, 45));
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 6, 40));
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 7, 35));
                    break;
                }
                case 6: {
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 1, 64));
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 2, 59));
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 3, 55));
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 4, 50));
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 5, 45));
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 6, 40));
                    break;
                }
                case 5: {
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 1, 43));
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 2, 38));
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 3, 33));
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 4, 28));
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 5, 23));
                    break;
                }
                case 4: {
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 1, 43));
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 2, 38));
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 3, 33));
                    this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), 4, 28));
                    break;
                }
                default: {
                    for (int i = 1; i <= this.stringCount; ++i) {
                        this.tempStrings.add(TGSongManager.newString(this.getSongManager().getFactory(), i, 0));
                    }
                    break;
                }
            }
        }
    }

    protected String[] getAllValueNames() {
        String[] stringArray = new String[120];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = NOTE_NAMES[i - i / 12 * 12] + i / 12;
        }
        return stringArray;
    }
}

