/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGExternalBeatViewerListener;
import org.herac.tuxguitar.gui.editors.TGRedrawListener;
import org.herac.tuxguitar.gui.editors.piano.Piano;
import org.herac.tuxguitar.gui.system.icons.IconLoader;
import org.herac.tuxguitar.gui.system.language.LanguageLoader;
import org.herac.tuxguitar.gui.tools.scale.ScaleListener;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.models.TGBeat;

public class PianoEditor
implements TGRedrawListener,
TGExternalBeatViewerListener,
IconLoader,
LanguageLoader,
ScaleListener {
    private Piano piano;

    public void show() {
        Shell shell = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 2144);
        shell.setLayout((Layout)new GridLayout());
        shell.setText(TuxGuitar.getProperty("piano.editor"));
        this.piano = new Piano((Composite)shell, 0);
        this.addListeners();
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                PianoEditor.this.removeListeners();
                TuxGuitar.instance().updateCache(true);
            }
        });
        DialogUtils.openDialog(shell, 10);
    }

    public void addListeners() {
        TuxGuitar.instance().getIconManager().addLoader(this);
        TuxGuitar.instance().getLanguageManager().addLoader(this);
        TuxGuitar.instance().getScaleManager().addListener(this);
        TuxGuitar.instance().getEditorManager().addRedrawListener(this);
        TuxGuitar.instance().getEditorManager().addBeatViewerListener(this);
    }

    public void removeListeners() {
        TuxGuitar.instance().getIconManager().removeLoader(this);
        TuxGuitar.instance().getLanguageManager().removeLoader(this);
        TuxGuitar.instance().getScaleManager().removeListener(this);
        TuxGuitar.instance().getEditorManager().removeRedrawListener(this);
        TuxGuitar.instance().getEditorManager().removeBeatViewerListener(this);
    }

    private Piano getPiano() {
        return this.piano;
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.getPiano().getShell().dispose();
            this.getPiano().dispose();
        }
    }

    public void redraw() {
        if (!this.isDisposed() && !TuxGuitar.instance().isLocked()) {
            this.getPiano().redraw();
        }
    }

    public void redrawPlayingMode() {
        if (!this.isDisposed() && !TuxGuitar.instance().isLocked()) {
            this.getPiano().redrawPlayingMode();
        }
    }

    public boolean isDisposed() {
        return this.getPiano() == null || this.getPiano().isDisposed();
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.getPiano().loadProperties();
            this.getPiano().getShell().setText(TuxGuitar.getProperty("piano.editor"));
        }
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.getPiano().loadIcons();
        }
    }

    public void loadScale() {
        if (!this.isDisposed()) {
            this.getPiano().loadScale();
        }
    }

    public void doRedraw(int n) {
        if (n == 1) {
            this.redraw();
        } else if (n == 3) {
            this.redrawPlayingMode();
        }
    }

    public void showExternalBeat(TGBeat tGBeat) {
        if (!this.isDisposed()) {
            this.getPiano().setExternalBeat(tGBeat);
        }
    }

    public void hideExternalBeat() {
        if (!this.isDisposed()) {
            this.getPiano().setExternalBeat(null);
        }
    }
}

