/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.fretboard;

import java.util.Properties;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.config.TGConfigManager;
import org.herac.tuxguitar.gui.util.DialogUtils;

public class FretBoardConfig {
    public static final int DISPLAY_TEXT_NOTE = 1;
    public static final int DISPLAY_TEXT_SCALE = 2;
    private int style;
    private Font font;
    private Color colorBackground;
    private Color colorString;
    private Color colorFretPoint;
    private Color colorNote;
    private Color colorScale;
    private static final int MINIMUN_CONTROL_WIDTH = 180;
    private static final int MINIMUN_BUTTON_WIDTH = 80;
    private static final int MINIMUN_BUTTON_HEIGHT = 25;

    public int getStyle() {
        return this.style;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getColorBackground() {
        return this.colorBackground;
    }

    public Color getColorString() {
        return this.colorString;
    }

    public Color getColorFretPoint() {
        return this.colorFretPoint;
    }

    public Color getColorNote() {
        return this.colorNote;
    }

    public Color getColorScale() {
        return this.colorScale;
    }

    public void load() {
        Display display = TuxGuitar.instance().getDisplay();
        TGConfigManager tGConfigManager = TuxGuitar.instance().getConfig();
        this.style = tGConfigManager.getIntConfigValue("fretboard.style");
        this.font = new Font((Device)display, tGConfigManager.getFontDataConfigValue("fretboard.font"));
        this.colorBackground = new Color((Device)display, tGConfigManager.getRGBConfigValue("fretboard.color.background"));
        this.colorString = new Color((Device)display, tGConfigManager.getRGBConfigValue("fretboard.color.string"));
        this.colorFretPoint = new Color((Device)display, tGConfigManager.getRGBConfigValue("fretboard.color.fret-point"));
        this.colorNote = new Color((Device)display, tGConfigManager.getRGBConfigValue("fretboard.color.note"));
        this.colorScale = new Color((Device)display, tGConfigManager.getRGBConfigValue("fretboard.color.scale"));
    }

    public void defaults() {
        TGConfigManager tGConfigManager = TuxGuitar.instance().getConfig();
        Properties properties = tGConfigManager.getDefaults();
        tGConfigManager.setProperty("fretboard.style", properties.getProperty("fretboard.style"));
        tGConfigManager.setProperty("fretboard.font", properties.getProperty("fretboard.font"));
        tGConfigManager.setProperty("fretboard.color.background", properties.getProperty("fretboard.color.background"));
        tGConfigManager.setProperty("fretboard.color.string", properties.getProperty("fretboard.color.string"));
        tGConfigManager.setProperty("fretboard.color.fret-point", properties.getProperty("fretboard.color.fret-point"));
        tGConfigManager.setProperty("fretboard.color.note", properties.getProperty("fretboard.color.note"));
        tGConfigManager.setProperty("fretboard.color.scale", properties.getProperty("fretboard.color.scale"));
    }

    public void save(int n, FontData fontData, RGB rGB, RGB rGB2, RGB rGB3, RGB rGB4, RGB rGB5) {
        TGConfigManager tGConfigManager = TuxGuitar.instance().getConfig();
        tGConfigManager.setProperty("fretboard.style", n);
        tGConfigManager.setProperty("fretboard.font", fontData);
        tGConfigManager.setProperty("fretboard.color.background", rGB);
        tGConfigManager.setProperty("fretboard.color.string", rGB2);
        tGConfigManager.setProperty("fretboard.color.fret-point", rGB3);
        tGConfigManager.setProperty("fretboard.color.note", rGB4);
        tGConfigManager.setProperty("fretboard.color.scale", rGB5);
    }

    public void dispose() {
        this.font.dispose();
        this.colorBackground.dispose();
        this.colorString.dispose();
        this.colorFretPoint.dispose();
        this.colorNote.dispose();
        this.colorScale.dispose();
    }

    public void configure(Shell shell) {
        final Shell shell2 = DialogUtils.newDialog(shell, 67680);
        shell2.setLayout((Layout)new GridLayout());
        shell2.setText(TuxGuitar.getProperty("fretboard.settings"));
        Group group = new Group((Composite)shell2, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("fretboard.settings"));
        final FontData fontData = this.getFontChooser((Composite)group, TuxGuitar.getProperty("fretboard.font"), this.font.getFontData()[0]);
        final RGB rGB = this.getColorChooser((Composite)group, TuxGuitar.getProperty("fretboard.background-color"), this.colorBackground.getRGB());
        final RGB rGB2 = this.getColorChooser((Composite)group, TuxGuitar.getProperty("fretboard.string-color"), this.colorString.getRGB());
        final RGB rGB3 = this.getColorChooser((Composite)group, TuxGuitar.getProperty("fretboard.fretpoint-color"), this.colorFretPoint.getRGB());
        final RGB rGB4 = this.getColorChooser((Composite)group, TuxGuitar.getProperty("fretboard.note-color"), this.colorNote.getRGB());
        final RGB rGB5 = this.getColorChooser((Composite)group, TuxGuitar.getProperty("fretboard.scale-note-color"), this.colorScale.getRGB());
        group = new Group((Composite)shell2, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("fretboard.settings.options"));
        final Button button = new Button((Composite)group, 32);
        button.setLayoutData((Object)new GridData(4, 4, true, true));
        button.setText(TuxGuitar.getProperty("fretboard.display-note-text"));
        button.setSelection((this.style & 1) != 0);
        final Button button2 = new Button((Composite)group, 32);
        button2.setLayoutData((Object)new GridData(4, 4, true, true));
        button2.setText(TuxGuitar.getProperty("fretboard.display-scale-text"));
        button2.setSelection((this.style & 2) != 0);
        Composite composite = new Composite((Composite)shell2, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button button3 = new Button(composite, 8);
        button3.setText(TuxGuitar.getProperty("defaults"));
        button3.setLayoutData((Object)this.getButtonData());
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
                FretBoardConfig.this.defaults();
                FretBoardConfig.this.applyChanges();
            }
        });
        Button button4 = new Button(composite, 8);
        button4.setText(TuxGuitar.getProperty("ok"));
        button4.setLayoutData((Object)this.getButtonData());
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = 0;
                n |= button.getSelection() ? 1 : 0;
                int n2 = button2.getSelection() ? 2 : 0;
                shell2.dispose();
                FretBoardConfig.this.save(n |= n2, fontData, rGB, rGB2, rGB3, rGB4, rGB5);
                FretBoardConfig.this.applyChanges();
            }
        });
        Button button5 = new Button(composite, 8);
        button5.setText(TuxGuitar.getProperty("cancel"));
        button5.setLayoutData((Object)this.getButtonData());
        button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button4);
        DialogUtils.openDialog(shell2, 11);
    }

    protected GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected void applyChanges() {
        this.dispose();
        this.load();
    }

    private RGB getColorChooser(Composite composite, String string, RGB rGB) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        label.setText(string);
        ButtonColor buttonColor = new ButtonColor(composite, 8, TuxGuitar.getProperty("choose"));
        buttonColor.setLayoutData(this.getAlignmentData(180, 4));
        buttonColor.loadColor(rGB);
        return buttonColor.getValue();
    }

    private FontData getFontChooser(final Composite composite, String string, FontData fontData) {
        final FontData fontData2 = new FontData(fontData.getName(), fontData.getHeight(), fontData.getStyle());
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        label.setText(string);
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)this.getAlignmentData(180, 4));
        button.setText(TuxGuitar.getProperty("choose"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Font font = new Font((Device)composite.getDisplay(), fontData2);
                FontDialog fontDialog = new FontDialog(composite.getShell());
                fontDialog.setFontList(font.getFontData());
                FontData fontData = fontDialog.open();
                if (fontData != null) {
                    fontData2.setName(fontData.getName());
                    fontData2.setHeight(fontData.getHeight());
                    fontData2.setStyle(fontData.getStyle());
                }
                font.dispose();
            }
        });
        return fontData2;
    }

    private GridData getAlignmentData(int n, int n2) {
        GridData gridData = new GridData();
        gridData.minimumWidth = n;
        gridData.horizontalAlignment = n2;
        gridData.verticalAlignment = -1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        return gridData;
    }

    private class ButtonColor {
        protected Button button;
        protected Color color;
        protected RGB value = new RGB(0, 0, 0);

        public ButtonColor(Composite composite, int n, String string) {
            this.button = new Button(composite, n);
            this.button.setText(string);
            this.addListeners();
        }

        protected void setLayoutData(Object object) {
            this.button.setLayoutData(object);
        }

        protected void loadColor(RGB rGB) {
            this.value.red = rGB.red;
            this.value.green = rGB.green;
            this.value.blue = rGB.blue;
            Color color = new Color((Device)this.button.getDisplay(), this.value);
            this.button.setForeground(color);
            this.disposeColor();
            this.color = color;
        }

        protected void disposeColor() {
            if (this.color != null && !this.color.isDisposed()) {
                this.color.dispose();
                this.color = null;
            }
        }

        private void addListeners() {
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ColorDialog colorDialog = new ColorDialog(ButtonColor.this.button.getShell());
                    colorDialog.setRGB(ButtonColor.this.value);
                    colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                    RGB rGB = colorDialog.open();
                    if (rGB != null) {
                        ButtonColor.this.loadColor(rGB);
                    }
                }
            });
            this.button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    ButtonColor.this.disposeColor();
                }
            });
        }

        protected RGB getValue() {
            return this.value;
        }
    }
}

