/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.lyric;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGUpdateListener;
import org.herac.tuxguitar.gui.editors.lyric.LyricModifyListener;
import org.herac.tuxguitar.gui.system.icons.IconLoader;
import org.herac.tuxguitar.gui.system.keybindings.KeyBinding;
import org.herac.tuxguitar.gui.system.keybindings.KeyBindingAction;
import org.herac.tuxguitar.gui.system.language.LanguageLoader;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.models.TGTrack;

public class LyricEditor
implements TGUpdateListener,
IconLoader,
LanguageLoader {
    private static int EDITOR_WIDTH = 450;
    private static int EDITOR_HEIGHT = 200;
    protected static final KeyBindingAction[] KB_ACTIONS = new KeyBindingAction[]{new KeyBindingAction("action.edit.undo", new KeyBinding(122, 262144)), new KeyBindingAction("action.edit.redo", new KeyBinding(121, 262144))};
    private TGTrack track;
    private Shell dialog;
    private LyricModifyListener listener = new LyricModifyListener(this);
    private Button previous;
    private Button next;
    private Label label;
    private Label fromLabel;
    private Spinner from;
    private Text text;
    private int caretPosition;
    private boolean updated;
    private int lastTrack;
    private int lastMeasuseCount;
    private String lastTrackName;

    public void show() {
        this.dialog = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 2160);
        this.dialog.setLayout((Layout)this.getDialogLayout());
        this.dialog.setSize(EDITOR_WIDTH, EDITOR_HEIGHT);
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                LyricEditor.this.onDispose();
            }
        });
        this.track = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getTrack();
        this.loadComposites();
        this.loadProperties();
        this.loadIcons();
        this.updateItems();
        this.addListeners();
        DialogUtils.openDialog(this.dialog, 8);
    }

    public void addListeners() {
        TuxGuitar.instance().getIconManager().addLoader(this);
        TuxGuitar.instance().getLanguageManager().addLoader(this);
        TuxGuitar.instance().getEditorManager().addUpdateListener(this);
    }

    public void removeListeners() {
        TuxGuitar.instance().getIconManager().removeLoader(this);
        TuxGuitar.instance().getLanguageManager().removeLoader(this);
        TuxGuitar.instance().getEditorManager().removeUpdateListener(this);
    }

    public void onDispose() {
        this.track = null;
        this.label = null;
        this.text = null;
        this.dialog = null;
        this.removeListeners();
        TuxGuitar.instance().updateCache(true);
    }

    private GridLayout getDialogLayout() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        return gridLayout;
    }

    private void loadComposites() {
        this.loadToolBar((Composite)this.dialog);
        this.loadLyricText((Composite)this.dialog);
    }

    private void loadToolBar(Composite composite) {
        final Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(5, false));
        composite2.setLayoutData((Object)new GridData(4, 128, true, false));
        this.previous = new Button(composite2, 16388);
        this.next = new Button(composite2, 131076);
        this.label = new Label(composite2, 0);
        this.label.setText(this.track.getName());
        this.label.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fromLabel = new Label(composite2, 0);
        this.fromLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        this.from = new Spinner(composite2, 2048);
        this.from.setLayoutData((Object)new GridData(50, -1));
        this.from.setMinimum(1);
        this.from.setMaximum(this.track.countMeasures());
        this.from.setSelection(this.track.getLyrics().getFrom());
        this.from.setEnabled(this.track.countMeasures() > 1);
        this.from.addModifyListener((ModifyListener)this.listener);
        this.previous.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getAction("action.track.go-previous").process((TypedEvent)selectionEvent);
                composite2.layout();
            }
        });
        this.next.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getAction("action.track.go-next").process((TypedEvent)selectionEvent);
                composite2.layout();
            }
        });
    }

    private void loadLyricText(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text = new Text(composite2, 2626);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text.setFocus();
        this.text.setText(this.track.getLyrics().getLyrics());
        this.text.addModifyListener((ModifyListener)this.listener);
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                for (int i = 0; i < KB_ACTIONS.length; ++i) {
                    if (keyEvent.keyCode != KB_ACTIONS[i].getKeyBinding().getKey() || keyEvent.stateMask != KB_ACTIONS[i].getKeyBinding().getMask()) continue;
                    TuxGuitar.instance().getAction(KB_ACTIONS[i].getAction()).process((TypedEvent)keyEvent);
                    return;
                }
            }
        });
    }

    public void updateItems() {
        if (!this.isDisposed()) {
            boolean bl = !TuxGuitar.instance().getPlayer().isRunning();
            this.listener.setEnabled(false);
            if (this.updated) {
                this.lastTrack = 0;
                this.lastTrackName = null;
                this.lastMeasuseCount = 0;
            }
            this.track = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getTrack();
            if (this.isTrackNameChanged()) {
                this.label.setText(this.track.getName());
            }
            if (this.isMeasureCountChanged()) {
                this.from.setMaximum(this.track.countMeasures());
            }
            if (this.isTrackChanged()) {
                this.from.setSelection(this.track.getLyrics().getFrom());
                this.text.setText(this.track.getLyrics().getLyrics());
                this.text.setSelection(this.caretPosition >= 0 ? this.caretPosition : this.text.getCharCount());
            }
            this.from.setEnabled(bl && this.track.countMeasures() > 1);
            this.text.setEnabled(bl);
            this.setCaretPosition(-1);
            this.listener.setEnabled(bl);
            this.updated = false;
        }
    }

    private boolean isTrackChanged() {
        int n = this.track.getNumber();
        if (n != this.lastTrack) {
            this.lastTrack = n;
            return true;
        }
        return false;
    }

    private boolean isTrackNameChanged() {
        String string = this.track.getName();
        if (this.lastTrackName == null || !string.equals(this.lastTrackName)) {
            this.lastTrackName = string;
            return true;
        }
        return false;
    }

    private boolean isMeasureCountChanged() {
        int n = this.track.countMeasures();
        if (n != this.lastMeasuseCount) {
            this.lastMeasuseCount = n;
            return true;
        }
        return false;
    }

    public void update() {
        this.updated = true;
    }

    public void setCaretPosition(int n) {
        this.caretPosition = n;
    }

    public TGTrack getTrack() {
        return this.track;
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty("lyric.editor"));
            this.fromLabel.setText(TuxGuitar.getProperty("edit.from"));
        }
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.dialog.setImage(TuxGuitar.instance().getIconManager().getAppIcon());
        }
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    public void doUpdate(int n) {
        if (n == 1) {
            this.updateItems();
        } else if (n == 2 || n == 3) {
            this.update();
        }
    }
}

