/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.ArrayList;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.TGBeatGroup;
import org.herac.tuxguitar.gui.editors.tab.TGChordImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGNoteImpl;
import org.herac.tuxguitar.gui.editors.tab.TGVoiceImpl;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGVoice;

public class TGBeatImpl
extends TGBeat {
    public static final int JOINED_TYPE_NONE_LEFT = 1;
    public static final int JOINED_TYPE_NONE_RIGHT = 2;
    public static final int JOINED_TYPE_LEFT = 3;
    public static final int JOINED_TYPE_RIGHT = 4;
    private int posX;
    private int width;
    private TGNoteImpl maxNote;
    private TGNoteImpl minNote;
    private boolean[] usedStrings;
    private int joinedType;
    private boolean joinedGreaterThanQuarter;
    private TGBeatImpl join1;
    private TGBeatImpl join2;
    private TGBeatImpl previous;
    private TGBeatImpl next;
    private TGBeatGroup group;

    public TGBeatImpl(TGFactory tGFactory) {
        super(tGFactory);
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int n) {
        this.posX = n;
    }

    public int getMinimumWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public TGNoteImpl getMinNote() {
        return this.minNote;
    }

    public TGNoteImpl getMaxNote() {
        return this.maxNote;
    }

    public TGMeasureImpl getMeasureImpl() {
        return (TGMeasureImpl)this.getMeasure();
    }

    public boolean[] getUsedStrings() {
        if (this.usedStrings == null) {
            this.usedStrings = new boolean[this.getMeasure().getTrack().stringCount()];
        }
        return this.usedStrings;
    }

    public TGBeatImpl getJoin1() {
        return this.join1;
    }

    public void setJoin1(TGBeatImpl tGBeatImpl) {
        this.join1 = tGBeatImpl;
    }

    public TGBeatImpl getJoin2() {
        return this.join2;
    }

    public void setJoin2(TGBeatImpl tGBeatImpl) {
        this.join2 = tGBeatImpl;
    }

    public boolean isJoinedGreaterThanQuarter() {
        return this.joinedGreaterThanQuarter;
    }

    public void setJoinedGreaterThanQuarter(boolean bl) {
        this.joinedGreaterThanQuarter = bl;
    }

    public int getJoinedType() {
        return this.joinedType;
    }

    public void setJoinedType(int n) {
        this.joinedType = n;
    }

    public TGBeatImpl getPreviousBeat() {
        return this.previous;
    }

    public void setPreviousBeat(TGBeatImpl tGBeatImpl) {
        this.previous = tGBeatImpl;
    }

    public TGBeatImpl getNextBeat() {
        return this.next;
    }

    public void setNextBeat(TGBeatImpl tGBeatImpl) {
        this.next = tGBeatImpl;
    }

    public TGBeatGroup getBeatGroup() {
        return this.group;
    }

    public void setBeatGroup(TGBeatGroup tGBeatGroup) {
        this.group = tGBeatGroup;
    }

    public int getSpacing() {
        return this.getMeasureImpl().getBeatSpacing(this);
    }

    public boolean isPlaying(ViewLayout viewLayout) {
        return this.getMeasureImpl().isPlaying(viewLayout) && TuxGuitar.instance().getEditorCache().isPlaying(this.getMeasure(), this);
    }

    public TGVoiceImpl getVoiceImpl(int n) {
        TGVoice tGVoice = super.getVoice(n);
        if (tGVoice instanceof TGVoiceImpl) {
            return (TGVoiceImpl)tGVoice;
        }
        return null;
    }

    public void reset() {
        this.maxNote = null;
        this.minNote = null;
        this.usedStrings = new boolean[this.getMeasure().getTrack().stringCount()];
    }

    public void check(TGNoteImpl tGNoteImpl) {
        int n = tGNoteImpl.getRealValue();
        if (this.maxNote == null || n > this.maxNote.getRealValue()) {
            this.maxNote = tGNoteImpl;
        }
        if (this.minNote == null || n < this.minNote.getRealValue()) {
            this.minNote = tGNoteImpl;
        }
        this.getUsedStrings();
        this.usedStrings[tGNoteImpl.getString() - 1] = true;
    }

    public void play() {
        if (!TuxGuitar.instance().getPlayer().isRunning()) {
            new Thread(new Runnable(){

                public void run() {
                    ArrayList arrayList = new ArrayList();
                    for (int i = 0; i < TGBeatImpl.this.countVoices(); ++i) {
                        arrayList.addAll(TGBeatImpl.this.getVoice(i).getNotes());
                    }
                    TuxGuitar.instance().getPlayer().playBeat(TGBeatImpl.this.getMeasure().getTrack(), arrayList);
                }
            }).start();
        }
    }

    public void paint(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        if (!viewLayout.isPlayModeEnabled() && (viewLayout.getStyle() & 4) != 0) {
            this.paintExtraLines(tGPainter, viewLayout, n, n2);
        }
        for (int i = 0; i < 2; ++i) {
            this.getVoiceImpl(i).paint(viewLayout, tGPainter, n, n2);
        }
        if (!viewLayout.isPlayModeEnabled()) {
            if (this.isChordBeat()) {
                TGChordImpl tGChordImpl = (TGChordImpl)this.getChord();
                tGChordImpl.paint(viewLayout, tGPainter, n, n2);
            }
            if (this.getStroke().getDirection() != 0) {
                this.paintStroke(viewLayout, tGPainter, n, n2);
            }
        }
    }

    public void paintExtraLines(TGPainter tGPainter, ViewLayout viewLayout, int n, int n2) {
        if (!this.isRestBeat()) {
            int n3 = n2 + this.getMeasureImpl().getTs().getPosition(7);
            this.paintExtraLines(tGPainter, viewLayout, this.getMinNote(), n, n3);
            this.paintExtraLines(tGPainter, viewLayout, this.getMaxNote(), n, n3);
        }
    }

    private void paintExtraLines(TGPainter tGPainter, ViewLayout viewLayout, TGNoteImpl tGNoteImpl, int n, int n2) {
        block3: {
            int n3;
            float f;
            float f2;
            int n4;
            block2: {
                float f3 = viewLayout.getScale();
                n4 = n2 + tGNoteImpl.getScorePosY();
                int n5 = n + this.getPosX() + this.getSpacing();
                f2 = (float)n5 - 4.0f * f3;
                f = (float)n5 + 12.0f * f3;
                n3 = viewLayout.getScoreLineSpacing();
                viewLayout.setLineStyle(tGPainter);
                if (n4 >= n2) break block2;
                for (int i = n2; i > n4; i -= n3) {
                    tGPainter.initPath();
                    tGPainter.moveTo(f2, i);
                    tGPainter.lineTo(f, i);
                    tGPainter.closePath();
                }
                break block3;
            }
            if (n4 <= n2 + n3 * 4) break block3;
            for (int i = n2 + n3 * 5; i < n4 + n3; i += n3) {
                tGPainter.initPath();
                tGPainter.moveTo(f2, i);
                tGPainter.lineTo(f, i);
                tGPainter.closePath();
            }
        }
    }

    public void paintStroke(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        float f;
        int n3 = viewLayout.getStyle();
        float f2 = viewLayout.getScale();
        float f3 = (float)(n + this.getPosX() + this.getSpacing()) + 12.0f * f2;
        float f4 = 0.0f;
        float f5 = 0.0f;
        if ((n3 & 4) != 0) {
            f = n2 + this.getPaintPosition(7);
            f4 = f + (float)viewLayout.getScoreLineSpacing();
            f5 = f + (float)(this.getMeasureImpl().getTrackImpl().getScoreHeight() - viewLayout.getScoreLineSpacing());
        }
        if ((n3 & 8) != 0) {
            f = n2 + this.getPaintPosition(17);
            f4 = f + (float)viewLayout.getStringSpacing();
            f5 = f + (float)(this.getMeasureImpl().getTrackImpl().getTabHeight() - viewLayout.getStringSpacing());
        } else if ((n3 & 4) != 0) {
            f = n2 + this.getPaintPosition(7);
            f4 = f + (float)viewLayout.getScoreLineSpacing();
            f5 = f + (float)(this.getMeasureImpl().getTrackImpl().getScoreHeight() - viewLayout.getScoreLineSpacing());
        } else {
            return;
        }
        if (this.getStroke().getDirection() == 1) {
            tGPainter.initPath();
            tGPainter.moveTo(f3, f4);
            tGPainter.lineTo(f3, f5);
            tGPainter.lineTo(f3 - 2.0f * f2, f5 - 5.0f * f2);
            tGPainter.moveTo(f3, f5);
            tGPainter.lineTo(f3 + 2.0f * f2, f5 - 5.0f * f2);
            tGPainter.closePath();
        } else if (this.getStroke().getDirection() == -1) {
            tGPainter.initPath();
            tGPainter.moveTo(f3, f5);
            tGPainter.lineTo(f3, f4);
            tGPainter.lineTo(f3 - 2.0f * f2, f4 + 3.0f * f2);
            tGPainter.moveTo(f3, f4);
            tGPainter.lineTo(f3 + 2.0f * f2, f4 + 3.0f * f2);
            tGPainter.closePath();
        }
    }

    public int getPaintPosition(int n) {
        return this.getMeasureImpl().getTs().getPosition(n);
    }

    public void removeChord() {
        if (this.isChordBeat()) {
            TGChordImpl tGChordImpl = (TGChordImpl)this.getChord();
            tGChordImpl.dispose();
        }
        super.removeChord();
    }

    public void dispose() {
        if (this.isChordBeat()) {
            TGChordImpl tGChordImpl = (TGChordImpl)this.getChord();
            tGChordImpl.dispose();
        }
    }
}

