/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGString;

public class TGChordImpl
extends TGChord {
    public static final int MAX_FRETS = 6;
    private int style;
    private int posX;
    private int posY;
    private int width;
    private int height;
    private int tonic;
    private int diagramWidth;
    private int diagramHeight;
    private int nameWidth;
    private int nameHeight;
    private Image diagram;
    private Color foregroundColor;
    private Color backgroundColor;
    private Color noteColor;
    private Color tonicColor;
    private Color color;
    private Font font;
    private Font firstFretFont;
    private int firstFretSpacing;
    private int stringSpacing;
    private int fretSpacing;
    private int noteSize;
    private boolean editing;

    public TGChordImpl(int n) {
        super(n);
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean bl) {
        this.editing = bl;
    }

    public void setPosX(int n) {
        this.posX = n;
    }

    public void setPosY(int n) {
        this.posY = n;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setStyle(int n) {
        this.style = n;
    }

    public void setTonic(int n) {
        if (!this.isDisposed() && this.tonic != n) {
            this.dispose();
        }
        this.tonic = n;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color color) {
        if (!this.isDisposed() && !this.isSameColor(this.foregroundColor, color)) {
            this.dispose();
        }
        this.foregroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        if (!this.isDisposed() && !this.isSameColor(this.backgroundColor, color)) {
            this.dispose();
        }
        this.backgroundColor = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (!this.isDisposed() && !this.isSameColor(this.color, color)) {
            this.dispose();
        }
        this.color = color;
    }

    public Color getNoteColor() {
        return this.noteColor;
    }

    public void setNoteColor(Color color) {
        if (!this.isDisposed() && !this.isSameColor(this.noteColor, color)) {
            this.dispose();
        }
        this.noteColor = color;
    }

    public Color getTonicColor() {
        return this.tonicColor;
    }

    public void setTonicColor(Color color) {
        if (!this.isDisposed() && !this.isSameColor(this.tonicColor, color)) {
            this.dispose();
        }
        this.tonicColor = color;
    }

    public int getFirstFretSpacing() {
        return this.firstFretSpacing;
    }

    public void setFirstFretSpacing(int n) {
        if (!this.isDisposed() && this.firstFretSpacing != n) {
            this.dispose();
        }
        this.firstFretSpacing = n;
    }

    public int getFretSpacing() {
        return this.fretSpacing;
    }

    public void setFretSpacing(int n) {
        if (!this.isDisposed() && this.fretSpacing != n) {
            this.dispose();
        }
        this.fretSpacing = n;
    }

    public int getStringSpacing() {
        return this.stringSpacing;
    }

    public void setStringSpacing(int n) {
        if (!this.isDisposed() && this.stringSpacing != n) {
            this.dispose();
        }
        this.stringSpacing = n;
    }

    public int getNoteSize() {
        return this.noteSize;
    }

    public void setNoteSize(int n) {
        if (!this.isDisposed() && this.noteSize != n) {
            this.dispose();
        }
        this.noteSize = n;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (!this.isDisposed() && !this.isSameFont(this.font, font)) {
            this.dispose();
        }
        this.font = font;
    }

    public Font getFirstFretFont() {
        return this.firstFretFont;
    }

    public void setFirstFretFont(Font font) {
        if (!this.isDisposed() && !this.isSameFont(this.firstFretFont, font)) {
            this.dispose();
        }
        this.firstFretFont = font;
    }

    public void paint(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        viewLayout.setChordStyle(this);
        this.setPosY(this.getPaintPosition(5));
        this.setEditing(false);
        this.update(tGPainter, viewLayout.isBufferEnabled());
        this.paint(tGPainter, this.getBeatImpl().getSpacing() + n + Math.round(4.0f * viewLayout.getScale()), n2);
    }

    public void paint(TGPainter tGPainter, int n, int n2) {
        int n3 = n + this.getPosX();
        int n4 = n2 + this.getPosY();
        if ((this.style & 0x20) != 0) {
            if (this.diagram != null) {
                tGPainter.drawImage(this.diagram, n3 - (this.diagramWidth - this.getFirstFretSpacing()) / 2 - this.getFirstFretSpacing(), n4);
            } else {
                this.paintDiagram(tGPainter, n3 - (this.diagramWidth - this.getFirstFretSpacing()) / 2 - this.getFirstFretSpacing(), n4);
            }
        }
        if ((this.style & 0x10) != 0 && this.getName() != null && this.getName().length() > 0) {
            tGPainter.setFont(this.getFont());
            tGPainter.setForeground(this.getForegroundColor());
            tGPainter.setBackground(this.getBackgroundColor());
            tGPainter.drawString(this.getName(), n3 - this.nameWidth / 2, n4 + (this.height - this.nameHeight));
        }
    }

    public void update(TGPainter tGPainter, boolean bl) {
        this.width = 0;
        this.height = 0;
        if (this.getFirstFret() <= 0) {
            this.calculateFirstFret();
        }
        if ((this.style & 0x10) != 0) {
            this.updateName(tGPainter);
            this.width = Math.max(this.width, this.nameWidth);
            this.height += this.nameHeight;
        }
        if ((this.style & 0x20) != 0) {
            this.updateDiagram(bl ? tGPainter.getGC().getDevice() : null);
            this.width = Math.max(this.width, this.diagramWidth);
            this.height += this.diagramHeight;
        }
    }

    protected void updateName(TGPainter tGPainter) {
        String string = this.getName();
        if (tGPainter == null || string == null || string.length() == 0) {
            this.nameWidth = 0;
            this.nameHeight = 0;
            return;
        }
        Point point = tGPainter.getStringExtent(string);
        this.nameWidth = point.x;
        this.nameHeight = point.y;
    }

    protected void updateDiagram(Device device) {
        Font font = this.getFirstFretFont();
        this.diagramWidth = this.getStringSpacing() + this.getStringSpacing() * this.countStrings() + (font != null ? this.getFirstFretSpacing() : 0);
        this.diagramHeight = this.getFretSpacing() + this.getFretSpacing() * 6;
        if (device != null && (this.diagram == null || this.diagram.isDisposed())) {
            this.diagram = new Image(device, this.diagramWidth, this.diagramHeight);
            TGPainter tGPainter = new TGPainter(new GC((Drawable)this.diagram));
            this.paintDiagram(tGPainter, 0, 0);
            tGPainter.dispose();
        }
    }

    protected void paintDiagram(TGPainter tGPainter, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        Font font = this.getFirstFretFont();
        tGPainter.setBackground(this.getBackgroundColor());
        tGPainter.initPath(2);
        tGPainter.addRectangle(n, n2, this.diagramWidth, this.diagramHeight);
        tGPainter.closePath();
        tGPainter.setForeground(this.getColor());
        int n7 = n + this.getStringSpacing();
        int n8 = n2 + this.getFretSpacing();
        if (font != null) {
            String string = Integer.toString(this.getFirstFret());
            tGPainter.setFont(font);
            Point point = tGPainter.getStringExtent(string);
            tGPainter.drawString(string, n + (this.getFirstFretSpacing() - point.x), Math.round((float)n8 + ((float)this.getFretSpacing() / 2.0f - (float)point.y / 2.0f)));
            n7 += this.getFirstFretSpacing();
        }
        tGPainter.initPath();
        for (n6 = 0; n6 < this.getStrings().length; ++n6) {
            int n9 = n7 + n6 * this.getStringSpacing();
            n5 = n7 + n6 * this.getStringSpacing();
            n4 = n8;
            n3 = n8 + this.getFretSpacing() * 5;
            tGPainter.moveTo(n9, n4);
            tGPainter.lineTo(n5, n3);
        }
        tGPainter.closePath();
        tGPainter.initPath();
        for (n6 = 0; n6 < 6; ++n6) {
            int n10 = n7;
            n5 = n7 + this.getStringSpacing() * (this.countStrings() - 1);
            n4 = n8 + n6 * this.getFretSpacing();
            n3 = n8 + n6 * this.getFretSpacing();
            tGPainter.moveTo(n10, n4);
            tGPainter.lineTo(n5, n3);
        }
        tGPainter.closePath();
        tGPainter.setLineWidth(1);
        for (n6 = 0; n6 < this.getStrings().length; ++n6) {
            int n11 = this.getFretValue(n6);
            n5 = n7 + (this.getStringSpacing() * (this.countStrings() - 1) - this.getStringSpacing() * n6);
            if (n11 < 0) {
                tGPainter.initPath();
                tGPainter.moveTo(n5 - this.getNoteSize() / 2, n2);
                tGPainter.lineTo(n5 + this.getNoteSize() / 2, n2 + this.getNoteSize());
                tGPainter.moveTo(n5 + this.getNoteSize() / 2, n2);
                tGPainter.lineTo(n5 - this.getNoteSize() / 2, n2 + this.getNoteSize());
                tGPainter.closePath();
                continue;
            }
            if (n11 == 0) {
                tGPainter.initPath();
                tGPainter.addOval(n5 - this.getNoteSize() / 2, n2, this.getNoteSize(), this.getNoteSize());
                tGPainter.closePath();
                continue;
            }
            tGPainter.setBackground(this.tonic >= 0 && (this.getStringValue(n6 + 1) + n11) % 12 == this.tonic ? this.getTonicColor() : this.getNoteColor());
            tGPainter.initPath(2);
            n4 = n8 + (this.getFretSpacing() * (n11 -= this.getFirstFret() - 1) - this.getFretSpacing() / 2);
            tGPainter.addOval(n5 - this.getNoteSize() / 2, n4 - this.getNoteSize() / 2, this.getNoteSize() + 1, this.getNoteSize() + 1);
            tGPainter.closePath();
        }
    }

    public void calculateFirstFret() {
        int n;
        int n2 = -1;
        int n3 = -1;
        boolean bl = false;
        for (n = 0; n < this.getStrings().length; ++n) {
            int n4 = this.getFretValue(n);
            boolean bl2 = bl = bl || n4 == 0;
            if (n4 <= 0) continue;
            n2 = n2 < 0 ? n4 : Math.min(n2, n4);
            n3 = Math.max(n3, n4);
        }
        n = bl && n3 < 6 ? 1 : n2;
        this.setFirstFret(Math.max(n, 1));
    }

    private int getStringValue(int n) {
        TGString tGString = this.getBeat().getMeasure().getTrack().getString(n);
        return tGString.getValue();
    }

    public boolean isDisposed() {
        return this.diagram == null || this.diagram.isDisposed();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.diagram.dispose();
        }
    }

    public int getPosX() {
        return this.isEditing() ? this.posX : this.getBeatImpl().getPosX();
    }

    public int getPaintPosition(int n) {
        return this.getBeatImpl().getMeasureImpl().getTs().getPosition(n);
    }

    public TGBeatImpl getBeatImpl() {
        return (TGBeatImpl)this.getBeat();
    }

    private boolean isSameFont(Font font, Font font2) {
        if (font == null && font2 == null) {
            return true;
        }
        if (font != null && font2 != null && !font.isDisposed() && !font2.isDisposed()) {
            FontData[] fontDataArray = font.getFontData();
            FontData[] fontDataArray2 = font2.getFontData();
            if (fontDataArray.length > 0 && fontDataArray2.length > 0) {
                boolean bl = fontDataArray[0].getName().equals(fontDataArray2[0].getName());
                boolean bl2 = fontDataArray[0].getStyle() == fontDataArray2[0].getStyle();
                boolean bl3 = fontDataArray[0].getHeight() == fontDataArray2[0].getHeight();
                return bl && bl2 && bl3;
            }
        }
        return false;
    }

    private boolean isSameColor(Color color, Color color2) {
        if (color == null && color2 == null) {
            return true;
        }
        if (color != null && color2 != null && !color.isDisposed() && !color2.isDisposed()) {
            RGB rGB = color.getRGB();
            RGB rGB2 = color2.getRGB();
            if (rGB != null && rGB2 != null) {
                return rGB.red == rGB2.red && rGB.green == rGB2.green && rGB.blue == rGB2.blue;
            }
        }
        return false;
    }
}

