/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.TGBeatGroup;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureBuffer;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureHeaderImpl;
import org.herac.tuxguitar.gui.editors.tab.TGNoteImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTextImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.editors.tab.TGVoiceImpl;
import org.herac.tuxguitar.gui.editors.tab.TablatureUtil;
import org.herac.tuxguitar.gui.editors.tab.layout.TrackSpacing;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.editors.tab.painters.TGClefPainter;
import org.herac.tuxguitar.gui.editors.tab.painters.TGKeySignaturePainter;
import org.herac.tuxguitar.gui.editors.tab.painters.TGTempoPainter;
import org.herac.tuxguitar.gui.editors.tab.painters.TGTripletFeelPainter;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGTupleto;

public class TGMeasureImpl
extends TGMeasure {
    public static final int NATURAL = 1;
    public static final int SHARP = 2;
    public static final int FLAT = 3;
    public static final int[][] KEY_SIGNATURES = new int[][]{{1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 2, 1, 1, 1}, {2, 1, 1, 2, 1, 1, 1}, {2, 1, 1, 2, 2, 1, 1}, {2, 2, 1, 2, 2, 1, 1}, {2, 2, 1, 2, 2, 2, 1}, {2, 2, 2, 2, 2, 2, 1}, {2, 2, 2, 2, 2, 2, 2}, {1, 1, 1, 1, 1, 1, 3}, {1, 1, 3, 1, 1, 1, 3}, {1, 1, 3, 1, 1, 3, 3}, {1, 3, 3, 1, 1, 3, 3}, {1, 3, 3, 1, 3, 3, 3}, {3, 3, 3, 1, 3, 3, 3}, {3, 3, 3, 3, 3, 3, 3}};
    public static final int[] ACCIDENTAL_SHARP_NOTES = new int[]{0, 0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6};
    public static final int[] ACCIDENTAL_FLAT_NOTES = new int[]{0, 1, 1, 2, 2, 3, 4, 4, 5, 5, 6, 6};
    public static final boolean[] ACCIDENTAL_NOTES = new boolean[]{false, true, false, true, false, false, true, false, true, false, true, false};
    public static final int[] SCORE_KEY_OFFSETS = new int[]{30, 18, 22, 24};
    public static final int[] SCORE_KEY_SHARP_POSITIONS = new int[]{1, 4, 0, 3, 6, 2, 5};
    public static final int[] SCORE_KEY_FLAT_POSITIONS = new int[]{5, 2, 6, 3, 0, 4, 1};
    private static final int DEFAULT_CLEF_SPACING = 40;
    private static final int DEFAULT_QUARTER_SPACING = 30;
    private int posX;
    private int posY;
    private int quarterSpacing;
    private long divisionLength;
    private boolean paintClef = true;
    private boolean paintKeySignature = true;
    private TGMeasure prevMeasure;
    private boolean outOfBounds;
    private boolean firstOfLine;
    private boolean compactMode;
    private int spacing;
    private TrackSpacing ts;
    private int maxY;
    private int minY;
    private int notEmptyVoices;
    private int notEmptyBeats;
    private int widthBeats = 0;
    private List[] voiceGroups;
    private TGMeasureBuffer buffer;
    private boolean bufferCreated;
    private Color markerColor;
    private int lyricBeatIndex;
    private int width;
    private boolean text;
    private boolean chord;
    private boolean accentuated;
    private boolean harmonic;
    private boolean tapping;
    private boolean palmMute;
    private boolean vibrato;
    private boolean tupleto;
    private boolean fadeIn;
    private boolean[][] registeredAccidentals = new boolean[11][7];

    public TGMeasureImpl(TGMeasureHeader tGMeasureHeader) {
        super(tGMeasureHeader);
        this.voiceGroups = new List[2];
        for (int i = 0; i < 2; ++i) {
            this.voiceGroups[i] = new ArrayList();
        }
    }

    public void create(ViewLayout viewLayout) {
        this.divisionLength = TGSongManager.getDivisionLength(this.getHeader());
        this.resetSpacing();
        this.autoCompleteSilences(viewLayout.getSongManager());
        this.orderBeats(viewLayout.getSongManager());
        this.checkCompactMode(viewLayout);
        this.clearRegisteredAccidentals();
        this.calculateBeats(viewLayout);
        this.calculateWidth(viewLayout);
        this.setFirstOfLine(false);
    }

    public void update(ViewLayout viewLayout) {
        this.updateComponents(viewLayout);
        this.setOutOfBounds(true);
        this.setBufferCreated(false);
    }

    private void checkCompactMode(ViewLayout viewLayout) {
        boolean bl;
        boolean bl2 = bl = (viewLayout.getStyle() & 1) != 0;
        if (bl && (viewLayout.getStyle() & 2) != 0) {
            bl = viewLayout.getSongManager().getSong().countTracks() == 1;
        }
        this.compactMode = bl;
    }

    private void clearRegisteredAccidentals() {
        for (int i = 0; i < 11; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.registeredAccidentals[i][j] = false;
            }
        }
    }

    public void calculateWidth(ViewLayout viewLayout) {
        if (this.compactMode) {
            this.width = this.widthBeats;
        } else {
            double d = 1.0 / (double)this.getTimeSignature().getDenominator().getValue() * 4.0 * (double)this.getTimeSignature().getNumerator();
            this.width = (int)((double)this.getQuarterSpacing() * d);
        }
        this.width += this.getFirstNoteSpacing(viewLayout);
        this.width += this.getRepeatClose() > 0 ? 20 : 0;
        this.width += this.getHeaderImpl().getLeftSpacing(viewLayout);
        this.width += this.getHeaderImpl().getRightSpacing(viewLayout);
        this.getHeaderImpl().notifyWidth(this.width);
    }

    private void calculateBeats(ViewLayout viewLayout) {
        Object object;
        int n;
        TGChord tGChord = null;
        TGDuration tGDuration = null;
        Object object2 = null;
        TGVoiceImpl[] tGVoiceImplArray = new TGVoiceImpl[2];
        TGBeatGroup[] tGBeatGroupArray = new TGBeatGroup[2];
        int n2 = viewLayout.getStyle();
        int n3 = 0;
        boolean[] blArray = new boolean[2];
        boolean bl = (n2 & 0x30) != 0;
        this.widthBeats = 0;
        this.notEmptyBeats = 0;
        this.notEmptyVoices = 0;
        for (n = 0; n < 2; ++n) {
            this.voiceGroups[n].clear();
        }
        for (n = 0; n < this.countBeats(); ++n) {
            int n4;
            object = (TGBeatImpl)this.getBeat(n);
            ((TGBeatImpl)object).reset();
            if (bl && ((TGBeat)object).getChord() != null) {
                if (tGChord != null) {
                    n4 = (int)(((TGBeat)object).getStart() - tGChord.getBeat().getStart());
                    n3 = n3 > 0 ? Math.min(n3, Math.abs(n4)) : n4;
                }
                tGChord = ((TGBeat)object).getChord();
            }
            n4 = 1;
            for (int i = 0; i < 2; ++i) {
                TGVoiceImpl tGVoiceImpl = (TGVoiceImpl)((TGBeat)object).getVoice(i);
                if (tGVoiceImpl.isEmpty()) continue;
                n4 = 0;
                tGVoiceImpl.reset();
                if (tGDuration == null || tGVoiceImpl.getDuration().getTime() <= tGDuration.getTime()) {
                    tGDuration = tGVoiceImpl.getDuration();
                }
                if (!blArray[i]) {
                    blArray[i] = true;
                    ++this.notEmptyVoices;
                }
                Iterator iterator = tGVoiceImpl.getNotes().iterator();
                while (iterator.hasNext()) {
                    TGNoteImpl tGNoteImpl = (TGNoteImpl)iterator.next();
                    tGVoiceImpl.check(tGNoteImpl);
                }
                if (!tGVoiceImpl.isRestVoice()) {
                    ((TGBeatImpl)object).check(tGVoiceImpl.getMinNote());
                    ((TGBeatImpl)object).check(tGVoiceImpl.getMaxNote());
                    if (tGBeatGroupArray[i] == null || !this.canJoin(viewLayout.getSongManager(), tGVoiceImpl, tGVoiceImplArray[i])) {
                        tGBeatGroupArray[i] = new TGBeatGroup(i);
                        this.voiceGroups[i].add(tGBeatGroupArray[i]);
                    }
                    tGBeatGroupArray[i].check(tGVoiceImpl);
                } else {
                    for (int j = 0; j < 2; ++j) {
                        TGVoiceImpl tGVoiceImpl2;
                        if (j == tGVoiceImpl.getIndex() || (tGVoiceImpl2 = ((TGBeatImpl)object).getVoiceImpl(j)).isEmpty() || !tGVoiceImpl2.getDuration().isEqual(tGVoiceImpl.getDuration()) || tGVoiceImpl2.isRestVoice() && tGVoiceImpl2.isHiddenSilence()) continue;
                        tGVoiceImpl.setHiddenSilence(true);
                        break;
                    }
                }
                this.makeVoice(viewLayout, tGVoiceImpl, tGVoiceImplArray[i], tGBeatGroupArray[i]);
                tGVoiceImplArray[i] = tGVoiceImpl;
            }
            if (n4 != 0) {
                System.out.println("Empty Beat !!!!!! " + ((TGBeat)object).getStart() + "  " + n);
            }
            this.makeBeat(viewLayout, (TGBeatImpl)object, (TGBeatImpl)object2, bl);
            object2 = object;
        }
        for (n = 0; n < this.voiceGroups.length; ++n) {
            object = this.voiceGroups[n].iterator();
            while (object.hasNext()) {
                TGBeatGroup tGBeatGroup = (TGBeatGroup)object.next();
                tGBeatGroup.finish(viewLayout, this);
            }
        }
        if (!this.compactMode) {
            int n5 = this.quarterSpacing = tGDuration != null ? viewLayout.getSpacingForQuarter(tGDuration) : Math.round(30.0f * viewLayout.getScale());
            if (bl && n3 > 0) {
                n = viewLayout.getChordFretIndexSpacing() + viewLayout.getChordStringSpacing() + this.getTrack().stringCount() * viewLayout.getChordStringSpacing();
                int n6 = (int)(960L * (long)n / (long)n3);
                this.quarterSpacing = Math.max(n6, this.quarterSpacing);
            }
            this.getHeaderImpl().notifyQuarterSpacing(this.quarterSpacing);
        }
    }

    public boolean canJoin(TGSongManager tGSongManager, TGVoiceImpl tGVoiceImpl, TGVoiceImpl tGVoiceImpl2) {
        if (tGVoiceImpl == null || tGVoiceImpl2 == null || tGVoiceImpl.isRestVoice() || tGVoiceImpl2.isRestVoice()) {
            return false;
        }
        long l = this.getDivisionLength();
        long l2 = this.getStart();
        long l3 = tGSongManager.getMeasureManager().getRealStart(this, tGVoiceImpl.getBeat().getStart()) - l2;
        long l4 = tGSongManager.getMeasureManager().getRealStart(this, tGVoiceImpl2.getBeat().getStart()) - l2;
        if (tGVoiceImpl.getDuration().getValue() < 8 || tGVoiceImpl2.getDuration().getValue() < 8) {
            return l3 == l4;
        }
        long l5 = (l + l3) / l;
        long l6 = (l + l4) / l;
        return l5 == l6;
    }

    private void makeVoice(ViewLayout viewLayout, TGVoiceImpl tGVoiceImpl, TGVoiceImpl tGVoiceImpl2, TGBeatGroup tGBeatGroup) {
        tGVoiceImpl.setWidth((int)viewLayout.getVoiceWidth(tGVoiceImpl));
        tGVoiceImpl.setBeatGroup(tGBeatGroup);
        if (tGVoiceImpl2 != null) {
            tGVoiceImpl.setPreviousBeat(tGVoiceImpl2);
            tGVoiceImpl2.setNextBeat(tGVoiceImpl);
        }
    }

    private void makeBeat(ViewLayout viewLayout, TGBeatImpl tGBeatImpl, TGBeatImpl tGBeatImpl2, boolean bl) {
        int n;
        int n2 = -1;
        boolean bl2 = true;
        for (n = 0; n < 2; ++n) {
            TGVoiceImpl tGVoiceImpl = tGBeatImpl.getVoiceImpl(n);
            if (tGVoiceImpl.isEmpty()) continue;
            if (n2 < 0 || tGVoiceImpl.getWidth() < n2) {
                n2 = tGVoiceImpl.getWidth();
            }
            if (tGVoiceImpl.isRestVoice()) continue;
            bl2 = false;
        }
        tGBeatImpl.setWidth(n2);
        this.notEmptyBeats += bl2 ? 0 : 1;
        this.widthBeats += tGBeatImpl.getMinimumWidth();
        if (tGBeatImpl2 != null) {
            tGBeatImpl.setPreviousBeat(tGBeatImpl2);
            tGBeatImpl2.setNextBeat(tGBeatImpl);
            if (bl && tGBeatImpl.isChordBeat() && tGBeatImpl2.isChordBeat()) {
                n = tGBeatImpl2.getMinimumWidth();
                int n3 = viewLayout.getChordFretIndexSpacing() + viewLayout.getChordStringSpacing() + this.getTrack().stringCount() * viewLayout.getChordStringSpacing();
                tGBeatImpl2.setWidth(Math.max(n3, n));
                this.widthBeats -= n;
                this.widthBeats += tGBeatImpl2.getMinimumWidth();
            }
        }
    }

    public void calculateMeasureChanges(ViewLayout viewLayout) {
        this.paintClef = false;
        this.paintKeySignature = false;
        TGMeasure tGMeasure = this.prevMeasure = viewLayout.isFirstMeasure(this) ? null : (TGMeasureImpl)viewLayout.getSongManager().getTrackManager().getPrevMeasure(this);
        if ((viewLayout.getStyle() & 4) != 0) {
            if (this.prevMeasure == null || this.getClef() != this.prevMeasure.getClef()) {
                this.paintClef = true;
                this.getHeaderImpl().notifyClefSpacing(Math.round(40.0f * viewLayout.getScale()));
            }
            if (this.prevMeasure == null || this.getKeySignature() != this.prevMeasure.getKeySignature()) {
                this.paintKeySignature = true;
                this.getHeaderImpl().notifyKeySignatureSpacing(this.calculateKeySignatureSpacing(viewLayout));
            }
        }
    }

    private void autoCompleteSilences(TGSongManager tGSongManager) {
        tGSongManager.getMeasureManager().autoCompleteSilences(this);
    }

    private void updateComponents(ViewLayout viewLayout) {
        Object object;
        int n;
        int n2;
        this.maxY = 0;
        this.minY = 0;
        int n3 = n2 = this.getFirstNoteSpacing(viewLayout);
        for (n = 0; n < this.countBeats(); ++n) {
            int n4;
            object = (TGBeatImpl)this.getBeat(n);
            if (this.compactMode) {
                ((TGBeatImpl)object).setPosX(n3);
                n3 += ((TGBeatImpl)object).getMinimumWidth();
            } else {
                n4 = this.getMaxQuarterSpacing(viewLayout);
                int n5 = n2 + TablatureUtil.getStartPosition(this, ((TGBeat)object).getStart(), n4);
                int n6 = -1;
                for (int i = 0; i < ((TGBeat)object).countVoices(); ++i) {
                    TGVoiceImpl tGVoiceImpl = ((TGBeatImpl)object).getVoiceImpl(i);
                    if (tGVoiceImpl.isEmpty()) continue;
                    int n7 = n2 + TablatureUtil.getStartPosition(this, ((TGBeat)object).getStart() + tGVoiceImpl.getDuration().getTime(), n4);
                    int n8 = n7 - n5;
                    if (n6 < 0 || n8 < n6) {
                        n6 = n8;
                    }
                    tGVoiceImpl.setWidth(n8);
                }
                ((TGBeatImpl)object).setPosX(n5);
                ((TGBeatImpl)object).setWidth(n6);
            }
            for (n4 = 0; n4 < ((TGBeat)object).countVoices(); ++n4) {
                TGVoiceImpl tGVoiceImpl = ((TGBeatImpl)object).getVoiceImpl(n4);
                if (tGVoiceImpl.isEmpty()) continue;
                Iterator iterator = tGVoiceImpl.getNotes().iterator();
                while (iterator.hasNext()) {
                    TGNoteImpl tGNoteImpl = (TGNoteImpl)iterator.next();
                    this.checkEffects(viewLayout, tGNoteImpl.getEffect());
                    tGNoteImpl.update(viewLayout);
                }
                tGVoiceImpl.update(viewLayout);
                if (!this.tupleto && !tGVoiceImpl.getDuration().getTupleto().isEqual(TGTupleto.NORMAL)) {
                    this.tupleto = true;
                }
                if ((viewLayout.getStyle() & 4) != 0 && (!tGVoiceImpl.isRestVoice() || tGVoiceImpl.isHiddenSilence())) continue;
                if (tGVoiceImpl.getMaxY() > this.maxY) {
                    this.maxY = tGVoiceImpl.getMaxY();
                }
                if (tGVoiceImpl.getMinY() >= this.minY) continue;
                this.minY = tGVoiceImpl.getMinY();
            }
            if (!this.chord && ((TGBeat)object).isChordBeat()) {
                this.chord = true;
            }
            if (this.text || !((TGBeat)object).isTextBeat()) continue;
            this.text = true;
        }
        if ((viewLayout.getStyle() & 4) != 0) {
            for (n = 0; n < this.voiceGroups.length; ++n) {
                object = this.voiceGroups[n].iterator();
                while (object.hasNext()) {
                    TGBeatGroup tGBeatGroup = (TGBeatGroup)object.next();
                    this.checkValue(viewLayout, tGBeatGroup.getMinNote(), tGBeatGroup.getDirection());
                    this.checkValue(viewLayout, tGBeatGroup.getMaxNote(), tGBeatGroup.getDirection());
                }
            }
        }
    }

    public int getNoteAccidental(int n) {
        if (n >= 0 && n < 128) {
            boolean bl;
            int n2 = this.getKeySignature();
            int n3 = n % 12;
            int n4 = n / 12;
            int n5 = n2 <= 7 ? 2 : 3;
            int[] nArray = n2 <= 7 ? ACCIDENTAL_SHARP_NOTES : ACCIDENTAL_FLAT_NOTES;
            boolean bl2 = ACCIDENTAL_NOTES[n3];
            boolean bl3 = bl = KEY_SIGNATURES[n2][nArray[n3]] == n5;
            if (bl != bl2 && !this.registeredAccidentals[n4][nArray[n3]]) {
                this.registeredAccidentals[n4][nArray[n3]] = true;
                return bl2 ? n5 : 1;
            }
            if (bl == bl2 && this.registeredAccidentals[n4][nArray[n3]]) {
                this.registeredAccidentals[n4][nArray[n3]] = false;
                return bl2 ? n5 : 1;
            }
        }
        return 0;
    }

    private void checkValue(ViewLayout viewLayout, TGNoteImpl tGNoteImpl, int n) {
        int n2 = tGNoteImpl.getScorePosY();
        float f = TGBeatGroup.getUpOffset(viewLayout);
        float f2 = TGBeatGroup.getDownOffset(viewLayout);
        if (n == 1 && n2 > this.maxY) {
            this.maxY = n2;
        } else if (n == 2 && (float)n2 + f2 > (float)this.maxY) {
            this.maxY = (int)((float)n2 + f2 + 2.0f);
        }
        if (n == 1 && (float)n2 - f < (float)this.minY) {
            this.minY = (int)((float)n2 - f - 2.0f);
        } else if (n == 2 && n2 < this.minY) {
            this.minY = n2;
        }
    }

    private void checkEffects(ViewLayout viewLayout, TGNoteEffect tGNoteEffect) {
        if (tGNoteEffect.isAccentuatedNote() || tGNoteEffect.isHeavyAccentuatedNote()) {
            this.accentuated = true;
        }
        if (tGNoteEffect.isHarmonic() && (viewLayout.getStyle() & 4) == 0) {
            this.harmonic = true;
        }
        if (tGNoteEffect.isTapping() || tGNoteEffect.isSlapping() || tGNoteEffect.isPopping()) {
            this.tapping = true;
        }
        if (tGNoteEffect.isPalmMute()) {
            this.palmMute = true;
        }
        if (tGNoteEffect.isFadeIn()) {
            this.fadeIn = true;
        }
        if (tGNoteEffect.isVibrato() || tGNoteEffect.isTrill()) {
            this.vibrato = true;
        }
    }

    private void resetSpacing() {
        this.text = false;
        this.chord = false;
        this.tupleto = false;
        this.accentuated = false;
        this.harmonic = false;
        this.tapping = false;
        this.palmMute = false;
        this.fadeIn = false;
        this.vibrato = false;
    }

    public void registerSpacing(ViewLayout viewLayout, TrackSpacing trackSpacing) {
        if (this.hasMarker()) {
            trackSpacing.setSize(1, viewLayout.getMarkerSpacing());
        }
        if (this.chord) {
            trackSpacing.setSize(5, viewLayout.getDefaultChordSpacing());
        }
        if (this.text) {
            trackSpacing.setSize(2, viewLayout.getTextSpacing());
        }
        if (this.getHeader().getRepeatAlternative() > 0) {
            trackSpacing.setSize(4, viewLayout.getRepeatEndingSpacing());
        }
        if (this.tupleto) {
            trackSpacing.setSize(9, viewLayout.getTupletoSpacing());
        }
        if (this.accentuated) {
            trackSpacing.setSize(10, viewLayout.getEffectSpacing());
        }
        if (this.harmonic) {
            trackSpacing.setSize(11, viewLayout.getEffectSpacing());
        }
        if (this.tapping) {
            trackSpacing.setSize(12, viewLayout.getEffectSpacing());
        }
        if (this.palmMute) {
            trackSpacing.setSize(13, viewLayout.getEffectSpacing());
        }
        if (this.fadeIn) {
            trackSpacing.setSize(15, viewLayout.getEffectSpacing());
        }
        if (this.vibrato) {
            trackSpacing.setSize(14, viewLayout.getEffectSpacing());
        }
    }

    private void orderBeats(TGSongManager tGSongManager) {
        tGSongManager.getMeasureManager().orderBeats(this);
    }

    public void paintMeasure(ViewLayout viewLayout, TGPainter tGPainter) {
        this.setOutOfBounds(false);
        boolean bl = viewLayout.isBufferEnabled();
        if (this.shouldRepaintBuffer() || !bl) {
            int n;
            TGPainter tGPainter2 = tGPainter;
            int n2 = bl ? 0 : this.getPosX();
            int n3 = n = bl ? 0 : this.getPosY();
            if (bl) {
                this.getBuffer().makeBuffer(this.getWidth(viewLayout) + this.getSpacing(), this.getTs().getSize(), viewLayout.getResources().getBackgroundColor());
                tGPainter2 = this.getBuffer().getPainter();
            }
            viewLayout.paintLines(this.getTrackImpl(), this.getTs(), tGPainter2, n2, n, this.getWidth(viewLayout) + this.getSpacing());
            this.paintTimeSignature(viewLayout, tGPainter2, n2, n);
            this.paintClef(viewLayout, tGPainter2, n2, n);
            this.paintKeySignature(viewLayout, tGPainter2, n2, n);
            this.paintComponents(viewLayout, tGPainter2, n2, n);
            this.setBufferCreated(true);
        }
        if (bl) {
            tGPainter.setBackground(viewLayout.getResources().getBackgroundColor());
            this.getBuffer().paintImage(tGPainter, this.getPosX(), this.getPosY(), this.getTs().getPosition(3));
        }
        this.paintMarker(viewLayout, tGPainter);
        this.paintTexts(viewLayout, tGPainter);
        this.paintTempo(viewLayout, tGPainter);
        this.paintTripletFeel(viewLayout, tGPainter);
        this.paintDivisions(viewLayout, tGPainter);
        this.paintRepeatEnding(viewLayout, tGPainter);
        this.paintPlayMode(viewLayout, tGPainter);
    }

    private boolean shouldRepaintBuffer() {
        return this.isDisposed() || !this.isBufferCreated();
    }

    public void paintRepeatEnding(ViewLayout viewLayout, TGPainter tGPainter) {
        if (this.getHeader().getRepeatAlternative() > 0) {
            float f = viewLayout.getScale();
            float f2 = this.getPosX() + this.getHeaderImpl().getLeftSpacing(viewLayout) + this.getFirstNoteSpacing(viewLayout);
            float f3 = this.getPosX() + this.getWidth(viewLayout) + this.getSpacing();
            float f4 = this.getPosY() + this.getTs().getPosition(4);
            float f5 = f4 + (float)viewLayout.getRepeatEndingSpacing() * 0.75f;
            String string = new String();
            for (int i = 0; i < 8; ++i) {
                if ((this.getHeader().getRepeatAlternative() & 1 << i) == 0) continue;
                string = string + (string.length() > 0 ? ", " + Integer.toString(i + 1) : Integer.toString(i + 1));
            }
            viewLayout.setRepeatEndingStyle(tGPainter);
            tGPainter.initPath();
            tGPainter.moveTo(f2, f5);
            tGPainter.lineTo(f2, f4);
            tGPainter.lineTo(f3, f4);
            tGPainter.closePath();
            tGPainter.drawString(string, Math.round(f2 + 5.0f * f), Math.round(f4 + 2.0f * f));
        }
    }

    public void paintComponents(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        Iterator iterator = this.getBeats().iterator();
        while (iterator.hasNext()) {
            TGBeatImpl tGBeatImpl = (TGBeatImpl)iterator.next();
            tGBeatImpl.paint(viewLayout, tGPainter, n + this.getHeaderImpl().getLeftSpacing(viewLayout), n2);
        }
    }

    private void paintDivisions(ViewLayout viewLayout, TGPainter tGPainter) {
        int n = this.getPosX();
        int n2 = this.getPosX() + this.getWidth(viewLayout);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = viewLayout.getStyle();
        boolean bl = false;
        if ((n6 & 4) != 0) {
            n3 = this.getPosY() + this.getTs().getPosition(7);
            n4 = n3 + viewLayout.getScoreLineSpacing() * 4;
            bl = true;
            if ((n6 & 8) != 0 && (viewLayout.isFirstMeasure(this) || this.isFirstOfLine())) {
                n5 = this.getPosY() + this.getTs().getPosition(17) - n4;
            }
            this.paintDivisions(viewLayout, tGPainter, n, n3, n2, n4, n5, bl);
        }
        if ((n6 & 8) != 0) {
            n3 = this.getPosY() + this.getTs().getPosition(17);
            n4 = n3 + (this.getTrack().getStrings().size() - 1) * viewLayout.getStringSpacing();
            bl = (n6 & 4) == 0;
            n5 = 0;
            this.paintDivisions(viewLayout, tGPainter, n, n3, n2, n4, n5, bl);
        }
    }

    private void paintDivisions(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2, int n3, int n4, int n5, boolean bl) {
        float f;
        float f2;
        float f3 = viewLayout.getScale();
        int n6 = 1;
        int n7 = Math.max(n6, Math.round(3.0f * f3));
        if (bl) {
            String string = Integer.toString(this.getNumber());
            viewLayout.setMeasureNumberStyle(tGPainter);
            tGPainter.drawString(string, this.getPosX() + Math.round(f3), n2 - tGPainter.getStringExtent((String)string).y - Math.round(f3));
        }
        viewLayout.setDivisionsStyle(tGPainter, true);
        if (this.isRepeatOpen() || viewLayout.isFirstMeasure(this)) {
            tGPainter.initPath(3);
            tGPainter.setLineWidth(n6);
            tGPainter.addRectangle(n, n2, n7, n4 + n5 - n2);
            tGPainter.closePath();
            tGPainter.initPath();
            tGPainter.setLineWidth(n6);
            tGPainter.moveTo((float)(n + n7) + f3 + (float)n6, n2);
            tGPainter.lineTo((float)(n + n7) + f3 + (float)n6, n4 + n5);
            tGPainter.closePath();
            if (this.isRepeatOpen()) {
                int n8 = Math.max(1, Math.round(4.0f * f3));
                f2 = (float)n7 + f3 + (float)n6 + 2.0f * f3;
                f = (float)n7 + f3 + (float)n6 + 2.0f * f3;
                tGPainter.setLineWidth(n6);
                tGPainter.initPath(2);
                tGPainter.moveTo((float)n + f2, (float)(n2 + (n4 - n2) / 2) - (f + (float)(n8 / 2)));
                tGPainter.addOval((float)n + f2, (float)(n2 + (n4 - n2) / 2) - (f + (float)(n8 / 2)), n8, n8);
                tGPainter.moveTo((float)n + f2, (float)(n2 + (n4 - n2) / 2) + (f - (float)(n8 / 2)));
                tGPainter.addOval((float)n + f2, (float)(n2 + (n4 - n2) / 2) + (f - (float)(n8 / 2)), n8, n8);
                tGPainter.closePath();
            }
        } else {
            tGPainter.initPath();
            tGPainter.setLineWidth(n6);
            tGPainter.moveTo(n, n2);
            tGPainter.lineTo(n, n4 + n5);
            tGPainter.closePath();
        }
        if (this.getRepeatClose() > 0 || viewLayout.isLastMeasure(this)) {
            tGPainter.initPath();
            tGPainter.setLineWidth(n6);
            tGPainter.moveTo((float)(n3 + this.getSpacing()) - ((float)n7 + f3 + (float)n6), n2);
            tGPainter.lineTo((float)(n3 + this.getSpacing()) - ((float)n7 + f3 + (float)n6), n4);
            tGPainter.closePath();
            tGPainter.initPath(3);
            tGPainter.setLineWidth(n6);
            tGPainter.addRectangle(n3 + this.getSpacing() - n7, n2, n7, n4 - n2);
            tGPainter.closePath();
            if (this.getRepeatClose() > 0) {
                int n9 = Math.max(1, Math.round(4.0f * f3));
                f2 = (float)n7 + f3 + (float)n6 + 2.0f * f3 + (float)n9;
                f = (float)n7 + f3 + (float)n6 + 2.0f * f3;
                tGPainter.setLineWidth(n6);
                tGPainter.initPath(2);
                tGPainter.moveTo((float)n3 - f2 + (float)this.getSpacing(), (float)(n2 + (n4 - n2) / 2) - (f + (float)(n9 / 2)));
                tGPainter.addOval((float)n3 - f2 + (float)this.getSpacing(), (float)(n2 + (n4 - n2) / 2) - (f + (float)(n9 / 2)), n9, n9);
                tGPainter.moveTo((float)n3 - f2 + (float)this.getSpacing(), (float)(n2 + (n4 - n2) / 2) + (f - (float)(n9 / 2)));
                tGPainter.addOval((float)n3 - f2 + (float)this.getSpacing(), (float)(n2 + (n4 - n2) / 2) + (f - (float)(n9 / 2)), n9, n9);
                tGPainter.closePath();
                if (bl) {
                    viewLayout.setDivisionsStyle(tGPainter, false);
                    String string = "x" + this.getRepeatClose();
                    Point point = tGPainter.getStringExtent(string);
                    tGPainter.drawString(string, n3 - point.x + this.getSpacing() - n9, n2 - point.y - Math.round(f3));
                }
            }
        } else {
            tGPainter.initPath();
            tGPainter.setLineWidth(n6);
            tGPainter.moveTo(n3 + this.getSpacing(), n2);
            tGPainter.lineTo(n3 + this.getSpacing(), n4);
            tGPainter.closePath();
        }
        tGPainter.setLineWidth(n6);
    }

    private void paintClef(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        if ((viewLayout.getStyle() & 4) != 0 && this.paintClef) {
            int n3 = n + Math.round(14.0f * viewLayout.getScale());
            int n4 = n2 + this.getTs().getPosition(7);
            viewLayout.setClefStyle(tGPainter);
            tGPainter.initPath(2);
            if (this.getClef() == 1) {
                TGClefPainter.paintTreble(tGPainter, n3, n4, viewLayout.getScoreLineSpacing());
            } else if (this.getClef() == 2) {
                TGClefPainter.paintBass(tGPainter, n3, n4, viewLayout.getScoreLineSpacing());
            } else if (this.getClef() == 3) {
                TGClefPainter.paintTenor(tGPainter, n3, n4, viewLayout.getScoreLineSpacing());
            } else if (this.getClef() == 4) {
                TGClefPainter.paintAlto(tGPainter, n3, n4, viewLayout.getScoreLineSpacing());
            }
            tGPainter.closePath();
        }
    }

    private void paintKeySignature(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        block14: {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            float f;
            block15: {
                float f2;
                if ((viewLayout.getStyle() & 4) == 0 || !this.paintKeySignature) break block14;
                f = viewLayout.getScoreLineSpacing();
                n7 = n + this.getClefSpacing(viewLayout) + 10;
                n6 = n2 + this.getTs().getPosition(7);
                int n8 = this.getKeySignature();
                n5 = this.prevMeasure != null ? this.prevMeasure.getKeySignature() : 0;
                n4 = 0;
                if (this.getClef() == 1) {
                    n4 = 0;
                } else if (this.getClef() == 2) {
                    n4 = 2;
                } else if (this.getClef() == 3) {
                    n4 = -1;
                } else if (this.getClef() == 4) {
                    n4 = 1;
                }
                viewLayout.setKeySignatureStyle(tGPainter);
                if (n8 >= 1 && n8 <= 7) {
                    for (n3 = 0; n3 < n8; ++n3) {
                        f2 = f / 2.0f * (float)((SCORE_KEY_SHARP_POSITIONS[n3] + n4 + 7) % 7) - f / 2.0f;
                        tGPainter.initPath(2);
                        TGKeySignaturePainter.paintSharp(tGPainter, n7, (float)n6 + f2, f);
                        tGPainter.closePath();
                        n7 = (int)((float)n7 + (f - f / 4.0f));
                    }
                } else if (n8 >= 8 && n8 <= 14) {
                    for (n3 = 7; n3 < n8; ++n3) {
                        f2 = f / 2.0f * (float)((SCORE_KEY_FLAT_POSITIONS[n3 - 7] + n4 + 7) % 7) - f / 2.0f;
                        tGPainter.initPath(2);
                        TGKeySignaturePainter.paintFlat(tGPainter, n7, (float)n6 + f2, f);
                        tGPainter.closePath();
                        n7 = (int)((float)n7 + (f - f / 4.0f));
                    }
                }
                if (n5 < 1 || n5 > 7) break block15;
                for (int i = n3 = n8 >= 1 && n8 <= 7 ? n8 : 0; i < n5; ++i) {
                    float f3 = f / 2.0f * (float)((SCORE_KEY_SHARP_POSITIONS[i] + n4 + 7) % 7) - f / 2.0f;
                    tGPainter.initPath(2);
                    TGKeySignaturePainter.paintNatural(tGPainter, n7, (float)n6 + f3, f);
                    tGPainter.closePath();
                    n7 = (int)((float)n7 + (f - f / 4.0f));
                }
                break block14;
            }
            if (n5 < 8 || n5 > 14) break block14;
            for (int i = n3 = n8 >= 8 && n8 <= 14 ? n8 : 7; i < n5; ++i) {
                float f4 = f / 2.0f * (float)((SCORE_KEY_FLAT_POSITIONS[i - 7] + n4 + 7) % 7) - f / 2.0f;
                tGPainter.initPath(2);
                TGKeySignaturePainter.paintNatural(tGPainter, n7, (float)n6 + f4, f);
                tGPainter.closePath();
                n7 = (int)((float)n7 + (f - f / 4.0f));
            }
        }
    }

    private void paintTimeSignature(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        if (this.getHeaderImpl().shouldPaintTimeSignature()) {
            viewLayout.setTimeSignatureStyle(tGPainter);
            float f = viewLayout.getScale();
            int n3 = viewLayout.getStyle();
            int n4 = Math.round(5.0f * f);
            int n5 = this.getClefSpacing(viewLayout) + this.getKeySignatureSpacing(viewLayout) + this.getHeaderImpl().getLeftSpacing(viewLayout) + n4;
            String string = Integer.toString(this.getTimeSignature().getNumerator());
            String string2 = Integer.toString(this.getTimeSignature().getDenominator().getValue());
            if ((n3 & 4) != 0) {
                int n6 = this.getTs().getPosition(7);
                int n7 = (int)((float)n6 - 3.0f * f);
                int n8 = (int)((float)(n6 + viewLayout.getScoreLineSpacing() * 4 - tGPainter.getStringExtent((String)string2).y) + 3.0f * f);
                tGPainter.drawString(string, n + n5, n2 + n7, true);
                tGPainter.drawString(string2, n + n5, n2 + n8, true);
            } else if ((n3 & 8) != 0) {
                int n9 = this.getTs().getPosition(17);
                int n10 = (int)((8.0f - (float)this.getTrack().stringCount()) * f);
                int n11 = n9 - n10;
                int n12 = n9 + this.getTrackImpl().getTabHeight() - tGPainter.getStringExtent((String)string2).y + n10;
                tGPainter.drawString(string, n + n5, n2 + n11, true);
                tGPainter.drawString(string2, n + n5, n2 + n12, true);
            }
        }
    }

    private void paintTempo(ViewLayout viewLayout, TGPainter tGPainter) {
        if (this.getHeaderImpl().shouldPaintTempo()) {
            float f = 5.0f * viewLayout.getScale();
            int n = this.getPosX() + this.getHeaderImpl().getLeftSpacing(viewLayout);
            int n2 = this.getPosY();
            int n3 = Math.max(viewLayout.getScoreLineSpacing(), viewLayout.getStringSpacing());
            int n4 = viewLayout.getStyle();
            if ((n4 & 4) != 0) {
                n2 += this.getTs().getPosition(7) - n3;
            } else if ((n4 & 8) != 0) {
                n2 += this.getTs().getPosition(17) - n3;
            }
            viewLayout.setTempoStyle(tGPainter, false);
            int n5 = n;
            int n6 = n2 - (Math.round(f * 3.5f) + 2);
            if (viewLayout.isBufferEnabled()) {
                tGPainter.drawImage(viewLayout.getResources().getTempoImage(), n5, n6);
            } else {
                TGTempoPainter.paintTempo(tGPainter, n5, n6, f);
            }
            viewLayout.setTempoStyle(tGPainter, true);
            String string = " = " + this.getTempo().getValue();
            int n7 = n + (Math.round(1.33f * f) + 1);
            int n8 = Math.round((float)(n2 - tGPainter.getStringExtent((String)string).y) - 1.0f * viewLayout.getScale());
            tGPainter.drawString(string, n7, n8, true);
        }
    }

    private void paintTripletFeel(ViewLayout viewLayout, TGPainter tGPainter) {
        if (this.getHeaderImpl().shouldPaintTripletFeel()) {
            float f = 5.0f * viewLayout.getScale();
            int n = this.getPosX() + this.getHeaderImpl().getLeftSpacing(viewLayout) + this.getHeaderImpl().getTempoSpacing(viewLayout);
            int n2 = this.getPosY();
            int n3 = Math.max(viewLayout.getScoreLineSpacing(), viewLayout.getStringSpacing());
            int n4 = viewLayout.getStyle();
            if ((n4 & 4) != 0) {
                n2 += this.getTs().getPosition(7) - n3;
            } else if ((n4 & 8) != 0) {
                n2 += this.getTs().getPosition(17) - n3;
            }
            viewLayout.setTripletFeelStyle(tGPainter, true);
            String string = " = ";
            Point point = tGPainter.getStringExtent(string);
            int n5 = n + Math.round(1.33f * f + 1.5f * f);
            int n6 = Math.round((float)(n2 - point.y) - 1.0f * viewLayout.getScale());
            tGPainter.drawString(string, n5, n6, true);
            viewLayout.setTripletFeelStyle(tGPainter, false);
            int n7 = n;
            int n8 = n + (Math.round(1.33f * f + 1.5f * f) + point.x);
            int n9 = n2 - (Math.round(1.0f * f + 2.5f * f) + 2);
            int n10 = n2 - (Math.round(1.0f * f + 2.5f * f + 1.0f * f) + 2);
            if (this.getTripletFeel() == 1 && this.prevMeasure != null) {
                int n11 = this.prevMeasure.getTripletFeel();
                if (n11 == 2) {
                    if (viewLayout.isBufferEnabled()) {
                        tGPainter.drawImage(viewLayout.getResources().getTripletFeel8(), n7, n10);
                        tGPainter.drawImage(viewLayout.getResources().getTripletFeelNone8(), n8, n9);
                    } else {
                        TGTripletFeelPainter.paintTripletFeel8(tGPainter, n7, n10, f);
                        TGTripletFeelPainter.paintTripletFeelNone8(tGPainter, n8, n9, f);
                    }
                } else if (n11 == 3) {
                    if (viewLayout.isBufferEnabled()) {
                        tGPainter.drawImage(viewLayout.getResources().getTripletFeel16(), n7, n10);
                        tGPainter.drawImage(viewLayout.getResources().getTripletFeelNone16(), n8, n9);
                    } else {
                        TGTripletFeelPainter.paintTripletFeel16(tGPainter, n7, n10, f);
                        TGTripletFeelPainter.paintTripletFeelNone16(tGPainter, n8, n9, f);
                    }
                }
            } else if (this.getTripletFeel() == 2) {
                if (viewLayout.isBufferEnabled()) {
                    tGPainter.drawImage(viewLayout.getResources().getTripletFeelNone8(), n7, n9);
                    tGPainter.drawImage(viewLayout.getResources().getTripletFeel8(), n8, n10);
                } else {
                    TGTripletFeelPainter.paintTripletFeelNone8(tGPainter, n7, n9, f);
                    TGTripletFeelPainter.paintTripletFeel8(tGPainter, n8, n10, f);
                }
            } else if (this.getTripletFeel() == 3) {
                if (viewLayout.isBufferEnabled()) {
                    tGPainter.drawImage(viewLayout.getResources().getTripletFeelNone16(), n7, n9);
                    tGPainter.drawImage(viewLayout.getResources().getTripletFeel16(), n8, n10);
                } else {
                    TGTripletFeelPainter.paintTripletFeelNone16(tGPainter, n7, n9, f);
                    TGTripletFeelPainter.paintTripletFeel16(tGPainter, n8, n10, f);
                }
            }
        }
    }

    private void paintMarker(ViewLayout viewLayout, TGPainter tGPainter) {
        if (this.hasMarker()) {
            int n = this.getPosX() + this.getHeaderImpl().getLeftSpacing(viewLayout) + this.getFirstNoteSpacing(viewLayout);
            int n2 = this.getPosY() + this.getTs().getPosition(1);
            viewLayout.setMarkerStyle(tGPainter);
            tGPainter.setForeground(this.getMarkerColor());
            tGPainter.drawString(this.getMarker().getTitle(), n, n2);
        }
    }

    private void paintTexts(ViewLayout viewLayout, TGPainter tGPainter) {
        Iterator iterator = this.getBeats().iterator();
        while (iterator.hasNext()) {
            TGBeat tGBeat = (TGBeat)iterator.next();
            if (!tGBeat.isTextBeat()) continue;
            TGTextImpl tGTextImpl = (TGTextImpl)tGBeat.getText();
            tGTextImpl.paint(viewLayout, tGPainter, this.getPosX() + this.getHeaderImpl().getLeftSpacing(viewLayout), this.getPosY());
        }
    }

    private void paintPlayMode(ViewLayout viewLayout, TGPainter tGPainter) {
        if (viewLayout.isPlayModeEnabled() && this.isPlaying(viewLayout)) {
            float f = viewLayout.getScale();
            int n = this.getWidth(viewLayout) + this.getSpacing();
            int n2 = this.getPosY();
            int n3 = this.getPosY();
            int n4 = viewLayout.getStyle();
            if ((n4 & 0xC) == 12) {
                n2 += this.getTs().getPosition(7) - viewLayout.getScoreLineSpacing();
                n3 += this.getTs().getPosition(17) + this.getTrackImpl().getTabHeight() + viewLayout.getStringSpacing();
            } else if ((n4 & 4) != 0) {
                n2 += this.getTs().getPosition(7) - viewLayout.getScoreLineSpacing();
                n3 += this.getTs().getPosition(7) + viewLayout.getScoreLineSpacing() * 5;
            } else if ((n4 & 8) != 0) {
                n2 += this.getTs().getPosition(17) - viewLayout.getStringSpacing();
                n3 += this.getTs().getPosition(17) + this.getTrackImpl().getTabHeight() + viewLayout.getStringSpacing();
            }
            viewLayout.setMeasurePlayingStyle(tGPainter);
            tGPainter.setLineWidth(1);
            tGPainter.initPath();
            tGPainter.addRectangle((float)this.getPosX() + 5.0f * f, n2, (float)n - 10.0f * f, n3 - n2);
            tGPainter.closePath();
        }
    }

    public boolean isPlaying(ViewLayout viewLayout) {
        return this.getTrackImpl().hasCaret(viewLayout) && TuxGuitar.instance().getEditorCache().isPlaying(this);
    }

    public int getBeatSpacing(TGBeat tGBeat) {
        return (int)((tGBeat.getStart() - this.getStart()) * (long)this.getSpacing() / this.getLength());
    }

    public boolean hasTrack(int n) {
        return this.getTrack().getNumber() == n;
    }

    public int getWidth(ViewLayout viewLayout) {
        return (viewLayout.getStyle() & 2) != 0 ? this.getHeaderImpl().getMaxWidth() : this.width;
    }

    private int calculateKeySignatureSpacing(ViewLayout viewLayout) {
        int n = 0;
        if (this.paintKeySignature) {
            n = this.getKeySignature() <= 7 ? (n += Math.round(6.0f * viewLayout.getScale() * (float)this.getKeySignature())) : (n += Math.round(6.0f * viewLayout.getScale() * (float)(this.getKeySignature() - 7)));
            if (this.prevMeasure != null) {
                n = this.prevMeasure.getKeySignature() <= 7 ? (n += Math.round(6.0f * viewLayout.getScale() * (float)this.prevMeasure.getKeySignature())) : (n += Math.round(6.0f * viewLayout.getScale() * (float)(this.prevMeasure.getKeySignature() - 7)));
            }
        }
        return n;
    }

    public int getFirstNoteSpacing(ViewLayout viewLayout) {
        return this.getHeaderImpl().getFirstNoteSpacing(viewLayout, this);
    }

    public int getClefSpacing(ViewLayout viewLayout) {
        return this.getHeaderImpl().getClefSpacing(viewLayout, this);
    }

    public int getKeySignatureSpacing(ViewLayout viewLayout) {
        return this.getHeaderImpl().getKeySignatureSpacing(viewLayout, this);
    }

    public long getDivisionLength() {
        return this.divisionLength;
    }

    public boolean isBufferCreated() {
        return this.bufferCreated;
    }

    public void setBufferCreated(boolean bl) {
        this.bufferCreated = bl;
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int n) {
        this.posX = n;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int n) {
        this.posY = n;
    }

    private int getQuarterSpacing() {
        return this.quarterSpacing;
    }

    private int getMaxQuarterSpacing(ViewLayout viewLayout) {
        return (viewLayout.getStyle() & 2) != 0 ? this.getHeaderImpl().getMaxQuarterSpacing() : this.quarterSpacing;
    }

    public TGMeasureHeaderImpl getHeaderImpl() {
        return (TGMeasureHeaderImpl)super.getHeader();
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int n) {
        if (n != this.spacing) {
            this.setBufferCreated(false);
        }
        this.spacing = n;
    }

    public boolean isOutOfBounds() {
        return this.outOfBounds;
    }

    public void setOutOfBounds(boolean bl) {
        this.outOfBounds = bl;
    }

    public boolean isFirstOfLine() {
        return this.firstOfLine;
    }

    public void setFirstOfLine(boolean bl) {
        this.firstOfLine = bl;
    }

    public TGTrackImpl getTrackImpl() {
        return (TGTrackImpl)super.getTrack();
    }

    public TrackSpacing getTs() {
        return this.ts;
    }

    public void setTs(TrackSpacing trackSpacing) {
        if (this.getTs() == null) {
            this.setBufferCreated(false);
        } else if (this.getTs().getPosition(7) != trackSpacing.getPosition(7)) {
            this.setBufferCreated(false);
        } else if (this.getTs().getPosition(17) != trackSpacing.getPosition(17)) {
            this.setBufferCreated(false);
        }
        this.ts = trackSpacing;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getNotEmptyBeats() {
        return this.notEmptyBeats;
    }

    public int getNotEmptyVoices() {
        return this.notEmptyVoices;
    }

    public int getLyricBeatIndex() {
        return this.lyricBeatIndex;
    }

    public void setLyricBeatIndex(int n) {
        this.lyricBeatIndex = n;
    }

    public boolean isPaintClef() {
        return this.paintClef;
    }

    public boolean isPaintKeySignature() {
        return this.paintKeySignature;
    }

    public boolean isDisposed() {
        return this.getBuffer().isDisposed();
    }

    public TGMeasureBuffer getBuffer() {
        if (this.buffer == null) {
            this.buffer = new TGMeasureBuffer((Device)TuxGuitar.instance().getDisplay());
        }
        return this.buffer;
    }

    public Color getMarkerColor() {
        TGColor tGColor = this.getMarker().getColor();
        if (this.markerColor != null && !this.markerColor.isDisposed()) {
            RGB rGB = this.markerColor.getRGB();
            if (rGB.red != tGColor.getR() || rGB.green != tGColor.getG() || rGB.blue != tGColor.getB()) {
                this.disposeMarkerColor();
            }
        }
        if (this.markerColor == null || this.markerColor.isDisposed()) {
            this.markerColor = new Color((Device)TuxGuitar.instance().getDisplay(), tGColor.getR(), tGColor.getG(), tGColor.getB());
        }
        return this.markerColor;
    }

    public void disposeMarkerColor() {
        if (this.markerColor != null && !this.markerColor.isDisposed()) {
            this.markerColor.dispose();
            this.markerColor = null;
        }
    }

    public void dispose() {
        new SyncThread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    TGMeasureImpl.this.getBuffer().dispose();
                    TGMeasureImpl.this.disposeMarkerColor();
                    Iterator iterator = TGMeasureImpl.this.getBeats().iterator();
                    while (iterator.hasNext()) {
                        TGBeatImpl tGBeatImpl = (TGBeatImpl)iterator.next();
                        tGBeatImpl.dispose();
                    }
                }
            }
        }).start();
    }
}

