/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.Iterator;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.TGBeatGroup;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGNoteImpl;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.editors.tab.painters.TGNotePainter;
import org.herac.tuxguitar.gui.editors.tab.painters.TGSilencePainter;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGTupleto;
import org.herac.tuxguitar.song.models.TGVoice;

public class TGVoiceImpl
extends TGVoice {
    public static final int JOINED_TYPE_NONE_LEFT = 1;
    public static final int JOINED_TYPE_NONE_RIGHT = 2;
    public static final int JOINED_TYPE_LEFT = 3;
    public static final int JOINED_TYPE_RIGHT = 4;
    private int width;
    private TGNoteImpl maxNote;
    private TGNoteImpl minNote;
    private boolean[] usedStrings;
    private int joinedType;
    private boolean joinedGreaterThanQuarter;
    private TGVoiceImpl join1;
    private TGVoiceImpl join2;
    private TGVoiceImpl previous;
    private TGVoiceImpl next;
    private TGBeatGroup group;
    private boolean hiddenSilence;
    private int maxY;
    private int minY;
    private float silenceY;
    private float silenceHeight;
    private int maxString;
    private int minString;

    public TGVoiceImpl(TGFactory tGFactory, int n) {
        super(tGFactory, n);
    }

    public int getPosX() {
        return this.getBeatImpl().getPosX();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public TGNoteImpl getMinNote() {
        return this.minNote;
    }

    public TGNoteImpl getMaxNote() {
        return this.maxNote;
    }

    public TGBeatImpl getBeatImpl() {
        return (TGBeatImpl)this.getBeat();
    }

    public TGMeasureImpl getMeasureImpl() {
        return (TGMeasureImpl)this.getBeat().getMeasure();
    }

    public boolean[] getUsedStrings() {
        if (this.usedStrings == null) {
            this.usedStrings = new boolean[this.getBeat().getMeasure().getTrack().stringCount()];
        }
        return this.usedStrings;
    }

    public TGVoiceImpl getJoin1() {
        return this.join1;
    }

    public void setJoin1(TGVoiceImpl tGVoiceImpl) {
        this.join1 = tGVoiceImpl;
    }

    public TGVoiceImpl getJoin2() {
        return this.join2;
    }

    public void setJoin2(TGVoiceImpl tGVoiceImpl) {
        this.join2 = tGVoiceImpl;
    }

    public boolean isJoinedGreaterThanQuarter() {
        return this.joinedGreaterThanQuarter;
    }

    public void setJoinedGreaterThanQuarter(boolean bl) {
        this.joinedGreaterThanQuarter = bl;
    }

    public int getJoinedType() {
        return this.joinedType;
    }

    public void setJoinedType(int n) {
        this.joinedType = n;
    }

    public void setPreviousBeat(TGVoiceImpl tGVoiceImpl) {
        this.previous = tGVoiceImpl;
    }

    public void setNextBeat(TGVoiceImpl tGVoiceImpl) {
        this.next = tGVoiceImpl;
    }

    public TGBeatGroup getBeatGroup() {
        return this.group;
    }

    public void setBeatGroup(TGBeatGroup tGBeatGroup) {
        this.group = tGBeatGroup;
    }

    public boolean isPlaying(ViewLayout viewLayout) {
        return this.getMeasureImpl().isPlaying(viewLayout) && TuxGuitar.instance().getEditorCache().isPlaying(this.getBeat().getMeasure(), this.getBeat());
    }

    public void reset() {
        this.maxNote = null;
        this.minNote = null;
        this.hiddenSilence = false;
        this.usedStrings = new boolean[this.getBeat().getMeasure().getTrack().stringCount()];
        this.maxString = 1;
        this.minString = this.getBeat().getMeasure().getTrack().stringCount();
    }

    public void check(TGNoteImpl tGNoteImpl) {
        int n = tGNoteImpl.getRealValue();
        if (this.maxNote == null || n > this.maxNote.getRealValue()) {
            this.maxNote = tGNoteImpl;
        }
        if (this.minNote == null || n < this.minNote.getRealValue()) {
            this.minNote = tGNoteImpl;
        }
        this.getUsedStrings();
        this.usedStrings[tGNoteImpl.getString() - 1] = true;
        if (tGNoteImpl.getString() > this.maxString) {
            this.maxString = tGNoteImpl.getString();
        }
        if (tGNoteImpl.getString() < this.minString) {
            this.minString = tGNoteImpl.getString();
        }
    }

    public void update(ViewLayout viewLayout) {
        this.minY = 0;
        this.maxY = 0;
        if (this.isRestVoice()) {
            this.updateSilenceSpacing(viewLayout);
        } else {
            this.updateNoteVoice(viewLayout);
        }
    }

    public void updateNoteVoice(ViewLayout viewLayout) {
        this.joinedType = 2;
        this.joinedGreaterThanQuarter = false;
        this.setJoin1(this);
        this.setJoin2(this);
        boolean bl = false;
        boolean bl2 = false;
        if (this.previous != null && !this.previous.isRestVoice() && this.getMeasureImpl().canJoin(viewLayout.getSongManager(), this, this.previous)) {
            bl2 = true;
            if (this.previous.getDuration().getValue() >= this.getDuration().getValue()) {
                this.setJoin1(this.previous);
                this.setJoin2(this);
                this.joinedType = 3;
                bl = true;
            }
            if (this.previous.getDuration().getValue() > 4) {
                this.joinedGreaterThanQuarter = true;
            }
        }
        if (this.next != null && !this.next.isRestVoice() && this.getMeasureImpl().canJoin(viewLayout.getSongManager(), this, this.next)) {
            if (this.next.getDuration().getValue() >= this.getDuration().getValue()) {
                this.setJoin2(this.next);
                if (this.previous == null || this.previous.isRestVoice() || this.previous.getDuration().getValue() < this.getDuration().getValue()) {
                    this.setJoin1(this);
                }
                bl = true;
                this.joinedType = 4;
            }
            if (this.next.getDuration().getValue() > 4) {
                this.joinedGreaterThanQuarter = true;
            }
        }
        if (!bl && bl2) {
            this.joinedType = 1;
        }
        if ((viewLayout.getStyle() & 8) != 0 && (viewLayout.getStyle() & 4) == 0) {
            this.minY = 0;
            this.maxY = this.getBeatImpl().getMeasureImpl().getTrackImpl().getTabHeight();
            if (this.getBeatGroup().getDirection() == 2) {
                this.maxY += viewLayout.getStringSpacing() / 2 * 5 + 1;
            } else {
                this.minY -= viewLayout.getStringSpacing() / 2 * 5 + 1;
            }
        }
    }

    public void updateSilenceSpacing(ViewLayout viewLayout) {
        this.silenceY = 0.0f;
        this.silenceHeight = 0.0f;
        if (!this.isHiddenSilence()) {
            int n = viewLayout.getStyle();
            int n2 = 0;
            int n3 = 0;
            float f = 0.0f;
            if ((n & 4) != 0) {
                n2 = viewLayout.getScoreLineSpacing();
                n3 = 5;
                f = (float)n2 / 9.0f;
            } else {
                n2 = viewLayout.getStringSpacing();
                n3 = this.getBeat().getMeasure().getTrack().stringCount();
                f = (float)n2 / 10.0f;
            }
            int n4 = this.getDuration().getValue();
            if (n4 == 1) {
                this.silenceHeight = n2;
                this.silenceY = n3 <= 5 ? n2 : n2 * 2;
            } else if (n4 == 2) {
                this.silenceHeight = n2;
                this.silenceY = (float)(n3 <= 5 ? n2 * 2 : n2 * 3) - this.silenceHeight;
            } else if (n4 == 4) {
                this.silenceHeight = f * 16.0f;
                this.silenceY = (float)(n2 * (n3 - 1) / 2) - this.silenceHeight / 2.0f;
            } else if (n4 == 8) {
                this.silenceHeight = f * 12.0f;
                this.silenceY = (float)(n2 * (n3 - 1) / 2) - this.silenceHeight / 2.0f;
            } else if (n4 == 16) {
                this.silenceHeight = f * 16.0f;
                this.silenceY = (float)(n2 * (n3 - 1) / 2) - this.silenceHeight / 2.0f;
            } else if (n4 == 32) {
                this.silenceHeight = f * 24.0f;
                this.silenceY = (float)(n2 * (n3 - 1) / 2) - this.silenceHeight / 2.0f;
            } else if (n4 == 64) {
                this.silenceHeight = f * 28.0f;
                this.silenceY = (float)(n2 * (n3 - 1) / 2) - this.silenceHeight / 2.0f;
            }
            for (int i = 0; i < this.getBeat().countVoices(); ++i) {
                float f2;
                TGVoiceImpl tGVoiceImpl;
                if (i == this.getIndex() || (tGVoiceImpl = this.getBeatImpl().getVoiceImpl(i)).isEmpty()) continue;
                if (tGVoiceImpl.isRestVoice()) {
                    if (tGVoiceImpl.isHiddenSilence()) continue;
                    float f3 = n2 * 3;
                    f2 = this.silenceY - f3 / (float)this.getBeat().countVoices();
                    this.silenceY = f2 + f3 * (float)this.getIndex();
                    continue;
                }
                if ((viewLayout.getStyle() & 4) != 0) {
                    float f4;
                    int n5 = tGVoiceImpl.getBeatGroup().getDirection();
                    int n6 = tGVoiceImpl.getBeatGroup().getY1(viewLayout, tGVoiceImpl.getMinNote(), this.getMeasureImpl().getKeySignature(), this.getMeasureImpl().getClef());
                    int n7 = tGVoiceImpl.getBeatGroup().getY1(viewLayout, tGVoiceImpl.getMaxNote(), this.getMeasureImpl().getKeySignature(), this.getMeasureImpl().getClef());
                    if (n5 == 1) {
                        f4 = n6 + n2 * 2;
                        if (!(f4 > this.silenceY)) continue;
                        this.silenceY = f4;
                        continue;
                    }
                    if (n5 != 2 || !((f4 = (float)n7 - (this.silenceHeight + (float)n2)) < this.silenceY)) continue;
                    this.silenceY = f4;
                    continue;
                }
                if ((viewLayout.getStyle() & 8) == 0) continue;
                int n8 = tGVoiceImpl.getBeatGroup().getDirection();
                if (n8 == 1) {
                    f2 = n2 * tGVoiceImpl.getMaxString();
                    if (!(f2 > this.silenceY)) continue;
                    this.silenceY = f2;
                    continue;
                }
                if (n8 != 2 || !((f2 = (float)(n2 * (tGVoiceImpl.getMinString() - 1)) - (this.silenceHeight + (float)n2)) < this.silenceY)) continue;
                this.silenceY = f2;
            }
            this.minY = (int)this.silenceY;
            this.maxY = (int)(this.silenceY + this.silenceHeight);
        }
    }

    public void paint(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        if (!this.isEmpty()) {
            if (this.isRestVoice() && !this.isHiddenSilence()) {
                this.paintSilence(viewLayout, tGPainter, n, n2);
            } else {
                Iterator iterator = this.getNotes().iterator();
                while (iterator.hasNext()) {
                    TGNoteImpl tGNoteImpl = (TGNoteImpl)iterator.next();
                    tGNoteImpl.paint(viewLayout, tGPainter, n, n2);
                }
                if (!viewLayout.isPlayModeEnabled()) {
                    this.paintBeat(viewLayout, tGPainter, n, n2);
                }
            }
        }
    }

    public void paintSilence(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        int n3 = viewLayout.getStyle();
        int n4 = 0;
        int n5 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        if ((n3 & 4) != 0) {
            n4 = n + this.getPosX() + this.getBeatImpl().getSpacing();
            f = (float)(n2 + this.getPaintPosition(7)) + this.silenceY;
            n5 = viewLayout.getScoreLineSpacing();
            f2 = (float)n5 / 9.0f;
        } else {
            n4 = n + this.getPosX() + this.getBeatImpl().getSpacing() - 1;
            f = (float)(n2 + this.getPaintPosition(17)) + this.silenceY;
            n5 = viewLayout.getStringSpacing();
            f2 = (float)n5 / 10.0f;
        }
        this.setStyle(viewLayout, tGPainter, viewLayout.isPlayModeEnabled() && this.isPlaying(viewLayout));
        tGPainter.initPath(2);
        int n6 = this.getDuration().getValue();
        if (n6 == 1) {
            TGSilencePainter.paintWhole(tGPainter, n4, f, f2);
        } else if (n6 == 2) {
            TGSilencePainter.paintHalf(tGPainter, n4, f, f2);
        } else if (n6 == 4) {
            TGSilencePainter.paintQuarter(tGPainter, n4, f, f2);
        } else if (n6 == 8) {
            TGSilencePainter.paintEighth(tGPainter, n4, f, f2);
        } else if (n6 == 16) {
            TGSilencePainter.paintSixteenth(tGPainter, n4, f, f2);
        } else if (n6 == 32) {
            TGSilencePainter.paintThirtySecond(tGPainter, n4, f, f2);
        } else if (n6 == 64) {
            TGSilencePainter.paintSixtyFourth(tGPainter, n4, f, f2);
        }
        tGPainter.closePath();
        if (this.getDuration().isDotted() || this.getDuration().isDoubleDotted()) {
            viewLayout.setDotStyle(tGPainter);
            tGPainter.initPath();
            tGPainter.moveTo(n4 + 10, f + 1.0f);
            tGPainter.addOval(n4 + 10, f + 1.0f, 1.0f, 1.0f);
            if (this.getDuration().isDoubleDotted()) {
                tGPainter.moveTo(n4 + 13, f + 1.0f);
                tGPainter.addOval(n4 + 13, f + 1.0f, 1.0f, 1.0f);
            }
            tGPainter.closePath();
        }
        if (!this.getDuration().getTupleto().isEqual(TGTupleto.NORMAL)) {
            viewLayout.setTupletoStyle(tGPainter);
            if ((n3 & 4) != 0) {
                tGPainter.drawString(Integer.toString(this.getDuration().getTupleto().getEnters()), n4, n2 + this.getPaintPosition(9));
            } else {
                tGPainter.drawString(Integer.toString(this.getDuration().getTupleto().getEnters()), n4, n2 + this.getPaintPosition(9));
            }
        }
    }

    public void setStyle(ViewLayout viewLayout, TGPainter tGPainter, boolean bl) {
        if ((viewLayout.getStyle() & 4) != 0) {
            viewLayout.setScoreSilenceStyle(tGPainter, bl);
        } else {
            viewLayout.setTabSilenceStyle(tGPainter, bl);
        }
    }

    public void paintBeat(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        if (!this.isRestVoice()) {
            int n3 = viewLayout.getStyle();
            int n4 = this.getBeatImpl().getSpacing();
            if ((n3 & 4) != 0) {
                this.paintScoreBeat(viewLayout, tGPainter, n, n2 + this.getPaintPosition(7), n4);
            }
            if ((n3 & 8) != 0 && (n3 & 4) == 0) {
                this.paintTablatureBeat(viewLayout, tGPainter, n, n2 + this.getPaintPosition(17), n4);
            }
        }
    }

    public void paintTablatureBeat(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2, int n3) {
        if (!this.isRestVoice()) {
            float f;
            float f2 = viewLayout.getScale();
            float f3 = 2.0f * f2;
            float f4 = (float)(n + this.getPosX() + n3) + f3;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = f2;
            float f8 = 2.0f * f2;
            int n4 = viewLayout.getStringSpacing();
            if (this.getBeatGroup().getDirection() == 2) {
                f5 = n2 + this.getMeasureImpl().getTrackImpl().getTabHeight() + n4 / 2;
                f6 = n2 + this.getMeasureImpl().getTrackImpl().getTabHeight() + n4 / 2 * 5;
            } else {
                f5 = (float)(n2 - n4 / 2) - f8;
                f6 = n2 - n4 / 2 * 5;
            }
            if (this.getDuration().getValue() >= 4) {
                viewLayout.setTabNoteFooterStyle(tGPainter);
                tGPainter.initPath();
                tGPainter.setLineWidth((int)f7);
                tGPainter.moveTo(f4, f5);
                tGPainter.lineTo(f4, f6);
                tGPainter.closePath();
                if (this.getDuration().getValue() >= 8) {
                    float f9 = 0.0f;
                    f = 0.0f;
                    int n5 = this.getJoinedType();
                    if (n5 == 2) {
                        f9 = (float)this.getPosX() + f3 + (float)n3;
                        f = (float)this.getPosX() + f3 + (float)n3 + 6.0f * f2;
                    } else if (n5 == 1) {
                        f9 = (float)this.getPosX() + f3 + (float)n3 - 5.0f * f2;
                        f = (float)this.getPosX() + f3 + (float)n3;
                    } else {
                        f9 = (float)this.getJoin1().getPosX() + f3 + (float)this.getJoin1().getBeatImpl().getSpacing();
                        f = (float)this.getJoin2().getPosX() + f3 + (float)this.getJoin2().getBeatImpl().getSpacing();
                    }
                    int n6 = this.getDuration().getIndex() - 2;
                    if (n6 > 0) {
                        int n7 = viewLayout.getStringSpacing() / 2;
                        int n8 = this.getBeatGroup().getDirection() == 2 ? 1 : -1;
                        tGPainter.setLineWidth((int)f8);
                        tGPainter.initPath();
                        for (int i = n6; i > 0; --i) {
                            tGPainter.moveTo((float)n + f9, f6 + (float)((n7 - i * n7) * n8));
                            tGPainter.lineTo((float)n + f, f6 + (float)((n7 - i * n7) * n8));
                        }
                        tGPainter.closePath();
                        tGPainter.setLineWidth(1);
                    }
                }
            } else if (this.getDuration().getValue() == 2) {
                viewLayout.setTabNoteFooterStyle(tGPainter);
                tGPainter.initPath();
                tGPainter.setLineWidth((int)f7);
                tGPainter.moveTo(f4, f5 + (f6 - f5) / 2.0f);
                tGPainter.lineTo(f4, f6);
                tGPainter.closePath();
            }
            if (this.getDuration().isDotted() || this.getDuration().isDoubleDotted()) {
                int n9 = this.getJoinedType();
                f = this.getDuration().getValue() > 1 ? (n9 == 2 || n9 == 4 ? f4 + 4.0f * f2 : f4 - 5.0f * f2) : f4;
                float f10 = f6 - (this.getDuration().getValue() >= 8 ? (float)(n4 / 2 * (this.getDuration().getIndex() - 2)) : 1.0f * f2);
                this.paintDot(viewLayout, tGPainter, f, f10, f2);
            }
            if (!this.getDuration().getTupleto().isEqual(TGTupleto.NORMAL)) {
                viewLayout.setTupletoStyle(tGPainter);
                tGPainter.drawString(Integer.toString(this.getDuration().getTupleto().getEnters()), (int)(f4 - 3.0f), n2 - this.getPaintPosition(17) + this.getPaintPosition(9));
            }
        }
    }

    public void paintScoreBeat(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2, int n3) {
        int n4 = n + this.getPosX() + n3;
        if (!this.getDuration().getTupleto().isEqual(TGTupleto.NORMAL)) {
            viewLayout.setTupletoStyle(tGPainter);
            tGPainter.drawString(Integer.toString(this.getDuration().getTupleto().getEnters()), n4, n2 - this.getPaintPosition(7) + this.getPaintPosition(9));
        }
        if (this.getDuration().getValue() >= 2) {
            int n5;
            viewLayout.setScoreNoteFooterStyle(tGPainter);
            float f = viewLayout.getScale();
            float f2 = viewLayout.getScoreLineSpacing();
            int n6 = this.group.getDirection();
            int n7 = this.getBeat().getMeasure().getKeySignature();
            int n8 = this.getBeat().getMeasure().getClef();
            int n9 = n6 == 1 ? viewLayout.getResources().getScoreNoteWidth() : 0;
            int n10 = n6 == 1 ? viewLayout.getScoreLineSpacing() / 3 + 1 : viewLayout.getScoreLineSpacing() / 3 * 2;
            int n11 = n2 + (n6 == 2 ? this.maxNote.getScorePosY() : this.minNote.getScorePosY());
            int n12 = n2 + this.group.getY2(viewLayout, this.getPosX() + n3, n7, n8);
            tGPainter.initPath();
            tGPainter.moveTo(n4 + n9, n11 + n10);
            tGPainter.lineTo(n4 + n9, n12);
            tGPainter.closePath();
            if (this.getDuration().getValue() >= 8 && (n5 = this.getDuration().getIndex() - 3) >= 0) {
                int n13 = n6 == 2 ? 1 : -1;
                int n14 = this.getJoinedType();
                boolean bl = this.isJoinedGreaterThanQuarter();
                if (!(n14 != 1 && n14 != 2 || bl)) {
                    float f3 = n + n9 + this.getPosX() + n3;
                    float f4 = (float)(n2 + this.group.getY2(viewLayout, this.getPosX() + n3, n7, n8)) - f2 * 2.0f * (float)n13;
                    for (int i = 0; i <= n5; ++i) {
                        tGPainter.initPath(2);
                        TGNotePainter.paintFooter(tGPainter, f3, f4 - (float)i * (f2 / 2.0f) * (float)n13, n13, f2);
                        tGPainter.closePath();
                    }
                } else {
                    int n15 = 0;
                    int n16 = 0;
                    if (n14 == 2) {
                        n15 = this.getPosX() + n3;
                        n16 = this.getPosX() + n3 + 6;
                    } else if (n14 == 1) {
                        n15 = this.getPosX() + n3 - 5;
                        n16 = this.getPosX() + n3;
                    } else {
                        n15 = this.getJoin1().getPosX() + this.getJoin1().getBeatImpl().getSpacing();
                        n16 = this.getJoin2().getPosX() + this.getJoin2().getBeatImpl().getSpacing();
                    }
                    int n17 = n2 + this.group.getY2(viewLayout, n15, n7, n8);
                    int n18 = n2 + this.group.getY2(viewLayout, n16, n7, n8);
                    tGPainter.setLineWidth(Math.max(1, Math.round(3.0f * f)));
                    tGPainter.initPath();
                    for (int i = 0; i <= n5; ++i) {
                        tGPainter.moveTo(n + n9 + n15, (float)n17 - (float)i * (5.0f * f) * (float)n13);
                        tGPainter.lineTo(n + n9 + n16, (float)n18 - (float)i * (5.0f * f) * (float)n13);
                    }
                    tGPainter.closePath();
                    tGPainter.setLineWidth(1);
                }
            }
        }
    }

    public void paintDot(ViewLayout viewLayout, TGPainter tGPainter, float f, float f2, float f3) {
        float f4 = 3.0f * f3;
        float f5 = f;
        float f6 = f2;
        viewLayout.setDotStyle(tGPainter);
        tGPainter.initPath(2);
        tGPainter.moveTo(f5 - f4 / 2.0f, f6 - f4 / 2.0f);
        tGPainter.addOval(f5 - f4 / 2.0f, f6 - f4 / 2.0f, f4, f4);
        if (this.getDuration().isDoubleDotted()) {
            tGPainter.moveTo(f5 + (f4 + 2.0f) - f4 / 2.0f, f6 - f4 / 2.0f);
            tGPainter.addOval(f5 + (f4 + 2.0f) - f4 / 2.0f, f6 - f4 / 2.0f, f4, f4);
        }
        tGPainter.closePath();
    }

    public int getPaintPosition(int n) {
        return this.getMeasureImpl().getTs().getPosition(n);
    }

    public int getMaxString() {
        return this.maxString;
    }

    public int getMinString() {
        return this.minString;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMinY() {
        return this.minY;
    }

    public boolean isHiddenSilence() {
        return this.hiddenSilence;
    }

    public void setHiddenSilence(boolean bl) {
        this.hiddenSilence = bl;
    }
}

