/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.items.ToolItems;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGTupleto;

public class DurationToolItems
extends ToolItems {
    public static final String NAME = "duration.items";
    protected ToolBar toolBar;
    private ToolItem[] durationItems;
    private ToolItem dotted;
    private ToolItem doubleDotted;
    private TupletoMenuItem tupletoItems;

    public DurationToolItems() {
        super(NAME);
    }

    public void showItems(ToolBar toolBar) {
        this.toolBar = toolBar;
        this.durationItems = new ToolItem[7];
        this.durationItems[0] = new ToolItem(toolBar, 16);
        this.durationItems[0].setToolTipText("Redonda");
        this.durationItems[0].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.set-whole"));
        this.durationItems[1] = new ToolItem(toolBar, 16);
        this.durationItems[1].setToolTipText("Blanca");
        this.durationItems[1].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.set-half"));
        this.durationItems[2] = new ToolItem(toolBar, 16);
        this.durationItems[2].setToolTipText("Negra");
        this.durationItems[2].setSelection(true);
        this.durationItems[2].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.set-quarter"));
        this.durationItems[3] = new ToolItem(toolBar, 16);
        this.durationItems[3].setToolTipText("Corchea");
        this.durationItems[3].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.set-eighth"));
        this.durationItems[4] = new ToolItem(toolBar, 16);
        this.durationItems[4].setToolTipText("Semi-Corchea");
        this.durationItems[4].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.set-sixteenth"));
        this.durationItems[5] = new ToolItem(toolBar, 16);
        this.durationItems[5].setToolTipText("Fusa");
        this.durationItems[5].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.set-thirty-second"));
        this.durationItems[6] = new ToolItem(toolBar, 16);
        this.durationItems[6].setToolTipText("Semi-Fusa");
        this.durationItems[6].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.set-sixty-fourth"));
        new ToolItem(toolBar, 2);
        this.dotted = new ToolItem(toolBar, 32);
        this.dotted.setToolTipText("Puntillo");
        this.dotted.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.change-dotted"));
        this.doubleDotted = new ToolItem(toolBar, 32);
        this.doubleDotted.setToolTipText("Doble Puntillo");
        this.doubleDotted.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.change-double-dotted"));
        this.tupletoItems = new TupletoMenuItem();
        this.tupletoItems.addItems();
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        TGDuration tGDuration = this.getEditor().getTablature().getCaret().getDuration();
        boolean bl = TuxGuitar.instance().getPlayer().isRunning();
        int n = tGDuration.getIndex();
        for (int i = 0; i < this.durationItems.length; ++i) {
            this.durationItems[i].setSelection(i == n);
            this.durationItems[i].setEnabled(!bl);
        }
        this.dotted.setSelection(tGDuration.isDotted());
        this.dotted.setEnabled(!bl);
        this.doubleDotted.setSelection(tGDuration.isDoubleDotted());
        this.doubleDotted.setEnabled(!bl);
        this.tupletoItems.setEnabled(!bl);
        this.tupletoItems.update();
    }

    public void loadProperties() {
        this.durationItems[0].setToolTipText(TuxGuitar.getProperty("duration.whole"));
        this.durationItems[1].setToolTipText(TuxGuitar.getProperty("duration.half"));
        this.durationItems[2].setToolTipText(TuxGuitar.getProperty("duration.quarter"));
        this.durationItems[3].setToolTipText(TuxGuitar.getProperty("duration.eighth"));
        this.durationItems[4].setToolTipText(TuxGuitar.getProperty("duration.sixteenth"));
        this.durationItems[5].setToolTipText(TuxGuitar.getProperty("duration.thirtysecond"));
        this.durationItems[6].setToolTipText(TuxGuitar.getProperty("duration.sixtyfourth"));
        this.dotted.setToolTipText(TuxGuitar.getProperty("duration.dotted"));
        this.doubleDotted.setToolTipText(TuxGuitar.getProperty("duration.doubledotted"));
        this.tupletoItems.setText(TuxGuitar.getProperty("duration.tupleto"));
    }

    public void loadIcons() {
        this.durationItems[0].setImage(TuxGuitar.instance().getIconManager().getDuration(1));
        this.durationItems[1].setImage(TuxGuitar.instance().getIconManager().getDuration(2));
        this.durationItems[2].setImage(TuxGuitar.instance().getIconManager().getDuration(4));
        this.durationItems[3].setImage(TuxGuitar.instance().getIconManager().getDuration(8));
        this.durationItems[4].setImage(TuxGuitar.instance().getIconManager().getDuration(16));
        this.durationItems[5].setImage(TuxGuitar.instance().getIconManager().getDuration(32));
        this.durationItems[6].setImage(TuxGuitar.instance().getIconManager().getDuration(64));
        this.dotted.setImage(TuxGuitar.instance().getIconManager().getDurationDotted());
        this.doubleDotted.setImage(TuxGuitar.instance().getIconManager().getDurationDoubleDotted());
        this.tupletoItems.setImage(TuxGuitar.instance().getIconManager().getDurationTupleto());
    }

    protected TablatureEditor getEditor() {
        return super.getEditor();
    }

    private class TupletoMenuItem
    extends SelectionAdapter {
        private ToolItem tupleto;
        private Menu subMenu;
        private MenuItem[] subMenuItems;

        public TupletoMenuItem() {
            this.tupleto = new ToolItem(DurationToolItems.this.toolBar, 4);
            this.tupleto.addSelectionListener((SelectionListener)this);
            this.tupleto.setData((Object)this.newTupleto(3, 2));
            this.subMenu = new Menu((Control)this.tupleto.getParent().getShell());
        }

        public void setText(String string) {
            this.tupleto.setToolTipText(string);
        }

        public void setImage(Image image) {
            this.tupleto.setImage(image);
        }

        public void setEnabled(boolean bl) {
            this.tupleto.setEnabled(bl);
        }

        public void addItems() {
            this.subMenuItems = new MenuItem[8];
            this.subMenuItems[0] = new MenuItem(this.subMenu, 32);
            this.subMenuItems[0].setText("3");
            this.subMenuItems[0].setData((Object)this.newTupleto(3, 2));
            this.subMenuItems[0].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.change-tupleto"));
            this.subMenuItems[1] = new MenuItem(this.subMenu, 32);
            this.subMenuItems[1].setText("5");
            this.subMenuItems[1].setData((Object)this.newTupleto(5, 4));
            this.subMenuItems[1].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.change-tupleto"));
            this.subMenuItems[2] = new MenuItem(this.subMenu, 32);
            this.subMenuItems[2].setText("6");
            this.subMenuItems[2].setData((Object)this.newTupleto(6, 4));
            this.subMenuItems[2].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.change-tupleto"));
            this.subMenuItems[3] = new MenuItem(this.subMenu, 32);
            this.subMenuItems[3].setText("7");
            this.subMenuItems[3].setData((Object)this.newTupleto(7, 4));
            this.subMenuItems[3].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.change-tupleto"));
            this.subMenuItems[4] = new MenuItem(this.subMenu, 32);
            this.subMenuItems[4].setText("9");
            this.subMenuItems[4].setData((Object)this.newTupleto(9, 8));
            this.subMenuItems[4].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.change-tupleto"));
            this.subMenuItems[5] = new MenuItem(this.subMenu, 32);
            this.subMenuItems[5].setText("10");
            this.subMenuItems[5].setData((Object)this.newTupleto(10, 8));
            this.subMenuItems[5].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.change-tupleto"));
            this.subMenuItems[6] = new MenuItem(this.subMenu, 32);
            this.subMenuItems[6].setText("11");
            this.subMenuItems[6].setData((Object)this.newTupleto(11, 8));
            this.subMenuItems[6].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.change-tupleto"));
            this.subMenuItems[7] = new MenuItem(this.subMenu, 32);
            this.subMenuItems[7].setText("12");
            this.subMenuItems[7].setData((Object)this.newTupleto(12, 8));
            this.subMenuItems[7].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.duration.change-tupleto"));
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.detail == 4) {
                ToolItem toolItem = (ToolItem)selectionEvent.widget;
                Rectangle rectangle = toolItem.getBounds();
                Point point = toolItem.getParent().toDisplay(new Point(rectangle.x, rectangle.y));
                this.subMenu.setLocation(point.x, point.y + rectangle.height);
                this.subMenu.setVisible(true);
            } else {
                TGDuration tGDuration = DurationToolItems.this.getEditor().getTablature().getCaret().getDuration();
                if (tGDuration.getTupleto().isEqual(TGTupleto.NORMAL)) {
                    ((TGTupleto)this.tupleto.getData()).setEnters(3);
                    ((TGTupleto)this.tupleto.getData()).setTimes(2);
                } else {
                    ((TGTupleto)this.tupleto.getData()).setEnters(1);
                    ((TGTupleto)this.tupleto.getData()).setTimes(1);
                }
                TuxGuitar.instance().getAction("action.note.duration.change-tupleto").process((TypedEvent)selectionEvent);
            }
        }

        public void update() {
            TGDuration tGDuration = DurationToolItems.this.getEditor().getTablature().getCaret().getDuration();
            for (int i = 0; i < this.subMenuItems.length; ++i) {
                TGTupleto tGTupleto = (TGTupleto)this.subMenuItems[i].getData();
                this.subMenuItems[i].setSelection(tGTupleto.isEqual(tGDuration.getTupleto()));
            }
        }

        private TGTupleto newTupleto(int n, int n2) {
            TGTupleto tGTupleto = TuxGuitar.instance().getSongManager().getFactory().newTupleto();
            tGTupleto.setEnters(n);
            tGTupleto.setTimes(n2);
            return tGTupleto;
        }
    }
}

