/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.layout.LinearViewLayout;
import org.herac.tuxguitar.gui.editors.tab.layout.PageViewLayout;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.items.ToolItems;

public class LayoutToolItems
extends ToolItems {
    public static final String NAME = "layout.items";
    private ToolItem pageLayout;
    private ToolItem linearLayout;
    private ToolItem multitrack;
    private ToolItem scoreEnabled;
    private ToolItem compact;

    public LayoutToolItems() {
        super(NAME);
    }

    public void showItems(ToolBar toolBar) {
        this.pageLayout = new ToolItem(toolBar, 16);
        this.pageLayout.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.view.layout-set-page"));
        this.linearLayout = new ToolItem(toolBar, 16);
        this.linearLayout.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.view.layout-set-linear"));
        this.multitrack = new ToolItem(toolBar, 32);
        this.multitrack.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.view.layout-set-multitrack"));
        this.scoreEnabled = new ToolItem(toolBar, 32);
        this.scoreEnabled.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.view.layout-set-score-enabled"));
        this.compact = new ToolItem(toolBar, 32);
        this.compact.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.view.layout-set-compact"));
        this.loadIcons();
        this.loadProperties();
    }

    public void loadProperties() {
        this.pageLayout.setToolTipText(TuxGuitar.getProperty("view.layout.page"));
        this.linearLayout.setToolTipText(TuxGuitar.getProperty("view.layout.linear"));
        this.multitrack.setToolTipText(TuxGuitar.getProperty("view.layout.multitrack"));
        this.scoreEnabled.setToolTipText(TuxGuitar.getProperty("view.layout.score-enabled"));
        this.compact.setToolTipText(TuxGuitar.getProperty("view.layout.compact"));
    }

    public void loadIcons() {
        this.pageLayout.setImage(TuxGuitar.instance().getIconManager().getLayoutPage());
        this.linearLayout.setImage(TuxGuitar.instance().getIconManager().getLayoutLinear());
        this.multitrack.setImage(TuxGuitar.instance().getIconManager().getLayoutMultitrack());
        this.scoreEnabled.setImage(TuxGuitar.instance().getIconManager().getLayoutScore());
        this.compact.setImage(TuxGuitar.instance().getIconManager().getLayoutCompact());
    }

    public void update() {
        ViewLayout viewLayout = this.getEditor().getTablature().getViewLayout();
        int n = viewLayout.getStyle();
        this.pageLayout.setSelection(viewLayout instanceof PageViewLayout);
        this.linearLayout.setSelection(viewLayout instanceof LinearViewLayout);
        this.multitrack.setSelection((n & 2) != 0);
        this.scoreEnabled.setSelection((n & 4) != 0);
        this.compact.setSelection((n & 1) != 0);
        this.compact.setEnabled((n & 2) == 0 || this.getEditor().getTablature().getSongManager().getSong().countTracks() == 1);
    }
}

