/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.herac.tuxguitar.gui.items.ToolItems;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ToolBarsWriter {
    private static final String ITEM_LIST_TAG = "toolbars";
    private static final String ITEM_TAG = "toolbar";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ENABLED = "enabled";

    public static void saveToolBars(ToolItems[] toolItemsArray, File file) {
        try {
            Document document = ToolBarsWriter.createDocument();
            ToolBarsWriter.setToolBars(toolItemsArray, document);
            ToolBarsWriter.saveDocument(document, file);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        return document;
    }

    public static void saveDocument(Document document, File file) throws FileNotFoundException, TransformerException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(fileOutputStream);
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(dOMSource, streamResult);
    }

    private static void setToolBars(ToolItems[] toolItemsArray, Document document) {
        Element element = document.createElement(ITEM_LIST_TAG);
        for (int i = 0; i < toolItemsArray.length; ++i) {
            Element element2 = document.createElement(ITEM_TAG);
            element.appendChild(element2);
            Attr attr = document.createAttribute(ATTR_NAME);
            attr.setNodeValue(toolItemsArray[i].getName());
            element2.getAttributes().setNamedItem(attr);
            attr = document.createAttribute(ATTR_ENABLED);
            attr.setNodeValue(Boolean.toString(toolItemsArray[i].isEnabled()));
            element2.getAttributes().setNamedItem(attr);
        }
        document.appendChild(element);
    }
}

