/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.printer;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.printer.PrintStyles;
import org.herac.tuxguitar.gui.util.DialogUtils;

public class PrintStylesDialog {
    public static PrintStyles open(Shell shell) {
        final PrintStyles printStyles = new PrintStyles();
        final Shell shell2 = DialogUtils.newDialog(shell, 67680);
        shell2.setLayout((Layout)new GridLayout());
        shell2.setText(TuxGuitar.getProperty("options"));
        Group group = new Group((Composite)shell2, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)PrintStylesDialog.getGroupData());
        group.setText(TuxGuitar.getProperty("track"));
        Label label = new Label((Composite)group, 0);
        label.setText(TuxGuitar.getProperty("track"));
        final Combo combo = new Combo((Composite)group, 12);
        combo.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int i = 1; i <= TuxGuitar.instance().getSongManager().getSong().countTracks(); ++i) {
            combo.add(TuxGuitar.instance().getSongManager().getTrack(i).getName());
        }
        combo.select(TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getTrack().getNumber() - 1);
        Group group2 = new Group((Composite)shell2, 16);
        group2.setLayout((Layout)new GridLayout(2, false));
        group2.setLayoutData((Object)PrintStylesDialog.getGroupData());
        group2.setText(TuxGuitar.getProperty("print.range"));
        final int n = TuxGuitar.instance().getSongManager().getSong().countMeasureHeaders();
        Label label2 = new Label((Composite)group2, 0);
        label2.setText(TuxGuitar.getProperty("edit.from"));
        final Spinner spinner = new Spinner((Composite)group2, 2048);
        spinner.setLayoutData((Object)PrintStylesDialog.getSpinnerData());
        spinner.setMaximum(n);
        spinner.setMinimum(1);
        spinner.setSelection(1);
        Label label3 = new Label((Composite)group2, 0);
        label3.setText(TuxGuitar.getProperty("edit.to"));
        final Spinner spinner2 = new Spinner((Composite)group2, 2048);
        spinner2.setLayoutData((Object)PrintStylesDialog.getSpinnerData());
        spinner2.setMinimum(1);
        spinner2.setMaximum(n);
        spinner2.setSelection(n);
        spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = spinner.getSelection();
                int n2 = spinner2.getSelection();
                if (n < 1) {
                    spinner.setSelection(1);
                } else if (n > n2) {
                    spinner.setSelection(n2);
                }
            }
        });
        spinner2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n3;
                int n2 = spinner2.getSelection();
                if (n2 < (n3 = spinner.getSelection())) {
                    spinner2.setSelection(n3);
                } else if (n2 > n) {
                    spinner2.setSelection(n);
                }
            }
        });
        Group group3 = new Group((Composite)shell2, 16);
        group3.setLayout((Layout)new GridLayout());
        group3.setLayoutData((Object)PrintStylesDialog.getGroupData());
        group3.setText(TuxGuitar.getProperty("options"));
        final Button button = new Button((Composite)group3, 32);
        button.setText(TuxGuitar.getProperty("export.tablature-enabled"));
        button.setSelection(true);
        final Button button2 = new Button((Composite)group3, 32);
        button2.setText(TuxGuitar.getProperty("export.score-enabled"));
        button2.setSelection(true);
        final Button button3 = new Button((Composite)group3, 32);
        button3.setText(TuxGuitar.getProperty("export.chord-name-enabled"));
        button3.setSelection(true);
        final Button button4 = new Button((Composite)group3, 32);
        button4.setText(TuxGuitar.getProperty("export.chord-diagram-enabled"));
        button4.setSelection(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!button.getSelection()) {
                    button2.setSelection(true);
                }
            }
        });
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!button2.getSelection()) {
                    button.setSelection(true);
                }
            }
        });
        Composite composite = new Composite((Composite)shell2, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button button5 = new Button(composite, 8);
        button5.setText(TuxGuitar.getProperty("ok"));
        button5.setLayoutData((Object)PrintStylesDialog.getButtonData());
        button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = 0;
                n |= button2.getSelection() ? 4 : 0;
                n |= button.getSelection() ? 8 : 0;
                n |= button3.getSelection() ? 16 : 0;
                int n2 = button4.getSelection() ? 32 : 0;
                printStyles.setTrackNumber(combo.getSelectionIndex() + 1);
                printStyles.setFromMeasure(spinner.getSelection());
                printStyles.setToMeasure(spinner2.getSelection());
                printStyles.setStyle(n |= n2);
                shell2.dispose();
            }
        });
        Button button6 = new Button(composite, 8);
        button6.setText(TuxGuitar.getProperty("cancel"));
        button6.setLayoutData((Object)PrintStylesDialog.getButtonData());
        button6.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button5);
        DialogUtils.openDialog(shell2, 11);
        return printStyles.getTrackNumber() > 0 ? printStyles : null;
    }

    private static GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    private static GridData getSpinnerData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 60;
        return gridData;
    }

    private static GridData getGroupData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 300;
        return gridData;
    }
}

