/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.keybindings.editor;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.keybindings.KeyBinding;
import org.herac.tuxguitar.gui.system.keybindings.KeyBindingAction;
import org.herac.tuxguitar.gui.system.keybindings.KeyBindingReserveds;
import org.herac.tuxguitar.gui.system.keybindings.editor.KeyBindingEditor;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.MessageDialog;

public class KeyBindingSelector {
    protected Shell dialog;
    protected KeyBindingEditor editor;
    protected KeyBinding keyBinding;
    protected String action;

    public KeyBindingSelector(KeyBindingEditor keyBindingEditor, KeyBindingAction keyBindingAction) {
        this.editor = keyBindingEditor;
        this.keyBinding = keyBindingAction.getKeyBinding();
        this.action = keyBindingAction.getAction();
    }

    public KeyBinding select(Shell shell) {
        Composite composite;
        this.dialog = DialogUtils.newDialog(shell, 67680);
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setLayoutData((Object)new GridData(4, 4, true, true));
        this.dialog.setText(TuxGuitar.getProperty("key-bindings-editor"));
        Group group = new Group((Composite)this.dialog, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty(this.action));
        final Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        composite2.setFocus();
        composite2.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                KeyBinding keyBinding = new KeyBinding(keyEvent.keyCode, keyEvent.stateMask);
                if (keyBinding.isSameAs(KeyBindingSelector.this.keyBinding) || KeyBindingSelector.this.isValid(keyBinding)) {
                    if (KeyBindingSelector.this.keyBinding == null) {
                        KeyBindingSelector.this.keyBinding = new KeyBinding();
                    }
                    KeyBindingSelector.this.keyBinding.setKey(keyBinding.getKey());
                    KeyBindingSelector.this.keyBinding.setMask(keyBinding.getMask());
                }
                KeyBindingSelector.this.dialog.dispose();
            }
        });
        Label label = new Label(composite2, 0x1000000);
        label.setImage(label.getDisplay().getSystemImage(2));
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        Label label2 = new Label(composite2, 0x1000000);
        label2.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        label2.setText(TuxGuitar.getProperty("key-bindings-editor-push-a-key"));
        FontData[] fontDataArray = label2.getFont().getFontData();
        if (fontDataArray != null && fontDataArray.length > 0) {
            composite = new Font((Device)label2.getDisplay(), new FontData(fontDataArray[0].getName(), 14, 1));
            label2.setFont((Font)composite);
            label2.addDisposeListener(new DisposeListener((Font)composite){
                private final /* synthetic */ Font val$font;
                {
                    this.val$font = font;
                }

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    this.val$font.dispose();
                }
            });
        }
        composite = new Composite((Composite)this.dialog, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button button = new Button(composite, 8);
        button.setText(TuxGuitar.getProperty("clean"));
        button.setLayoutData((Object)this.getButtonData());
        button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                composite2.setFocus();
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyBindingSelector.this.keyBinding = null;
                KeyBindingSelector.this.dialog.dispose();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(TuxGuitar.getProperty("cancel"));
        button2.setLayoutData((Object)this.getButtonData());
        button2.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                composite2.setFocus();
            }
        });
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyBindingSelector.this.dialog.dispose();
            }
        });
        DialogUtils.openDialog(this.dialog, 11);
        return this.keyBinding;
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected boolean isValid(KeyBinding keyBinding) {
        if (KeyBindingReserveds.isReserved(keyBinding)) {
            if (!this.editor.isDisposed()) {
                String string = TuxGuitar.getProperty("key-bindings-editor-reserved-title");
                String string2 = TuxGuitar.getProperty("key-bindings-editor-reserved-message");
                MessageDialog.infoMessage(this.editor.getDialog(), string, string2);
            }
            return false;
        }
        if (this.editor.exists(keyBinding)) {
            ConfirmDialog confirmDialog = new ConfirmDialog(TuxGuitar.getProperty("key-bindings-editor-override"));
            confirmDialog.setDefaultStatus(ConfirmDialog.STATUS_NO);
            if (confirmDialog.confirm(ConfirmDialog.BUTTON_YES | ConfirmDialog.BUTTON_NO, ConfirmDialog.BUTTON_NO) == ConfirmDialog.STATUS_NO) {
                return false;
            }
        }
        return true;
    }
}

