/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.table.TGTable;

public class TGTableColumn {
    private TGTable table;
    private CLabel column;
    private List controls;

    public TGTableColumn(TGTable tGTable, int n) {
        this.table = tGTable;
        this.controls = new ArrayList();
        this.column = new CLabel(this.table.getColumnControl(), n | 8);
        this.column.setLayout((Layout)new GridLayout());
        this.column.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                TGTableColumn.this.layout();
            }
        });
        this.column.pack();
        this.appendListeners((Control)this.column);
    }

    public CLabel getControl() {
        return this.column;
    }

    public void setTitle(String string) {
        this.column.setText(string);
    }

    public void addControl(Control control) {
        this.controls.add(control);
        this.appendListeners(control);
    }

    public void appendListeners(Control control) {
        TuxGuitar.instance().getkeyBindingManager().appendListenersTo(control);
    }

    public void layout() {
        Point point = this.column.getLocation();
        Point point2 = this.column.getSize();
        for (int i = 0; i < this.controls.size(); ++i) {
            Control control = (Control)this.controls.get(i);
            if (control.isDisposed()) continue;
            control.setSize(point2.x, this.table.getRowHeight());
            control.setLocation(point.x, 0);
        }
    }

    public void notifyRemoved() {
        for (int i = 0; i < this.controls.size(); ++i) {
            Control control = (Control)this.controls.get(i);
            if (!control.isDisposed()) continue;
            this.controls.remove(i--);
        }
    }
}

