/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.scale;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tools.scale.ScaleInfo;
import org.herac.tuxguitar.gui.tools.scale.ScaleListener;
import org.herac.tuxguitar.gui.tools.scale.xml.ScaleReader;
import org.herac.tuxguitar.gui.util.TGFileUtils;
import org.herac.tuxguitar.gui.util.TGMusicKeyUtils;
import org.herac.tuxguitar.song.models.TGScale;

public class ScaleManager {
    private static final String[] KEY_NAMES = TGMusicKeyUtils.getSharpKeyNames("scale");
    private static final String KEY_SEPARATOR = ",";
    public static final int NONE_SELECTION = -1;
    private List scales = new ArrayList();
    private List scaleListeners = new ArrayList();
    private TGScale scale = TuxGuitar.instance().getSongManager().getFactory().newScale();
    private int selectionIndex = -1;
    private int selectionKey = 0;

    public ScaleManager() {
        this.loadScales();
    }

    public void addListener(ScaleListener scaleListener) {
        if (!this.scaleListeners.contains(scaleListener)) {
            this.scaleListeners.add(scaleListener);
        }
    }

    public void removeListener(ScaleListener scaleListener) {
        if (this.scaleListeners.contains(scaleListener)) {
            this.scaleListeners.remove(scaleListener);
        }
    }

    public void fireListeners() {
        for (int i = 0; i < this.scaleListeners.size(); ++i) {
            ScaleListener scaleListener = (ScaleListener)this.scaleListeners.get(i);
            scaleListener.loadScale();
        }
    }

    public void selectScale(int n, int n2) {
        if (n == -1) {
            this.getScale().clear();
        } else if (n >= 0 && n < this.scales.size()) {
            this.getScale().clear();
            ScaleInfo scaleInfo = (ScaleInfo)this.scales.get(n);
            String[] stringArray = scaleInfo.getKeys().split(KEY_SEPARATOR);
            for (int i = 0; i < stringArray.length; ++i) {
                int n3 = Integer.parseInt(stringArray[i]) - 1;
                if (n3 < 0 || n3 >= 12) continue;
                this.getScale().setNote(n3, true);
            }
            this.getScale().setKey(n2);
        }
        this.selectionIndex = n;
        this.selectionKey = n2;
        this.fireListeners();
    }

    public TGScale getScale() {
        return this.scale;
    }

    public int countScales() {
        return this.scales.size();
    }

    public String getScaleName(int n) {
        if (n >= 0 && n < this.scales.size()) {
            return ((ScaleInfo)this.scales.get(n)).getName();
        }
        return null;
    }

    public String getScaleKeys(int n) {
        if (n >= 0 && n < this.scales.size()) {
            return ((ScaleInfo)this.scales.get(n)).getKeys();
        }
        return null;
    }

    public String[] getScaleNames() {
        String[] stringArray = new String[this.scales.size()];
        for (int i = 0; i < this.scales.size(); ++i) {
            ScaleInfo scaleInfo = (ScaleInfo)this.scales.get(i);
            stringArray[i] = scaleInfo.getName();
        }
        return stringArray;
    }

    public String getKeyName(int n) {
        if (n >= 0 && n < KEY_NAMES.length) {
            return KEY_NAMES[n];
        }
        return null;
    }

    public String[] getKeyNames() {
        return KEY_NAMES;
    }

    public int getSelectionIndex() {
        return this.selectionIndex;
    }

    public int getSelectionKey() {
        return this.selectionKey;
    }

    private void loadScales() {
        try {
            new ScaleReader().loadScales(this.scales, TGFileUtils.getResourceAsStream("scales/scales.xml"));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

